/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.sistore;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.DoNothingCameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifCameraControl;
import de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifDevice;
import de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifVideoSourceClient;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.util.SeeTecException;

public final class SistoreOnvifCameraSrv
extends LiveCameraSrv {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifCameraSrv";

    @Override
    public final CameraControl createCameraControl(Long entityType) {
        SistoreOnvifDevice genericOnvifDevice = (SistoreOnvifDevice)this.device;
        if (genericOnvifDevice.getDeviceDefinitionFromConfiguration() != null && genericOnvifDevice.getDeviceDefinitionFromConfiguration().getMiscVideoServerCapabilities().isCanPTZ()) {
            return new SistoreOnvifCameraControl();
        }
        return new DoNothingCameraControl();
    }

    @Override
    public final VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        SistoreOnvifVideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [VideoSourceClient] with VideoProfileHandler=" + listener + " ...");
        try {
            videoSourceClient = new SistoreOnvifVideoSourceClient();
            errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seeTecException) {
            throw seeTecException;
        }
        catch (Throwable throwable) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            String errorMessage = "Creating [VideoSourceClient] for " + this + " failed";
            this.logger.error(errorMessage, throwable);
            throw new SeeTecException(-20001, errorMessage);
        }
        return videoSourceClient;
    }

    @Override
    public final ContentFrame getJpegSnapshot(Integer[] resolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED...");
    }
}

