/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.simple;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.video.onvif.simple.SimpleGenericOnvifCameraSrv;
import de.seetec.v5.re.cm.device.video.onvif.simple.SimpleGenericOnvifDevice;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import java.util.List;
import java.util.Vector;
import javax.xml.ws.Holder;
import org.onvif.ver10.schema.PTZPreset;
import org.onvif.ver20.ptz.wsdl.PTZ;

public class SimpleGenericOnvifCameraControl
extends CameraControl {
    private OnvifCore onvifCore = null;
    private PTZ ptzService = null;

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        SimpleGenericOnvifDevice onvifDevice = (SimpleGenericOnvifDevice)((SimpleGenericOnvifCameraSrv)this.videoSrv).getDevice();
        if (onvifDevice.isOnvifDevice()) {
            this.initializeOnvifCoreAndPtzService();
            try {
                this.onvifCore.getPtzService().sendContinuousPtzCommand(onvifDevice.getProfileToken1(), panSpeed, tiltSpeed, zoomSpeed, 10, 100L);
                this.videoSrv.notifyForCameraControl();
            }
            catch (Exception exception) {
                this.logger.warn("Continuous PTZ command coud not be executed on " + onvifDevice.toString());
                this.logger.warn((Object)exception);
            }
        }
        return 0;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousIris(Integer value) {
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        try {
            SimpleGenericOnvifDevice onvifDevice = (SimpleGenericOnvifDevice)((SimpleGenericOnvifCameraSrv)this.videoSrv).getDevice();
            if (onvifDevice.isOnvifDevice()) {
                this.initializeOnvifCoreAndPtzService();
                String encodedPresetName = this.getEncodedPresetNameEmptyNotAllowed(presetName);
                List presets = this.ptzService.getPresets(onvifDevice.getProfileToken1());
                for (PTZPreset preset : presets) {
                    if (preset.getName() != null && !preset.getName().equals(encodedPresetName)) continue;
                    this.ptzService.removePreset(onvifDevice.getProfileToken1(), preset.getToken());
                }
                Holder presetToken = new Holder();
                this.ptzService.setPreset(onvifDevice.getProfileToken1(), encodedPresetName, presetToken);
                PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, (String)presetToken.value, encodedPresetName);
                this.presetList.addElement(presetCnf);
                result.addElement(presetCnf.getPresetCnf());
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Setting preset [" + presetName + "] failed");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            SimpleGenericOnvifDevice onvifDevice = (SimpleGenericOnvifDevice)((SimpleGenericOnvifCameraSrv)this.videoSrv).getDevice();
            if (onvifDevice.isOnvifDevice()) {
                this.initializeOnvifCoreAndPtzService();
                String encodedPresetName = this.getEncodedPresetNameEmptyNotAllowed(presetName);
                List presets = this.ptzService.getPresets(onvifDevice.getProfileToken1());
                for (PTZPreset preset : presets) {
                    if (preset.getName() == null || !preset.getName().equals(encodedPresetName)) continue;
                    this.ptzService.gotoPreset(onvifDevice.getProfileToken1(), preset.getToken(), null);
                    this.videoSrv.notifyForCameraControl();
                    break;
                }
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.warn("Going to preset [" + presetName + "] failed");
            return -21600;
        }
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = this.getEncodedPresetNameEmptyNotAllowed(presetName);
            SimpleGenericOnvifDevice onvifDevice = (SimpleGenericOnvifDevice)((SimpleGenericOnvifCameraSrv)this.videoSrv).getDevice();
            if (onvifDevice.isOnvifDevice()) {
                this.initializeOnvifCoreAndPtzService();
                List presets = this.ptzService.getPresets(onvifDevice.getProfileToken1());
                for (PTZPreset preset : presets) {
                    if (preset.getName() != null && !preset.getName().equals(encodedPresetName)) continue;
                    this.ptzService.removePreset(onvifDevice.getProfileToken1(), preset.getToken());
                }
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Removing preset [" + presetName + "] failed");
            return -21600;
        }
    }

    private void initializeOnvifCoreAndPtzService() {
        SimpleGenericOnvifDevice onvifDevice = (SimpleGenericOnvifDevice)((SimpleGenericOnvifCameraSrv)this.videoSrv).getDevice();
        if (this.onvifCore == null) {
            this.onvifCore = onvifDevice.getOnvifCore();
        }
        if (this.ptzService == null) {
            this.ptzService = this.onvifCore.getPtzService().getOnvifPtzService();
        }
    }
}

