/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.generic;

import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.onvif.ver10.schema.AudioEncoder2Configuration;
import org.onvif.ver10.schema.AudioEncoder2ConfigurationOptions;
import org.onvif.ver10.schema.AudioSourceConfiguration;
import org.onvif.ver10.schema.H264Profile;
import org.onvif.ver10.schema.Rotate;
import org.onvif.ver10.schema.RotateMode;
import org.onvif.ver10.schema.VideoEncoder2Configuration;
import org.onvif.ver10.schema.VideoEncoder2ConfigurationOptions;
import org.onvif.ver10.schema.VideoRateControl2;
import org.onvif.ver10.schema.VideoResolution2;
import org.onvif.ver10.schema.VideoSourceConfiguration;
import org.onvif.ver10.schema.VideoSourceConfigurationExtension;
import org.onvif.ver20.media.wsdl.ConfigurationRef;
import org.onvif.ver20.media.wsdl.Media2;
import org.onvif.ver20.media.wsdl.MediaProfile;

public class GenericOnvifVideoSourceClientMedia2
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifVideoSourceClientMedia2";

    @Override
    public int init() {
        String rtspHost = this.networkParameter.getHost();
        int rtspPort = this.getRTSPPortFromConfiguration();
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        try {
            MediaProfile mediaProfile;
            block64: {
                GenericOnvifDevice onvifDevice = (GenericOnvifDevice)this.getVideoSrv().getDevice();
                OnvifCore onvifCore = onvifDevice.getOnvifCore();
                DeviceDefinition deviceDefinition = onvifDevice.getDeviceDefinitionFromConfiguration();
                Media2 media2Service = onvifCore.getMedia2Service().getOnvifMedia2Service();
                String[] selectedOnvifProfileAndStreamName = OnvifHelper.extractOnvifProfileAndStreamName(this.listener.getVideoSourceParameter().getStreamName());
                String selectedOnvifProfile = selectedOnvifProfileAndStreamName[0];
                String encoderConfigurationStreamName = selectedOnvifProfileAndStreamName[1];
                ArrayList<String> types = new ArrayList<String>();
                types.add("All");
                mediaProfile = null;
                if (selectedOnvifProfile.equals("VMS default")) {
                    List allMediaProfiles = media2Service.getProfiles(null, types);
                    for (MediaProfile profile : allMediaProfiles) {
                        if (profile.getConfigurations() == null || profile.getConfigurations().getVideoEncoder() == null || profile.getConfigurations().getVideoEncoder().getToken() == null || !profile.getConfigurations().getVideoEncoder().getToken().equals(this.listener.getVideoSourceParameter().getStreamName())) continue;
                        mediaProfile = profile;
                        break;
                    }
                } else {
                    List mediaProfiles = media2Service.getProfiles(selectedOnvifProfile, types);
                    if (mediaProfiles.size() > 0) {
                        mediaProfile = (MediaProfile)mediaProfiles.get(0);
                    }
                }
                if (mediaProfile == null) {
                    this.logger.error("Error while retrieving media profile \"" + selectedOnvifProfile + "\" from device");
                    return -20001;
                }
                List videoSourceConfigurations = media2Service.getVideoSourceConfigurations(null, mediaProfile.getToken());
                VideoSourceConfiguration videoSourceConfiguration = (VideoSourceConfiguration)videoSourceConfigurations.get(0);
                try {
                    List degreeList = media2Service.getVideoSourceConfigurationOptions(null, null).getExtension().getRotate().getDegreeList().getItems();
                    if (degreeList != null && degreeList.size() > 1) {
                        Rotate rotate = new Rotate();
                        rotate.setDegree(Integer.valueOf(this.rotationAngle));
                        rotate.setMode(this.rotationAngle == 0 ? RotateMode.OFF : RotateMode.ON);
                        VideoSourceConfigurationExtension videoSourceConfigurationExtension = videoSourceConfiguration.getExtension();
                        videoSourceConfigurationExtension.setRotate(rotate);
                        videoSourceConfiguration.setExtension(videoSourceConfigurationExtension);
                    }
                }
                catch (Exception ex) {
                    try {
                        List rotateModeList = media2Service.getVideoSourceConfigurationOptions(null, null).getExtension().getRotate().getMode();
                        if (rotateModeList != null && rotateModeList.size() > 1 || rotateModeList != null && rotateModeList.size() == 1 && rotateModeList.get(0) == RotateMode.ON) {
                            Rotate rotate = new Rotate();
                            rotate.setMode(this.rotationAngle == 0 ? RotateMode.OFF : RotateMode.ON);
                            VideoSourceConfigurationExtension videoSourceConfigurationExtension = videoSourceConfiguration.getExtension();
                            videoSourceConfigurationExtension.setRotate(rotate);
                            videoSourceConfiguration.setExtension(videoSourceConfigurationExtension);
                        }
                    }
                    catch (Exception exception) {
                        this.logger.warn("Could not rotate image using Media Service for " + this);
                    }
                }
                try {
                    media2Service.setVideoSourceConfiguration(videoSourceConfiguration);
                }
                catch (Throwable throwable) {
                    this.logger.warn("Error while trying to set VideoSourceConfiguration [" + videoSourceConfiguration.getToken() + "] for " + this);
                }
                VideoEncoder2Configuration videoEncoder2Configuration = (VideoEncoder2Configuration)media2Service.getVideoEncoderConfigurations(encoderConfigurationStreamName, null).get(0);
                List videoEncoder2ConfigurationOptionList = media2Service.getVideoEncoderConfigurationOptions(videoEncoder2Configuration.getToken(), null);
                int minGovRange = 1;
                int maxGovRange = 1000;
                for (VideoEncoder2ConfigurationOptions videoEncoder2ConfigurationOptions : videoEncoder2ConfigurationOptionList) {
                    List govLengthRangeList;
                    if (!videoEncoder2ConfigurationOptions.getEncoding().equals("H265") || (govLengthRangeList = videoEncoder2ConfigurationOptions.getGovLengthRange()).size() <= 1) continue;
                    minGovRange = (Integer)govLengthRangeList.get(0);
                    maxGovRange = (Integer)govLengthRangeList.get(govLengthRangeList.size() - 1);
                }
                VideoResolution2 videoResolution2 = new VideoResolution2();
                videoResolution2.setWidth(this.width);
                videoResolution2.setHeight(this.height);
                videoEncoder2Configuration.setResolution(videoResolution2);
                if (this.videoCodec == Codec.MJPEG) {
                    videoEncoder2Configuration.setEncoding("JPEG");
                } else if (this.videoCodec == Codec.H264) {
                    videoEncoder2Configuration.setEncoding(Codec.H264.name());
                    MpegProfile mpegProfile = this.listener.getVideoSourceParameter().getMpegProfile();
                    if (mpegProfile == MpegProfile.BASELINE) {
                        videoEncoder2Configuration.setProfile(H264Profile.BASELINE.value());
                    } else if (mpegProfile == MpegProfile.EXTENDED) {
                        videoEncoder2Configuration.setProfile(H264Profile.EXTENDED.value());
                    } else if (mpegProfile == MpegProfile.HIGH) {
                        videoEncoder2Configuration.setProfile(H264Profile.HIGH.value());
                    } else {
                        videoEncoder2Configuration.setProfile(H264Profile.MAIN.value());
                    }
                    int govLength = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, minGovRange, maxGovRange);
                    videoEncoder2Configuration.setGovLength(Integer.valueOf(govLength));
                } else if (this.videoCodec == Codec.H265) {
                    videoEncoder2Configuration.setEncoding(Codec.H265.name());
                    int govLength = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, minGovRange, maxGovRange);
                    videoEncoder2Configuration.setGovLength(Integer.valueOf(govLength));
                }
                VideoRateControl2 videoRateControl2 = new VideoRateControl2();
                if (this.isConstantBitrateUsed) {
                    videoRateControl2.setBitrateLimit(this.bandwidth / 1024);
                } else {
                    videoEncoder2Configuration.setQuality((float)this.quality);
                }
                videoRateControl2.setConstantBitRate(Boolean.valueOf(this.isConstantBitrateUsed));
                videoRateControl2.setFrameRateLimit((float)this.fps / 1000.0f);
                videoEncoder2Configuration.setRateControl(videoRateControl2);
                try {
                    media2Service.setVideoEncoderConfiguration(videoEncoder2Configuration);
                }
                catch (Throwable throwable) {
                    this.logger.warn("Error while trying to set VideoEncoder2Configuration [" + videoEncoder2Configuration.getToken() + "] for " + this + " : " + throwable.getMessage());
                }
                try {
                    ArrayList<ConfigurationRef> configurationRefs;
                    if (mediaProfile.getConfigurations().getVideoSource() == null || !mediaProfile.getConfigurations().getVideoSource().getToken().equals(videoSourceConfiguration.getToken())) {
                        ConfigurationRef configurationRefVideoSource = new ConfigurationRef();
                        configurationRefVideoSource.setToken(videoSourceConfiguration.getToken());
                        configurationRefVideoSource.setType("VideoSource");
                        configurationRefs = new ArrayList<ConfigurationRef>();
                        configurationRefs.add(configurationRefVideoSource);
                        media2Service.addConfiguration(mediaProfile.getToken(), null, configurationRefs);
                    }
                    if (mediaProfile.getConfigurations().getVideoEncoder() == null || !mediaProfile.getConfigurations().getVideoEncoder().getToken().equals(videoEncoder2Configuration.getToken())) {
                        ConfigurationRef configurationRefVideoEncoder = new ConfigurationRef();
                        configurationRefVideoEncoder.setToken(videoEncoder2Configuration.getToken());
                        configurationRefVideoEncoder.setType("VideoEncoder");
                        configurationRefs = new ArrayList();
                        configurationRefs.add(configurationRefVideoEncoder);
                        media2Service.addConfiguration(mediaProfile.getToken(), null, configurationRefs);
                    }
                }
                catch (Throwable throwable) {
                    this.logger.warn("Error while trying to add VideoSourceConfiguration [" + videoSourceConfiguration.getToken() + "] and VideoEncoderConfiguration[" + videoEncoder2Configuration.getToken() + "] to Profile:[" + mediaProfile.getToken() + "] for " + this + " : " + throwable.getMessage());
                }
                if (this.transmissionID == TransmissionType.RTP_OVER_UDP_UNICAST) {
                    this.rtspUrl = media2Service.getStreamUri("RtspUnicast", mediaProfile.getToken());
                } else if (this.transmissionID == TransmissionType.RTP_OVER_UDP_MULTICAST) {
                    this.startMulticastStreaming();
                    this.rtspUrl = media2Service.getStreamUri("RtspMulticast", mediaProfile.getToken());
                } else if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_TCP) {
                    this.rtspUrl = media2Service.getStreamUri("RTSP", mediaProfile.getToken());
                } else if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST) {
                    this.rtspUrl = media2Service.getStreamUri("RtspOverHttp", mediaProfile.getToken());
                }
                if (this.transmissionID != TransmissionType.PROPRIETARY_MULTICAST) {
                    this.rtspUrl = OnvifHelper.changeIPAddressPortOfUrl(this.rtspUrl, rtspHost, rtspPort, this.logger);
                }
                try {
                    if (deviceDefinition == null || deviceDefinition.getAudioCapabilities() == null || !deviceDefinition.getAudioCapabilities().isCanAudio() || !this.isAudioEnabled || this.audioCodec == Codec.UNKNOWN) break block64;
                    AudioSourceConfiguration audioSourceConfiguration = (AudioSourceConfiguration)media2Service.getAudioSourceConfigurations(null, mediaProfile.getToken()).get(0);
                    try {
                        media2Service.setAudioSourceConfiguration(audioSourceConfiguration);
                    }
                    catch (Throwable throwable) {
                        this.logger.warn("Error while trying to set AudioSourceConfiguration [" + audioSourceConfiguration.getToken() + "] for " + this + " : " + throwable.getMessage());
                    }
                    AudioEncoder2Configuration audioEncoder2Configuration = (AudioEncoder2Configuration)media2Service.getAudioEncoderConfigurations(null, mediaProfile.getToken()).get(0);
                    List audioEncoder2ConfigurationOptions = media2Service.getAudioEncoderConfigurationOptions(audioEncoder2Configuration.getToken(), mediaProfile.getToken());
                    audioEncoder2Configuration = this.createAudioEncoder2Configuration(audioEncoder2Configuration, audioEncoder2ConfigurationOptions);
                    try {
                        media2Service.setAudioEncoderConfiguration(audioEncoder2Configuration);
                    }
                    catch (Throwable throwable) {
                        this.logger.warn("Error while trying to set AudioEncoderConfiguration [" + audioEncoder2Configuration.getToken() + "] for " + this);
                    }
                    try {
                        if (mediaProfile.getConfigurations().getAudioSource() == null || !mediaProfile.getConfigurations().getAudioSource().getToken().equals(audioSourceConfiguration.getToken())) {
                            ArrayList<ConfigurationRef> configurationRefList = new ArrayList<ConfigurationRef>();
                            ConfigurationRef configurationRefAudioSource = new ConfigurationRef();
                            configurationRefAudioSource.setType("AudioSource");
                            configurationRefAudioSource.setToken(audioSourceConfiguration.getToken());
                            configurationRefList.add(configurationRefAudioSource);
                            ConfigurationRef configurationRefAudioEncoder = new ConfigurationRef();
                            configurationRefAudioEncoder.setType("AudioEncoder");
                            configurationRefAudioEncoder.setToken(audioEncoder2Configuration.getToken());
                            configurationRefList.add(configurationRefAudioEncoder);
                            media2Service.addConfiguration(mediaProfile.getToken(), null, configurationRefList);
                        }
                    }
                    catch (Throwable throwable) {
                        this.logger.warn("Error while trying to add AudioSourceConfiguration [" + audioSourceConfiguration.getToken() + "] to Profile:[" + mediaProfile.getToken() + "] for " + this + " : " + throwable.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    this.logger.warn("Error while trying to configure ONVIF audio for " + this);
                }
            }
            this.logger.info("Use following ONVIF Profile: " + mediaProfile.getToken() + " and following RTSP URL: " + this.rtspUrl + " for " + this);
            this.logger.info("Use following RTSP host: " + rtspHost + " for " + this);
            this.logger.info("Use following RTSP port: " + rtspPort + " for " + this);
        }
        catch (ConfigurationException exception) {
            this.logger.error("There are problems while setting parameters via ONVIF on the device " + this, (Throwable)exception);
            return -21602;
        }
        catch (SeeTecException exception) {
            this.logger.error("There are problems while setting parameters via ONVIF on the device " + this, (Throwable)exception);
            return exception.getErrorCode();
        }
        catch (Throwable throwable) {
            this.logger.error("There are problems while setting parameters via ONVIF on the device " + this, throwable);
            return -21662;
        }
        try {
            int legacyTimeout = (int)((GenericOnvifDevice)this.videoSrv.getDevice()).getOnvifLegacyTimeout();
            this.networkParameter.checkAndSetTimeout(legacyTimeout);
            this.rtspSettings = new RTSPStreamSettings();
            int keepaliveMethod = 3;
            boolean useHttpPersistentDuplexTunnel = false;
            if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST) {
                if (this.rtspUrl.startsWith("http")) {
                    this.rtspUrl = this.rtspUrl.replace("http", "rtsp");
                }
                keepaliveMethod = 2;
                useHttpPersistentDuplexTunnel = true;
            }
            if ((this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, rtspPort, this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, keepaliveMethod, this.rtspUrl, useHttpPersistentDuplexTunnel)) != 0) {
                this.logger.error("Error while setting RTSP parameters for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspSettings.setHost(rtspHost);
            this.rtspSettings.setUdpBuffer(65535);
            this.rtspSettings.setUserAgent("Java");
            if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST) {
                this.rtspSettings.setReceiverReportsEnabled(false);
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP stream for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (SeeTecException exception) {
            this.logger.error("Error while first RTSP request. errorCode: " + exception.getErrorCode() + " for " + this.getVideoSrv(), (Throwable)exception);
            return exception.getErrorCode();
        }
        catch (Exception exception) {
            this.logger.error("Error while first RTSP request. errorCode: " + this.errorCode + " for " + this.getVideoSrv(), (Throwable)exception);
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    private int getRTSPPortFromConfiguration() {
        int rtspPort = 554;
        try {
            rtspPort = this.listener.getVideoSourceParameter().getRtspPort();
        }
        catch (ConfigurationException configurationException) {
            this.logger.warn("Error reading RTSP port from configuration. Setting Default Port 554 for " + this.getVideoSrv().getDevice());
        }
        return rtspPort;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        try {
            if (this.transmissionID == TransmissionType.RTP_OVER_UDP_MULTICAST) {
                this.stopMulticastStreaming();
            }
        }
        catch (SeeTecException exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
        }
        return super.shutdown();
    }

    private void startMulticastStreaming() throws SeeTecException {
        this.multicastStreaming(true);
    }

    private void stopMulticastStreaming() throws SeeTecException {
        this.multicastStreaming(false);
    }

    private void multicastStreaming(boolean start) throws SeeTecException {
        GenericOnvifDevice onvifDevice = (GenericOnvifDevice)this.getVideoSrv().getDevice();
        try {
            int videoSourceNumber = this.listener.getVideoSourceParameter().getServerEntryNo() - 1;
            int videoStreamNumber = this.listener.getDynamicVideoProfileID();
            OnvifCore onvifCore = onvifDevice.getOnvifCore();
            String[] selectedOnvifProfileAndStreamName = OnvifHelper.extractOnvifProfileAndStreamName(this.listener.getVideoSourceParameter().getStreamName());
            String selectedOnvifProfile = selectedOnvifProfileAndStreamName[0];
            MediaProfile profile = onvifCore.getMedia2Service().getProfile(selectedOnvifProfile, "VMS default", videoSourceNumber, videoStreamNumber);
            if (start) {
                onvifCore.getMedia2Service().getOnvifMedia2Service().startMulticastStreaming(profile.getToken());
            } else {
                onvifCore.getMedia2Service().getOnvifMedia2Service().stopMulticastStreaming(profile.getToken());
            }
        }
        catch (ConfigurationException exception) {
            throw new SeeTecException(-21602, "Error when " + (start ? "start" : "stop") + " multicast streaming for " + this);
        }
        catch (SeeTecException exception) {
            throw new SeeTecException(exception.getErrorCode(), "Error when " + (start ? "start" : "stop") + " multicast streaming for " + this);
        }
    }

    private AudioEncoder2Configuration createAudioEncoder2Configuration(AudioEncoder2Configuration audioEncoder2Configuration, List<AudioEncoder2ConfigurationOptions> audioEncoder2ConfigurationOptionsList) {
        String encoding = "";
        if (this.audioCodec == Codec.G711U || this.audioCodec == Codec.G711A) {
            encoding = "PCMU";
        } else if (this.audioCodec == Codec.G726) {
            encoding = "G726";
        } else if (this.audioCodec == Codec.AAC) {
            encoding = "AAC";
        }
        audioEncoder2Configuration.setEncoding(encoding);
        for (AudioEncoder2ConfigurationOptions audioEncoder2ConfigurationOptions : audioEncoder2ConfigurationOptionsList) {
            if (!audioEncoder2ConfigurationOptions.getEncoding().equals(encoding)) continue;
            int bitrate = this.getBiggestBitrate(audioEncoder2ConfigurationOptions);
            audioEncoder2Configuration.setBitrate(bitrate);
            int sampleRateToSet = this.getMostCompatibleSamplerate(audioEncoder2ConfigurationOptions);
            audioEncoder2Configuration.setSampleRate(sampleRateToSet);
        }
        return audioEncoder2Configuration;
    }

    private int getBiggestBitrate(AudioEncoder2ConfigurationOptions audioEncoder2ConfigurationOptions) {
        return OnvifHelper.getBiggestIntValueAndConvert(audioEncoder2ConfigurationOptions.getBitrateList(), false);
    }

    private int getMostCompatibleSamplerate(AudioEncoder2ConfigurationOptions audioEncoder2ConfigurationOptions) {
        int samplerateToSet = 0;
        List availableSampleRates = audioEncoder2ConfigurationOptions.getSampleRateList().getItems();
        Iterator iterator = availableSampleRates.iterator();
        while (iterator.hasNext()) {
            int samplerate = (Integer)iterator.next();
            if (samplerate == 8) {
                samplerateToSet = samplerate;
                break;
            }
            if (samplerateToSet == 0) {
                samplerateToSet = samplerate;
                continue;
            }
            samplerateToSet = samplerateToSet < samplerate ? samplerateToSet : samplerate;
        }
        return samplerateToSet;
    }
}

