/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.generic;

import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Iterator;
import java.util.List;
import org.onvif.ver10.media.wsdl.Media;
import org.onvif.ver10.schema.AudioEncoderConfiguration;
import org.onvif.ver10.schema.AudioEncoderConfigurationOption;
import org.onvif.ver10.schema.AudioEncoding;
import org.onvif.ver10.schema.AudioSource;
import org.onvif.ver10.schema.AudioSourceConfiguration;
import org.onvif.ver10.schema.H264Configuration;
import org.onvif.ver10.schema.H264Profile;
import org.onvif.ver10.schema.IPAddress;
import org.onvif.ver10.schema.IPType;
import org.onvif.ver10.schema.IntRange;
import org.onvif.ver10.schema.Mpeg4Configuration;
import org.onvif.ver10.schema.Mpeg4Profile;
import org.onvif.ver10.schema.MulticastConfiguration;
import org.onvif.ver10.schema.Profile;
import org.onvif.ver10.schema.Rotate;
import org.onvif.ver10.schema.RotateMode;
import org.onvif.ver10.schema.StreamType;
import org.onvif.ver10.schema.TransportProtocol;
import org.onvif.ver10.schema.VideoEncoderConfiguration;
import org.onvif.ver10.schema.VideoEncoderConfigurationOptions;
import org.onvif.ver10.schema.VideoEncoding;
import org.onvif.ver10.schema.VideoRateControl;
import org.onvif.ver10.schema.VideoResolution;
import org.onvif.ver10.schema.VideoSource;
import org.onvif.ver10.schema.VideoSourceConfiguration;
import org.onvif.ver10.schema.VideoSourceConfigurationExtension;

public final class GenericOnvifVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifVideoSourceClient";

    @Override
    public int init() {
        String rtspHost = this.networkParameter.getHost();
        int rtspPort = this.getRTSPPortFromConfiguration();
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        try {
            Profile profile;
            OnvifCore onvifCore;
            block84: {
                VideoEncoderConfiguration videoEncoderConfiguration;
                int videoSourceNumber = this.listener.getVideoSourceParameter().getServerEntryNo() - 1;
                int videoStreamNumber = this.listener.getDynamicVideoProfileID();
                int audioSourceNumber = 0;
                int audioStreamNumber = 0;
                GenericOnvifDevice onvifDevice = (GenericOnvifDevice)this.getVideoSrv().getDevice();
                onvifCore = onvifDevice.getOnvifCore();
                DeviceDefinition deviceDefinition = onvifDevice.getDeviceDefinitionFromConfiguration();
                Media mediaService = onvifCore.getMediaService().getOnvifMediaService();
                String[] selectedOnvifProfileAndStreamName = OnvifHelper.extractOnvifProfileAndStreamName(this.listener.getVideoSourceParameter().getStreamName());
                String selectedOnvifProfile = selectedOnvifProfileAndStreamName[0];
                String selectedStreamName = selectedOnvifProfileAndStreamName[1];
                profile = onvifCore.getMediaService().getProfile(selectedOnvifProfile, "VMS default", videoSourceNumber, videoStreamNumber);
                VideoSourceConfiguration videoSourceConfiguration = null;
                try {
                    videoSourceConfiguration = (VideoSourceConfiguration)mediaService.getCompatibleVideoSourceConfigurations(profile.getToken()).get(videoSourceNumber);
                }
                catch (Exception ex) {
                    List configurations = mediaService.getVideoSourceConfigurations();
                    if (configurations.size() > videoSourceNumber) {
                        videoSourceConfiguration = (VideoSourceConfiguration)configurations.get(videoSourceNumber);
                    }
                    if (configurations.size() == 1) {
                        videoSourceConfiguration = (VideoSourceConfiguration)configurations.get(0);
                    }
                    this.logger.warn("No Video Source Configuration found for " + this);
                }
                if (videoSourceConfiguration != null) {
                    videoSourceConfiguration.setSourceToken(((VideoSource)mediaService.getVideoSources().get(videoSourceNumber)).getToken());
                    try {
                        List degreeList = mediaService.getVideoSourceConfigurationOptions(null, null).getExtension().getRotate().getDegreeList().getItems();
                        if (degreeList != null && degreeList.size() > 1) {
                            Rotate rotate = new Rotate();
                            rotate.setDegree(Integer.valueOf(this.rotationAngle));
                            rotate.setMode(this.rotationAngle == 0 ? RotateMode.OFF : RotateMode.ON);
                            VideoSourceConfigurationExtension videoSourceConfigurationExtension = videoSourceConfiguration.getExtension();
                            if (videoSourceConfigurationExtension == null) {
                                videoSourceConfigurationExtension = new VideoSourceConfigurationExtension();
                            }
                            videoSourceConfigurationExtension.setRotate(rotate);
                            videoSourceConfiguration.setExtension(videoSourceConfigurationExtension);
                        }
                    }
                    catch (Exception ex) {
                        try {
                            List rotateModeList = mediaService.getVideoSourceConfigurationOptions(null, null).getExtension().getRotate().getMode();
                            if (rotateModeList != null && rotateModeList.size() > 1 || rotateModeList != null && rotateModeList.size() == 1 && rotateModeList.get(0) == RotateMode.ON) {
                                Rotate rotate = new Rotate();
                                rotate.setMode(this.rotationAngle == 0 ? RotateMode.OFF : RotateMode.ON);
                                VideoSourceConfigurationExtension videoSourceConfigurationExtension = videoSourceConfiguration.getExtension();
                                if (videoSourceConfigurationExtension == null) {
                                    videoSourceConfigurationExtension = new VideoSourceConfigurationExtension();
                                }
                                videoSourceConfigurationExtension.setRotate(rotate);
                                videoSourceConfiguration.setExtension(videoSourceConfigurationExtension);
                            }
                        }
                        catch (Exception exception) {
                            this.logger.warn("Could not rotate image using Media Service for " + this);
                        }
                    }
                    try {
                        mediaService.setVideoSourceConfiguration(videoSourceConfiguration, true);
                    }
                    catch (Throwable throwable) {
                        this.logger.warn("Error while trying to set VideoSourceConfiguration [" + videoSourceConfiguration.getToken() + "] for " + this);
                    }
                    try {
                        if (profile.getVideoSourceConfiguration() == null || profile.getVideoSourceConfiguration() != null && !profile.getVideoSourceConfiguration().getToken().equals(videoSourceConfiguration.getToken())) {
                            mediaService.addVideoSourceConfiguration(profile.getToken(), videoSourceConfiguration.getToken());
                        }
                    }
                    catch (Throwable throwable) {
                        this.logger.warn("Error while trying to add VideoSourceConfiguration [" + videoSourceConfiguration.getToken() + "] to Profile:[" + profile.getToken() + "] for " + this);
                    }
                }
                if (this.videoCodec == Codec.RTSP) {
                    videoEncoderConfiguration = (VideoEncoderConfiguration)mediaService.getVideoEncoderConfigurations().get(0);
                } else {
                    IntRange govLengthRange;
                    videoEncoderConfiguration = mediaService.getVideoEncoderConfiguration(selectedStreamName);
                    VideoEncoderConfigurationOptions videoEncoderConfigurationOptions = mediaService.getVideoEncoderConfigurationOptions(selectedStreamName, null);
                    IntRange qualityRange = videoEncoderConfigurationOptions.getQualityRange();
                    MpegProfile mpegProfile = this.listener.getVideoSourceParameter().getMpegProfile();
                    VideoEncoding videoEncoding = null;
                    if (this.videoCodec == Codec.MJPEG) {
                        videoEncoding = VideoEncoding.JPEG;
                        videoEncoderConfiguration.setMPEG4(null);
                        videoEncoderConfiguration.setH264(null);
                    } else if (this.videoCodec == Codec.H264) {
                        videoEncoding = VideoEncoding.H_264;
                        H264Configuration h264Configuration = new H264Configuration();
                        govLengthRange = videoEncoderConfigurationOptions.getH264().getGovLengthRange();
                        h264Configuration.setGovLength(Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, govLengthRange.getMin(), govLengthRange.getMax()));
                        if (mpegProfile == MpegProfile.BASELINE) {
                            h264Configuration.setH264Profile(H264Profile.BASELINE);
                        } else if (mpegProfile == MpegProfile.EXTENDED) {
                            h264Configuration.setH264Profile(H264Profile.EXTENDED);
                        } else if (mpegProfile == MpegProfile.HIGH) {
                            h264Configuration.setH264Profile(H264Profile.HIGH);
                        } else if (mpegProfile == MpegProfile.MAIN) {
                            h264Configuration.setH264Profile(H264Profile.MAIN);
                        } else {
                            h264Configuration.setH264Profile(null);
                        }
                        videoEncoderConfiguration.setH264(h264Configuration);
                        videoEncoderConfiguration.setMPEG4(null);
                    } else if (this.videoCodec == Codec.MPEG4) {
                        videoEncoding = VideoEncoding.MPEG_4;
                        Mpeg4Configuration mpeg4Configuration = new Mpeg4Configuration();
                        govLengthRange = videoEncoderConfigurationOptions.getMPEG4().getGovLengthRange();
                        mpeg4Configuration.setGovLength(Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, govLengthRange.getMin(), govLengthRange.getMax()));
                        if (mpegProfile == MpegProfile.SP) {
                            mpeg4Configuration.setMpeg4Profile(Mpeg4Profile.SP);
                        } else if (mpegProfile == MpegProfile.ASP) {
                            mpeg4Configuration.setMpeg4Profile(Mpeg4Profile.ASP);
                        } else {
                            mpeg4Configuration.setMpeg4Profile(null);
                        }
                        videoEncoderConfiguration.setMPEG4(mpeg4Configuration);
                        videoEncoderConfiguration.setH264(null);
                    }
                    videoEncoderConfiguration.setEncoding(videoEncoding);
                    this.quality /= 1000;
                    int calculatedQuality = this.quality * (qualityRange.getMax() - qualityRange.getMin()) / 100 + qualityRange.getMin();
                    videoEncoderConfiguration.setQuality((float)calculatedQuality);
                    VideoResolution videoResolution = new VideoResolution();
                    videoResolution.setWidth(this.width);
                    videoResolution.setHeight(this.height);
                    videoEncoderConfiguration.setResolution(videoResolution);
                    VideoRateControl videoRateControl = new VideoRateControl();
                    videoRateControl.setBitrateLimit(this.bandwidth / 1024);
                    videoRateControl.setEncodingInterval(this.listener.getVideoSourceParameter().getEncodingInterval() / 1000);
                    videoRateControl.setFrameRateLimit((int)(this.fps / 1000L));
                    videoEncoderConfiguration.setRateControl(videoRateControl);
                    if (this.videoCodec == Codec.MJPEG && (this.rotationAngle == 90 || this.rotationAngle == 270)) {
                        int temp = this.width;
                        this.width = this.height;
                        this.height = temp;
                    }
                    if (this.transmissionID == TransmissionType.RTP_OVER_UDP_MULTICAST) {
                        String multicastAddress = "0.0.0.0";
                        int multicastPort = 0;
                        int multicastTtl = 0;
                        boolean multicastAutoStart = false;
                        String[] deviceMulticastConfiguration = this.listener.getVideoSourceParameter().getDeviceMulticastConfiguration();
                        if (deviceMulticastConfiguration != null) {
                            multicastAddress = deviceMulticastConfiguration[0];
                            multicastPort = Integer.parseInt(deviceMulticastConfiguration[1]);
                            multicastTtl = 1;
                            try {
                                multicastTtl = Integer.parseInt(deviceMulticastConfiguration[2]);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        MulticastConfiguration onvifMulticast = new MulticastConfiguration();
                        IPAddress onvifMulticastAddress = new IPAddress();
                        onvifMulticastAddress.setType(IPType.I_PV_4);
                        onvifMulticastAddress.setIPv4Address(multicastAddress);
                        onvifMulticast.setAddress(onvifMulticastAddress);
                        onvifMulticast.setPort(multicastPort);
                        onvifMulticast.setTTL(multicastTtl);
                        onvifMulticast.setAutoStart(multicastAutoStart);
                        videoEncoderConfiguration.setMulticast(onvifMulticast);
                    }
                }
                try {
                    mediaService.setVideoEncoderConfiguration(videoEncoderConfiguration, true);
                }
                catch (Throwable throwable) {
                    this.logger.warn("Error while trying to set VideoEncoderConfiguration [" + videoEncoderConfiguration.getToken() + "] for " + this);
                }
                try {
                    if (profile.getVideoEncoderConfiguration() == null || profile.getVideoEncoderConfiguration() != null && !profile.getVideoEncoderConfiguration().getToken().equals(videoEncoderConfiguration.getToken())) {
                        mediaService.addVideoEncoderConfiguration(profile.getToken(), videoEncoderConfiguration.getToken());
                    }
                }
                catch (Throwable throwable) {
                    this.logger.warn("Error while trying to add VideoEncoderConfiguration [" + videoEncoderConfiguration.getToken() + "] to Profile:[" + profile.getToken() + "] for " + this);
                }
                try {
                    if (deviceDefinition == null || deviceDefinition.getAudioCapabilities() == null || !deviceDefinition.getAudioCapabilities().isCanAudio()) break block84;
                    if (this.isAudioEnabled && this.audioCodec != Codec.UNKNOWN) {
                        AudioSourceConfiguration audioSourceConfiguration = (AudioSourceConfiguration)mediaService.getCompatibleAudioSourceConfigurations(profile.getToken()).get(audioSourceNumber);
                        audioSourceConfiguration.setSourceToken(((AudioSource)mediaService.getAudioSources().get(audioSourceNumber)).getToken());
                        try {
                            mediaService.setAudioSourceConfiguration(audioSourceConfiguration, true);
                        }
                        catch (Throwable throwable) {
                            this.logger.warn("Error while trying to set AudioSourceConfiguration [" + audioSourceConfiguration.getToken() + "] for " + this);
                        }
                        try {
                            if (profile.getAudioSourceConfiguration() == null || profile.getAudioSourceConfiguration() != null && !profile.getAudioSourceConfiguration().getToken().equals(audioSourceConfiguration.getToken())) {
                                mediaService.addAudioSourceConfiguration(profile.getToken(), audioSourceConfiguration.getToken());
                            }
                        }
                        catch (Throwable throwable) {
                            this.logger.warn("Error while trying to add AudioSourceConfiguration [" + audioSourceConfiguration.getToken() + "] to Profile:[" + profile.getToken() + "] for " + this);
                        }
                        AudioEncoderConfiguration audioEncoderConfiguration = (AudioEncoderConfiguration)mediaService.getCompatibleAudioEncoderConfigurations(profile.getToken()).get(audioStreamNumber);
                        List audioEncoderConfigurationOptions = mediaService.getAudioEncoderConfigurationOptions(audioEncoderConfiguration.getToken(), profile.getToken()).getOptions();
                        audioEncoderConfiguration = this.createAudioEncoderConfiguration(audioEncoderConfiguration, audioEncoderConfigurationOptions);
                        try {
                            mediaService.setAudioEncoderConfiguration(audioEncoderConfiguration, true);
                        }
                        catch (Throwable throwable) {
                            this.logger.warn("Error while trying to set AudioEncoderConfiguration [" + audioEncoderConfiguration.getToken() + "] for " + this);
                        }
                        try {
                            if (profile.getAudioEncoderConfiguration() == null || profile.getAudioEncoderConfiguration() != null && !profile.getAudioEncoderConfiguration().getToken().equals(audioEncoderConfiguration.getToken())) {
                                mediaService.addAudioEncoderConfiguration(profile.getToken(), audioEncoderConfiguration.getToken());
                            }
                            break block84;
                        }
                        catch (Throwable throwable) {
                            this.logger.warn("Error while trying to add AudioEncoderConfiguration [" + audioEncoderConfiguration.getToken() + "] to Profile:[" + profile.getToken() + "] for " + this);
                        }
                        break block84;
                    }
                    try {
                        if (profile.getAudioEncoderConfiguration() != null) {
                            mediaService.removeAudioEncoderConfiguration(profile.getToken());
                        }
                    }
                    catch (Throwable throwable) {
                        this.logger.warn("Error while trying to remove AudioEncoderConfiguration from Profile: [" + profile.getToken() + "] for " + this);
                    }
                }
                catch (Throwable throwable) {
                    this.logger.warn("Error while trying to configure ONVIF audio for " + this);
                }
            }
            if (this.transmissionID == TransmissionType.RTP_OVER_UDP_UNICAST) {
                this.rtspUrl = onvifCore.getMediaService().getStreamUri(profile.getToken(), StreamType.RTP_UNICAST, TransportProtocol.UDP);
            } else if (this.transmissionID == TransmissionType.RTP_OVER_UDP_MULTICAST) {
                this.rtspUrl = onvifCore.getMediaService().getStreamUri(profile.getToken(), StreamType.RTP_MULTICAST, TransportProtocol.UDP);
                this.startMulticastStreaming();
            } else if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_TCP) {
                this.rtspUrl = onvifCore.getMediaService().getStreamUri(profile.getToken(), StreamType.RTP_UNICAST, TransportProtocol.RTSP);
            } else if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST) {
                this.rtspUrl = onvifCore.getMediaService().getStreamUri(profile.getToken(), StreamType.RTP_UNICAST, TransportProtocol.HTTP);
            }
            if (this.transmissionID != TransmissionType.PROPRIETARY_MULTICAST) {
                this.rtspUrl = OnvifHelper.changeIPAddressPortOfUrl(this.rtspUrl, rtspHost, rtspPort, this.logger);
            }
            this.logger.info("Use following ONVIF Profile: " + profile.getToken() + " and following RTSP URL: " + this.rtspUrl + " for " + this);
            this.logger.info("Use following RTSP host: " + rtspHost + " for " + this);
            this.logger.info("Use following RTSP port: " + rtspPort + " for " + this);
        }
        catch (ConfigurationException exception) {
            this.logger.error("There are problems while setting parameters via ONVIF on the device " + this, (Throwable)exception);
            return -21602;
        }
        catch (SeeTecException exception) {
            this.logger.error("There are problems while setting parameters via ONVIF on the device " + this, (Throwable)exception);
            return exception.getErrorCode();
        }
        catch (Throwable throwable) {
            this.logger.error("There are problems while setting parameters via ONVIF on the device " + this, throwable);
            return -21662;
        }
        try {
            int legacyTimeout = (int)((GenericOnvifDevice)this.videoSrv.getDevice()).getOnvifLegacyTimeout();
            this.networkParameter.checkAndSetTimeout(legacyTimeout);
            this.rtspSettings = new RTSPStreamSettings();
            int keepaliveMethod = 3;
            boolean useHttpPersistentDuplexTunnel = false;
            this.respectEveryParameterSet = true;
            if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST) {
                if (this.rtspUrl.startsWith("http")) {
                    this.rtspUrl = this.rtspUrl.replace("http", "rtsp");
                }
                keepaliveMethod = 2;
                useHttpPersistentDuplexTunnel = true;
            }
            if ((this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, rtspPort, this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, keepaliveMethod, this.rtspUrl, useHttpPersistentDuplexTunnel)) != 0) {
                this.logger.error("Error while setting RTSP parameters for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspSettings.setHost(rtspHost);
            this.rtspSettings.setUdpBuffer(65535);
            this.rtspSettings.setUserAgent("Java");
            if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST) {
                this.rtspSettings.setReceiverReportsEnabled(false);
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP stream for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (SeeTecException exception) {
            this.logger.error("Error while first RTSP request. errorCode: " + exception.getErrorCode() + " for " + this.getVideoSrv(), (Throwable)exception);
            return exception.getErrorCode();
        }
        catch (Exception exception) {
            this.logger.error("Error while first RTSP request. errorCode: " + this.errorCode + " for " + this.getVideoSrv(), (Throwable)exception);
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    private AudioEncoderConfiguration createAudioEncoderConfiguration(AudioEncoderConfiguration audioEncoderConfiguration, List<AudioEncoderConfigurationOption> audioEncoderConfigurationOptions) {
        AudioEncoding audioEncoding = null;
        if (this.audioCodec == Codec.G711U || this.audioCodec == Codec.G711A) {
            audioEncoding = AudioEncoding.G_711;
        } else if (this.audioCodec == Codec.G726) {
            audioEncoding = AudioEncoding.G_726;
        } else if (this.audioCodec == Codec.AAC) {
            audioEncoding = AudioEncoding.AAC;
        }
        audioEncoderConfiguration.setEncoding(audioEncoding);
        int bitrate = this.getBiggestBitrate(audioEncoderConfigurationOptions, audioEncoding);
        audioEncoderConfiguration.setBitrate(bitrate);
        int sampleRateToSet = this.getMostCompatibleSamplerate(audioEncoderConfigurationOptions, audioEncoding);
        audioEncoderConfiguration.setSampleRate(sampleRateToSet);
        return audioEncoderConfiguration;
    }

    private int getBiggestBitrate(List<AudioEncoderConfigurationOption> audioEncoderConfigurationOptions, AudioEncoding audioEncoding) {
        int bitrate = 0;
        for (AudioEncoderConfigurationOption audioEncoderConfigurationOption : audioEncoderConfigurationOptions) {
            if (audioEncoderConfigurationOption.getEncoding() != audioEncoding) continue;
            bitrate = OnvifHelper.getBiggestIntValueAndConvert(audioEncoderConfigurationOption.getBitrateList(), false);
            break;
        }
        return bitrate;
    }

    private int getMostCompatibleSamplerate(List<AudioEncoderConfigurationOption> audioEncoderConfigurationOptions, AudioEncoding audioEncoding) {
        int samplerateToSet = 0;
        block0: for (AudioEncoderConfigurationOption audioEncoderConfigurationOption : audioEncoderConfigurationOptions) {
            if (audioEncoderConfigurationOption.getEncoding() != audioEncoding) continue;
            List availableSampleRates = audioEncoderConfigurationOption.getSampleRateList().getItems();
            Iterator iterator = availableSampleRates.iterator();
            while (iterator.hasNext()) {
                int samplerate = (Integer)iterator.next();
                if (samplerate == 8) {
                    samplerateToSet = samplerate;
                    break block0;
                }
                if (samplerateToSet == 0) {
                    samplerateToSet = samplerate;
                    continue;
                }
                samplerateToSet = samplerateToSet < samplerate ? samplerateToSet : samplerate;
            }
            break block0;
        }
        return samplerateToSet;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        try {
            if (this.transmissionID == TransmissionType.RTP_OVER_UDP_MULTICAST) {
                this.stopMulticastStreaming();
            }
        }
        catch (SeeTecException exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
        }
        return super.shutdown();
    }

    private void startMulticastStreaming() throws SeeTecException {
        this.multicastStreaming(true);
    }

    private void stopMulticastStreaming() throws SeeTecException {
        this.multicastStreaming(false);
    }

    private void multicastStreaming(boolean start) throws SeeTecException {
        GenericOnvifDevice onvifDevice = (GenericOnvifDevice)this.getVideoSrv().getDevice();
        try {
            int videoSourceNumber = this.listener.getVideoSourceParameter().getServerEntryNo() - 1;
            int videoStreamNumber = this.listener.getDynamicVideoProfileID();
            OnvifCore onvifCore = onvifDevice.getOnvifCore();
            String[] selectedOnvifProfileAndStreamName = OnvifHelper.extractOnvifProfileAndStreamName(this.listener.getVideoSourceParameter().getStreamName());
            String selectedOnvifProfile = selectedOnvifProfileAndStreamName[0];
            Profile profile = onvifCore.getMediaService().getProfile(selectedOnvifProfile, "VMS default", videoSourceNumber, videoStreamNumber);
            if (start) {
                onvifCore.getMediaService().getOnvifMediaService().startMulticastStreaming(profile.getToken());
            } else {
                onvifCore.getMediaService().getOnvifMediaService().stopMulticastStreaming(profile.getToken());
            }
        }
        catch (ConfigurationException exception) {
            throw new SeeTecException(-21602, "Error when " + (start ? "start" : "stop") + " multicast streaming for " + this);
        }
        catch (SeeTecException exception) {
            throw new SeeTecException(exception.getErrorCode(), "Error when " + (start ? "start" : "stop") + " multicast streaming for " + this);
        }
    }

    private int getRTSPPortFromConfiguration() {
        int rtspPort = 554;
        try {
            rtspPort = this.listener.getVideoSourceParameter().getRtspPort();
        }
        catch (ConfigurationException configurationException) {
            this.logger.warn("Error reading RTSP port from configuration. Setting Default Port 554 for " + this.getVideoSrv().getDevice());
        }
        return rtspPort;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

