/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.generic;

import de.seetec.v5.re.cm.device.video.onvif.generic.RecordingEvent;
import de.seetec.v5.re.cm.shared.timerange.TimeRange;
import de.seetec.v5.re.shared.MpegProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.onvif.ver10.schema.FindEventResult;
import org.onvif.ver10.schema.FindEventResultList;
import org.onvif.ver10.schema.H264Profile;
import org.onvif.ver10.schema.IntRange;
import org.onvif.ver10.schema.ItemList;
import org.onvif.ver10.schema.Message;
import org.onvif.ver10.schema.TrackInformation;

public class GenericOnvifHelper {
    public static List<RecordingEvent> getRecordingEvents(FindEventResultList findEventResultList) {
        ArrayList<RecordingEvent> recordingEventList = new ArrayList<RecordingEvent>();
        for (FindEventResult findEventResult : findEventResultList.getResult()) {
            String name;
            Message message;
            String recordingState;
            if (findEventResult.getEvent() == null || findEventResult.getEvent().getTopic() == null || findEventResult.getEvent().getTopic().getContent() == null || findEventResult.getEvent().getTopic().getContent().size() <= 0 || !(recordingState = (String)findEventResult.getEvent().getTopic().getContent().get(0)).toLowerCase().contains("recordinghistory/recording/state") || (message = (Message)findEventResult.getEvent().getMessage().getAny()).getData().getSimpleItem().size() <= 0 || !(name = ((ItemList.SimpleItem)message.getData().getSimpleItem().get(0)).getName()).toLowerCase().contains("isrecording")) continue;
            long timestamp = findEventResult.getTime().toGregorianCalendar().getTimeInMillis();
            String value = ((ItemList.SimpleItem)message.getData().getSimpleItem().get(0)).getValue();
            boolean recording = value.toLowerCase().equals("true");
            RecordingEvent ssr = new RecordingEvent();
            ssr.setStart(recording);
            ssr.setTimestamp(timestamp);
            recordingEventList.add(ssr);
        }
        Collections.sort(recordingEventList);
        return recordingEventList;
    }

    public static List<TimeRange> getTimeRangeList(long startTimeStamp, long endTimeStamp, TrackInformation trackInTime, List<RecordingEvent> recordingEventList) {
        long startOfTrack = trackInTime.getDataFrom().toGregorianCalendar(TimeZone.getTimeZone("GMT"), null, null).getTimeInMillis();
        long endOfTrack = trackInTime.getDataTo().toGregorianCalendar(TimeZone.getTimeZone("GMT"), null, null).getTimeInMillis();
        startOfTrack = startOfTrack < startTimeStamp ? startTimeStamp : startOfTrack;
        endOfTrack = endOfTrack > endTimeStamp ? endTimeStamp : endOfTrack;
        long startOfSlice = 0L;
        long endOfSlice = 0L;
        ArrayList<TimeRange> timeRangeTmp = new ArrayList<TimeRange>();
        boolean expectStartEvent = true;
        for (RecordingEvent recordingEvent : recordingEventList) {
            if (recordingEvent.isStart()) {
                if (!expectStartEvent) continue;
                if (recordingEvent.getTimestamp() >= startOfTrack && recordingEvent.getTimestamp() <= endOfTrack) {
                    startOfSlice = recordingEvent.getTimestamp();
                } else if (recordingEvent.getTimestamp() < startOfTrack) {
                    startOfSlice = startOfTrack;
                }
                expectStartEvent = false;
            } else {
                if (expectStartEvent) continue;
                if (recordingEvent.getTimestamp() >= startOfTrack && recordingEvent.getTimestamp() <= endOfTrack) {
                    if (recordingEvent.getTimestamp() >= startOfSlice) {
                        if (startOfSlice == 0L) {
                            startOfSlice = startOfTrack;
                        }
                        endOfSlice = recordingEvent.getTimestamp();
                    } else {
                        startOfSlice = 0L;
                        endOfSlice = 0L;
                    }
                } else if (recordingEvent.getTimestamp() > endOfTrack) {
                    endOfSlice = endOfTrack;
                }
                expectStartEvent = true;
            }
            if (startOfSlice == 0L || endOfSlice == 0L) continue;
            TimeRange timeRange = new TimeRange(startOfSlice, endOfSlice);
            if (timeRange.getStartTimestamp() >= startTimeStamp && timeRange.getStartTimestamp() <= endTimeStamp && timeRange.getEndTimestamp() >= startTimeStamp && timeRange.getEndTimestamp() <= endTimeStamp) {
                TimeRange t = new TimeRange(timeRange.getStartTimestamp(), timeRange.getEndTimestamp());
                timeRangeTmp.add(t);
            }
            startOfSlice = 0L;
            endOfSlice = 0L;
        }
        if (startOfSlice != 0L && endOfSlice == 0L) {
            TimeRange timeRange = new TimeRange(startOfSlice, endOfTrack);
            timeRangeTmp.add(timeRange);
        }
        return timeRangeTmp;
    }

    public static long convertTimestampToCamera(long timestamp, Long diff) {
        long t = timestamp + (diff == null ? 0L : diff);
        return t;
    }

    public IntRange convertFramerateListToIntRange(List<Float> framerateList) {
        IntRange frameRateRange = new IntRange();
        for (Float framerate : framerateList) {
            if (frameRateRange.getMin() == 0 || (float)frameRateRange.getMin() > framerate.floatValue()) {
                frameRateRange.setMin(framerate.intValue());
            }
            if (frameRateRange.getMax() != 0 && !((float)frameRateRange.getMax() < framerate.floatValue())) continue;
            frameRateRange.setMax(framerate.intValue());
        }
        return frameRateRange;
    }

    public IntRange convertGovLengthListToIntRange(List<Integer> govLengthList) {
        IntRange govLengthRange = new IntRange();
        for (Integer govLength : govLengthList) {
            if (govLengthRange.getMin() == 0 || govLengthRange.getMin() > govLength) {
                govLengthRange.setMin(govLength.intValue());
            }
            if (govLengthRange.getMax() != 0 && govLengthRange.getMax() >= govLength) continue;
            govLengthRange.setMax(govLength.intValue());
        }
        return govLengthRange;
    }

    public List<Integer> createMpegProfilesList(List<String> h264Profiles) {
        ArrayList<Integer> profiles = new ArrayList<Integer>();
        if (h264Profiles != null) {
            for (String h264Profile : h264Profiles) {
                if (h264Profile.equals(H264Profile.BASELINE.value())) {
                    profiles.add(MpegProfile.BASELINE.getType());
                    continue;
                }
                if (h264Profile.equals(H264Profile.EXTENDED.value())) {
                    profiles.add(MpegProfile.EXTENDED.getType());
                    continue;
                }
                if (h264Profile.equals(H264Profile.HIGH.value())) {
                    profiles.add(MpegProfile.HIGH.getType());
                    continue;
                }
                if (!h264Profile.equals(H264Profile.MAIN.value())) continue;
                profiles.add(MpegProfile.MAIN.getType());
            }
        }
        return profiles;
    }
}

