/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.generic;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.onvif.EventMessage;
import de.seetec.v5.re.cm.device.shared.onvif.EventMessageDescription;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifDevice;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifIoHandler;
import de.seetec.v5.shared.Basic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.onvif.ver10.events.wsdl.PullMessagesFaultResponse;
import org.onvif.ver10.events.wsdl.PullMessagesFaultResponse_Exception;
import org.onvif.ver10.schema.VideoSource;
import org.onvif.ver10.schema.VideoSourceConfiguration;

public class GenericOnvifEventHandler
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifEventHandler";
    private Logger logger = null;
    private Thread thread = null;
    private OnvifCore onvifCore = null;
    private GenericOnvifDevice genericOnvifDevice = null;
    private final Collection<HardwareMotionDetection<? extends MotionDetectionHandler>> hardwareMotionDetections = Collections.synchronizedList(new ArrayList());
    private GenericOnvifIoHandler genericOnvifIoHandler = null;
    private int timeoutInSeconds = 5;
    private int messageLimit = 30;
    private Duration timeoutDuration = null;
    private HashMap<String, Integer> sources = new HashMap();
    private final List<Integer> activeTrigger = Collections.synchronizedList(new ArrayList());

    public GenericOnvifEventHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    protected static boolean contains(String[] stringArray, String searchString) {
        if (stringArray != null && stringArray.length > 0 && searchString != null && !searchString.isEmpty()) {
            for (String line : stringArray) {
                if (!line.equals(searchString)) continue;
                return true;
            }
        }
        return false;
    }

    public int init(OnvifCore onvifCore, GenericOnvifDevice genericOnvifDevice) {
        this.onvifCore = onvifCore;
        this.genericOnvifDevice = genericOnvifDevice;
        try {
            this.timeoutDuration = OnvifHelper.intToDuration(this.timeoutInSeconds);
            List videoSources = this.onvifCore.getMediaService().getOnvifMediaService().getVideoSources();
            List videoSourceConfigurationList = this.onvifCore.getMediaService().getOnvifMediaService().getVideoSourceConfigurations();
            this.sources = this.matchVideoSourceNumbersToTokenAndName(videoSources, videoSourceConfigurationList);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.error("Incorrect Input for intToDuration for " + this.genericOnvifDevice);
        }
        this.thread = new Thread((Runnable)this, CLASS_NAME);
        this.thread.start();
        return 0;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        int tryCounter = 0;
        while (!this.isShutdown(CLASS_NAME) && !this.genericOnvifDevice.isShutdown()) {
            try {
                List<EventMessage> eventMessages;
                if (this.hardwareMotionDetections != null) {
                    for (HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection : this.hardwareMotionDetections) {
                        for (Integer n : this.activeTrigger) {
                            hardwareMotionDetection.evaluateWindow(n);
                        }
                    }
                }
                if (tryCounter > 2) {
                    Thread.sleep(60000L);
                    this.onvifCore.getEventService().resetEventService();
                    tryCounter = 0;
                } else {
                    Thread.sleep(250L);
                }
                try {
                    eventMessages = this.onvifCore.getEventService().pullMessages(this.timeoutDuration, this.messageLimit);
                    tryCounter = 0;
                }
                catch (PullMessagesFaultResponse_Exception pullMessagesFaultResponse_Exception) {
                    ++tryCounter;
                    PullMessagesFaultResponse pullMessagesFaultResponse = pullMessagesFaultResponse_Exception.getFaultInfo();
                    if (this.timeoutInSeconds > OnvifHelper.durationToInt(pullMessagesFaultResponse.getMaxTimeout())) {
                        this.timeoutDuration = pullMessagesFaultResponse.getMaxTimeout();
                        this.timeoutInSeconds = OnvifHelper.durationToInt(this.timeoutDuration);
                    }
                    if (this.messageLimit > pullMessagesFaultResponse.getMaxMessageLimit()) {
                        this.messageLimit = pullMessagesFaultResponse.getMaxMessageLimit();
                    }
                    this.logger.warn("ONVIF FAULT : " + pullMessagesFaultResponse_Exception.getMessage() + " for " + this.genericOnvifDevice);
                    this.logger.info("Using MaxTimeout = " + this.timeoutInSeconds + " and MaxMessageLimit = " + this.messageLimit + " " + this.genericOnvifDevice);
                    continue;
                }
                catch (Exception exception) {
                    ++tryCounter;
                    this.logger.info("Error message : " + exception.getMessage() + " for " + this.genericOnvifDevice);
                    this.logger.warn("Error while evaluating Onvif event for " + this.genericOnvifDevice);
                    continue;
                }
                HashMap<Integer, Boolean> inputs = new HashMap<Integer, Boolean>();
                for (EventMessage eventMessage : eventMessages) {
                    DigitalInputSrv[] iServices;
                    if (this.hardwareMotionDetections == null) continue;
                    for (HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection : this.hardwareMotionDetections) {
                        HardwareMotionDetectionCnf[] hardwareMotionDetectionCnfs;
                        int sourceNumber = hardwareMotionDetection.getVideoSrv().getVideoSourceCnf().getServerEntryNo();
                        if (eventMessage.getSourceValue() == null || (this.sources.get(eventMessage.getSourceValue()) == null || this.sources.get(eventMessage.getSourceValue()) != sourceNumber) && this.sources.get(eventMessage.getSourceValue()) != null || (hardwareMotionDetectionCnfs = hardwareMotionDetection.getHardwareMotionDetectionCnf()) == null || hardwareMotionDetectionCnfs.length <= 0) continue;
                        for (HardwareMotionDetectionCnf hardwareMotionDetectionCnf : hardwareMotionDetectionCnfs) {
                            EventMessageDescription eventMessageDefinition;
                            String onvifEventType = hardwareMotionDetectionCnf.getOnvifEventType();
                            int window = hardwareMotionDetectionCnf.getWindow() - 1;
                            String topic = this.removeNamespace(eventMessage.getTopic());
                            if (!topic.contains(onvifEventType) || !GenericOnvifEventHandler.contains((eventMessageDefinition = this.genericOnvifDevice.getEventTypesMap().get(onvifEventType)).getDataName(), eventMessage.getDataName())) continue;
                            int value = 0;
                            if (eventMessage.getDataValue().matches("\\d+")) {
                                try {
                                    value = Integer.parseInt(eventMessage.getDataValue());
                                }
                                catch (NumberFormatException ex) {
                                    this.logger.warn("Could not parse " + eventMessage.getDataValue() + " for " + this);
                                }
                            }
                            if (value > 1 || eventMessage.getDataValue().toLowerCase().equals("true") || eventMessage.getDataValue().equals("1") || eventMessage.getDataValue().equals("Trigger") || eventMessage.getDataValue().equals("Notify") || eventMessage.getDataValue().contains("IVA_Alarm")) {
                                hardwareMotionDetection.evaluateWindow(window);
                                if (!eventMessage.getDataName().equalsIgnoreCase("state")) continue;
                                this.setRetriggerAlarm(window);
                                continue;
                            }
                            if ((!eventMessage.getDataName().equalsIgnoreCase("state") || !eventMessage.getDataValue().equalsIgnoreCase("false")) && !eventMessage.getDataValue().equals("0")) continue;
                            this.removeRetriggerAlarm(window);
                        }
                    }
                    if (this.genericOnvifIoHandler == null || (iServices = this.genericOnvifIoHandler.getDigitalInputSrv()) == null) continue;
                    for (int i = 0; i < iServices.length; i += 2) {
                        if (!iServices[i + 1].getDigitalInputSrvCnf().isEnabled()) continue;
                        String onvifEventType = iServices[i + 1].getDigitalInputSrvCnf().getOnvifEventType();
                        String topic = this.removeNamespace(eventMessage.getTopic());
                        if (!topic.contains(onvifEventType)) continue;
                        EventMessageDescription eventMessageDefinition = this.genericOnvifDevice.getEventTypesMap().get(onvifEventType);
                        int input = i / 2;
                        boolean inputDetected = false;
                        if (GenericOnvifEventHandler.contains(eventMessageDefinition.getDataName(), eventMessage.getDataName()) && (eventMessage.getDataValue().toLowerCase().equals("true") || eventMessage.getDataValue().equals("1"))) {
                            inputDetected = true;
                        }
                        if (inputs.get(input) != null && ((Boolean)inputs.get(input)).booleanValue()) continue;
                        inputs.put(input, inputDetected);
                    }
                }
                for (Map.Entry entry : inputs.entrySet()) {
                    this.genericOnvifIoHandler.receiveAlarm((Integer)entry.getKey(), (Boolean)entry.getValue() != false ? 1 : 0);
                }
            }
            catch (Exception exception) {
                this.logger.warn("Error while evaluating Onvif event for " + this, (Throwable)exception);
            }
        }
        super.setRunFinished(CLASS_NAME, true);
    }

    public int shutdown() {
        this.activeTrigger.clear();
        this.startShutdown(CLASS_NAME);
        return 0;
    }

    public void activateMotionDetection(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        if (!this.hardwareMotionDetections.contains(hardwareMotionDetection) && hardwareMotionDetection != null) {
            this.hardwareMotionDetections.add(hardwareMotionDetection);
        }
    }

    public void deactivateMotionDetection(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        if (this.hardwareMotionDetections.contains(hardwareMotionDetection)) {
            this.hardwareMotionDetections.remove(hardwareMotionDetection);
        }
    }

    public void activateInputAlarms(GenericOnvifIoHandler genericOnvifIoHandler) {
        this.genericOnvifIoHandler = genericOnvifIoHandler;
    }

    public void deactivateInputAlarms() {
        this.genericOnvifIoHandler = null;
    }

    protected String removeNamespace(String inputString) {
        if (inputString == null) {
            return null;
        }
        String[] stringWithoutSlashes = inputString.split("/");
        if (stringWithoutSlashes.length < 2) {
            return inputString;
        }
        for (int i = 0; i < stringWithoutSlashes.length; ++i) {
            String[] stringWithoutColon;
            String stringBetweenSlashes = stringWithoutSlashes[i];
            if (!stringBetweenSlashes.contains(":") || (stringWithoutColon = stringBetweenSlashes.split(":")).length != 2) continue;
            stringWithoutSlashes[i] = stringWithoutColon[1];
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < stringWithoutSlashes.length; ++i) {
            result.append(stringWithoutSlashes[i]);
            if (i >= stringWithoutSlashes.length - 1) continue;
            result.append("/");
        }
        return result.toString();
    }

    protected HashMap<String, Integer> matchVideoSourceNumbersToTokenAndName(List<VideoSource> videoSources, List<VideoSourceConfiguration> videoSourceConfigurationList) {
        HashMap<String, Integer> sourceMatchings = new HashMap<String, Integer>();
        if (videoSources != null) {
            for (int i = 0; i < videoSources.size(); ++i) {
                String videoSourceToken = videoSources.get(i).getToken();
                if (videoSourceConfigurationList != null) {
                    for (VideoSourceConfiguration videoSourceConfiguration : videoSourceConfigurationList) {
                        String sourceName;
                        if (!videoSourceConfiguration.getSourceToken().equals(videoSourceToken) || (sourceName = videoSourceConfiguration.getName()) == null || sourceName.isEmpty()) continue;
                        sourceMatchings.put(sourceName, i + 1);
                    }
                }
                sourceMatchings.put(videoSourceToken, i + 1);
            }
        }
        return sourceMatchings;
    }

    private void setRetriggerAlarm(int window) {
        if (!this.activeTrigger.contains(window)) {
            this.activeTrigger.add(window);
        }
    }

    private void removeRetriggerAlarm(int window) {
        if (this.activeTrigger.contains(window)) {
            this.activeTrigger.remove(window);
        }
    }
}

