/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.generic;

import de.seetec.v5.re.cm.configuration.definition.camera.FeaturesType;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecsType;
import de.seetec.v5.re.cm.configuration.definition.device.AvailableIOsType;
import de.seetec.v5.re.cm.configuration.definition.device.BitrateSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.CameraResolutionType;
import de.seetec.v5.re.cm.configuration.definition.device.CaptureModeDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.CodecType;
import de.seetec.v5.re.cm.configuration.definition.device.CommentsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceGroupMembershipsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceNetworkDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.EdgeStoragePlaybackSpeedType;
import de.seetec.v5.re.cm.configuration.definition.device.ImageRotationCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MiscVideoServerCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MultiStreamingDefinitionsType;
import de.seetec.v5.re.cm.configuration.definition.device.OnvifEventDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.RtspSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.StreamDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedApiVersionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCameraResolutionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCaptureModesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedEdgeStoragePlaybackSpeedsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedMPEGProfileIDs;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedOnvifEventsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedRotationAnglesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedTransmissionTypeIDsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedVideoSourceEntityTypesType;
import de.seetec.v5.re.cm.configuration.definition.device.VirtualCameraDefinitionType;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministration;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.onvif.EventMessageDescription;
import de.seetec.v5.re.cm.device.shared.onvif.MultiStreamingInformation;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDefaultResolutionFramerate;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifException;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.shared.onvif.WebServicePasswordHandler;
import de.seetec.v5.re.cm.device.shared.onvif.services.DeviceIoService;
import de.seetec.v5.re.cm.device.shared.onvif.services.DeviceService;
import de.seetec.v5.re.cm.device.shared.onvif.services.EventService;
import de.seetec.v5.re.cm.device.shared.onvif.services.ImagingService;
import de.seetec.v5.re.cm.device.shared.onvif.services.Media2Service;
import de.seetec.v5.re.cm.device.shared.onvif.services.ReplayService;
import de.seetec.v5.re.cm.device.shared.onvif.services.SearchService;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifCameraAdministration;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifEventHandler;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifHelper;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifIoHandler;
import de.seetec.v5.re.cm.device.video.onvif.generic.RecordingEvent;
import de.seetec.v5.re.cm.shared.timerange.TimeRange;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.DeviceCnf;
import de.seetec.v5.re.shared.MediaID;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelperAdapter;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.SeeTecX509TrustManager;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.TrustManager;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.logging.log4j.Logger;
import org.onvif.ver10.device.wsdl.Device;
import org.onvif.ver10.media.wsdl.Media;
import org.onvif.ver10.media.wsdl.VideoSourceMode;
import org.onvif.ver10.schema.AudioEncoderConfigurationOption;
import org.onvif.ver10.schema.AudioEncoderConfigurationOptions;
import org.onvif.ver10.schema.AudioEncoding;
import org.onvif.ver10.schema.AudioSource;
import org.onvif.ver10.schema.AutoFocusMode;
import org.onvif.ver10.schema.Capabilities;
import org.onvif.ver10.schema.CapabilityCategory;
import org.onvif.ver10.schema.ContinuousFocusOptions;
import org.onvif.ver10.schema.EventFilter;
import org.onvif.ver10.schema.ExposureMode;
import org.onvif.ver10.schema.ExposureOptions20;
import org.onvif.ver10.schema.FindEventResultList;
import org.onvif.ver10.schema.FindRecordingResultList;
import org.onvif.ver10.schema.FocusOptions20;
import org.onvif.ver10.schema.H264Options;
import org.onvif.ver10.schema.H264Profile;
import org.onvif.ver10.schema.ImagingOptions20;
import org.onvif.ver10.schema.IntRange;
import org.onvif.ver10.schema.IrCutFilterMode;
import org.onvif.ver10.schema.JpegOptions;
import org.onvif.ver10.schema.MoveOptions20;
import org.onvif.ver10.schema.Mpeg4Options;
import org.onvif.ver10.schema.Mpeg4Profile;
import org.onvif.ver10.schema.NetworkProtocolType;
import org.onvif.ver10.schema.PTZNode;
import org.onvif.ver10.schema.PTZSpaces;
import org.onvif.ver10.schema.Profile;
import org.onvif.ver10.schema.RealTimeStreamingCapabilities;
import org.onvif.ver10.schema.RecordingInformation;
import org.onvif.ver10.schema.RotateMode;
import org.onvif.ver10.schema.SearchScope;
import org.onvif.ver10.schema.SearchScopeExtension;
import org.onvif.ver10.schema.SearchState;
import org.onvif.ver10.schema.Space1DDescription;
import org.onvif.ver10.schema.Space2DDescription;
import org.onvif.ver10.schema.TrackInformation;
import org.onvif.ver10.schema.TrackType;
import org.onvif.ver10.schema.VideoEncoder2Configuration;
import org.onvif.ver10.schema.VideoEncoder2ConfigurationOptions;
import org.onvif.ver10.schema.VideoEncoderConfiguration;
import org.onvif.ver10.schema.VideoEncoderConfigurationOptions;
import org.onvif.ver10.schema.VideoResolution;
import org.onvif.ver10.schema.VideoResolution2;
import org.onvif.ver10.schema.VideoSource;
import org.onvif.ver10.schema.VideoSourceConfiguration;
import org.onvif.ver20.media.wsdl.MediaProfile;
import org.onvif.ver20.media.wsdl.StreamingCapabilities;
import org.onvif.ver20.ptz.wsdl.PTZ;

public class GenericOnvifDevice
extends VideoServer {
    public static final String DEFAULT_CAPTURE_MODE_TOKEN = "SeeTecDefaultCaptureMode";
    public static final String DEFAULT_PROFILE_TOKEN = "VMS default";
    public static final String PROFILE_TOKEN_SEPARATOR = "||";
    public static final int ZOOM_MULTIPLIER = 1000;
    public static final String HTTP_DIGEST = "HttpDigest";
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifDevice";
    private static final int VIDEO_SOURCE_INDEX = 0;
    public static final int ONVIF_DEFAULT_HTTP_PORT = 80;
    public static final int ONVIF_DEFAULT_HTTPS_PORT = 443;
    public static final int ONVIF_DEFAULT_RTSP_PORT = 554;
    private static volatile CameraAdministration CAMERA_ADMINISTRATION = null;
    private final long onvifLegacyTimeout = TimeUnit.SECONDS.toMillis(5L);
    private OnvifCore onvifCore = null;
    private GenericOnvifEventHandler genericOnvifEventHandler = null;
    private final Object semaphore = new Object();
    private Map<String, EventMessageDescription> eventTypesMap = null;
    private final long onvifMaxVideoStreamNetworkTimeout = TimeUnit.SECONDS.toMillis(20L);
    private final long onvifMinVideoStreamNetworkTimeout = TimeUnit.SECONDS.toMillis(5L);

    public long getOnvifLegacyTimeout() {
        return this.onvifLegacyTimeout;
    }

    @Override
    protected IOHandler createIOHandler() {
        if (this.isSupportingIO()) {
            return new GenericOnvifIoHandler();
        }
        return null;
    }

    @Override
    protected boolean isSupportingIO() {
        try {
            if (this.getOnvifCore().getDeviceIoService() != null && (this.getOnvifCore().getEventService() != null && this.getOnvifCore().getDeviceService().getNumberOfInputs() > 0 || this.getOnvifCore().getDeviceService().getNumberOfRelays() > 0)) {
                return true;
            }
        }
        catch (SeeTecException exception) {
            this.getLogger().warn("Could not read IOs for " + this);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnvifCore getOnvifCore() throws SeeTecException {
        Object object = this.semaphore;
        synchronized (object) {
            try {
                DeviceCnf deviceCnf = this.getDeviceCnf();
                NetworkParameter networkParameter = deviceCnf.getNetworkParameter();
                boolean useAuthorization = deviceCnf.getUseAuthorization();
                if (this.deviceHostChanged(networkParameter)) {
                    this.onvifCore.shutdown();
                    this.onvifCore = null;
                }
                if (this.onvifCore == null) {
                    if (networkParameter == null) {
                        throw new SeeTecException(-21601, "NetworkParameters are null");
                    }
                    OnvifDevice onvifDevice = this.createOnvifDevice(useAuthorization, networkParameter);
                    this.onvifCore = this.createOnvifCore(onvifDevice);
                }
            }
            catch (OnvifException onvifException) {
                throw new SeeTecException(onvifException.getErrorCode(), onvifException.getCause().getMessage());
            }
            catch (ConfigurationException exception) {
                this.getLogger().error("Problems while initializing ONVIF Core [" + exception.getMessage() + "]");
                this.onvifCore = null;
            }
        }
        return this.onvifCore;
    }

    protected OnvifDevice createOnvifDevice(boolean useAuthorization, NetworkParameter networkParameter) {
        String user = null;
        String password = null;
        if (networkParameter.getUserPWD() != null) {
            user = networkParameter.getUserPWD()[0];
            password = networkParameter.getUserPWD()[1];
        }
        String authenticationType = this.checkAuthenticationType(useAuthorization, networkParameter, user, password);
        OnvifDevice onvifDevice = new OnvifDevice(this.getDeviceEntity().getEntityName(), networkParameter, user, password, authenticationType, useAuthorization);
        return onvifDevice;
    }

    protected OnvifCore createOnvifCore(OnvifDevice onvifDevice) throws OnvifException {
        OnvifCore newOnvifCore = new OnvifCore();
        newOnvifCore.init(onvifDevice, this.getLogger().isDebugEnabled());
        return newOnvifCore;
    }

    public String checkAuthenticationType(boolean useAuthorization, NetworkParameter networkParameter, String user, String password) {
        String passwordType = "PasswordDigest";
        if (useAuthorization) {
            try {
                int authenticationCheckTimeout = 7000;
                passwordType = GenericOnvifDevice.checkAuthenticationType(networkParameter.getHost(), networkParameter.getHTTPport(), networkParameter.getSSLport(), user, password, authenticationCheckTimeout, networkParameter.useHTTPS());
            }
            catch (Exception exception) {
                passwordType = "PasswordDigest";
            }
        }
        this.logger.info("Authentication type for " + this + " : " + passwordType);
        return passwordType;
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Cannot change name of variable, because its in external lib. Besides, it is not the password, but passwort TYPE.")
    protected static String checkAuthenticationType(String host, int port, int sslPort, String user, String pass, int timeout, boolean useHttps) {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        String authenticationType = HTTP_DIGEST;
        factory.setBindingId("http://schemas.xmlsoap.org/wsdl/soap12/");
        factory.setServiceClass(Device.class);
        String url = (useHttps ? "https://" : "http://") + host + ":" + (useHttps ? sslPort : port) + "/onvif/device_service";
        factory.setAddress(url);
        Device device = (Device)factory.create(Device.class);
        ArrayList<CapabilityCategory> capabilityCategories = new ArrayList<CapabilityCategory>();
        capabilityCategories.add(CapabilityCategory.ALL);
        Client deviceClient = ClientProxy.getClient((Object)device);
        HTTPConduit httpConduitForDeviceClient = (HTTPConduit)deviceClient.getConduit();
        TLSClientParameters tlsClientParametersDevice = httpConduitForDeviceClient.getTlsClientParameters();
        if (tlsClientParametersDevice == null) {
            tlsClientParametersDevice = new TLSClientParameters();
            httpConduitForDeviceClient.setTlsClientParameters(tlsClientParametersDevice);
        }
        tlsClientParametersDevice.setTrustManagers(new TrustManager[]{new SeeTecX509TrustManager()});
        tlsClientParametersDevice.setDisableCNCheck(true);
        Capabilities capabilities = device.getCapabilities(capabilityCategories);
        factory.setServiceClass(Media.class);
        String mediaServiceAddress = capabilities.getMedia() != null ? capabilities.getMedia().getXAddr() : null;
        mediaServiceAddress = useHttps ? OnvifHelper.changeIPAddressPortOfUrl(mediaServiceAddress, host, sslPort, null) : OnvifHelper.changeIPAddressPortOfUrl(mediaServiceAddress, host, port, null);
        factory.setAddress(mediaServiceAddress);
        Media media = (Media)factory.create(Media.class);
        Client client = ClientProxy.getClient((Object)media);
        HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
        AuthorizationPolicy authorizationPolicy = new AuthorizationPolicy();
        authorizationPolicy.setAuthorizationType("Digest");
        authorizationPolicy.setUserName(user);
        authorizationPolicy.setPassword(pass);
        httpConduit.setAuthorization(authorizationPolicy);
        TLSClientParameters tlsClientParameters = httpConduit.getTlsClientParameters();
        if (tlsClientParameters == null) {
            tlsClientParameters = new TLSClientParameters();
            httpConduit.setTlsClientParameters(tlsClientParameters);
        }
        tlsClientParameters.setTrustManagers(new TrustManager[]{new SeeTecX509TrustManager()});
        tlsClientParameters.setDisableCNCheck(true);
        try {
            media.getProfiles();
            List videoSourceConfigurations = media.getVideoSourceConfigurations();
            if (videoSourceConfigurations.size() > 0) {
                media.setVideoSourceConfiguration((VideoSourceConfiguration)videoSourceConfigurations.get(0), true);
            }
        }
        catch (Exception e) {
            client = ClientProxy.getClient((Object)media);
            HTTPConduit httpConduitNoDigest = (HTTPConduit)client.getConduit();
            httpConduitNoDigest.setAuthorization(null);
            Endpoint endpoint = client.getEndpoint();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("action", "UsernameToken");
            properties.put("user", user);
            properties.put("passwordType", "PasswordDigest");
            properties.put("passwordCallbackRef", new WebServicePasswordHandler(pass));
            WSS4JOutInterceptor wssOut = new WSS4JOutInterceptor(properties);
            endpoint.getOutInterceptors().add(wssOut);
            try {
                media.getProfiles();
                List videoSourceConfigurations = media.getVideoSourceConfigurations();
                if (videoSourceConfigurations.size() > 0) {
                    media.setVideoSourceConfiguration((VideoSourceConfiguration)videoSourceConfigurations.get(0), true);
                }
                authenticationType = "PasswordDigest";
            }
            catch (Exception ex) {
                authenticationType = "PasswordText";
            }
        }
        return authenticationType;
    }

    private boolean deviceHostChanged(NetworkParameter networkParameter) {
        boolean deviceHostChanged = false;
        if (this.onvifCore != null && networkParameter != null) {
            String newIP = networkParameter.getHost();
            int newPort = networkParameter.getHTTPport();
            String currentIP = this.onvifCore.getOnvifDevice().getIp();
            int currentPort = this.onvifCore.getOnvifDevice().getPort();
            deviceHostChanged = !currentIP.equals(newIP) || currentPort != newPort;
        }
        return deviceHostChanged;
    }

    public final GenericOnvifEventHandler getGenericOnvifEventHandler() {
        if (this.genericOnvifEventHandler == null) {
            try {
                this.genericOnvifEventHandler = new GenericOnvifEventHandler();
                this.genericOnvifEventHandler.init(this.getOnvifCore(), this);
            }
            catch (SeeTecException exception) {
                this.getLogger().warn("GenericOnvifEventHandler could not be initialized", (Throwable)exception);
            }
        }
        return this.genericOnvifEventHandler;
    }

    @Override
    public int shutdown() {
        if (this.genericOnvifEventHandler != null) {
            this.genericOnvifEventHandler.shutdown();
            this.genericOnvifEventHandler = null;
        }
        return super.shutdown();
    }

    @Override
    protected final DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        try {
            boolean hasCaptureModeChanged;
            String currentSignature = this.getOnvifCore().getDeviceService().getDeviceInformation().getFirmwareVersion();
            String currentName = this.getOnvifCore().getDeviceService().getDeviceInformation().getDeviceModel();
            String currentComments = "RE_APP_VERSION::7.1.1_23";
            String currentManufacturer = this.getOnvifCore().getDeviceService().getDeviceInformation().getManufacturer();
            currentManufacturer = currentManufacturer + " - ONVIF Profile-S/G Driver";
            long deviceType = this.getDeviceType();
            long sourceType = 219602L;
            if (deviceType == 205501L) {
                sourceType = 215501L;
                currentManufacturer = "Flir Smart Driver (F/PT-Series)";
            } else if (deviceType == 204203L) {
                sourceType = 214203L;
                currentManufacturer = "Canon Smart Driver";
            } else if (deviceType == 206500L) {
                sourceType = 216500L;
                currentManufacturer = "Uniview Smart Driver";
            } else if (deviceType == 206600L) {
                sourceType = 216600L;
                currentManufacturer = "Eclipse Smart Driver";
            }
            String currentlySetCaptureMode = "";
            try {
                Media mediaService = this.getOnvifCore().getMediaService().getOnvifMediaService();
                String videoSourceToken = ((VideoSource)mediaService.getVideoSources().get(0)).getToken();
                List videoSourceModes = mediaService.getVideoSourceModes(videoSourceToken);
                currentlySetCaptureMode = GenericOnvifDevice.getCurrentlySetCaptureMode(videoSourceModes);
            }
            catch (Exception ex) {
                this.getLogger().warn("Could not get currently set capture mode for " + this + " Asuming capture mode is empty");
            }
            String foundDisplayResolutionInDefinition = this.getCurrentCaptureModeFromDefinition();
            boolean bl = hasCaptureModeChanged = !currentlySetCaptureMode.equals(foundDisplayResolutionInDefinition);
            if (!(signature != null && signature.equals(currentSignature) && manufacturer != null && manufacturer.equals(currentManufacturer) && name != null && name.equals(currentName) && comments != null && comments.equals("RE_APP_VERSION::7.1.1_23") && !hasCaptureModeChanged)) {
                DeviceDefinition deviceDefinition = new DeviceDefinition();
                deviceDefinition.setCountFirstChannelOnly(true);
                deviceDefinition.setSignature(currentSignature);
                deviceDefinition.setManufacturer(currentManufacturer);
                CommentsType commentsType = new CommentsType();
                commentsType.getString().add("RE_APP_VERSION::7.1.1_23");
                deviceDefinition.setComments(commentsType);
                deviceDefinition.setDefaultMediaID(MediaID.VIDEO_SERVER_DIGITAL.getType());
                String apiVersion = "Core Specification 2.5";
                SupportedApiVersionsType supportedApiVersionsType = this.createSupportedApiVersionsType("Core Specification 2.5");
                deviceDefinition.setSupportedApiVersions(supportedApiVersionsType);
                deviceDefinition.setDefaultApiVersion("Core Specification 2.5");
                boolean canPTZ = this.getOnvifCore().getPtzService() != null;
                SupportedVideoSourceEntityTypesType supportedVideoSourceEntityTypesType = this.createSupportedVideoSourceEntityTypesType(sourceType, canPTZ);
                deviceDefinition.setSupportedVideoSourceEntityTypes(supportedVideoSourceEntityTypesType);
                List<Integer> httpPorts = this.getOnvifCore().getDeviceService().getPorts(NetworkProtocolType.HTTP);
                List<Integer> httpsPorts = this.getOnvifCore().getDeviceService().getPorts(NetworkProtocolType.HTTPS);
                DeviceNetworkDefinitionType deviceNetworkDefinitionType = this.createDeviceNetworkDefinitionType(httpPorts, httpsPorts);
                deviceDefinition.setDeviceNetworkDefinition(deviceNetworkDefinitionType);
                VirtualCameraDefinitionType virtualCameraDefinitionType = this.createVirtualCameraDefinitionType();
                deviceDefinition.setVirtualCameraDefinition(virtualCameraDefinitionType);
                List videoSources = this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoSources();
                deviceDefinition.setNoOfCams(videoSources.size());
                String defaultVideoSourceIndexToken = ((VideoSource)videoSources.get(0)).getToken();
                VideoSourceMode enabledVideoSourceMode = null;
                try {
                    List videoSourceModes = this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoSourceModes(defaultVideoSourceIndexToken);
                    for (VideoSourceMode videoSourceMode : videoSourceModes) {
                        if (!videoSourceMode.isEnabled().booleanValue()) continue;
                        enabledVideoSourceMode = videoSourceMode;
                    }
                }
                catch (Throwable throwable) {
                    this.getLogger().info("CaptureModes not supported by " + this.getOnvifCore().getOnvifDevice());
                }
                SupportedCaptureModesType supportedCaptureModesType = this.createSupportedCaptureModesType(enabledVideoSourceMode);
                deviceDefinition.setSupportedCaptureModes(supportedCaptureModesType);
                deviceDefinition.setDefaultCaptureModeIndex(0);
                ImageRotationCapabilitiesType imageRotationCapabilitiesType = this.createImageRotationCapabilitiesType();
                deviceDefinition.setImageRotationCapabilities(imageRotationCapabilitiesType);
                AudioEncoderConfigurationOptions audioEncoderConfigurationOptions = null;
                List audioSources = null;
                List audioOutputs = null;
                try {
                    Media onvifMediaService = this.getOnvifCore().getMediaService().getOnvifMediaService();
                    audioSources = onvifMediaService.getAudioSources();
                    audioEncoderConfigurationOptions = onvifMediaService.getAudioEncoderConfigurationOptions(null, null);
                }
                catch (Throwable throwable) {
                    this.getLogger().info("Onvif Device [" + this + "] does not support audio");
                }
                try {
                    audioOutputs = this.getOnvifCore().getDeviceIoService().getOnvifDeviceIoService().getAudioOutputs();
                }
                catch (Exception ex) {
                    this.getLogger().info("Audio Outputs could not be readfor [" + this + "] ");
                }
                AudioCapabilitiesType audioCapabilitiesType = this.createAudioCapabilitiesType(audioSources, audioEncoderConfigurationOptions, audioOutputs);
                deviceDefinition.setAudioCapabilities(audioCapabilitiesType);
                DeviceIoService deviceIoService = this.getOnvifCore().getDeviceIoService();
                EventService eventService = this.getOnvifCore().getEventService();
                DeviceService deviceService = this.getOnvifCore().getDeviceService();
                int numberOfInputs = 0;
                int numberOfRelays = 0;
                if (deviceIoService != null) {
                    numberOfRelays = deviceService.getNumberOfRelays();
                    if (eventService != null) {
                        numberOfInputs = deviceService.getNumberOfInputs();
                    }
                }
                AvailableIOsType availableIOsType = this.createAvailableIOsType(numberOfInputs, numberOfRelays);
                deviceDefinition.setAvailableIOs(availableIOsType);
                Map<String, EventMessageDescription> localEventTypesMap = null;
                if (eventService != null) {
                    localEventTypesMap = this.getEventTypesMap();
                }
                SupportedOnvifEventsType supportedOnvifEventsType = this.createSupportedOnvifEventsType(localEventTypesMap);
                deviceDefinition.setSupportedOnvifEvents(supportedOnvifEventsType);
                MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = this.createMiscVideoServerCapabilitiesType(canPTZ);
                deviceDefinition.setMiscVideoServerCapabilities(miscVideoServerCapabilitiesType);
                DeviceGroupMembershipsType deviceGroupMembershipsType = this.createDeviceGroupMembershipsType(deviceType);
                deviceDefinition.setDeviceGroupMemberships(deviceGroupMembershipsType);
                if (deviceGroupMembershipsType.getDeviceGroups().contains("EdgeStorage")) {
                    SupportedEdgeStoragePlaybackSpeedsType supportedEdgeStoragePlaybackSpeedsType = new SupportedEdgeStoragePlaybackSpeedsType();
                    EdgeStoragePlaybackSpeedType edgeStoragePlaybackSpeedType = new EdgeStoragePlaybackSpeedType();
                    edgeStoragePlaybackSpeedType.setSpeedName("1x");
                    edgeStoragePlaybackSpeedType.setSpeedValue(1);
                    supportedEdgeStoragePlaybackSpeedsType.getEdgeStoragePlaybackSpeed().add(edgeStoragePlaybackSpeedType);
                    deviceDefinition.setSupportedEdgeStoragePlaybackSpeeds(supportedEdgeStoragePlaybackSpeedsType);
                }
                deviceDefinition.setEntityType(deviceType);
                deviceDefinition.setName(currentName);
                if (this.getLogger().isDebugEnabled()) {
                    try {
                        String deviceDefinitionXml = Basic.marshalXML((Object)deviceDefinition);
                        this.getLogger().debug(deviceDefinitionXml);
                    }
                    catch (Throwable ex) {
                        this.getLogger().warn("Error while outputting definition XML data: " + ex.getMessage() + " for " + this);
                    }
                }
                return deviceDefinition;
            }
            this.getLogger().info("Returning no definition for " + this);
            return null;
        }
        catch (SeeTecException exception) {
            this.getLogger().warn("Error while reading information from " + this, (Throwable)exception);
            throw exception;
        }
        catch (Exception exception) {
            this.getLogger().warn("Error while reading information from " + this, (Throwable)exception);
            throw new SeeTecException(-21600, exception.getMessage());
        }
    }

    private SupportedCaptureModesType createSupportedCaptureModesType(VideoSourceMode videoSourceMode) throws SeeTecException {
        List profiles;
        SupportedCaptureModesType supportedCaptureModesType = new SupportedCaptureModesType();
        OnvifDefaultResolutionFramerate onvifResolutionFramerate = null;
        Media2Service media2Service = this.getOnvifCore().getMedia2Service();
        if (media2Service != null) {
            List videoEncoder2ConfigurationOptions = null;
            try {
                videoEncoder2ConfigurationOptions = media2Service.getOnvifMedia2Service().getVideoEncoderConfigurationOptions(null, null);
            }
            catch (Exception ex) {
                videoEncoder2ConfigurationOptions = media2Service.getOnvifMedia2Service().getVideoEncoderConfigurationOptions(null, null);
            }
            if (!videoEncoder2ConfigurationOptions.isEmpty() && ((VideoEncoder2ConfigurationOptions)videoEncoder2ConfigurationOptions.get(0)).getFrameRatesSupported().isEmpty()) {
                List mediaProfiles = media2Service.getOnvifMedia2Service().getProfiles(null, null);
                videoEncoder2ConfigurationOptions = media2Service.getOnvifMedia2Service().getVideoEncoderConfigurationOptions(null, ((MediaProfile)mediaProfiles.get(0)).getToken());
            }
            for (VideoEncoder2ConfigurationOptions videoEncoder2ConfigurationOption : videoEncoder2ConfigurationOptions) {
                if (!videoEncoder2ConfigurationOption.getEncoding().equalsIgnoreCase("h265")) continue;
                onvifResolutionFramerate = new OnvifDefaultResolutionFramerate(videoEncoder2ConfigurationOption);
                break;
            }
        }
        if (!(onvifResolutionFramerate != null || (onvifResolutionFramerate = new OnvifDefaultResolutionFramerate(this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoEncoderConfigurationOptions(null, null))).getFrameRateRange() != null && onvifResolutionFramerate.getResolutionsAvailable() != null || (profiles = this.getOnvifCore().getMediaService().getOnvifMediaService().getProfiles()).isEmpty())) {
            String profileToken = ((Profile)profiles.get(0)).getToken();
            String configurationToken = ((Profile)profiles.get(0)).getVideoEncoderConfiguration().getToken();
            onvifResolutionFramerate = new OnvifDefaultResolutionFramerate(this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoEncoderConfigurationOptions(configurationToken, profileToken));
        }
        CaptureModeDefinitionType captureModeDefinitionType = this.createCaptureModeDefinitionType(videoSourceMode, media2Service, onvifResolutionFramerate);
        supportedCaptureModesType.getCaptureModeDefinition().add(captureModeDefinitionType);
        return supportedCaptureModesType;
    }

    private SupportedOnvifEventsType createSupportedOnvifEventsType(Map<String, EventMessageDescription> localEventTypesMap) {
        SupportedOnvifEventsType supportedOnvifEventsType = new SupportedOnvifEventsType();
        if (localEventTypesMap != null) {
            for (Map.Entry<String, EventMessageDescription> entry : localEventTypesMap.entrySet()) {
                try {
                    OnvifEventDefinitionType onvifEventDefinition = new OnvifEventDefinitionType();
                    onvifEventDefinition.setEventType(entry.getKey());
                    onvifEventDefinition.setMaxNumber(entry.getValue().getDataType().length > 0 && entry.getValue().getDataType()[0] != null && entry.getValue().getDataType()[0].equals("xsd:boolean") ? 1 : Integer.MAX_VALUE);
                    supportedOnvifEventsType.getOnvifEventDefinition().add(onvifEventDefinition);
                }
                catch (Exception ex) {
                    this.logger.warn("Exception while reading onvif events for " + this + " : " + ex.getMessage());
                }
            }
        }
        return supportedOnvifEventsType;
    }

    private AvailableIOsType createAvailableIOsType(int numberOfInputs, int numberOfRelays) {
        AvailableIOsType availableIOsType = new AvailableIOsType();
        if (numberOfInputs > 0) {
            availableIOsType.getInputOutputCapabilities().add(0);
        }
        for (int i = 0; i < numberOfRelays; ++i) {
            availableIOsType.getInputOutputCapabilities().add(1);
        }
        return availableIOsType;
    }

    private SupportedApiVersionsType createSupportedApiVersionsType(String apiVersion) {
        SupportedApiVersionsType supportedApiVersionsType = new SupportedApiVersionsType();
        supportedApiVersionsType.getString().add(apiVersion);
        return supportedApiVersionsType;
    }

    private SupportedVideoSourceEntityTypesType createSupportedVideoSourceEntityTypesType(long sourceType, boolean canPTZ) throws SeeTecException {
        SupportedVideoSourceEntityTypesType supportedVideoSourceEntityTypesType = new SupportedVideoSourceEntityTypesType();
        supportedVideoSourceEntityTypesType.getLong().add(sourceType);
        if (canPTZ) {
            supportedVideoSourceEntityTypesType.getLong().add(219901L);
        }
        return supportedVideoSourceEntityTypesType;
    }

    private AudioCapabilitiesType createAudioCapabilitiesType(List<AudioSource> audioSources, AudioEncoderConfigurationOptions audioEncoderConfigurationOptions, List<String> audioOutputs) {
        boolean canAudioOut;
        List audioEncoderConfigurationOptionsList = null;
        int numberOfAudioSources = 0;
        boolean canAudio = false;
        int defaultAudioCodecIndex = 0;
        AudioCodecsType audioCodecsType = null;
        if (audioSources != null && audioEncoderConfigurationOptions != null) {
            audioEncoderConfigurationOptionsList = audioEncoderConfigurationOptions.getOptions();
            numberOfAudioSources = audioSources.size();
            canAudio = numberOfAudioSources > 0;
        }
        boolean bl = canAudioOut = audioOutputs != null && audioOutputs.size() > 0;
        if (canAudio) {
            audioCodecsType = new AudioCodecsType();
            for (AudioEncoderConfigurationOption audioEncoderConfigurationOption : audioEncoderConfigurationOptionsList) {
                AudioCodecDefinitionType audioCodecDefinitionType = new AudioCodecDefinitionType();
                AudioEncoding audioEncoding = audioEncoderConfigurationOption.getEncoding();
                CodecType codecType = new CodecType();
                if (audioEncoding == AudioEncoding.G_711) {
                    codecType.setValue(Codec.G711U.getType());
                } else if (audioEncoding == AudioEncoding.G_726) {
                    codecType.setValue(Codec.G726.getType());
                }
                audioCodecDefinitionType.setAudioCodec(codecType);
                int bitrate = OnvifHelper.getBiggestIntValueAndConvert(audioEncoderConfigurationOption.getBitrateList(), true);
                audioCodecDefinitionType.setBitrate(bitrate);
                audioCodecsType.getAudioCodecDefinition().add(audioCodecDefinitionType);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("AudioCapabilities CanAudio[" + canAudio + "] NumberOfAudioStreams [" + numberOfAudioSources + "] defaultAudioCodex [" + defaultAudioCodecIndex + "] NoAudioCodesType [" + (audioCodecsType != null ? audioCodecsType.getAudioCodecDefinition().size() : 0) + "]");
        }
        AudioCapabilitiesType audioCapabilitiesType = new AudioCapabilitiesType();
        audioCapabilitiesType.setCanAudio(canAudio);
        audioCapabilitiesType.setNumberOfPossibleAudioStreams(numberOfAudioSources);
        audioCapabilitiesType.setDefaultAudioCodecIndex(defaultAudioCodecIndex);
        audioCapabilitiesType.setAudioCodecs(audioCodecsType);
        audioCapabilitiesType.setCanAudioOut(canAudioOut);
        return audioCapabilitiesType;
    }

    private DeviceGroupMembershipsType createDeviceGroupMembershipsType(long deviceType) {
        DeviceGroupMembershipsType deviceGroupMembershipsType = new DeviceGroupMembershipsType();
        deviceGroupMembershipsType.getDeviceGroups().add("OnvifLimitation");
        deviceGroupMembershipsType.getDeviceGroups().add("GenericDriver");
        deviceGroupMembershipsType.getDeviceGroups().add("ConfigurableVideoStreamNetworkTimeout");
        deviceGroupMembershipsType.getDeviceGroups().add("PresetsImportable");
        deviceGroupMembershipsType.getDeviceGroups().add("CameraAdministrationModifyPassword");
        if (deviceType == 209601L || deviceType == 205501L || deviceType == 206500L || deviceType == 206600L) {
            deviceGroupMembershipsType.getDeviceGroups().add("DeviceMulticastConfiguration");
            deviceGroupMembershipsType.getDeviceGroups().add("CheckDeviceInfos");
        }
        try {
            SearchService searchService = this.getOnvifCore().getSearchService();
            ReplayService replayService = this.getOnvifCore().getReplayService();
            if (searchService != null && replayService != null) {
                deviceGroupMembershipsType.getDeviceGroups().add("EdgeStorage");
                deviceGroupMembershipsType.getDeviceGroups().add("EdgeStorageVideoImport");
            }
        }
        catch (SeeTecException ex) {
            this.logger.warn("Could not read Service from ONVIF device for " + this);
        }
        return deviceGroupMembershipsType;
    }

    private VirtualCameraDefinitionType createVirtualCameraDefinitionType() {
        VirtualCameraDefinitionType virtualCameraDefinitionType = new VirtualCameraDefinitionType();
        virtualCameraDefinitionType.setCanVirtualCamera(false);
        virtualCameraDefinitionType.setCanVirtualCameraCropping(false);
        virtualCameraDefinitionType.setNoOfVirtualCameras(0);
        return virtualCameraDefinitionType;
    }

    private ImageRotationCapabilitiesType createImageRotationCapabilitiesType() {
        SupportedRotationAnglesType supportedRotationAnglesType;
        ArrayList<Integer> degreeListMedia = null;
        ImageRotationCapabilitiesType imageRotationCapabilitiesType = new ImageRotationCapabilitiesType();
        try {
            degreeListMedia = this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoSourceConfigurationOptions(null, null).getExtension().getRotate().getDegreeList().getItems();
        }
        catch (Exception ex) {
            try {
                degreeListMedia = this.getOnvifCore().getMedia2Service().getOnvifMedia2Service().getVideoSourceConfigurationOptions(null, null).getExtension().getRotate().getDegreeList().getItems();
            }
            catch (Exception ex1) {
                this.getLogger().info("Could not get image rotation capabilities from camera. Will rotate image on client for " + this);
            }
        }
        if (degreeListMedia == null) {
            List rotateModes = null;
            try {
                rotateModes = this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoSourceConfigurationOptions(null, null).getExtension().getRotate().getMode();
            }
            catch (Exception ex) {
                try {
                    rotateModes = this.getOnvifCore().getMedia2Service().getOnvifMedia2Service().getVideoSourceConfigurationOptions(null, null).getExtension().getRotate().getMode();
                }
                catch (Exception ex1) {
                    this.getLogger().info("Could not get image rotation capabilities from camera. Will rotate image on client for " + this);
                }
            }
            if (rotateModes != null && rotateModes.size() > 0) {
                degreeListMedia = new ArrayList<Integer>();
                for (RotateMode rotateMode : rotateModes) {
                    if (rotateMode == RotateMode.OFF) {
                        degreeListMedia.add(0);
                        continue;
                    }
                    if (rotateMode != RotateMode.ON) continue;
                    degreeListMedia.add(180);
                }
            }
        }
        if (degreeListMedia != null && degreeListMedia.size() > 0) {
            imageRotationCapabilitiesType.setCanRotateJPEGImage(true);
            imageRotationCapabilitiesType.setCanRotateMPEGImage(true);
            supportedRotationAnglesType = new SupportedRotationAnglesType();
            boolean is0DegreesAdded = false;
            for (Integer degrees : degreeListMedia) {
                supportedRotationAnglesType.getInt().add(degrees * 1000);
                if (degrees != 0) continue;
                is0DegreesAdded = true;
            }
            if (!is0DegreesAdded) {
                supportedRotationAnglesType.getInt().add(0);
            }
            imageRotationCapabilitiesType.setSupportedRotationAngles(supportedRotationAnglesType);
        } else {
            imageRotationCapabilitiesType.setCanRotateJPEGImage(false);
            imageRotationCapabilitiesType.setCanRotateMPEGImage(false);
            supportedRotationAnglesType = new SupportedRotationAnglesType();
            supportedRotationAnglesType.getInt().add(0);
            supportedRotationAnglesType.getInt().add(180000);
            imageRotationCapabilitiesType.setSupportedRotationAngles(supportedRotationAnglesType);
        }
        return imageRotationCapabilitiesType;
    }

    private MiscVideoServerCapabilitiesType createMiscVideoServerCapabilitiesType(boolean canPTZ) {
        MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = new MiscVideoServerCapabilitiesType();
        miscVideoServerCapabilitiesType.setCanTimeDate(false);
        miscVideoServerCapabilitiesType.setCanTitle(false);
        miscVideoServerCapabilitiesType.setCanDetectTampering(false);
        miscVideoServerCapabilitiesType.setCanDetectVideoloss(false);
        miscVideoServerCapabilitiesType.setNoOfRS232S(0);
        miscVideoServerCapabilitiesType.setCanTimeshift(false);
        miscVideoServerCapabilitiesType.setPTZSpeedMultiplier(100);
        miscVideoServerCapabilitiesType.setCanPTZ(canPTZ);
        return miscVideoServerCapabilitiesType;
    }

    private CaptureModeDefinitionType createCaptureModeDefinitionType(VideoSourceMode videoSourceMode, Media2Service media2Service, OnvifDefaultResolutionFramerate onvifResolutionFramerate) throws SeeTecException {
        CaptureModeDefinitionType captureModeDefinitionType = new CaptureModeDefinitionType();
        captureModeDefinitionType.setRebootRequired(videoSourceMode != null ? videoSourceMode.isReboot() : false);
        captureModeDefinitionType.setModeSuffix(videoSourceMode != null ? videoSourceMode.getDescription() : "");
        String videoSourceConfigurationToken = ((VideoSourceConfiguration)this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoSourceConfigurations().get(0)).getToken();
        MultiStreamingInformation multiStreamingInformation = this.getOnvifCore().getMediaService().getMultiStreamingInformation(videoSourceConfigurationToken);
        captureModeDefinitionType.setMaxTotalNumberOfStreams(multiStreamingInformation.getTotalNumber());
        CameraResolutionType captureModeCameraResolutionType = this.createCameraResolutionType(videoSourceMode, onvifResolutionFramerate);
        captureModeDefinitionType.setResolution(captureModeCameraResolutionType);
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = this.createMultiStreamingDefinitionsType(media2Service, multiStreamingInformation, onvifResolutionFramerate.getFrameRateRange());
        captureModeDefinitionType.setMultiStreamingDefinitions(multiStreamingDefinitionsType);
        captureModeDefinitionType.setDefaultStreamDefinitionIndex(0);
        return captureModeDefinitionType;
    }

    private CameraResolutionType createCameraResolutionType(VideoSourceMode videoSourceMode, OnvifDefaultResolutionFramerate onvifResolutionFramerate) {
        CameraResolutionType captureModeCameraResolutionType = new CameraResolutionType();
        VideoResolution biggestResolution = OnvifHelper.getBiggestResolution(onvifResolutionFramerate.getResolutionsAvailable());
        String token = videoSourceMode != null ? videoSourceMode.getToken() : DEFAULT_CAPTURE_MODE_TOKEN;
        int width = videoSourceMode != null ? videoSourceMode.getMaxResolution().getWidth() : biggestResolution.getWidth();
        int height = videoSourceMode != null ? videoSourceMode.getMaxResolution().getHeight() : biggestResolution.getHeight();
        int minFrameRate = onvifResolutionFramerate.getFrameRateRange().getMin();
        int maxFrameRate = videoSourceMode != null ? (int)videoSourceMode.getMaxFramerate() : onvifResolutionFramerate.getFrameRateRange().getMax();
        captureModeCameraResolutionType.setDisplayResolution(width + "x" + height + "@" + maxFrameRate + " [" + token + "]");
        captureModeCameraResolutionType.setWidth(width);
        captureModeCameraResolutionType.setHeight(height);
        captureModeCameraResolutionType.setMinMilliFPS(minFrameRate * 1000);
        captureModeCameraResolutionType.setMaxMilliFPS(maxFrameRate * 1000);
        captureModeCameraResolutionType.setResolution(width + "x" + height);
        captureModeCameraResolutionType.setSupportedFrameRates(null);
        return captureModeCameraResolutionType;
    }

    private MultiStreamingDefinitionsType createMultiStreamingDefinitionsType(Media2Service media2Service, MultiStreamingInformation multiStreamingInformation, IntRange frameRateRangeForBiggestResolution) throws SeeTecException {
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = new MultiStreamingDefinitionsType();
        List videoEncoderConfigurations = null;
        boolean deviceSupportsMedia1 = false;
        try {
            videoEncoderConfigurations = this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoEncoderConfigurations();
        }
        catch (Exception ex) {
            this.logger.warn("Could not get video encoder configuration for " + this + " : " + ex.getMessage());
        }
        if (videoEncoderConfigurations != null) {
            List profiles = this.getOnvifCore().getMediaService().getOnvifMediaService().getProfiles();
            List<String> onvifProfileTokens = this.getProfileTokensFromProfiles(profiles);
            RealTimeStreamingCapabilities streamingCapabilities = this.getOnvifCore().getDeviceService().getCapabilities().getMedia().getStreamingCapabilities();
            List<Integer> rtspPorts = this.getOnvifCore().getDeviceService().getPorts(NetworkProtocolType.RTSP);
            for (String onvifProfile : onvifProfileTokens) {
                for (VideoEncoderConfiguration videoEncoderConfiguration : videoEncoderConfigurations) {
                    VideoEncoderConfigurationOptions videoEncoderConfigurationOptions = null;
                    try {
                        videoEncoderConfigurationOptions = this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoEncoderConfigurationOptions(videoEncoderConfiguration.getToken(), !onvifProfile.equals(DEFAULT_PROFILE_TOKEN) ? onvifProfile : null);
                    }
                    catch (SeeTecException exception) {
                        throw exception;
                    }
                    catch (Exception exception) {
                        if (!onvifProfile.equals(DEFAULT_PROFILE_TOKEN)) {
                            this.getLogger().warn("GetVideoEncoderConfigurationOptions failed, VideoEncoderConfiguration=" + videoEncoderConfiguration.getToken() + " and ProfileToken=" + onvifProfile + " seem to be incompatible " + this.getOnvifCore().getOnvifDevice(), (Throwable)exception);
                            continue;
                        }
                        throw new SeeTecException(-21600, "GetVideoEncoderConfigurationOptions failed for VideoEncoderConfiguration=" + videoEncoderConfiguration.getToken() + " " + this.getOnvifCore().getOnvifDevice());
                    }
                    String streamName = (!onvifProfile.equals(DEFAULT_PROFILE_TOKEN) ? onvifProfile + PROFILE_TOKEN_SEPARATOR : "") + videoEncoderConfiguration.getToken();
                    if (videoEncoderConfigurationOptions.getH264() != null) {
                        StreamDefinitionType streamDefinitionTypeH264 = this.createStreamDefinitionTypeH264(multiStreamingInformation, videoEncoderConfigurationOptions.getH264(), frameRateRangeForBiggestResolution, streamName, streamingCapabilities, rtspPorts);
                        multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionTypeH264);
                        deviceSupportsMedia1 = true;
                    }
                    if (videoEncoderConfigurationOptions.getJPEG() != null) {
                        StreamDefinitionType streamDefinitionTypeMjpeg = this.createStreamDefinitionTypeMjpeg(multiStreamingInformation, videoEncoderConfigurationOptions.getJPEG(), frameRateRangeForBiggestResolution, streamName, streamingCapabilities, rtspPorts);
                        multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionTypeMjpeg);
                        deviceSupportsMedia1 = true;
                    }
                    if (videoEncoderConfigurationOptions.getMPEG4() == null) continue;
                    StreamDefinitionType streamDefinitionTypeMpeg4 = this.createStreamDefinitionTypeMpeg4(multiStreamingInformation, videoEncoderConfigurationOptions.getMPEG4(), frameRateRangeForBiggestResolution, streamName, streamingCapabilities, rtspPorts);
                    multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionTypeMpeg4);
                    deviceSupportsMedia1 = true;
                }
            }
        }
        if (media2Service != null) {
            ArrayList<String> types = new ArrayList<String>();
            types.add("All");
            List mediaProfiles = media2Service.getOnvifMedia2Service().getProfiles(null, types);
            List<String> onvifMedia2ProfileTokens = this.getProfileTokensFromMedia2Profiles(mediaProfiles);
            ArrayList<String> profilesUsed = new ArrayList<String>();
            ArrayList<String> configurationsUsed = new ArrayList<String>();
            for (String onvifMedia2Profile : onvifMedia2ProfileTokens) {
                try {
                    List videoEncoder2Configurations = media2Service.getOnvifMedia2Service().getVideoEncoderConfigurations(null, onvifMedia2Profile);
                    for (VideoEncoder2Configuration videoEncoder2Configuration : videoEncoder2Configurations) {
                        if (videoEncoder2Configuration.getToken() == null) continue;
                        List videoEncoder2ConfigurationOptions = null;
                        try {
                            videoEncoder2ConfigurationOptions = media2Service.getOnvifMedia2Service().getVideoEncoderConfigurationOptions(videoEncoder2Configuration.getToken(), onvifMedia2Profile);
                        }
                        catch (Exception exception) {
                            if (!onvifMedia2Profile.equals(DEFAULT_PROFILE_TOKEN)) {
                                this.getLogger().warn("GetVideoEncoderConfigurationOptions failed, VideoEncoderConfiguration=" + videoEncoder2Configuration.getToken() + " and ProfileToken=" + onvifMedia2Profile + " seem to be incompatible " + this.getOnvifCore().getOnvifDevice(), (Throwable)exception);
                                continue;
                            }
                            throw new SeeTecException(-21600, "GetVideoEncoderConfigurationOptions failed for VideoEncoderConfiguration=" + videoEncoder2Configuration.getToken() + " " + this.getOnvifCore().getOnvifDevice());
                        }
                        String streamName = onvifMedia2Profile + PROFILE_TOKEN_SEPARATOR + videoEncoder2Configuration.getToken();
                        if (onvifMedia2Profile.contains("seetec")) {
                            streamName = videoEncoder2Configuration.getToken();
                        }
                        if (profilesUsed.contains(onvifMedia2Profile) || configurationsUsed.contains(videoEncoder2Configuration.getToken())) continue;
                        for (VideoEncoder2ConfigurationOptions videoEncoder2ConfigurationOption : videoEncoder2ConfigurationOptions) {
                            String tokenName;
                            if (videoEncoder2ConfigurationOption.getEncoding().equals("H265")) {
                                tokenName = OnvifHelper.extractOnvifProfileAndStreamName(streamName)[1];
                                VideoEncoder2ConfigurationOptions videoEncoderConfigurationOptions = this.getVideoEncoder2ConfigurationOptions(media2Service, tokenName, Codec.H265);
                                if (videoEncoderConfigurationOptions == null) continue;
                                StreamDefinitionType streamDefinitionTypeH265 = this.createStreamDefinitionTypeH265(media2Service, videoEncoder2ConfigurationOption, streamName);
                                multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionTypeH265);
                                profilesUsed.add(onvifMedia2Profile);
                                configurationsUsed.add(videoEncoder2Configuration.getToken());
                                continue;
                            }
                            if (!deviceSupportsMedia1 && videoEncoder2ConfigurationOption.getEncoding().equals(Codec.H264.name())) {
                                tokenName = OnvifHelper.extractOnvifProfileAndStreamName(streamName)[1];
                                StreamDefinitionType streamDefinitionTypeH264 = this.createStreamDefinitionTypeH264(multiStreamingInformation, media2Service, videoEncoder2ConfigurationOption, streamName, frameRateRangeForBiggestResolution);
                                multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionTypeH264);
                                profilesUsed.add(onvifMedia2Profile);
                                configurationsUsed.add(tokenName);
                                continue;
                            }
                            if (deviceSupportsMedia1 || !videoEncoder2ConfigurationOption.getEncoding().equals("JPEG")) continue;
                            tokenName = OnvifHelper.extractOnvifProfileAndStreamName(streamName)[1];
                            StreamDefinitionType streamDefinitionTypeMjpeg = this.createStreamDefinitionTypeMjpeg(multiStreamingInformation, media2Service, videoEncoder2ConfigurationOption, streamName, frameRateRangeForBiggestResolution);
                            multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionTypeMjpeg);
                            profilesUsed.add(onvifMedia2Profile);
                            configurationsUsed.add(tokenName);
                        }
                    }
                }
                catch (WebServiceException webServiceException) {
                }
            }
        }
        return multiStreamingDefinitionsType;
    }

    private List<String> getProfileTokensFromProfiles(List<Profile> profiles) {
        ArrayList<String> onvifProfileTokens = new ArrayList<String>();
        onvifProfileTokens.add(DEFAULT_PROFILE_TOKEN);
        for (Profile profile : profiles) {
            if (profile.getToken().contains("seetec")) continue;
            onvifProfileTokens.add(profile.getToken());
        }
        return onvifProfileTokens;
    }

    private List<String> getProfileTokensFromMedia2Profiles(List<MediaProfile> mediaProfiles) {
        ArrayList<String> onvifMedia2ProfileTokens = new ArrayList<String>();
        for (MediaProfile mediaProfile : mediaProfiles) {
            onvifMedia2ProfileTokens.add(mediaProfile.getToken());
        }
        return onvifMedia2ProfileTokens;
    }

    protected StreamDefinitionType createStreamDefinitionTypeMpeg4(MultiStreamingInformation multiStreamingInformation, Mpeg4Options mpeg4Options, IntRange frameRateRangeForBiggestResolution, String streamName, RealTimeStreamingCapabilities streamingCapabilities, List<Integer> rtspPorts) throws SeeTecException {
        CodecType codecType = new CodecType();
        codecType.setValue(Codec.MPEG4.getType());
        Integer numberOfStreams = multiStreamingInformation.getNumberOfMpeg4Streams() != null ? multiStreamingInformation.getNumberOfMpeg4Streams() : multiStreamingInformation.getTotalNumber();
        List videoResolutions = mpeg4Options.getResolutionsAvailable();
        IntRange frameRateRange = mpeg4Options.getFrameRateRange();
        IntRange encodingIntervalRange = mpeg4Options.getEncodingIntervalRange();
        IntRange govLengthIntervalRange = mpeg4Options.getGovLengthRange();
        SupportedMPEGProfileIDs supportedMPEGProfileIds = new SupportedMPEGProfileIDs();
        List mpeg4Profiles = mpeg4Options.getMpeg4ProfilesSupported();
        if (mpeg4Profiles != null) {
            for (Mpeg4Profile mpeg4Profile : mpeg4Profiles) {
                if (mpeg4Profile == Mpeg4Profile.SP) {
                    supportedMPEGProfileIds.getInt().add(MpegProfile.SP.getType());
                    continue;
                }
                if (mpeg4Profile != Mpeg4Profile.ASP) continue;
                supportedMPEGProfileIds.getInt().add(MpegProfile.ASP.getType());
            }
        }
        StreamDefinitionType streamDefinitionTypeMpeg4 = this.createOnvifStreamDefinitionType(numberOfStreams, frameRateRangeForBiggestResolution, encodingIntervalRange, govLengthIntervalRange, codecType, streamName, videoResolutions, frameRateRange, supportedMPEGProfileIds, streamingCapabilities, rtspPorts);
        return streamDefinitionTypeMpeg4;
    }

    protected StreamDefinitionType createStreamDefinitionTypeMjpeg(MultiStreamingInformation multiStreamingInformation, JpegOptions jpegOptions, IntRange frameRateRangeForBiggestResolution, String streamName, RealTimeStreamingCapabilities streamingCapabilities, List<Integer> rtspPorts) throws SeeTecException {
        CodecType codecType = new CodecType();
        codecType.setValue(Codec.MJPEG.getType());
        Integer numberOfStreams = multiStreamingInformation.getNumberOfJpegStreams() != null ? multiStreamingInformation.getNumberOfJpegStreams() : multiStreamingInformation.getTotalNumber();
        List videoResolutions = jpegOptions.getResolutionsAvailable();
        IntRange frameRateRange = jpegOptions.getFrameRateRange();
        IntRange encodingIntervalRange = jpegOptions.getEncodingIntervalRange();
        StreamDefinitionType streamDefinitionTypeMjpeg = this.createOnvifStreamDefinitionType(numberOfStreams, frameRateRangeForBiggestResolution, encodingIntervalRange, null, codecType, streamName, videoResolutions, frameRateRange, null, streamingCapabilities, rtspPorts);
        return streamDefinitionTypeMjpeg;
    }

    private StreamDefinitionType createStreamDefinitionTypeMjpeg(MultiStreamingInformation multiStreamingInformation, Media2Service media2Service, VideoEncoder2ConfigurationOptions videoEncoder2ConfigurationOption, String streamName, IntRange frameRateRangeForBiggestResolution) throws SeeTecException {
        CodecType codecType = new CodecType();
        codecType.setValue(Codec.MJPEG.getType());
        Integer numberOfStreams = multiStreamingInformation.getNumberOfJpegStreams() == null ? 1 : multiStreamingInformation.getNumberOfJpegStreams();
        List videoResolutions2 = videoEncoder2ConfigurationOption.getResolutionsAvailable();
        ArrayList<VideoResolution> videoResolutions = new ArrayList<VideoResolution>();
        for (VideoResolution2 videoResolution2 : videoResolutions2) {
            VideoResolution videoResolution = new VideoResolution();
            videoResolution.setHeight(videoResolution2.getHeight());
            videoResolution.setWidth(videoResolution2.getWidth());
            videoResolutions.add(videoResolution);
        }
        List frameratesSupported = videoEncoder2ConfigurationOption.getFrameRatesSupported();
        GenericOnvifHelper genericOnvifHelper = new GenericOnvifHelper();
        IntRange frameRateRange = genericOnvifHelper.convertFramerateListToIntRange(frameratesSupported);
        ArrayList<Integer> rtspPorts = new ArrayList<Integer>();
        rtspPorts.add(554);
        RealTimeStreamingCapabilities realTimeStreamingCapabilities = this.getRealTimeStreamingCapabilities(media2Service);
        StreamDefinitionType streamDefinitionTypeJpeg = this.createOnvifStreamDefinitionType(numberOfStreams, frameRateRangeForBiggestResolution, new IntRange(), null, codecType, streamName, videoResolutions, frameRateRange, null, realTimeStreamingCapabilities, rtspPorts);
        return streamDefinitionTypeJpeg;
    }

    protected StreamDefinitionType createStreamDefinitionTypeH264(MultiStreamingInformation multiStreamingInformation, H264Options h264Options, IntRange frameRateRangeForBiggestResolution, String streamName, RealTimeStreamingCapabilities streamingCapabilities, List<Integer> rtspPorts) throws SeeTecException {
        CodecType codecType = new CodecType();
        codecType.setValue(Codec.H264.getType());
        Integer numberOfStreams = multiStreamingInformation.getNumberOfH264Streams() != null ? multiStreamingInformation.getNumberOfH264Streams() : multiStreamingInformation.getTotalNumber();
        List videoResolutions = h264Options.getResolutionsAvailable();
        IntRange frameRateRange = h264Options.getFrameRateRange();
        IntRange encodingIntervalRange = h264Options.getEncodingIntervalRange();
        IntRange govLengthIntervalRange = h264Options.getGovLengthRange();
        SupportedMPEGProfileIDs supportedMPEGProfileIds = new SupportedMPEGProfileIDs();
        List h264Profiles = h264Options.getH264ProfilesSupported();
        if (h264Profiles != null) {
            for (H264Profile h264Profile : h264Profiles) {
                if (h264Profile == H264Profile.BASELINE) {
                    supportedMPEGProfileIds.getInt().add(MpegProfile.BASELINE.getType());
                    continue;
                }
                if (h264Profile == H264Profile.EXTENDED) {
                    supportedMPEGProfileIds.getInt().add(MpegProfile.EXTENDED.getType());
                    continue;
                }
                if (h264Profile == H264Profile.HIGH) {
                    supportedMPEGProfileIds.getInt().add(MpegProfile.HIGH.getType());
                    continue;
                }
                if (h264Profile != H264Profile.MAIN) continue;
                supportedMPEGProfileIds.getInt().add(MpegProfile.MAIN.getType());
            }
        }
        StreamDefinitionType streamDefinitionTypeH264 = this.createOnvifStreamDefinitionType(numberOfStreams, frameRateRangeForBiggestResolution, encodingIntervalRange, govLengthIntervalRange, codecType, streamName, videoResolutions, frameRateRange, supportedMPEGProfileIds, streamingCapabilities, rtspPorts);
        return streamDefinitionTypeH264;
    }

    private StreamDefinitionType createStreamDefinitionTypeH264(MultiStreamingInformation multiStreamingInformation, Media2Service media2Service, VideoEncoder2ConfigurationOptions videoEncoder2ConfigurationOption, String streamName, IntRange frameRateRangeForBiggestResolution) throws SeeTecException {
        CodecType codecType = new CodecType();
        codecType.setValue(Codec.H264.getType());
        Integer numberOfStreams = multiStreamingInformation.getNumberOfH264Streams() == null ? 1 : multiStreamingInformation.getNumberOfH264Streams();
        List videoResolutions2 = videoEncoder2ConfigurationOption.getResolutionsAvailable();
        ArrayList<VideoResolution> videoResolutions = new ArrayList<VideoResolution>();
        for (VideoResolution2 videoResolution2 : videoResolutions2) {
            VideoResolution videoResolution = new VideoResolution();
            videoResolution.setHeight(videoResolution2.getHeight());
            videoResolution.setWidth(videoResolution2.getWidth());
            videoResolutions.add(videoResolution);
        }
        GenericOnvifHelper genericOnvifHelper = new GenericOnvifHelper();
        IntRange frameRateRange = genericOnvifHelper.convertFramerateListToIntRange(videoEncoder2ConfigurationOption.getFrameRatesSupported());
        IntRange iFrameDistance = genericOnvifHelper.convertGovLengthListToIntRange(videoEncoder2ConfigurationOption.getGovLengthRange());
        SupportedMPEGProfileIDs supportedMPEGProfileIds = new SupportedMPEGProfileIDs();
        List h264Profiles = videoEncoder2ConfigurationOption.getProfilesSupported();
        List<Integer> profiles = genericOnvifHelper.createMpegProfilesList(h264Profiles);
        supportedMPEGProfileIds.getInt().addAll(profiles);
        ArrayList<Integer> rtspPorts = new ArrayList<Integer>();
        rtspPorts.add(554);
        RealTimeStreamingCapabilities realTimeStreamingCapabilities = this.getRealTimeStreamingCapabilities(media2Service);
        StreamDefinitionType streamDefinitionTypeH264 = this.createOnvifStreamDefinitionType(numberOfStreams, frameRateRangeForBiggestResolution, new IntRange(), iFrameDistance, codecType, streamName, videoResolutions, frameRateRange, supportedMPEGProfileIds, realTimeStreamingCapabilities, rtspPorts);
        return streamDefinitionTypeH264;
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Mentionned hard-coded password is just empty default pass which is a proper default setting in this case.")
    private DeviceNetworkDefinitionType createDeviceNetworkDefinitionType(List<Integer> httpPorts, List<Integer> httpsPorts) {
        DeviceNetworkDefinitionType deviceNetworkDefinitionType = new DeviceNetworkDefinitionType();
        deviceNetworkDefinitionType.setCanChangeHttpPort(true);
        deviceNetworkDefinitionType.setCanChangeHttpsPort(httpsPorts.size() > 0);
        deviceNetworkDefinitionType.setCanHttps(httpsPorts.size() > 0);
        deviceNetworkDefinitionType.setDefaultHttpPort(httpPorts.size() > 0 ? httpPorts.get(0) : 80);
        deviceNetworkDefinitionType.setDefaultHttpsPort(httpsPorts.size() > 0 ? httpsPorts.get(0) : 443);
        deviceNetworkDefinitionType.setDefaultPassword("");
        deviceNetworkDefinitionType.setDefaultUserName("");
        deviceNetworkDefinitionType.setUseAuthentication(false);
        deviceNetworkDefinitionType.setMinVideoStreamNetworkTimeout(this.onvifMinVideoStreamNetworkTimeout);
        deviceNetworkDefinitionType.setMaxVideoStreamNetworkTimeout(this.onvifMaxVideoStreamNetworkTimeout);
        deviceNetworkDefinitionType.setDefaultVideoStreamNetworkTimeout(this.onvifLegacyTimeout);
        return deviceNetworkDefinitionType;
    }

    public final Map<String, EventMessageDescription> getEventTypesMap() {
        if (this.eventTypesMap == null) {
            try {
                this.eventTypesMap = this.getOnvifCore().getEventService().getEventProperties();
            }
            catch (Exception exception) {
                this.getLogger().warn("Could not receive event list from " + this);
            }
        }
        return this.eventTypesMap;
    }

    private StreamDefinitionType createOnvifStreamDefinitionType(Integer numberOfStreams, IntRange frameRateRangeForBiggestResolution, IntRange encodingIntervalRange, IntRange govLengthIntervalRange, CodecType codecType, String streamName, List<VideoResolution> videoResolutions, IntRange frameRateRange, SupportedMPEGProfileIDs supportedMpegProfilesType, RealTimeStreamingCapabilities streamingCapabilities, List<Integer> rtspPorts) throws SeeTecException {
        StreamDefinitionType streamDefinitionType = new StreamDefinitionType();
        streamDefinitionType.setNoOfHWMDInputs(5);
        streamDefinitionType.setMaxNumberOfStreams(numberOfStreams);
        streamDefinitionType.setDefaultMilliFPS(frameRateRangeForBiggestResolution.getMin() < 5 && frameRateRangeForBiggestResolution.getMax() > 5 ? 5000 : frameRateRangeForBiggestResolution.getMin() * 1000);
        streamDefinitionType.setHideFPSField(false);
        streamDefinitionType.setHideIFrameField(govLengthIntervalRange == null);
        streamDefinitionType.setMinIFrameDistance(1000);
        streamDefinitionType.setMaxIFrameDistance(100000);
        streamDefinitionType.setHideKompressionField(false);
        streamDefinitionType.setHideBandwithField(false);
        streamDefinitionType.setEncodingIntervalMin(encodingIntervalRange.getMin() * 1000);
        streamDefinitionType.setEncodingIntervalMax(encodingIntervalRange.getMax() * 1000);
        streamDefinitionType.setStreamingMode(codecType);
        SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
        if (streamingCapabilities != null) {
            boolean canRtpRtspTcp;
            boolean canRtpMulticastDevice = streamingCapabilities.isRTPMulticast() != null && streamingCapabilities.isRTPMulticast() != false;
            boolean canRtpMulticastDriver = this.getDeviceType() == 209601L || this.getDeviceType() == 205501L || this.getDeviceType() == 204203L || this.getDeviceType() == 206500L || this.getDeviceType() == 206600L;
            boolean canRtpTcp = streamingCapabilities.isRTPTCP() != null && streamingCapabilities.isRTPTCP() != false;
            boolean bl = canRtpRtspTcp = streamingCapabilities.isRTPRTSPTCP() != null && streamingCapabilities.isRTPRTSPTCP() != false;
            if (canRtpMulticastDevice && canRtpMulticastDriver) {
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_MULTICAST.getType());
            }
            if (canRtpRtspTcp) {
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
            }
            if (canRtpTcp || canRtpRtspTcp) {
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
            }
        }
        streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
        RtspSettingsType rtspSettingsType = GenericOnvifDevice.createRtspSettingstype(rtspPorts);
        streamDefinitionType.setRtspSettings(rtspSettingsType);
        BitrateSettingsType bitrateSettingsType = GenericOnvifDevice.createBitrateSettingsType();
        streamDefinitionType.setBitrateSettings(bitrateSettingsType);
        streamDefinitionType.setName(streamName);
        SupportedCameraResolutionsType supportedCameraResolutionsType = this.createSupportedCameraResolutionsType(videoResolutions, frameRateRange);
        streamDefinitionType.setSupportedCameraResolutions(supportedCameraResolutionsType);
        streamDefinitionType.setSupportedMPEGProfileIDs(supportedMpegProfilesType);
        streamDefinitionType.setDefaultCameraResolutionIndex(0);
        streamDefinitionType.setDefaultTransmissionTypeIndex(0);
        return streamDefinitionType;
    }

    private SupportedCameraResolutionsType createSupportedCameraResolutionsType(List<VideoResolution> videoResolutions, IntRange frameRateRange) {
        SupportedCameraResolutionsType supportedCameraResolutionsType = new SupportedCameraResolutionsType();
        for (VideoResolution videoResolution : videoResolutions) {
            int width = videoResolution.getWidth();
            int height = videoResolution.getHeight();
            CameraResolutionType cameraResolutionType = new CameraResolutionType();
            cameraResolutionType.setDisplayResolution(width + "x" + height);
            cameraResolutionType.setWidth(width);
            cameraResolutionType.setHeight(height);
            cameraResolutionType.setMaxMilliFPS(frameRateRange.getMax() * 1000);
            cameraResolutionType.setMinMilliFPS(frameRateRange.getMin() * 1000);
            cameraResolutionType.setResolution(width + "x" + height);
            cameraResolutionType.setSupportedFrameRates(null);
            supportedCameraResolutionsType.getCameraResolution().add(cameraResolutionType);
        }
        return supportedCameraResolutionsType;
    }

    protected SupportedCameraResolutionsType createSupportedCameraResolutionsType(Media2Service media2Service, String streamName, Codec codec) {
        SupportedCameraResolutionsType supportedCameraResolutionsType = new SupportedCameraResolutionsType();
        String tokenName = OnvifHelper.extractOnvifProfileAndStreamName(streamName)[1];
        VideoEncoder2ConfigurationOptions videoEncoderConfigurationOptions = this.getVideoEncoder2ConfigurationOptions(media2Service, tokenName, codec);
        if (videoEncoderConfigurationOptions != null) {
            List resolutions2 = videoEncoderConfigurationOptions.getResolutionsAvailable();
            List framerates = videoEncoderConfigurationOptions.getFrameRatesSupported();
            float maxFramerate = ((Float)Collections.max(framerates)).floatValue();
            for (VideoResolution2 videoResolution2 : resolutions2) {
                CameraResolutionType cameraResolutionType = new CameraResolutionType();
                cameraResolutionType.setHeight(videoResolution2.getHeight());
                cameraResolutionType.setWidth(videoResolution2.getWidth());
                cameraResolutionType.setMinMilliFPS(1000);
                cameraResolutionType.setMaxMilliFPS((int)(maxFramerate * 1000.0f));
                cameraResolutionType.setResolution(videoResolution2.getWidth() + "x" + videoResolution2.getHeight());
                cameraResolutionType.setDisplayResolution(videoResolution2.getWidth() + "x" + videoResolution2.getHeight());
                supportedCameraResolutionsType.getCameraResolution().add(cameraResolutionType);
            }
        }
        return supportedCameraResolutionsType;
    }

    protected static RtspSettingsType createRtspSettingstype(List<Integer> rtspPorts) {
        RtspSettingsType rtspSettingsType = new RtspSettingsType();
        rtspSettingsType.setDefaultRtspPort(rtspPorts.size() > 0 ? rtspPorts.get(0) : 554);
        rtspSettingsType.setCanChangeRtspPort(true);
        rtspSettingsType.setCanMultipleRtspPorts(false);
        return rtspSettingsType;
    }

    protected static BitrateSettingsType createBitrateSettingsType() {
        BitrateSettingsType bitrateSettingsType = new BitrateSettingsType();
        bitrateSettingsType.setCanVBR(false);
        bitrateSettingsType.setCanVBRQuality(false);
        bitrateSettingsType.setCanCBR(true);
        bitrateSettingsType.setCanCBRQuality(true);
        bitrateSettingsType.setMaxBandwidth(51200000);
        bitrateSettingsType.setMinBandwidth(1024);
        bitrateSettingsType.setSupportedBitrates(null);
        return bitrateSettingsType;
    }

    @Override
    protected final VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        long deviceType = this.getDeviceType();
        long sourceType = 219602L;
        if (deviceType == 205501L) {
            sourceType = 215501L;
        } else if (deviceType == 204203L) {
            sourceType = 214203L;
        } else if (deviceType == 206500L) {
            sourceType = 216500L;
        } else if (deviceType == 206600L) {
            sourceType = 216600L;
        }
        try {
            List videoSourceConfigurationList;
            List videoSourceList = this.getOnvifCore().getMediaService().getOnvifMediaService().getVideoSources();
            String videoSourceToken = "";
            if (videoSourceList.size() > 0) {
                videoSourceToken = ((VideoSource)videoSourceList.get(0)).getToken();
            }
            if (videoSourceToken.isEmpty() && (videoSourceConfigurationList = this.getOnvifCore().getMedia2Service().getOnvifMedia2Service().getVideoSourceConfigurations(null, null)).size() > 0) {
                videoSourceToken = ((VideoSourceConfiguration)videoSourceConfigurationList.get(0)).getSourceToken();
            }
            boolean ptzAvailable = this.getOnvifCore().getPtzService() != null;
            boolean imagingAvailable = this.getOnvifCore().getImagingService() != null;
            VideoCameraDefinition videoCameraDefinition = new VideoCameraDefinition();
            videoCameraDefinition.setManufacturer(this.getOnvifCore().getDeviceService().getDeviceInformation().getManufacturer());
            videoCameraDefinition.setComment("");
            videoCameraDefinition.setDefaultMediaID(ptzAvailable ? MediaID.VIDEO_SOURCE_PTZ.getType() : MediaID.VIDEO_SOURCE_DIGITAL.getType());
            videoCameraDefinition.setName(this.getOnvifCore().getDeviceService().getDeviceInformation().getDeviceModel());
            videoCameraDefinition.setEntityType(sourceType);
            videoCameraDefinition.setPreferAbsolutePTZ(false);
            FeaturesType featuresType = new FeaturesType();
            if (ptzAvailable) {
                try {
                    PTZ ptzService = this.getOnvifCore().getPtzService().getOnvifPtzService();
                    List nodes = ptzService.getNodes();
                    boolean canNullLux = false;
                    boolean canAutoNullLux = false;
                    boolean canAutoFocus = false;
                    boolean canAutoIris = false;
                    boolean canFocus = false;
                    if (imagingAvailable && !videoSourceToken.isEmpty()) {
                        ImagingService imagingService = this.getOnvifCore().getImagingService();
                        ImagingOptions20 imagingOptions = imagingService.getImagingOptions(videoSourceToken);
                        MoveOptions20 moveOptions = imagingService.getMoveOptions(videoSourceToken);
                        canNullLux = this.isNullLuxAvailable(imagingOptions.getIrCutFilterModes());
                        canAutoNullLux = this.isAutoNullLuxAvailable(imagingOptions.getIrCutFilterModes());
                        canAutoFocus = this.isAutoFocusAvailable(imagingOptions.getFocus());
                        canAutoIris = this.isAutoIrisAvailable(imagingOptions.getExposure());
                        canFocus = this.isFocusAvailable(moveOptions.getContinuous());
                    }
                    if (nodes.size() > 0) {
                        PTZNode node = (PTZNode)ptzService.getNodes().get(0);
                        PTZSpaces spaces = node.getSupportedPTZSpaces();
                        featuresType.setCanAbsolutePan(spaces.getAbsolutePanTiltPositionSpace().size() > 0);
                        featuresType.setCanAbsoluteTilt(spaces.getAbsolutePanTiltPositionSpace().size() > 0);
                        featuresType.setCanAbsoluteZoom(spaces.getAbsoluteZoomPositionSpace().size() > 0);
                        featuresType.setCanContinuousPan(spaces.getContinuousPanTiltVelocitySpace().size() > 0);
                        featuresType.setCanContinuousTilt(spaces.getContinuousPanTiltVelocitySpace().size() > 0);
                        featuresType.setCanContinuousZoom(spaces.getContinuousZoomVelocitySpace().size() > 0);
                        featuresType.setCanRelativePan(false);
                        featuresType.setCanRelativeTilt(false);
                        featuresType.setCanRelativeZoom(false);
                        featuresType.setCanFocus(canFocus);
                        featuresType.setCanAutoFocus(canAutoFocus);
                        featuresType.setCanIris(false);
                        featuresType.setCanAutoIris(canAutoIris);
                        featuresType.setCanNullLux(canNullLux);
                        featuresType.setCanAutoNullLux(canAutoNullLux);
                        featuresType.setCanPreset(node.getMaximumNumberOfPresets() > 0);
                        if (featuresType.isCanAbsolutePan()) {
                            featuresType.setMinPan((int)((Space2DDescription)spaces.getAbsolutePanTiltPositionSpace().get(spaces.getAbsolutePanTiltPositionSpace().size() - 1)).getXRange().getMin());
                            featuresType.setMaxPan((int)((Space2DDescription)spaces.getAbsolutePanTiltPositionSpace().get(spaces.getAbsolutePanTiltPositionSpace().size() - 1)).getXRange().getMax());
                            featuresType.setMinTilt((int)((Space2DDescription)spaces.getAbsolutePanTiltPositionSpace().get(spaces.getAbsolutePanTiltPositionSpace().size() - 1)).getYRange().getMin());
                            featuresType.setMaxTilt((int)((Space2DDescription)spaces.getAbsolutePanTiltPositionSpace().get(spaces.getAbsolutePanTiltPositionSpace().size() - 1)).getYRange().getMax());
                        }
                        if (featuresType.isCanAbsoluteZoom()) {
                            featuresType.setMinAbsoluteZoom((int)(((Space1DDescription)spaces.getAbsoluteZoomPositionSpace().get(0)).getXRange().getMin() * 1000.0f));
                            featuresType.setMaxAbsoluteZoom((int)(((Space1DDescription)spaces.getAbsoluteZoomPositionSpace().get(0)).getXRange().getMax() * 1000.0f));
                        }
                        featuresType.setMinZoom(0);
                        featuresType.setMaxZoom(100000);
                        featuresType.setMinSpeed(0);
                        featuresType.setMaxSpeed(100000);
                        featuresType.setPTZMinContinuousLevel(10000);
                        featuresType.setPTZMaxContinuousLevel(100000);
                        featuresType.setPTZContinuousSpeedFactor(1000);
                        boolean canCenterPt = this.getCenterPtCapabilities(nodes);
                        featuresType.setCanCenterPT(canCenterPt);
                    }
                }
                catch (Exception ex) {
                    this.getLogger().warn("Error while reading PTZ capability for " + this + ". We are assuming PTZ is not available for " + this);
                }
            }
            videoCameraDefinition.setFeatures(featuresType);
            return videoCameraDefinition;
        }
        catch (SeeTecException exception) {
            this.getLogger().warn("Error while reading information from " + this, (Throwable)exception);
            throw exception;
        }
        catch (Exception exception) {
            this.getLogger().warn("Error while reading information from " + this, (Throwable)exception);
            throw new SeeTecException(-21600, exception.getMessage());
        }
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Wrong positive. Password TYPE and not passwort is set.")
    public static final int checkDeviceInfos(long type, String host, int port, boolean useAuthorization, String user, String pass, int timeout) {
        Capabilities capabilities;
        JaxWsProxyFactoryBean factory;
        int errorCode = 0;
        try {
            factory = new JaxWsProxyFactoryBean();
            factory.setBindingId("http://schemas.xmlsoap.org/wsdl/soap12/");
            factory.setServiceClass(Device.class);
            factory.setAddress("http://" + host + ":" + port + "/onvif/device_service");
            Device device = (Device)factory.create(Device.class);
            Client client = ClientProxy.getClient((Object)device);
            HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
            HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
            httpClientPolicy.setConnectionTimeout((long)timeout);
            httpClientPolicy.setReceiveTimeout((long)timeout);
            httpConduit.setClient(httpClientPolicy);
            ArrayList<CapabilityCategory> capabilityCategories = new ArrayList<CapabilityCategory>();
            capabilityCategories.add(CapabilityCategory.ALL);
            capabilities = device.getCapabilities(capabilityCategories);
        }
        catch (Exception e) {
            return -21697;
        }
        try {
            factory = new JaxWsProxyFactoryBean();
            factory.setBindingId("http://schemas.xmlsoap.org/wsdl/soap12/");
            factory.setServiceClass(Media.class);
            String mediaServiceAddress = capabilities.getMedia() != null ? capabilities.getMedia().getXAddr() : null;
            mediaServiceAddress = OnvifHelper.changeIPAddressPortOfUrl(mediaServiceAddress, host, port, null);
            factory.setAddress(mediaServiceAddress);
            Media media = (Media)factory.create(Media.class);
            Client client = ClientProxy.getClient((Object)media);
            HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
            HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
            httpClientPolicy.setConnectionTimeout((long)timeout);
            httpClientPolicy.setReceiveTimeout((long)timeout);
            httpConduit.setClient(httpClientPolicy);
            if (useAuthorization) {
                Endpoint endpoint = client.getEndpoint();
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("action", "UsernameToken");
                properties.put("user", user);
                properties.put("passwordType", "PasswordDigest");
                properties.put("passwordCallbackRef", new WebServicePasswordHandler(pass));
                WSS4JOutInterceptor wssOut = new WSS4JOutInterceptor(properties);
                endpoint.getOutInterceptors().add(wssOut);
            }
            media.getProfiles();
        }
        catch (Exception e) {
            errorCode = -21701;
        }
        return errorCode;
    }

    protected String getCurrentCaptureModeFromDefinition() {
        try {
            List<CaptureModeDefinitionType> list = this.getDeviceDefinitionFromConfiguration().getSupportedCaptureModes().getCaptureModeDefinition();
            if (!list.isEmpty()) {
                return list.get(0).getModeSuffix();
            }
        }
        catch (Exception e) {
            this.getLogger().debug("Could not find out current capture mode in definition [" + e.getMessage() + "] for " + this);
        }
        return "";
    }

    protected static String getCurrentlySetCaptureMode(List<VideoSourceMode> videoSourceModes) throws SeeTecException {
        String currentCaptureMode = "";
        for (VideoSourceMode videoSourceMode : videoSourceModes) {
            if (!videoSourceMode.isEnabled().booleanValue() || videoSourceMode.getDescription() == null) continue;
            currentCaptureMode = videoSourceMode.getDescription();
        }
        return currentCaptureMode;
    }

    private StreamDefinitionType createStreamDefinitionTypeH265(Media2Service media2Service, VideoEncoder2ConfigurationOptions videoEncoder2ConfigurationOption, String streamName) {
        StreamDefinitionType streamDefinitionType = new StreamDefinitionType();
        String codec = videoEncoder2ConfigurationOption.getEncoding();
        if (codec.contains("265")) {
            BitrateSettingsType bitrateSettingsType = new BitrateSettingsType();
            boolean canCbr = false;
            try {
                if (videoEncoder2ConfigurationOption.isConstantBitRateSupported().booleanValue()) {
                    canCbr = videoEncoder2ConfigurationOption.isConstantBitRateSupported();
                }
            }
            catch (Exception ex) {
                this.getLogger().warn("Exception while reading CBR capabilities for " + this);
            }
            bitrateSettingsType.setCanCBR(canCbr);
            bitrateSettingsType.setCanVBR(false);
            int minBandwidth = 1024;
            List govLengthRangeList = videoEncoder2ConfigurationOption.getGovLengthRange();
            if (govLengthRangeList.size() == 2) {
                streamDefinitionType.setEncodingIntervalMin((Integer)govLengthRangeList.get(0) * 1000);
                streamDefinitionType.setEncodingIntervalMax((Integer)govLengthRangeList.get(1) * 1000);
            }
            streamDefinitionType.setMaxIFrameDistance(100000);
            streamDefinitionType.setMinIFrameDistance(1000);
            streamDefinitionType.setHideBandwithField(false);
            int maxBandwidth = videoEncoder2ConfigurationOption.getBitrateRange().getMax();
            bitrateSettingsType.setMinBandwidth(minBandwidth);
            bitrateSettingsType.setMaxBandwidth(maxBandwidth * 1024);
            streamDefinitionType.setBitrateSettings(bitrateSettingsType);
            streamDefinitionType.setNoOfHWMDInputs(5);
            streamDefinitionType.setMaxNumberOfStreams(1);
            SupportedCameraResolutionsType supportedCameraResolutionsType = this.createSupportedCameraResolutionsType(media2Service, streamName, Codec.H265);
            streamDefinitionType.setSupportedCameraResolutions(supportedCameraResolutionsType);
            CodecType codecType = new CodecType();
            codecType.setValue(Codec.H265.getType());
            streamDefinitionType.setStreamingMode(codecType);
            streamDefinitionType.setName(streamName);
            StreamingCapabilities streamingCapabilities = null;
            try {
                streamingCapabilities = media2Service.getOnvifMedia2Service().getServiceCapabilities().getStreamingCapabilities();
            }
            catch (Exception ex) {
                this.getLogger().warn(ex.getMessage());
            }
            SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
            supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
            if (streamingCapabilities != null) {
                boolean canRtpRtspTcp;
                boolean canRtpMulticastDevice = streamingCapabilities.isRTPMulticast() != null && streamingCapabilities.isRTPMulticast() != false;
                boolean canRtpMulticastDriver = this.getDeviceType() == 209601L || this.getDeviceType() == 205501L || this.getDeviceType() == 204203L || this.getDeviceType() == 206500L || this.getDeviceType() == 206600L;
                boolean canRtpTcp = streamingCapabilities.isRTSPStreaming() != null && streamingCapabilities.isRTSPStreaming() != false;
                boolean bl = canRtpRtspTcp = streamingCapabilities.isRTPRTSPTCP() != null && streamingCapabilities.isRTPRTSPTCP() != false;
                if (canRtpMulticastDevice && canRtpMulticastDriver) {
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_MULTICAST.getType());
                }
                if (canRtpRtspTcp) {
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                }
                if (canRtpTcp || canRtpRtspTcp) {
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
                }
            }
            streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
            ArrayList<Integer> rtspPorts = new ArrayList<Integer>();
            rtspPorts.add(554);
            RtspSettingsType rtspSettingsType = GenericOnvifDevice.createRtspSettingstype(rtspPorts);
            streamDefinitionType.setRtspSettings(rtspSettingsType);
        }
        return streamDefinitionType;
    }

    protected VideoEncoder2ConfigurationOptions getVideoEncoder2ConfigurationOptions(Media2Service media2Service, String tokenName, Codec codec) {
        List videoEncoderConfigurationOptionList = media2Service.getOnvifMedia2Service().getVideoEncoderConfigurationOptions(tokenName, null);
        for (VideoEncoder2ConfigurationOptions videoEncoder2ConfigurationOptions : videoEncoderConfigurationOptionList) {
            if (!videoEncoder2ConfigurationOptions.getEncoding().equals(codec.name())) continue;
            return videoEncoder2ConfigurationOptions;
        }
        return null;
    }

    protected boolean isNullLuxAvailable(List<IrCutFilterMode> irCutFilterModes) {
        boolean nullLuxOnSupported = false;
        boolean nullLuxOffSupported = false;
        if (irCutFilterModes != null) {
            for (IrCutFilterMode irCutFilterMode : irCutFilterModes) {
                if (irCutFilterMode.value().toLowerCase().equals("on")) {
                    nullLuxOnSupported = true;
                    continue;
                }
                if (!irCutFilterMode.value().toLowerCase().equals("off")) continue;
                nullLuxOffSupported = true;
            }
        }
        return nullLuxOnSupported && nullLuxOffSupported;
    }

    protected boolean isAutoNullLuxAvailable(List<IrCutFilterMode> irCutFilterModes) {
        if (irCutFilterModes != null) {
            for (IrCutFilterMode irCutFilterMode : irCutFilterModes) {
                if (!irCutFilterMode.value().toLowerCase().equals("auto")) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isAutoFocusAvailable(FocusOptions20 focusOptions20) {
        if (focusOptions20 != null) {
            List autoFocusModes = focusOptions20.getAutoFocusModes();
            for (AutoFocusMode autoFocusMode : autoFocusModes) {
                if (!autoFocusMode.value().toLowerCase().equals("auto")) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isFocusAvailable(ContinuousFocusOptions continuousFocusOptions) {
        return continuousFocusOptions != null;
    }

    protected boolean isAutoIrisAvailable(ExposureOptions20 exposureOptions) {
        if (exposureOptions != null) {
            List exposureModes = exposureOptions.getMode();
            for (ExposureMode exposureMode : exposureModes) {
                if (exposureMode != ExposureMode.AUTO) continue;
                return true;
            }
        }
        return false;
    }

    private Logger getLogger() {
        return this.logger;
    }

    protected String checkEdgeStorageReady(int channelNumber) {
        try {
            List<TimeRange> lastRecordings = this.getRecordingInfosFromDevice(System.currentTimeMillis() - 300000L, System.currentTimeMillis(), channelNumber);
            ArrayList<String> multiLineLog = new ArrayList<String>();
            multiLineLog.add("Edge Storage Information for " + this);
            multiLineLog.add("Channel: " + channelNumber);
            if (lastRecordings.isEmpty()) {
                multiLineLog.add("Edge Storage is not ready, because there are no recordings available from the last 5 Minutes");
            } else {
                multiLineLog.add("Edge Storage is ready on the camera.");
            }
            return Basic.generateIndentedMultiLineLog(multiLineLog);
        }
        catch (Exception ex) {
            return "Exception while trying to get Edge Storage status for " + this;
        }
    }

    @Override
    public List<TimeRange> getRecordingInfosFromDevice(long startTimestamp, long endTimestamp, int channelNumber) {
        try {
            int counter;
            SearchService searchService = this.getOnvifCore().getSearchService();
            SearchScope searchScope = new SearchScope();
            searchScope.setRecordingInformationFilter(null);
            SearchScopeExtension searchScopeExtension = new SearchScopeExtension();
            searchScope.setExtension(searchScopeExtension);
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            Duration duration = datatypeFactory.newDuration("PT10S");
            String session = searchService.getOnvifSearchService().findRecordings(searchScope, null, duration);
            FindRecordingResultList findRecordingResultList = searchService.getOnvifSearchService().getRecordingSearchResults(session, null, null, null);
            List recordingInformationList = findRecordingResultList.getRecordingInformation();
            for (counter = 0; (findRecordingResultList.getSearchState().equals((Object)SearchState.SEARCHING) || findRecordingResultList.getSearchState().equals((Object)SearchState.QUEUED)) && counter < 10; ++counter) {
                Thread.sleep(10L);
                findRecordingResultList = searchService.getOnvifSearchService().getRecordingSearchResults(session, null, null, null);
                recordingInformationList.addAll(findRecordingResultList.getRecordingInformation());
            }
            try {
                searchService.getOnvifSearchService().endSearch(session);
            }
            catch (Exception ex) {
                this.logger.info("Exception while ending search " + session + ". Search has probably ended already for " + this);
            }
            ArrayList<TimeRange> timeRangeList = new ArrayList<TimeRange>();
            SearchScope searchScopeEvents = new SearchScope();
            EventFilter eventFilter = new EventFilter();
            Duration durationEvents = datatypeFactory.newDuration("PT10S");
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.setTimeInMillis(startTimestamp - 30000000L);
            XMLGregorianCalendar firstRecording = DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
            String searchToken = this.getOnvifCore().getSearchService().getOnvifSearchService().findEvents(firstRecording, null, searchScopeEvents, eventFilter, true, null, durationEvents);
            FindEventResultList findEventResultList = this.getOnvifCore().getSearchService().getOnvifSearchService().getEventSearchResults(searchToken, null, null, null);
            List<RecordingEvent> startStopRecordingList = GenericOnvifHelper.getRecordingEvents(findEventResultList);
            for (counter = 0; (findEventResultList.getSearchState().equals((Object)SearchState.SEARCHING) || findEventResultList.getSearchState().equals((Object)SearchState.QUEUED)) && counter < 10; ++counter) {
                Thread.sleep(10L);
                findEventResultList = this.getOnvifCore().getSearchService().getOnvifSearchService().getEventSearchResults(searchToken, null, null, null);
                startStopRecordingList.addAll(GenericOnvifHelper.getRecordingEvents(findEventResultList));
            }
            for (RecordingInformation recordingInformation : recordingInformationList) {
                ArrayList<TrackInformation> tracksInTime = new ArrayList<TrackInformation>();
                for (TrackInformation track : recordingInformation.getTrack()) {
                    if (track.getTrackType() != TrackType.VIDEO) continue;
                    long startTime = track.getDataFrom().toGregorianCalendar(TimeZone.getTimeZone("GMT"), null, null).getTimeInMillis();
                    long endTime = track.getDataTo().toGregorianCalendar(TimeZone.getTimeZone("GMT"), null, null).getTimeInMillis();
                    if ((startTimestamp < startTime || startTimestamp > endTime) && (endTimestamp < startTime || endTimestamp > endTime)) continue;
                    tracksInTime.add(track);
                }
                for (TrackInformation trackInTime : tracksInTime) {
                    List<TimeRange> timeRanges = GenericOnvifHelper.getTimeRangeList(startTimestamp, endTimestamp, trackInTime, startStopRecordingList);
                    timeRangeList.addAll(timeRanges);
                }
            }
            return timeRangeList;
        }
        catch (Exception ex) {
            this.logger.warn("Exception while calculating time ranges available from camera for " + this + ": " + ex.getMessage());
            return null;
        }
    }

    protected boolean getCenterPtCapabilities(List<PTZNode> ptzNodes) {
        for (PTZNode ptzNode : ptzNodes) {
            PTZSpaces ptzSpaces = ptzNode.getSupportedPTZSpaces();
            List space2DDescriptions = ptzSpaces.getRelativePanTiltTranslationSpace();
            for (Space2DDescription space2DDescription : space2DDescriptions) {
                if (!space2DDescription.getURI().contains("TranslationSpaceFov")) continue;
                return true;
            }
        }
        return false;
    }

    public static CameraAdministration getCameraAdministration() throws SeeTecException {
        if (CAMERA_ADMINISTRATION == null) {
            CAMERA_ADMINISTRATION = new GenericOnvifCameraAdministration((SeetecHttpClient)new NetworkHelperAdapter());
        }
        return CAMERA_ADMINISTRATION;
    }

    protected RealTimeStreamingCapabilities getRealTimeStreamingCapabilities(Media2Service media2Service) {
        StreamingCapabilities streamingCapabilities = null;
        try {
            streamingCapabilities = media2Service.getOnvifMedia2Service().getServiceCapabilities().getStreamingCapabilities();
        }
        catch (Exception ex) {
            this.getLogger().warn(ex.getMessage());
        }
        RealTimeStreamingCapabilities realTimeStreamingCapabilities = new RealTimeStreamingCapabilities();
        if (streamingCapabilities != null) {
            realTimeStreamingCapabilities.setRTPMulticast(streamingCapabilities.isRTPMulticast());
            realTimeStreamingCapabilities.setRTPTCP(streamingCapabilities.isRTSPStreaming());
            realTimeStreamingCapabilities.setRTPRTSPTCP(streamingCapabilities.isRTPRTSPTCP());
        }
        return realTimeStreamingCapabilities;
    }
}

