/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.generic;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.ArrayOfCameraPreset;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.CameraPreset;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.shared.onvif.services.ImagingService;
import de.seetec.v5.re.cm.device.shared.onvif.services.PtzService;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifCameraSrv;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifDevice;
import de.seetec.v5.re.cm.shared.PtzInfo;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Vector;
import javax.xml.ws.Holder;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.onvif.ver10.media.wsdl.Media;
import org.onvif.ver10.schema.AutoFocusMode;
import org.onvif.ver10.schema.ContinuousFocus;
import org.onvif.ver10.schema.ContinuousFocusOptions;
import org.onvif.ver10.schema.Exposure20;
import org.onvif.ver10.schema.ExposureMode;
import org.onvif.ver10.schema.FloatRange;
import org.onvif.ver10.schema.FocusConfiguration20;
import org.onvif.ver10.schema.FocusMove;
import org.onvif.ver10.schema.ImagingSettings20;
import org.onvif.ver10.schema.IrCutFilterMode;
import org.onvif.ver10.schema.PTZConfiguration;
import org.onvif.ver10.schema.PTZNode;
import org.onvif.ver10.schema.PTZPreset;
import org.onvif.ver10.schema.PTZSpaces;
import org.onvif.ver10.schema.PTZStatus;
import org.onvif.ver10.schema.PTZVector;
import org.onvif.ver10.schema.Profile;
import org.onvif.ver10.schema.Space2DDescription;
import org.onvif.ver10.schema.Vector2D;
import org.onvif.ver10.schema.VideoSource;

public class GenericOnvifCameraControl
extends CameraControl {
    private VideoCameraDefinition cameraConfig;
    private GenericOnvifDevice device;
    private PtzService ptzService = null;
    private String profileName = null;
    private float minContinuousFocusSpeed;
    private float maxContinuousFocusSpeed;
    private String videoSourceToken;
    private ImagingService imagingService;

    @Override
    public int init(VideoSrv videoSrv, String api, String host, int port, String usr, String pwd, Vector<PresetCnf> presetList) {
        block15: {
            if (this.ptzService == null) {
                try {
                    if (!(videoSrv.getDevice() instanceof GenericOnvifDevice) || !(videoSrv instanceof GenericOnvifCameraSrv)) break block15;
                    GenericOnvifDevice onvifDevice = (GenericOnvifDevice)((GenericOnvifCameraSrv)videoSrv).getDevice();
                    OnvifCore onvifCore = onvifDevice.getOnvifCore();
                    this.ptzService = onvifCore.getPtzService();
                    this.device = onvifDevice;
                    Media mediaService = onvifCore.getMediaService().getOnvifMediaService();
                    int videoSourceNumber = 0;
                    try {
                        videoSourceNumber = videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
                    }
                    catch (ConfigurationException exception) {
                        this.logger.warn("Error while initializing ONVIF PTZ configuration, could not read VideoSourceNumber from configuration", (Throwable)exception);
                    }
                    String[] selectedOnvifProfileAndStreamName = OnvifHelper.extractOnvifProfileAndStreamName(((GenericOnvifCameraSrv)videoSrv).getBasicVideoProfileHandler().getVideoSourceParameter().getStreamName());
                    String selectedOnvifProfile = selectedOnvifProfileAndStreamName[0];
                    this.profileName = onvifCore.getMediaService().getProfile(selectedOnvifProfile, "VMS default", videoSourceNumber, 0).getToken();
                    Profile profile = onvifCore.getMediaService().getOnvifMediaService().getProfile(this.profileName);
                    if (profile.getPTZConfiguration() == null) {
                        String ptzConfigurationToken;
                        List ptzConfigurations = onvifCore.getPtzService().getOnvifPtzService().getConfigurations();
                        if (videoSourceNumber < ptzConfigurations.size()) {
                            ptzConfigurationToken = ((PTZConfiguration)ptzConfigurations.get(videoSourceNumber)).getToken();
                        } else {
                            ptzConfigurationToken = ((PTZConfiguration)ptzConfigurations.get(0)).getToken();
                            this.logger.warn("Error while initializing ONVIF PTZ configuration, not enough PTZ configurations available, use first one instead");
                        }
                        mediaService.addPTZConfiguration(profile.getToken(), ptzConfigurationToken);
                    }
                    this.cameraConfig = videoSrv.getDevice().getVideoCameraDefinitionFromConfiguration();
                }
                catch (ConfigurationException exception) {
                    this.logger.warn("Error while initializing ONVIF PTZ configuration", (Throwable)exception);
                    return -21602;
                }
                catch (SeeTecException exception) {
                    this.logger.warn("Error while initializing ONVIF PTZ configuration", (Throwable)exception);
                    return exception.getErrorCode();
                }
            }
        }
        try {
            int videoSourceNumber = videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
            this.videoSourceToken = ((VideoSource)this.device.getOnvifCore().getMediaService().getOnvifMediaService().getVideoSources().get(videoSourceNumber)).getToken();
            this.imagingService = this.device.getOnvifCore().getImagingService();
        }
        catch (Exception ex) {
            this.logger.warn("Exception while trying to retrieve video source token: " + ex.getMessage() + " for " + this);
        }
        try {
            ContinuousFocusOptions continuousFocusOptions;
            if (this.imagingService != null && (continuousFocusOptions = this.imagingService.getOnvifImagingService().getMoveOptions(this.videoSourceToken).getContinuous()) != null) {
                this.minContinuousFocusSpeed = continuousFocusOptions.getSpeed().getMin();
                this.maxContinuousFocusSpeed = continuousFocusOptions.getSpeed().getMax();
            }
        }
        catch (Exception ex) {
            this.logger.info("Could not determine focus speeds. Asuming -1 and 1 for " + this);
        }
        int errorCode = super.init(videoSrv, api, host, port, usr, pwd, presetList);
        if (this.cameraConfig != null && this.cameraConfig.getFeatures().isCanAbsoluteZoom()) {
            this.ptzInfo = new PtzInfo();
            this.refreshAbsolutePosition(true);
        }
        return errorCode;
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        return 0;
    }

    @Override
    public int setAbsoluteZ(VideoServiceClientRequestHandler sender, Integer zoom) {
        try {
            if (this.cameraConfig != null && this.cameraConfig.getFeatures().isCanAbsoluteZoom()) {
                PTZStatus status = this.ptzService.getOnvifPtzService().getStatus(this.profileName);
                PTZVector position = status.getPosition();
                this.ptzService.sendAbsolutePtzCommand(this.profileName, position.getPanTilt().getX(), position.getPanTilt().getY(), (float)zoom.intValue() / 1000.0f);
                this.refreshAbsolutePosition(false);
                this.ptzInfo.setZoom(zoom);
            }
        }
        catch (Exception ex) {
            this.logger.error("SetAbsoluteZ failed for " + this.device, (Throwable)ex);
        }
        return 0;
    }

    private void refreshAbsolutePosition(boolean sendStatus) {
        if (this.ptzService == null || this.cameraConfig == null || !this.cameraConfig.getFeatures().isCanAbsoluteZoom()) {
            return;
        }
        try {
            PTZStatus status = this.ptzService.getOnvifPtzService().getStatus(this.profileName);
            PTZVector position = status.getPosition();
            this.ptzInfo.setMinZoom(this.cameraConfig.getFeatures().getMinAbsoluteZoom());
            this.ptzInfo.setMaxZoom(this.cameraConfig.getFeatures().getMaxAbsoluteZoom());
            int pan = position.getPanTilt() != null ? (int)position.getPanTilt().getX() : 0;
            this.ptzInfo.setPan(pan);
            int tilt = position.getPanTilt() != null ? (int)position.getPanTilt().getY() : 0;
            this.ptzInfo.setTilt(tilt);
            int zoom = position.getZoom() != null ? (int)position.getZoom().getX() : 0;
            this.ptzInfo.setZoom(zoom * 1000);
            if (sendStatus) {
                this.videoSrv.sendStatusAbsolutePTZ(null, this.ptzInfo.getPan(), this.ptzInfo.getTilt(), this.ptzInfo.getZoom());
            }
        }
        catch (Exception ex) {
            this.logger.error("RefreshAbsolutePosition failed for " + this.device, (Throwable)ex);
        }
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int errorCode = 0;
        try {
            this.ptzService.sendContinuousPtzCommand(this.profileName, panSpeed, tiltSpeed, zoomSpeed, 10, 100L);
            this.videoSrv.notifyForCameraControl();
        }
        catch (SeeTecException exception) {
            this.logger.error((Object)exception);
            errorCode = exception.getErrorCode();
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
            errorCode = -21653;
        }
        return errorCode;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        int errorCode = 0;
        try {
            List ptzNodes = this.ptzService.getOnvifPtzService().getNodes();
            for (PTZNode ptzNode : ptzNodes) {
                PTZSpaces ptzSpaces = ptzNode.getSupportedPTZSpaces();
                List space2DDescriptions = ptzSpaces.getRelativePanTiltTranslationSpace();
                for (Space2DDescription space2DDescription : space2DDescriptions) {
                    if (!space2DDescription.getURI().contains("TranslationSpaceFov")) continue;
                    float x = this.calculateValueFromFovTranslationSpace(xPosition, space2DDescription.getXRange());
                    float y = this.calculateValueFromFovTranslationSpace(yPosition, space2DDescription.getYRange());
                    PTZVector ptzVector = new PTZVector();
                    Vector2D vector2D = new Vector2D();
                    vector2D.setX(x);
                    vector2D.setY(-y);
                    vector2D.setSpace(space2DDescription.getURI());
                    ptzVector.setPanTilt(vector2D);
                    this.ptzService.getOnvifPtzService().relativeMove(this.profileName, ptzVector, null);
                    this.videoSrv.notifyForCameraControl();
                    return errorCode;
                }
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
            errorCode = -21653;
        }
        return errorCode;
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        return 0;
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousIris(Integer value) {
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        ImagingSettings20 imagingSettings20 = new ImagingSettings20();
        Exposure20 exposure20 = new Exposure20();
        exposure20.setMode(ExposureMode.AUTO);
        imagingSettings20.setExposure(exposure20);
        this.imagingService.getOnvifImagingService().setImagingSettings(this.videoSourceToken, imagingSettings20, Boolean.valueOf(true));
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        float speed = 0.0f;
        if (value == 0) {
            this.imagingService.getOnvifImagingService().stop(this.videoSourceToken);
        } else {
            try {
                this.setAutoFocus(false);
            }
            catch (Exception ex) {
                this.logger.warn("Exception while disabling auto focus for " + this + ": " + ex.getMessage());
            }
            speed = value > 0 ? this.maxContinuousFocusSpeed : this.minContinuousFocusSpeed;
            FocusMove focusMove = new FocusMove();
            ContinuousFocus continuousFocus = new ContinuousFocus();
            continuousFocus.setSpeed(speed);
            focusMove.setContinuous(continuousFocus);
            this.imagingService.getOnvifImagingService().move(this.videoSourceToken, focusMove);
        }
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        ImagingSettings20 imagingSettings20 = new ImagingSettings20();
        FocusConfiguration20 focusConfiguration20 = new FocusConfiguration20();
        focusConfiguration20.setAutoFocusMode(active != false ? AutoFocusMode.AUTO : AutoFocusMode.MANUAL);
        imagingSettings20.setFocus(focusConfiguration20);
        try {
            this.imagingService.getOnvifImagingService().setImagingSettings(this.videoSourceToken, imagingSettings20, Boolean.valueOf(true));
        }
        catch (Exception ex) {
            this.logger.warn("Exception while changing Autofocus mode to " + active + " for " + this + " : " + ex.getMessage() + ". Will try setting with default speed...");
            try {
                ImagingSettings20 imagingSettingsOnDevice = this.imagingService.getOnvifImagingService().getImagingSettings(this.videoSourceToken);
                float defaultSpeed = imagingSettingsOnDevice.getFocus().getDefaultSpeed().floatValue();
                imagingSettings20 = new ImagingSettings20();
                focusConfiguration20 = new FocusConfiguration20();
                focusConfiguration20.setAutoFocusMode(active != false ? AutoFocusMode.AUTO : AutoFocusMode.MANUAL);
                focusConfiguration20.setDefaultSpeed(Float.valueOf(defaultSpeed));
                imagingSettings20.setFocus(focusConfiguration20);
                this.imagingService.getOnvifImagingService().setImagingSettings(this.videoSourceToken, imagingSettings20, Boolean.valueOf(true));
            }
            catch (Exception e) {
                this.logger.warn("Exception while changing Autofocus mode to " + active + " for " + this + " : " + ex.getMessage());
            }
        }
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        try {
            ImagingSettings20 imagingSettings20 = new ImagingSettings20();
            imagingSettings20.setIrCutFilter(active != false ? IrCutFilterMode.OFF : IrCutFilterMode.ON);
            this.imagingService.getOnvifImagingService().setImagingSettings(this.videoSourceToken, imagingSettings20, Boolean.valueOf(true));
        }
        catch (Throwable ex) {
            this.logger.warn("Exception while changing Day/Night mode: " + ex.getMessage() + " for " + this);
            return -20001;
        }
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        int errorCode = 0;
        if (active.booleanValue()) {
            try {
                ImagingSettings20 imagingSettings20 = new ImagingSettings20();
                imagingSettings20.setIrCutFilter(IrCutFilterMode.AUTO);
                this.imagingService.getOnvifImagingService().setImagingSettings(this.videoSourceToken, imagingSettings20, Boolean.valueOf(true));
            }
            catch (Throwable ex) {
                this.logger.warn("Exception while changing Day/Night mode: " + ex.getMessage() + " for " + this);
                errorCode = -20001;
            }
        }
        return errorCode;
    }

    @Override
    public int setHomePosition() {
        try {
            this.ptzService.getOnvifPtzService().gotoHomePosition(this.profileName, null);
            this.videoSrv.notifyForCameraControl();
            return 0;
        }
        catch (Exception exception) {
            this.logger.warn("Setting HomePosition failed", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        try {
            String encodedPresetName = this.getEncodedPresetNameEmptyNotAllowed(presetName);
            List presets = this.ptzService.getOnvifPtzService().getPresets(this.profileName);
            for (PTZPreset preset : presets) {
                if (preset.getName() != null && !preset.getName().equals(encodedPresetName) && !preset.getName().equals(presetName)) continue;
                this.ptzService.getOnvifPtzService().removePreset(this.profileName, preset.getToken());
            }
            Holder presetToken = new Holder();
            this.ptzService.getOnvifPtzService().setPreset(this.profileName, encodedPresetName, presetToken);
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, (String)presetToken.value, encodedPresetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Setting preset [" + presetName + "] failed", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            String encodedPresetName = this.getEncodedPresetNameEmptyNotAllowed(presetName);
            List presets = this.ptzService.getOnvifPtzService().getPresets(this.profileName);
            for (PTZPreset preset : presets) {
                if (preset.getName() == null || !preset.getName().equals(encodedPresetName) && !preset.getName().equals(presetName)) continue;
                this.ptzService.getOnvifPtzService().gotoPreset(this.profileName, preset.getToken(), null);
                this.videoSrv.notifyForCameraControl();
                break;
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.warn("Going to preset [" + presetName + "] failed", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = this.getEncodedPresetNameEmptyNotAllowed(presetName);
            List presets = this.ptzService.getOnvifPtzService().getPresets(this.profileName);
            for (PTZPreset preset : presets) {
                if (preset.getName() != null && !preset.getName().equals(encodedPresetName) && !preset.getName().equals(presetName)) continue;
                this.ptzService.getOnvifPtzService().removePreset(this.profileName, preset.getToken());
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Removing preset [" + presetName + "] failed", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public ArrayOfCameraPreset getPresetsFromCamera() {
        try {
            OnvifCore onvifCore = this.device.getOnvifCore();
            Profile profile = onvifCore.getMediaService().getOnvifMediaService().getProfile(this.profileName);
            String profileToken = profile.getToken();
            List presetListFromCamera = this.ptzService.getOnvifPtzService().getPresets(profileToken);
            ArrayOfCameraPreset cameraPresets = new ArrayOfCameraPreset();
            if (presetListFromCamera.size() > 0) {
                for (PTZPreset ptzPreset : presetListFromCamera) {
                    String presetName = ptzPreset.getName();
                    String presetPosition = ptzPreset.getToken();
                    CameraPreset cameraPreset = new CameraPreset();
                    cameraPreset.setName(presetName);
                    PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), presetPosition, presetName);
                    cameraPreset.setPtzData(new String(presetCnf.getPresetCnf(), "UTF-8"));
                    cameraPresets.getCameraPreset().add(cameraPreset);
                }
            }
            return cameraPresets;
        }
        catch (Exception ex) {
            this.logger.error(ex + " for " + this);
            return new ArrayOfCameraPreset();
        }
    }

    @Override
    public int addCameraPresets(ArrayOfCameraPreset presets) {
        int errorCode = 0;
        if (presets == null) {
            this.logger.warn("Received null camera presets object in addCameraPresets!");
            return -20002;
        }
        List<CameraPreset> cameraPresets = presets.getCameraPreset();
        for (CameraPreset cameraPreset : cameraPresets) {
            try {
                Element ptzPosition;
                byte[] cameraPresetPtzData = cameraPreset.getPtzData().getBytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(cameraPresetPtzData);
                Document ptzDocument = new SAXBuilder().build((InputStream)bais);
                String presetPosition = "1";
                Element root = ptzDocument.getRootElement();
                if (root != null && (ptzPosition = root.getChild("PresetPosition")) != null) {
                    presetPosition = ptzPosition.getText().trim();
                }
                PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), presetPosition, this.getEncodedPresetName(cameraPreset.getName()));
                this.presetList.addElement(presetCnf);
                this.logger.info("Adding preset configuration: " + presetCnf);
            }
            catch (UnsupportedEncodingException ex) {
                this.logger.error("Unsupported encoding used in the ONVIF CameraControl.addCameraPresets()!");
                errorCode = -20001;
            }
            catch (JDOMException ex) {
                this.logger.error("Exception while parsing XML data for " + this + " : " + ex.getMessage());
            }
        }
        return errorCode;
    }

    protected float calculateValueFromFovTranslationSpace(Integer position, FloatRange floatRange) {
        float returnValue = 0.0f;
        if (position != null && floatRange != null) {
            float max;
            float min = floatRange.getMin();
            if (min + Float.MAX_VALUE == 0.0f) {
                min = -1.0f;
            }
            if ((max = floatRange.getMax()) - Float.MAX_VALUE == 0.0f) {
                max = 1.0f;
            }
            float median = (min + max) / 2.0f;
            if (position < 50) {
                float distMinToMedian = median - min;
                float divisor = distMinToMedian / 50.0f;
                float inverted = 50.0f - (float)position.intValue();
                returnValue = median - inverted * divisor;
            } else {
                float distMaxToMedian = max - median;
                float divisor = distMaxToMedian / 50.0f;
                float inverted = 100.0f - (float)position.intValue();
                returnValue = max - inverted * divisor;
            }
        }
        return returnValue;
    }
}

