/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.generic;

import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministration;
import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministrationBase;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifException;
import de.seetec.v5.re.cm.device.shared.onvif.services.DeviceService;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifDevice;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.List;
import org.onvif.ver10.schema.User;

public class GenericOnvifCameraAdministration
extends CameraAdministrationBase
implements CameraAdministration {
    public GenericOnvifCameraAdministration(SeetecHttpClient httpClient) throws SeeTecException {
        super(httpClient);
    }

    protected OnvifDevice createOnvifDevice(boolean useAuthorization, NetworkParameter networkParameter) {
        String user = null;
        String password = null;
        if (networkParameter.getUserPWD() != null) {
            user = networkParameter.getUserPWD()[0];
            password = networkParameter.getUserPWD()[1];
        }
        String authenticationType = this.checkAuthenticationType(useAuthorization, networkParameter, user, password);
        OnvifDevice onvifDevice = new OnvifDevice("", networkParameter, user, password, authenticationType, useAuthorization);
        return onvifDevice;
    }

    public String checkAuthenticationType(boolean useAuthorization, NetworkParameter networkParameter, String user, String password) {
        String passwordType = "PasswordDigest";
        if (useAuthorization) {
            try {
                int authenticationCheckTimeout = 7000;
                passwordType = GenericOnvifDevice.checkAuthenticationType(networkParameter.getHost(), networkParameter.getHTTPport(), networkParameter.getSSLport(), user, password, authenticationCheckTimeout, networkParameter.useHTTPS());
            }
            catch (Exception exception) {
                passwordType = "PasswordDigest";
            }
        }
        return passwordType;
    }

    protected OnvifCore createOnvifCore(OnvifDevice onvifDevice) throws OnvifException {
        OnvifCore newOnvifCore = new OnvifCore();
        newOnvifCore.init(onvifDevice, false);
        return newOnvifCore;
    }

    @Override
    protected void modifyPasswordOnDevice(String passwordToSet, NetworkParameter networkParameter) throws SeeTecException {
        try {
            List userList;
            OnvifDevice onvifDevice = this.createOnvifDevice(true, networkParameter);
            OnvifCore onvifCore = this.createOnvifCore(onvifDevice);
            DeviceService deviceService = onvifCore.getDeviceService();
            String userName = networkParameter.getUserPWD()[0];
            try {
                userList = deviceService.getOnvifDeviceService().getUsers();
            }
            catch (Exception e) {
                userList = deviceService.getOnvifDeviceService().getUsers();
            }
            for (User user : userList) {
                if (!user.getUsername().equals(userName)) continue;
                user.setPassword(passwordToSet);
                ArrayList<User> listToSet = new ArrayList<User>();
                listToSet.add(user);
                deviceService.getOnvifDeviceService().setUser(listToSet);
            }
        }
        catch (OnvifException ex) {
            String errorMessage = "";
            if (ex.getMessage().contains("UsernameMissing")) {
                errorMessage = "Username not recognized";
            } else if (ex.getMessage().contains("PasswordTooLong")) {
                errorMessage = "The password is too long";
            } else if (ex.getMessage().contains("PasswordTooWeak")) {
                errorMessage = "The password is too weak";
            } else if (ex.getMessage().contains("AnonymousNotAllowed")) {
                errorMessage = "User level Anonymous is not allowed";
            } else if (ex.getMessage().contains("FixedUser")) {
                errorMessage = "Password or User level may not be changed";
            }
            throw new SeeTecException(-20002, errorMessage);
        }
        catch (Exception t) {
            String errorMessage = t.getMessage();
            throw new SeeTecException(-20002, errorMessage);
        }
    }

    @Override
    protected void upgradeFirmwareOnDevice(byte[] firmwareData, NetworkParameter networkParameter) throws SeeTecException {
    }
}

