/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.generic;

import de.seetec.v5.re.cm.device.shared.AudioOutServer;
import de.seetec.v5.re.cm.device.shared.net.rtp.RtpSenderPacket;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.onvif.ver10.schema.Profile;
import org.onvif.ver10.schema.StreamType;
import org.onvif.ver10.schema.TransportProtocol;

public class GenericOnvifAudioOutServer
extends AudioOutServer
implements Runnable,
RTSPHandlerIntf {
    private final NetworkParameter networkParameter;
    private final Logger logger;
    private volatile boolean isShutdown = false;
    private Thread thread;
    private int rtspPort;
    private RTSPHandlerSuper rtspHandler;
    private Integer ssrc;
    private Integer sequenceNumber;
    private Integer timeStamp;
    private OnvifCore onvifCore;
    private final int packetSize = 512;
    private final int intervalLength = 800;
    private TransmissionType transport = TransmissionType.RTP_OVER_RTSP_OVER_TCP;
    private volatile boolean errorHandlingRunning;

    public GenericOnvifAudioOutServer(OnvifCore onvifCore, NetworkParameter networkParameter, int rtspPort) {
        if (networkParameter == null) {
            throw new IllegalArgumentException("NetworkParameter is null for Onvif Audio-Out Server: " + this);
        }
        this.networkParameter = networkParameter;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.rtspPort = rtspPort;
        this.onvifCore = onvifCore;
    }

    public void init() {
        this.isShutdown = false;
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
        this.logger.info(this + " initialized");
    }

    @Override
    public void sendDescribeResponse(RTSPResponse response) {
    }

    private void sendAudio(byte[] audioData) throws Exception {
        int pointer = 0;
        int previousPointer = 0;
        do {
            RtpSenderPacket rtpSenderPacket;
            int errorCode;
            byte[] dataToSend;
            if ((pointer += 512) > audioData.length) {
                dataToSend = new byte[audioData.length - previousPointer];
                System.arraycopy(audioData, previousPointer, dataToSend, 0, dataToSend.length);
            } else {
                dataToSend = new byte[512];
                System.arraycopy(audioData, previousPointer, dataToSend, 0, 512);
                previousPointer = pointer;
            }
            if (dataToSend.length > 0 && (errorCode = this.rtspHandler.sendRTPPacket(rtpSenderPacket = new RtpSenderPacket(dataToSend, this.getSequenceNumber(), this.getTimeStamp(), this.getSSRC()))) != 0) {
                throw new SeeTecException(errorCode, "Onvif Camera not reachable for audio packet");
            }
        } while (pointer < audioData.length);
    }

    @Override
    public void run() {
        while (!this.isShutdown) {
            try {
                TransportProtocol transportProtocol = this.transport == TransmissionType.RTP_OVER_RTSP_OVER_TCP ? TransportProtocol.TCP : TransportProtocol.UDP;
                String profileToken = ((Profile)this.onvifCore.getMediaService().getOnvifMediaService().getProfiles().get(0)).getToken();
                String rtspUrl = "";
                try {
                    rtspUrl = this.onvifCore.getMediaService().getStreamUri(profileToken, StreamType.RTP_UNICAST, transportProtocol);
                }
                catch (Exception ex) {
                    if (this.transport == TransmissionType.RTP_OVER_RTSP_OVER_TCP) {
                        this.logger.info("Cannot get URI for Backchannel Audio. Will try UDP transport protocol for " + this);
                        this.transport = TransmissionType.RTP_OVER_UDP_UNICAST;
                        transportProtocol = TransportProtocol.UDP;
                        rtspUrl = this.onvifCore.getMediaService().getStreamUri(profileToken, StreamType.RTP_UNICAST, transportProtocol);
                    }
                    throw ex;
                }
                if (!rtspUrl.isEmpty()) {
                    RTSPStreamSettings rtspSettings = new RTSPStreamSettings();
                    int errorCode = rtspSettings.init(this, this, this.networkParameter, this.rtspPort, rtspUrl, false, this.transport, 5000, true, 3, rtspUrl);
                    if (errorCode != 0) {
                        this.logger.error("Initialization of RTSPSettings failed with errorCode: " + errorCode + " for " + this);
                    }
                    rtspSettings.setIsVideoEnabled(false);
                    rtspSettings.setEnableBackchannel(true);
                    rtspSettings.setBackChannelCallback(this);
                    rtspSettings.setShutdownOnKeepAliveError(true);
                    this.rtspHandler = rtspSettings.getRTSPHandler();
                    errorCode = this.rtspHandler.start();
                    if (errorCode != 0) {
                        if (errorCode == -21659 && this.transport == TransmissionType.RTP_OVER_RTSP_OVER_TCP) {
                            this.logger.info("RTSP Request for Backchannel not working. Will change to UDP transport protocol for " + this);
                            this.transport = TransmissionType.RTP_OVER_UDP_UNICAST;
                            Thread.sleep(5000L);
                            continue;
                        }
                        this.logger.error("Audio Out Stream could not be started yet. Waiting 15 seconds before restarting. Device address: " + this.networkParameter.getHost());
                        Thread.sleep(15000L);
                        continue;
                    }
                    while (!this.isShutdown) {
                        try {
                            MediaFrame mediaFrameToSend = this.take();
                            for (byte[] singlePayLoad : mediaFrameToSend.getPayload()) {
                                this.sendAudio(singlePayLoad);
                            }
                        }
                        catch (Exception exception) {
                            this.logger.info("Error while sending audio packet for " + this + " : " + exception.getMessage());
                            break;
                        }
                    }
                }
                this.logger.info("Shutting down " + this);
            }
            catch (Exception ex) {
                this.logger.warn("Exception while starting RTSP handling for " + this);
            }
        }
        this.logger.info("Shutting down " + this);
    }

    @Override
    public int shutdown() {
        this.isShutdown = true;
        this.thread.interrupt();
        if (this.rtspHandler != null) {
            this.rtspHandler.shutdown();
        }
        return super.shutdown();
    }

    @Override
    public void processData(byte[] data) {
    }

    @Override
    public void onNetworkError(int errorCode) {
        if (!this.errorHandlingRunning) {
            this.errorHandlingRunning = true;
            this.thread.interrupt();
            if (this.rtspHandler != null) {
                this.rtspHandler.shutdown();
            }
            this.errorHandlingRunning = false;
        }
    }

    @Override
    public void sendStatusService(int errorCode) {
    }

    private int getSSRC() {
        if (this.ssrc == null) {
            Random r = new Random();
            this.ssrc = r.nextInt(Integer.MAX_VALUE);
        }
        return this.ssrc;
    }

    private int getSequenceNumber() {
        if (this.sequenceNumber == null) {
            Random r = new Random();
            this.sequenceNumber = r.nextInt(Short.MAX_VALUE);
        } else {
            GenericOnvifAudioOutServer genericOnvifAudioOutServer = this;
            Integer n = genericOnvifAudioOutServer.sequenceNumber;
            Integer n2 = genericOnvifAudioOutServer.sequenceNumber = Integer.valueOf(genericOnvifAudioOutServer.sequenceNumber + 1);
        }
        return this.sequenceNumber;
    }

    private int getTimeStamp() {
        if (this.timeStamp == null) {
            Random r = new Random();
            this.timeStamp = r.nextInt(Short.MAX_VALUE);
        }
        GenericOnvifAudioOutServer genericOnvifAudioOutServer = this;
        genericOnvifAudioOutServer.timeStamp = genericOnvifAudioOutServer.timeStamp + 800;
        return this.timeStamp;
    }

    @Override
    public void setSSRCfromRTSP(String ssrc) {
    }
}

