/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.norbain;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.norbain.NorbainCameraSrv;
import de.seetec.v5.re.cm.device.video.norbain.NorbainDevice;
import de.seetec.v5.re.cm.device.video.norbain.NorbainModel;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public final class NorbainVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.norbain.NorbainVideoSourceClient";
    private static final int channel = 1;

    @Override
    public final int init() {
        try {
            this.printDebug = false;
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            NorbainDevice norbainDevice = (NorbainDevice)this.getVideoSrv().getDevice();
            NorbainCameraSrv norbainCameraSrv = (NorbainCameraSrv)this.getVideoSrv();
            NorbainModel cameraModel = norbainDevice.getNorbainModel();
            int streamnumber = -1;
            if (this.videoCodec == Codec.H264) {
                streamnumber = 1;
            } else if (this.videoCodec == Codec.MJPEG) {
                streamnumber = 2;
            }
            int bandwidthMax = -1;
            int bandwidthMin = 100;
            int qualityMax = -1;
            int qualityMin = -1;
            this.fps /= 1000L;
            this.fps = this.fps > 30L ? 30L : this.fps;
            this.fps = this.fps < 1L ? 1L : this.fps;
            this.quality /= 1000;
            if (cameraModel == NorbainModel.A) {
                bandwidthMax = 4000;
                qualityMax = 100;
                qualityMin = 1;
            } else if (cameraModel == NorbainModel.B) {
                bandwidthMax = 1000;
                if (this.width > 720) {
                    bandwidthMax = 6000;
                } else if (this.width == 720) {
                    bandwidthMax = 4000;
                } else if (this.width == 640) {
                    bandwidthMax = 3000;
                } else if (this.width < 640) {
                    bandwidthMax = 2000;
                }
                if (this.fps <= 5L) {
                    bandwidthMax = 1000;
                }
                if (this.videoCodec == Codec.H264) {
                    if (this.quality < 20) {
                        this.quality = 30;
                    } else if (this.quality < 40) {
                        this.quality = 32;
                    } else if (this.quality < 60) {
                        this.quality = 35;
                    } else if (this.quality < 80) {
                        this.quality = 40;
                    } else if (this.quality <= 100) {
                        this.quality = 45;
                    }
                } else if (this.videoCodec == Codec.MJPEG) {
                    qualityMax = 90;
                    qualityMin = 2;
                    this.quality = this.quality > qualityMax ? qualityMax : this.quality;
                    this.quality = this.quality < qualityMin ? qualityMin : this.quality;
                }
            } else if (cameraModel == NorbainModel.C) {
                bandwidthMax = 8000;
                qualityMax = 100;
                qualityMin = 1;
            }
            this.bandwidth /= 1024;
            this.bandwidth = this.bandwidth > bandwidthMax ? bandwidthMax : this.bandwidth;
            this.bandwidth = this.bandwidth < bandwidthMin ? bandwidthMin : this.bandwidth;
            int gov = Tools.convertIFrameDistMStoFrameCount(this.fps * 1000L, this.iFrameDistMS, 1, 60);
            String govStruct = "IP";
            if (cameraModel != NorbainModel.B) {
                this.quality = this.quality > qualityMax ? qualityMax : this.quality;
                this.quality = this.quality < qualityMin ? qualityMin : this.quality;
            }
            StringBuilder setVideoParameterCommand = new StringBuilder();
            setVideoParameterCommand.append("/video/video.php?");
            if (cameraModel == NorbainModel.B) {
                setVideoParameterCommand.append("strm=").append(streamnumber).append("&");
            }
            setVideoParameterCommand.append("app=set");
            if (cameraModel != NorbainModel.B) {
                setVideoParameterCommand.append("&ch=").append(1);
            }
            setVideoParameterCommand.append("&ch").append(1).append("_strm").append(streamnumber).append("_en=").append(1);
            setVideoParameterCommand.append("&ch").append(1).append("_strm").append(streamnumber).append("_codec=").append(this.videoCodec == Codec.H264 ? "H264MP" : "MJPEG");
            setVideoParameterCommand.append("&ch").append(1).append("_strm").append(streamnumber).append("_res=").append(cameraModel == NorbainModel.B ? this.width + "x" + this.height : norbainCameraSrv.getResolutionTag(this.width, this.height));
            setVideoParameterCommand.append("&ch").append(1).append("_strm").append(streamnumber).append("_fps=").append(this.fps);
            if (cameraModel != NorbainModel.B || this.isConstantBitrateUsed) {
                setVideoParameterCommand.append("&ch").append(1).append("_strm").append(streamnumber).append("_bitrate=").append(this.bandwidth);
            }
            setVideoParameterCommand.append("&ch").append(1).append("_strm").append(streamnumber).append("_ratecontrol=").append(this.isConstantBitrateUsed ? "cbr" : "vbr");
            setVideoParameterCommand.append("&ch").append(1).append("_strm").append(streamnumber).append("_gov=").append(gov);
            if (cameraModel == NorbainModel.B && this.videoCodec == Codec.H264) {
                setVideoParameterCommand.append("&ch").append(1).append("_strm").append(streamnumber).append("_gov_struct=").append("IP");
            }
            if (cameraModel != NorbainModel.A || this.isConstantBitrateUsed || cameraModel == NorbainModel.B && this.videoCodec == Codec.H264 && !this.isConstantBitrateUsed) {
                setVideoParameterCommand.append("&ch").append(1).append("_strm").append(streamnumber).append("_quality=").append(this.quality);
            }
            if (cameraModel == NorbainModel.B && this.videoCodec == Codec.MJPEG) {
                StringBuffer preSetVideoParameterCommand = new StringBuffer();
                preSetVideoParameterCommand.append("/video/video.php?");
                preSetVideoParameterCommand.append("strm=").append(1).append("&");
                preSetVideoParameterCommand.append("app=set");
                preSetVideoParameterCommand.append("&ch").append(1).append("_strm").append(1).append("_res=").append(this.width).append("x").append(this.height);
                preSetVideoParameterCommand.append("&ch").append(1).append("_strm").append(1).append("_fps=").append(30);
                this.logger.info(preSetVideoParameterCommand.toString());
                byte[] preSetVideoParameterCommandReply = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)preSetVideoParameterCommand.toString(), (int)Integer.MAX_VALUE, (boolean)true);
                this.logger.info(new String(preSetVideoParameterCommandReply));
            }
            if (cameraModel == NorbainModel.C) {
                String getVideoParameterCommand = "/video/video.php?app=get";
                byte[] getVideoParameterCommandReply = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/video/video.php?app=get", (int)Integer.MAX_VALUE, (boolean)true);
                String getVideoParameterCommandReplyAString = new String(getVideoParameterCommandReply);
                getVideoParameterCommandReplyAString = getVideoParameterCommandReplyAString.substring(getVideoParameterCommandReplyAString.indexOf("&ch1_strm" + (streamnumber + 1) + "_"), getVideoParameterCommandReplyAString.lastIndexOf("&"));
                setVideoParameterCommand.append(getVideoParameterCommandReplyAString);
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)setVideoParameterCommand.toString(), (int)Integer.MAX_VALUE, (boolean)true);
            if (cameraModel != NorbainModel.A) {
                StringBuilder setImageParameterCommand = new StringBuilder();
                setImageParameterCommand.append("/video/image.php?app=set");
                if (cameraModel != NorbainModel.B) {
                    setImageParameterCommand.append("&ch=").append(1);
                }
                int rotation = norbainCameraSrv.getVideoSourceCnf().getImageRotation() / 1000;
                setImageParameterCommand.append("&flip=").append(rotation == 180 ? 1 : 0);
                setImageParameterCommand.append("&mirror=").append(rotation == 180 ? 1 : 0);
                this.logger.info(setImageParameterCommand.toString());
                byte[] imageParameterCommandReply = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)setImageParameterCommand.toString(), (int)Integer.MAX_VALUE, (boolean)true);
                this.logger.info(new String(imageParameterCommandReply));
            }
            StringBuilder setAudioParameterCommand = new StringBuilder();
            setAudioParameterCommand.append("/audio/audio.php?app=set");
            if (cameraModel != NorbainModel.B) {
                setAudioParameterCommand.append("&ch=").append(1);
            }
            if (this.isAudioEnabled) {
                this.logger.info("Audio enabled for " + this.getVideoSrv());
                setAudioParameterCommand.append("&snd1_enable=").append(1);
                setAudioParameterCommand.append("&snd1_codec=").append("G711U");
            } else {
                setAudioParameterCommand.append("&snd1_enable=").append(0);
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)setAudioParameterCommand.toString(), (int)Integer.MAX_VALUE, (boolean)true);
            if (cameraModel == NorbainModel.B) {
                Thread.sleep(9999L);
                --streamnumber;
            }
            this.rtspUrl = "rtsp://" + this.getHost() + "/" + 1 + "/stream" + streamnumber;
            this.networkParameter.setSoTimeout(5000);
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing RTSP settings for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP Handling for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.logger.info("init done for" + this.getVideoSrv());
            return 0;
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Exception while initialization for " + this, (Throwable)seeTecException);
            return seeTecException.getErrorCode();
        }
        catch (Throwable throwable) {
            this.logger.error("Unexpected exception while initialization for " + this);
            this.logger.error((Object)throwable, throwable);
            return -20000;
        }
    }

    @Override
    public final synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public final void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public final void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down" + this.getVideoSrv());
        this.shutdown();
    }

    @Override
    public final void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public final void processData(byte[] data) {
        this.processRtpData(data);
    }
}

