/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.norbain;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.video.norbain.NorbainCameraSrv;
import de.seetec.v5.re.cm.device.video.norbain.NorbainDevice;
import de.seetec.v5.re.cm.device.video.norbain.NorbainModel;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;

public class NorbainMotionDetectionHandler
extends MotionDetectionHandler
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.norbain.NorbainMotionDetectionHandler";
    private NetworkParameter networkParameter = null;
    private NorbainDevice norbainDevice = null;
    private long lastVideoLossEventSent = 0L;
    private HttpServerPushHandler httpServerPushHandler = null;

    public NorbainMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public final int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        int errorCode = 0;
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        try {
            NorbainCameraSrv norbainCameraSrv = (NorbainCameraSrv)this.listener.getVideoSrv();
            this.networkParameter = norbainCameraSrv.getDevice().getDeviceCnf().getNetworkParameter();
            if (!norbainCameraSrv.onlyVideoLossEnabled()) {
                String motionEnableUrl = "/event/motion.php?app=set&motion1_enable=1";
                byte[] motionResult = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/event/motion.php?app=set&motion1_enable=1", (int)Integer.MAX_VALUE);
                this.logger.info((Object)motionResult);
            } else if (norbainCameraSrv.getDevice().getDeviceType() == 204903L && norbainCameraSrv.getVideoSourceCnf().isEnableVideoloss()) {
                String lossEnableUrl = "/event/loss.php?app=set&vloss1_enable=1";
                byte[] lossResult = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/event/loss.php?app=set&vloss1_enable=1", (int)Integer.MAX_VALUE);
                this.logger.info((Object)lossResult);
            }
            super.setRunFinished(CLASS_NAME, false);
            try {
                this.norbainDevice = (NorbainDevice)norbainCameraSrv.getDevice();
                String streamId = "1";
                if (this.norbainDevice.getNorbainModel() == NorbainModel.B) {
                    streamId = "0";
                }
                String url = "/stream/event_stream.php?ch=1&strm=" + streamId;
                if (!norbainCameraSrv.onlyVideoLossEnabled()) {
                    url = url + "&motion=1";
                }
                if (norbainCameraSrv.getDevice().getDeviceType() == 204903L && norbainCameraSrv.getVideoSourceCnf().isEnableVideoloss()) {
                    url = url + "&vloss=1";
                }
                boolean bAsynchronous = true;
                this.httpServerPushHandler = new HttpServerPushHandler();
                errorCode = this.httpServerPushHandler.init(this, this.networkParameter, url);
                if (errorCode != 0) {
                    this.logger.error("Error [" + errorCode + "]with " + this.httpServerPushHandler);
                } else {
                    errorCode = this.httpServerPushHandler.startServerPush(bAsynchronous);
                    if (errorCode != 0) {
                        this.logger.warn("ServerPush of " + this.httpServerPushHandler + " terminated with error [" + errorCode + "]");
                    }
                }
            }
            catch (Throwable throwable) {
                this.logger.error("Trouble with MDHandler of " + this.listener.getVideoSrv());
                this.logger.error((Object)throwable, throwable);
                errorCode = -21651;
            }
        }
        catch (Exception exception) {
            this.logger.warn("MD could not be initialized");
            this.logger.warn((Object)exception);
        }
        return errorCode;
    }

    @Override
    public final void notifyForNetworkProblems() {
        this.logger.info("Network problem signaled for " + this.listener.getVideoSrv());
    }

    @Override
    public final void deliverContent(HttpServerPushContent httpServerPushContent) {
        byte[] content = httpServerPushContent.getContentBody();
        String body = new String(content);
        if (body.contains("motion=1")) {
            String streamId = "1";
            if (this.norbainDevice.getNorbainModel() == NorbainModel.B) {
                streamId = "0";
            }
            String regex = "ch1_strm" + streamId + "_rgn([\\p{Digit}]+)=1";
            String result = "";
            Matcher matcher = Pattern.compile(regex).matcher(body);
            while (matcher.find()) {
                result = matcher.group(1);
                this.listener.evaluateWindow(Integer.parseInt(result) - 1);
            }
        }
        if (body.contains("vloss=1") && System.currentTimeMillis() > this.lastVideoLossEventSent + 5000L) {
            this.lastVideoLossEventSent = System.currentTimeMillis();
            this.listener.getVideoSrv().getCore().sendVideoLossEvent(this.listener.getVideoSrv());
        }
    }

    @Override
    public final void sendStatusService(int nStatusCode) {
        if (nStatusCode != 0) {
            this.listener.notifyForNetworkProblems();
        }
    }

    @Override
    public final boolean isShutdown() {
        return false;
    }

    @Override
    public final int shutdown() {
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
        }
        return super.shutdown();
    }
}

