/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.norbain;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URLEncoder;
import java.util.Vector;

public final class NorbainCameraControl
extends CameraControl {
    private boolean firstHttpCommandSent = false;
    private Socket socket = null;
    private OutputStream os = null;
    private String url = "";

    private int sendCameraCommand(String url) {
        try {
            this.videoSrv.notifyForCameraControl();
            if (!this.url.equals(url)) {
                this.logger.info(url);
                this.readGetRequest(this.networkParameter, url);
                this.url = url;
                return 0;
            }
            return 0;
        }
        catch (SeeTecException seeTecException) {
            this.logger.error((Object)seeTecException, (Throwable)seeTecException);
            return seeTecException.getErrorCode();
        }
    }

    @Override
    public final int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED!");
    }

    @Override
    public final int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        this.logger.info("pan: " + panSpeed + " tilt: " + tiltSpeed + " zoom: " + zoomSpeed);
        if (zoomSpeed != null) {
            this.executeZoomCommand(zoomSpeed);
        } else if (panSpeed != null || tiltSpeed != null) {
            this.executePanTiltCommand(panSpeed, tiltSpeed);
        }
        return 0;
    }

    private void executeZoomCommand(Integer zoomSpeed) {
        int zoom = 0;
        String zoomCommand = "";
        zoom = zoomSpeed == null ? this.previousZoomSpeed : (zoomSpeed > 0 ? 1 : (zoomSpeed < 0 ? -1 : 0));
        zoomCommand = zoomSpeed > 0 ? "tele" : (zoomSpeed < 0 ? "wide" : "stop");
        if (zoom != this.previousZoomSpeed) {
            String command = "/ptz/control.php?ch=1&zoom=" + zoomCommand;
            this.sendCameraCommand(command);
            this.previousZoomSpeed = zoom;
        }
    }

    private void executePanTiltCommand(Integer panSpeed, Integer tiltSpeed) {
        int pan = 0;
        int tilt = 0;
        pan = panSpeed == null ? this.previousPanSpeed : this.translateValue(panSpeed);
        tilt = tiltSpeed == null ? this.previousTiltSpeed : this.translateValue(tiltSpeed);
        String moveCommand = "";
        if (pan == 0 && tilt > 0) {
            moveCommand = "up";
        } else if (pan == 0 && tilt < 0) {
            moveCommand = "down";
        } else if (pan < 0 && tilt == 0) {
            moveCommand = "left";
        } else if (pan > 0 && tilt == 0) {
            moveCommand = "right";
        } else if (pan < 0 && tilt > 0) {
            moveCommand = "upleft";
        } else if (pan > 0 && tilt > 0) {
            moveCommand = "upright";
        } else if (pan < 0 && tilt < 0) {
            moveCommand = "downleft";
        } else if (pan > 0 && tilt < 0) {
            moveCommand = "downright";
        } else if (pan == 0 && tilt == 0) {
            moveCommand = "stop";
        }
        int originalPan = pan;
        int originalTilt = tilt;
        pan = Math.abs(pan);
        tilt = Math.abs(tilt);
        if (moveCommand.equals("stop")) {
            String command = "/ptz/control.php?ch=1&move=" + moveCommand;
            this.sendCameraCommand(command);
            this.previousPanSpeed = originalPan;
            this.previousTiltSpeed = originalTilt;
        } else if (pan != this.previousPanSpeed || tilt != this.previousTiltSpeed) {
            pan = pan == 0 ? 1 : pan;
            tilt = tilt == 0 ? 1 : tilt;
            String command = "/ptz/control.php?ch=1&move=" + moveCommand;
            command = command + "&pspd=" + pan + "&tspd=" + tilt;
            this.sendCameraCommand(command);
            this.previousPanSpeed = originalPan;
            this.previousTiltSpeed = originalTilt;
        }
    }

    private int translateValue(int givenValue) {
        if (givenValue != 0) {
            int translatedValue = 0;
            boolean isNegative = false;
            if (givenValue < 0) {
                isNegative = true;
                givenValue *= -1;
            }
            if (givenValue == 0) {
                translatedValue = 0;
            } else if (givenValue < 10000) {
                translatedValue = 1;
            } else if (givenValue < 20000) {
                translatedValue = 2;
            } else if (givenValue < 30000) {
                translatedValue = 3;
            } else if (givenValue < 40000) {
                translatedValue = 4;
            } else if (givenValue < 60000) {
                translatedValue = 5;
            } else if (givenValue < 80000) {
                translatedValue = 6;
            } else if (givenValue < 100000) {
                translatedValue = 7;
            } else if (givenValue == 100000) {
                translatedValue = 8;
            }
            if (isNegative) {
                translatedValue *= -1;
            }
            return translatedValue;
        }
        return 0;
    }

    @Override
    public final int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED!");
    }

    @Override
    public final int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED!");
    }

    @Override
    public final int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED!");
    }

    @Override
    public final int setContinuousIris(Integer value) {
        if (value != null) {
            StringBuilder url = new StringBuilder("/ptz/control.php?iris=");
            if (value > 0) {
                this.sendCameraCommand(url.toString() + "open");
            } else if (value < 0) {
                this.sendCameraCommand(url.toString() + "close");
            } else {
                this.sendCameraCommand(url.toString() + "stop");
            }
        }
        return 0;
    }

    @Override
    public final int setAutoIris(Boolean active) {
        return 0;
    }

    @Override
    public final int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED!");
    }

    @Override
    public final int setContinuousFocus(Integer value) {
        if (value != null) {
            StringBuilder url = new StringBuilder("/ptz/control.php?focus=");
            if (value > 0) {
                this.sendCameraCommand(url.toString() + "far");
            } else if (value < 0) {
                this.sendCameraCommand(url.toString() + "near");
            } else {
                this.sendCameraCommand(url.toString() + "stop");
            }
        }
        return 0;
    }

    @Override
    public final int setAutoFocus(Boolean active) {
        return 0;
    }

    @Override
    public final int setZeroLux(Boolean active) {
        return 0;
    }

    @Override
    public final int setAutoZeroLux(Boolean active) {
        return 0;
    }

    @Override
    public final int setHomePosition() {
        return 0;
    }

    @Override
    public final int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        int presetPosition = -1;
        try {
            int i;
            byte[] vector = new byte[8];
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                vector[Integer.parseInt((String)presetCnf.getPresetPosition())] = 1;
            }
            for (i = 1; i <= vector.length; ++i) {
                if (vector[i] != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this + " :-(");
                return -21600;
            }
            presetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            this.sendCameraCommand("/ptz/control.php?presetsave=" + presetPosition);
            return 0;
        }
        catch (Throwable throwable) {
            this.logger.error((Object)throwable, throwable);
            this.logger.error("Adding preset [" + presetName + "] failed :-(");
            return -21600;
        }
    }

    @Override
    public final int setPresetPosition(String presetName) {
        try {
            presetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                this.sendCameraCommand("/ptz/control.php?preset=" + presetCnf.getPresetPosition());
                return 0;
            }
        }
        catch (Exception exception) {
            this.logger.error("Setting preset [" + presetName + "] failed", (Throwable)exception);
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available :-(");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public final int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.presetList.removeElementAt(i);
                return 0;
            }
        }
        catch (Exception exception) {
            this.logger.error("Removing preset [" + presetName + "] failed", (Throwable)exception);
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available :-(");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    public final byte[] readGetRequest(NetworkParameter networkParameter, String url) throws SeeTecException {
        int errorCode = 0;
        String errorMessage = null;
        byte[] result = null;
        try {
            String host = networkParameter.getHost();
            String authorization = null;
            authorization = networkParameter.getRealm() != null && networkParameter.getNonce() != null ? NetworkHelper.createDigestAuthorization((NetworkParameter)networkParameter, (String)networkParameter.getRealm(), (String)networkParameter.getNonce(), (String)"GET", (String)url, (String)networkParameter.getQop()) : NetworkHelper.createBasicAuthorization((String[])networkParameter.getUserPWD());
            String additionalData = networkParameter.getAdditionalData() != null ? networkParameter.getAdditionalData() : "";
            String request = "GET " + url + " HTTP/1.1\r\n" + additionalData + authorization + "User-Agent: Java/1.4.2\r\nHost: " + host + "\r\nAccept: text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2\r\nConnection: keep-alive\r\n\r\n";
            if (!this.firstHttpCommandSent) {
                this.socket = networkParameter.useHTTPS() ? NetworkHelper.createNetworkConnection((String)host, (int)networkParameter.getSSLport(), (boolean)true) : NetworkHelper.createNetworkConnection((String)host, (int)networkParameter.getHTTPport(), (boolean)false);
                this.socket.setSoTimeout(networkParameter.getSoTimeout());
                this.os = this.socket.getOutputStream();
                this.firstHttpCommandSent = true;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (NorbainCameraControl.this.firstHttpCommandSent) {
                            try {
                                Thread.sleep(15000L);
                                NorbainCameraControl.this.readGetRequest(NorbainCameraControl.this.networkParameter, "/stream/event_stream.php?keepalive=" + System.currentTimeMillis());
                            }
                            catch (Exception exception) {}
                        }
                    }
                }, this.toString()).start();
            }
            this.os.write(request.getBytes());
            this.os.flush();
        }
        catch (SeeTecException ex) {
            errorCode = ex.getErrorCode();
            errorMessage = ex.getMessage();
            this.firstHttpCommandSent = false;
            try {
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable ex) {
            errorCode = -20001;
            errorMessage = ex.getMessage() + ", " + networkParameter;
            this.firstHttpCommandSent = false;
            try {
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (errorCode != 0) {
            throw new SeeTecException(errorCode, errorMessage);
        }
        return result;
    }
}

