/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.mobotix;

import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.TimeHelper;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MobotixVideoSourceClient
extends JPEGVideoSourceClient {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.mobotix.MobotixVideoSourceClient";
    private final byte[] Boundary = "boundary=".getBytes();
    private long actualMilliFramerate = -1L;
    private int actualMilliCompression = -1;
    private int[] actualImageSize = new int[]{-1, -1};
    private boolean mobotixBoundaryHack = false;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        int errorCode = super.init(false);
        if (errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("ImageSize=[" + this.width + "x" + this.height + "], Resolution=[" + this.resolutionTag + "]");
        }
        if ((errorCode = this.setImageParameter(this.highestFramerate, this.quality, this.resolution)) != 0) {
            this.logger.warn("Setting stream parameter failed with error [" + errorCode + "] :-(");
            return errorCode;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("StreamingMode for " + this + " is [" + this.videoCodec + "]");
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return errorCode;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Grabbing images ...");
        }
        try {
            String sSeeTecID = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
            String sStream = this.videoCodec == Codec.MXPEG ? "MxPEG" : "full";
            long nFPS = (this.highestFramerate + 999L) / 1000L;
            long nSrvType = super.getVideoSrv().getEntityType();
            if (nSrvType == 210200L || nSrvType == 210201L || nSrvType == 210202L) {
                this.handleServerPush("/cgi-bin/faststream.jpg?stream=" + sStream + "&fps=" + nFPS + "&error=empty&sid=" + sSeeTecID);
            } else {
                this.handleServerPush("/control/faststream.jpg?stream=" + sStream + "&fps=" + nFPS + "&error=empty&jpheaderupdate=1&sid=" + sSeeTecID);
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    protected int handleServerPush(String sURL) {
        int errorCode;
        block41: {
            errorCode = 0;
            int len = -1;
            int nIndex = -1;
            byte[] inBuffer = new byte[1024];
            byte[] array = null;
            byte[] extBoundary = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
            InputStream is = null;
            byte[] singleLineDelimitter = this.getServerPushLineDelimitter(1);
            byte[] doubleLineDelimitter = this.getServerPushLineDelimitter(2);
            try {
                if (this.serverPushSocket != null) {
                    this.logger.error("Internal Error: [serverPushSocket] is not null!");
                    throw new RuntimeException("Internal Error :-(");
                }
                this.serverPushSocket = this.establishStream(sURL);
                if (this.serverPushSocket == null) {
                    this.logger.error("Cannot establish stream to [" + this.host + ":" + this.port + "] with url [" + sURL + "] :-(");
                    return -21656;
                }
                is = this.serverPushSocket.getInputStream();
                this.logger.info(this + " uses [" + sURL + "] to " + this.serverPushSocket);
                baos.reset();
                while (!this.isShutdown()) {
                    try {
                        len = is.read(inBuffer, 0, inBuffer.length);
                        if (len < 0) {
                            String sMSG = new String(array);
                            this.logger.error("Invalid server push for " + this + ":\n\r" + sMSG);
                            if (!sMSG.toLowerCase().contains("unauthorized")) {
                                errorCode = -21650;
                                break;
                            }
                            errorCode = -21657;
                        }
                    }
                    catch (NullPointerException npe) {}
                    break;
                    baos.write(inBuffer, 0, len);
                    array = baos.toByteArray();
                    if (array.length < 512) {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException npe) {}
                        continue;
                    }
                    byte[] newMobotixBoundary = new byte[]{13, 10, 13, 10, 45, 45, 77, 79, 66, 79, 84, 73};
                    if (Basic.indexOfByteArray((byte[])array, (byte[])newMobotixBoundary, (int)0) > 0) {
                        this.mobotixBoundaryHack = true;
                        singleLineDelimitter = this.getServerPushLineDelimitter(1);
                        doubleLineDelimitter = this.getServerPushLineDelimitter(2);
                    }
                    if (array.length > 0x100000) {
                        this.logger.error("No boundary found within [" + Basic.longToFormattedString((long)array.length) + " B] :-(");
                        errorCode = -21650;
                        break;
                    }
                    nIndex = Basic.indexOfByteArray((byte[])array, (byte[])doubleLineDelimitter, (int)0);
                    if (nIndex <= 0) continue;
                    try {
                        byte[] streamHeader = new byte[nIndex - 4];
                        System.arraycopy(array, 0, streamHeader, 0, nIndex - 4);
                        int nPos1 = Basic.indexOfByteArray((byte[])array, (byte[])this.Boundary, (int)0);
                        int nPos2 = Basic.indexOfByteArray((byte[])array, (byte[])singleLineDelimitter, (int)nPos1);
                        byte[] prefix = null;
                        byte[] simpleBoundary = null;
                        byte[] postfix = null;
                        if (array[nPos1] == 34 && array[nPos2 - 3] == 34) {
                            simpleBoundary = new byte[nPos2 - nPos1 - singleLineDelimitter.length - 2];
                            System.arraycopy(array, nPos1 + 1, simpleBoundary, 0, simpleBoundary.length);
                        } else if (array[nPos1] == 34 && array[nPos2 - 2] == 34) {
                            simpleBoundary = new byte[nPos2 - nPos1 - singleLineDelimitter.length - 2];
                            System.arraycopy(array, nPos1 + 1, simpleBoundary, 0, simpleBoundary.length);
                        } else {
                            simpleBoundary = new byte[nPos2 - nPos1 - singleLineDelimitter.length];
                            System.arraycopy(array, nPos1, simpleBoundary, 0, simpleBoundary.length);
                        }
                        if (simpleBoundary[0] == 45 && simpleBoundary[1] == 45) {
                            prefix = new byte[singleLineDelimitter.length];
                            System.arraycopy(singleLineDelimitter, 0, prefix, 0, singleLineDelimitter.length);
                        } else {
                            prefix = new byte[singleLineDelimitter.length + 2];
                            System.arraycopy(singleLineDelimitter, 0, prefix, 0, singleLineDelimitter.length);
                            prefix[singleLineDelimitter.length + 1] = 45;
                            prefix[singleLineDelimitter.length] = 45;
                        }
                        postfix = new byte[singleLineDelimitter.length];
                        System.arraycopy(singleLineDelimitter, 0, postfix, 0, singleLineDelimitter.length);
                        extBoundary = new byte[prefix.length + simpleBoundary.length + postfix.length];
                        System.arraycopy(prefix, 0, extBoundary, 0, prefix.length);
                        System.arraycopy(simpleBoundary, 0, extBoundary, prefix.length, simpleBoundary.length);
                        System.arraycopy(postfix, 0, extBoundary, prefix.length + simpleBoundary.length, postfix.length);
                        nIndex = Basic.indexOfByteArray((byte[])array, (byte[])extBoundary, (int)0);
                        if (nIndex >= 0) {
                            baos.reset();
                            baos.write(array, nIndex, array.length - nIndex);
                            break;
                        }
                        this.logger.error("No boundary found for URL [" + this.host + ":" + this.port + sURL + "] :-(");
                        if (extBoundary.length > 256) {
                            String sHeader = new String(extBoundary, 0, 256);
                            this.logger.error("   extBoundary=[" + sHeader + " ...] :-(");
                            StringBuilder sbHeader = new StringBuilder("      ");
                            for (int k = 0; k < 256; ++k) {
                                sbHeader.append(extBoundary[k]);
                            }
                            this.logger.error(sbHeader.toString());
                        } else {
                            this.logger.error("   extBoundary=[" + new String(extBoundary) + "] :-(");
                            StringBuilder sbHeader = new StringBuilder("      ");
                            for (int k = 0; k < extBoundary.length; ++k) {
                                sbHeader.append(Integer.toHexString(extBoundary[k]) + "-");
                            }
                            this.logger.error(sbHeader.toString());
                        }
                        this.logger.error("this.bMobotixBoundaryHack=" + this.mobotixBoundaryHack);
                        this.logger.error("singleLineDelimitter.length=" + singleLineDelimitter.length);
                        this.logger.error("prefix.length=" + prefix.length);
                        this.logger.error("postfix.length=" + postfix.length);
                        this.logger.error("simpleBoundary.length=" + simpleBoundary.length);
                        this.logger.error("simpleBoundary=" + new String(simpleBoundary));
                        this.logger.error("extBoundary.length=" + extBoundary.length);
                        StringBuilder sb = new StringBuilder("      ");
                        if (array.length > 256) {
                            for (int i = 0; i < 256; ++i) {
                                sb.append(Integer.toHexString(array[i]) + "-");
                            }
                        } else {
                            for (int i = 0; i < array.length; ++i) {
                                sb.append(Integer.toHexString(array[i]) + "-");
                            }
                        }
                        this.logger.error(sb.toString());
                        if (array.length > 256) {
                            this.logger.error("   array=[" + new String(array, 0, 256) + " ...] :-(");
                        } else {
                            this.logger.error("   array=[" + new String(array) + "] :-(");
                        }
                        errorCode = -21650;
                        break;
                    }
                    catch (Exception ex) {
                        String sWebServerRSP = array.length > 256 ? new String(array, 0, 256) : new String(array);
                        if (!sWebServerRSP.toLowerCase().contains("unauthorized")) {
                            if (sWebServerRSP.toLowerCase().indexOf("content-length: 9333") > 0) {
                                this.logger.warn("Mobotix indicates [No frame available] :-(");
                                errorCode = -21661;
                                break;
                            }
                            errorCode = -21650;
                            this.logger.warn((Object)ex, (Throwable)ex);
                            this.logger.warn("Reading [" + this.serverPushSocket + sURL + "] failed!\n\r\n\r" + sWebServerRSP + "\n");
                            break;
                        }
                        errorCode = -21657;
                        break;
                    }
                }
                if (errorCode == 0) {
                    array = baos.toByteArray();
                    int n = len = array.length < 256 ? array.length : 256;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.info("Reading content stream ...");
                    }
                    this.readContentStream(is, baos, extBoundary);
                } else {
                    this.listener.sendStatusService(errorCode);
                }
            }
            catch (Throwable ex) {
                this.logger.warn("Network problems for " + this + ":", ex);
                if (super.isShutdown() || this.listener == null) break block41;
                this.listener.sendStatusService(-21603);
            }
        }
        try {
            if (this.serverPushSocket != null) {
                this.serverPushSocket.close();
                this.serverPushSocket = null;
            }
        }
        catch (IOException ioex) {
            this.logger.warn((Object)ioex, (Throwable)ioex);
        }
        return errorCode;
    }

    protected int readContentStream(InputStream is, ByteArrayOutputStream baos, byte[] extBoundary) throws IOException {
        int len = 0;
        int nLastSearchPostition = 0;
        boolean bTrim = false;
        byte[] inBuffer = new byte[4096];
        byte[] array = null;
        byte[] contentHeader = null;
        byte[] contentBody = null;
        byte[] doubleLineDelimitter = this.getServerPushLineDelimitter(2);
        long tsLastContentRead = System.currentTimeMillis();
        while (!this.isShutdown() && !this.core.isShutdown()) {
            try {
                len = is.read(inBuffer, 0, inBuffer.length);
                if (len < 0) {
                    this.logger.error("Stream closed for " + this);
                    return -21651;
                }
            }
            catch (NullPointerException npe) {
                this.shutdown();
                return 0;
            }
            baos.write(inBuffer, 0, len);
            array = baos.toByteArray();
            int nStartOfHeader = 0;
            int nEndOfHeader = -1;
            int nEndOfBody = -1;
            while ((nEndOfBody = Basic.indexOfByteArray((byte[])array, (byte[])extBoundary, (int)nLastSearchPostition)) > 0) {
                nEndOfHeader = Basic.indexOfByteArray((byte[])array, (byte[])doubleLineDelimitter, (int)nStartOfHeader);
                if (nEndOfHeader > 0) {
                    contentHeader = new byte[nEndOfHeader - nStartOfHeader - doubleLineDelimitter.length];
                    System.arraycopy(array, nStartOfHeader, contentHeader, 0, contentHeader.length);
                }
                contentBody = new byte[nEndOfBody - nEndOfHeader - extBoundary.length];
                System.arraycopy(array, nEndOfHeader, contentBody, 0, contentBody.length);
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("... " + this + " delivers content of [" + Basic.longToFormattedString((long)contentBody.length) + " b] to listener [" + this.listener + "] ...");
                }
                if (this.videoCodec == Codec.MJPEG) {
                    super.deliverContent(contentBody);
                } else if (this.videoCodec == Codec.MXPEG) {
                    try {
                        int[] resolution = StreamingHelper.extractMXPEGResolution(contentBody);
                        if (resolution[0] != 0) {
                            this.width = resolution[0];
                            this.height = resolution[1];
                        }
                        MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MXPEG, this.width, this.height, contentBody);
                        this.deliverFrameCreateServerTimestamp(0, mediaFrame);
                    }
                    catch (SeeTecException ex) {
                        this.logger.error("Exception while creating video frame header for " + this + " : " + ex.getMessage());
                    }
                }
                nLastSearchPostition = nStartOfHeader = nEndOfBody;
                bTrim = true;
                if (tsLastContentRead + 60000L < System.currentTimeMillis()) {
                    this.logger.warn("Content read within [" + TimeHelper.getReadableTimerange((long)(System.currentTimeMillis() - tsLastContentRead)) + "] via " + this);
                }
                tsLastContentRead = System.currentTimeMillis();
            }
            if (bTrim) {
                baos.reset();
                baos.write(array, nLastSearchPostition, array.length - nLastSearchPostition);
                nLastSearchPostition = 0;
                bTrim = false;
                continue;
            }
            nLastSearchPostition = array.length - extBoundary.length;
            if (nLastSearchPostition >= 0) continue;
            nLastSearchPostition = 0;
        }
        return 0;
    }

    public int setImageParameter(Long nWantedMilliFramerate, Integer nWantedMilliCompression, int[] nWantedImageSize) {
        boolean bChanged = false;
        int errorCode = 0;
        StringBuilder sbURL = new StringBuilder("/control/control?set&section=imagecontrol");
        if (nWantedMilliFramerate != null && nWantedMilliFramerate != this.actualMilliFramerate) {
            long[] validValues = new long[]{500L, 1000L, 2000L, 3000L, 4000L, 6000L, 8000L, 10000L, 12000L, 14000L, 16000L, 20000L, 25000L};
            for (int i = 0; i < validValues.length; ++i) {
                if (nWantedMilliFramerate > validValues[i] && i + 1 < validValues.length) continue;
                sbURL.append("&framerate100=").append(validValues[i] / 10L);
                break;
            }
            bChanged = true;
            this.actualMilliFramerate = nWantedMilliFramerate;
        }
        if (nWantedMilliCompression != null && nWantedMilliCompression != this.actualMilliCompression) {
            sbURL.append("&quality=").append(nWantedMilliCompression / 1000);
            bChanged = true;
            this.actualMilliCompression = nWantedMilliCompression;
        }
        if (nWantedImageSize != null && nWantedImageSize[0] > 0 && nWantedImageSize[1] > 0 && (nWantedImageSize[0] != this.actualImageSize[0] || nWantedImageSize[1] != this.actualImageSize[1])) {
            sbURL.append("&size=").append(nWantedImageSize[0]).append("x").append(nWantedImageSize[1]);
            bChanged = true;
            this.actualImageSize = nWantedImageSize;
        }
        if (bChanged) {
            String sURL = sbURL.toString();
            try {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sURL);
                this.logger.info("New image parameter [" + sURL + "] set for " + this);
            }
            catch (SeeTecException ex) {
                this.logger.warn((Object)ex, (Throwable)ex);
                this.logger.warn("Couldn't set new image parameter [" + sURL + "] for " + this + " :-(");
                errorCode = ex.getErrorCode();
            }
        } else {
            this.logger.info("No change of image parameter for " + this);
        }
        return errorCode;
    }

    protected byte[] getServerPushLineDelimitter(int nLineCount) {
        if (this.mobotixBoundaryHack) {
            if (nLineCount == 1) {
                return new byte[]{13, 10};
            }
            if (nLineCount == 2) {
                return new byte[]{13, 10, 13, 10};
            }
        }
        byte[] array = new byte[nLineCount];
        for (int i = 0; i < nLineCount; ++i) {
            array[i] = 10;
        }
        return array;
    }
}

