/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.lumenera.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.shared.net.HTTPBody;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class LumeneraJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.lumenera.jpeg.LumeneraJPEGVideoSourceClient";
    private long actualMilliFramerate = -1L;
    private int actualMilliCompression = -1;
    private int[] actualImageSize = new int[]{-1, -1};

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        try {
            this.logger.info("init started for" + this.getVideoSrv());
            int errorCode = super.init(false);
            if (errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
                return errorCode;
            }
            this.setImageParameter(this.highestFramerate, this.quality, this.resolution);
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return errorCode;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        HttpServerPushHandler httpServerPushHandler = null;
        try {
            String sURL = "/cgi-bin/video";
            this.networkParameter.setSoTimeout(5000);
            boolean bAsynchronous = false;
            httpServerPushHandler = new HttpServerPushHandler();
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                this.logger.debug("Error while sleeping.");
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int errorCode = httpServerPushHandler.init(this, this.networkParameter, sURL);
            if (errorCode != 0) {
                this.logger.error("Error [" + errorCode + "]with " + httpServerPushHandler);
            } else {
                errorCode = httpServerPushHandler.startServerPush(bAsynchronous);
                if (errorCode != 0) {
                    this.logger.warn("ServerPush of " + httpServerPushHandler + " terminated with error [" + errorCode + "]");
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error("Trouble with JPEGServerPushStream of " + super.getVideoSrv(), ex);
        }
        if (httpServerPushHandler != null) {
            httpServerPushHandler.shutdown();
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public int setImageParameter(Long nWantedMilliFramerate, Integer nWantedMilliCompression, int[] nWantedImageSize) {
        boolean resolutionChanged = true;
        try {
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/get?width", (int)Integer.MAX_VALUE);
            HTTPResponse hTTPResponse = new HTTPResponse(result);
            HTTPBody hTTPBody = hTTPResponse.getHttpBody();
            String resolutionString = hTTPBody.getData();
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/get?height", (int)Integer.MAX_VALUE);
            hTTPResponse = new HTTPResponse(result);
            hTTPBody = hTTPResponse.getHttpBody();
            resolutionString = resolutionString + hTTPBody.getData();
            if (nWantedImageSize == null) {
                resolutionChanged = false;
            } else if (resolutionString.contains(nWantedImageSize[0] + "") && resolutionString.contains(nWantedImageSize[1] + "")) {
                resolutionChanged = false;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading camera configuration for " + this);
        }
        boolean bChanged = false;
        StringBuilder sbURL = new StringBuilder("/cgi-bin/set?");
        if (nWantedMilliFramerate != null && nWantedMilliFramerate != this.actualMilliFramerate) {
            sbURL.append(";maximum_framerate=").append((nWantedMilliFramerate + 999L) / 1000L);
            bChanged = true;
            this.actualMilliFramerate = nWantedMilliFramerate;
        }
        if (nWantedMilliCompression != null && nWantedMilliCompression != this.actualMilliCompression) {
            sbURL.append(";compression=").append(nWantedMilliCompression / 1000);
            bChanged = true;
            this.actualMilliCompression = nWantedMilliCompression;
        }
        if (nWantedImageSize != null && (nWantedImageSize[0] != this.actualImageSize[0] || nWantedImageSize[1] != this.actualImageSize[1])) {
            if (resolutionChanged) {
                sbURL.append(";width=").append(nWantedImageSize[0]);
                sbURL.append(";height=" + nWantedImageSize[1]);
                bChanged = true;
                this.actualImageSize = nWantedImageSize;
            }
            try {
                sbURL.append(";");
                sbURL.append(super.getVideoSrv().getVideoSourceCnf().getResolution(super.getVideoSrv().getVideoMode()));
            }
            catch (ConfigurationException cex) {
                this.logger.warn((Object)cex, (Throwable)cex);
            }
        }
        if (bChanged) {
            String sURL = sbURL.toString();
            try {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sURL);
                this.logger.info("New image parameter [" + sURL + "] set for " + this);
            }
            catch (SeeTecException ex) {
                this.logger.warn("Couldn't set new image parameter [" + sURL + "] for " + this + " :-(", (Throwable)ex);
            }
        } else {
            this.logger.info("No change of image parameter for " + this);
        }
        return 0;
    }

    @Override
    public void notifyForNetworkProblems() {
        this.listener.notifyForNetworkProblems();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }
}

