/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.lumenera;

import de.seetec.v5.re.cm.DMConstantsIntf;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.NetworkCallback;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpReaderUnicast;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;

public class LumeneraMotionDetectionHandler
extends MotionDetectionHandler
implements NetworkCallback,
DMConstantsIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.lumenera.LumeneraMotionDetectionHandler";
    private UdpReaderUnicast udpReader = null;
    private String host = null;
    private int port = Integer.MIN_VALUE;
    private int previousEventID = Integer.MIN_VALUE;

    public LumeneraMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        try {
            this.listener = hardwareMotionDetection;
            if (this.listener == null) {
                return -20003;
            }
            if (this.listener.getVideoSrv() == null || this.listener.getVideoSrv().getDevice() == null || this.listener.getVideoSrv().getDevice().getDeviceCnf() == null || this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter() == null) {
                return -20003;
            }
            this.host = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter().getHost();
            this.port = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter().getHTTPport();
            this.udpReader = new UdpReaderUnicast(this);
            this.udpReader.init(524288, 0, true);
            this.logger.info("UDP port '" + this.udpReader.getPort() + "' opened for " + this.listener.getVideoSrv());
            String localAddress = null;
            Socket testSocket = null;
            try {
                testSocket = new Socket(this.host, this.port);
                localAddress = testSocket.getLocalAddress().getHostAddress();
                this.logger.info("Address used for MD server port: " + localAddress + " for " + this.listener.getVideoSrv().getEntity());
                testSocket.close();
                testSocket = null;
            }
            catch (Exception e) {
                this.logger.error("Test connection failed for [" + this.listener.getVideoSrv() + "] :-(", (Throwable)e);
                if (testSocket != null) {
                    testSocket.close();
                    testSocket = null;
                }
                this.shutdown(false);
                return -21656;
            }
            StringBuilder url = new StringBuilder("/cgi-bin/set?;motion_alarm_enable=true;alarm_udp_client=");
            url.append(localAddress);
            url.append(";alarm_udp_port=");
            url.append(this.udpReader.getPort());
            url.append(";alarm_enable_udp=true");
            url.append(";io_in_alarm_enable=false");
            try {
                this.logger.info("Writing URL: " + url.toString() + " for " + this.listener.getVideoSrv());
                NetworkHelper.readGetRequest((NetworkParameter)this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter(), (String)url.toString(), (int)Integer.MIN_VALUE);
            }
            catch (SeeTecException se) {
                this.logger.error("Sending MD start request [" + url.toString() + "] failed  for " + this.listener.getVideoSrv() + " with error [" + se.getErrorCode() + "] :-(", (Throwable)se);
                this.shutdown(false);
                return se.getErrorCode();
            }
            catch (Throwable t) {
                this.logger.error("Sending MD start request [" + url.toString() + "] failed  for " + this.listener.getVideoSrv() + "  with exception [" + t.getMessage() + "] :-(", t);
                this.shutdown(false);
                return -20000;
            }
            return 0;
        }
        catch (Throwable t) {
            this.logger.error("Error while initializing for " + this.listener.getVideoSrv(), t);
            this.shutdown(false);
            return -20000;
        }
    }

    @Override
    public synchronized void onUdpData(byte[] data) {
        block9: {
            try {
                if (this.isShutdown(CLASS_NAME)) {
                    return;
                }
                if (data == null) {
                    this.logger.error("Incoming data is null for " + this.listener.getVideoSrv());
                    break block9;
                }
                if (new String(data).contains("motion-centroid")) {
                    String[] splitLines = new String(data).split("\r\n");
                    if (splitLines.length > 1) {
                        try {
                            if (Integer.parseInt(splitLines[0]) <= this.previousEventID) {
                                return;
                            }
                            this.previousEventID = Integer.parseInt(splitLines[0]);
                        }
                        catch (Exception e) {
                            this.logger.error("Error while parsing motion detection datagram. Ignore it.");
                            this.logger.error(new String(data));
                            return;
                        }
                    }
                    this.listener.evaluateWindow(0);
                    break block9;
                }
                this.logger.warn("Received datagram doesn't contain expected format.");
                this.logger.warn(new String(data));
            }
            catch (Throwable t) {
                this.logger.error("Ignoring packet due to unexpected error: " + t.getMessage(), t);
            }
        }
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown(CLASS_NAME)) {
            return;
        }
        this.listener.notifyForNetworkProblems();
    }

    @Override
    public int shutdown() {
        return this.shutdown(true);
    }

    private int shutdown(boolean sendDisable) {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.logger.info("Shutting down MD Handler for: " + this.listener.getVideoSrv());
        if (sendDisable) {
            String url = "/cgi-bin/set?;alarm_enable_udp=false";
            try {
                NetworkHelper.readGetRequest((NetworkParameter)this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter(), (String)url);
            }
            catch (SeeTecException se) {
                this.logger.error("Sending MD shutdown [" + url + "] failed for " + this.listener.getVideoSrv() + " with error [" + se.getErrorCode() + "] :-(", (Throwable)se);
            }
            catch (Throwable t) {
                this.logger.error("Sending MD shutdown [" + url + "] failed  for " + this.listener.getVideoSrv() + " with exception [" + t.getMessage() + "] :-(", t);
            }
        }
        if (this.udpReader != null) {
            this.logger.info("Shutting down UDPReader for " + this.listener.getVideoSrv());
            this.udpReader.shutdown();
            this.udpReader = null;
        }
        this.host = null;
        super.shutdown();
        return 0;
    }
}

