/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.lg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperH264;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.lg.LGCameraSrv;
import de.seetec.v5.re.cm.device.video.lg.LGDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class LGVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.lg.LGVideoSourceClient";
    private int rtspPort = 554;
    private LGDevice lgDevice;

    @Override
    public int init() {
        try {
            StringBuilder url;
            this.printDebug = false;
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.lgDevice = (LGDevice)((LGCameraSrv)this.getVideoSrv()).getDevice();
            this.resolutionTag = this.lgDevice.getResolutionTag(this.width, this.height);
            boolean channel = false;
            boolean isMaster = true;
            if (this.width <= 720 && this.lgDevice.isHdDevice()) {
                isMaster = false;
            }
            String getSourceUrl = "/httpapi?GetVideoSourceConfig&channel=0";
            String getReplayAsString = this.sendCommand("/httpapi?GetVideoSourceConfig&channel=0");
            if (getReplayAsString.contains("Error:10")) {
                return -21657;
            }
            String replyContent = getReplayAsString.split("\r\n\r\n")[1].substring(4);
            if (this.width >= 1280) {
                String[] values = replyContent.split("\r\n");
                StringBuilder setSourceUrl = new StringBuilder();
                setSourceUrl.append("/httpapi?SetVideoSourceConfig&channel=").append(0);
                for (String value : values) {
                    String[] singleValues = value.split(":");
                    if (singleValues[0].equals("captureMode")) continue;
                    setSourceUrl.append("&");
                    setSourceUrl.append(singleValues[0]);
                    setSourceUrl.append("=");
                    setSourceUrl.append(singleValues[1]);
                }
                setSourceUrl.append("&");
                setSourceUrl.append("captureMode");
                setSourceUrl.append("=");
                if (this.width == 1280 && this.height == 1024 || this.width == 2040 && this.height == 1536) {
                    setSourceUrl.append("1");
                } else if (this.width == 1280 && this.height == 720 || this.width == 1920 && this.height == 1080) {
                    setSourceUrl.append("2");
                }
                String setReply = this.sendCommand(setSourceUrl.toString());
                if (setReply.contains("Error:10")) {
                    return -21657;
                }
            }
            if (this.lgDevice.getDeviceType() == 203900L && !isMaster) {
                url = new StringBuilder();
                url.append("/httpapi?SetVideoEncoderConfig");
                url.append("&channel=");
                url.append(0);
                url.append("&master=");
                url.append("true");
                url.append("&enable=");
                url.append("true");
                url.append("&frameRate=");
                url.append(5);
                url.append("&resolutionType=");
                url.append(4);
                url.append("&videoCodec=");
                url.append(this.videoCodec == Codec.H264 ? "VIDEO_CODEC_H264" : "VIDEO_CODEC_MJPEG");
                url.append("&bitRateType=");
                url.append(this.isConstantBitrateUsed ? "VIDEO_BITRATE_T_CBR" : "VIDEO_BITRATE_T_VBR");
                url.append("&qualityType=");
                url.append("VIDEO_QUALITY_MEDIUM");
                url.append("&bitRate=");
                url.append(2048);
                url.append("&gopSize=");
                url.append(5);
                url.append("&deinterlacing=");
                url.append("true");
                url.append("&width=");
                url.append(1280);
                url.append("&height=");
                url.append(replyContent.contains("VIDEO_STANDARD_NTSC") ? "1024" : "720");
                String reply = this.sendCommand(url.toString());
                if (reply.contains("Error:10")) {
                    return -21657;
                }
                Thread.sleep(2000L);
            }
            url = new StringBuilder();
            url.append("/httpapi?SetVideoEncoderConfig");
            url.append("&channel=");
            url.append(0);
            url.append("&master=");
            if (isMaster) {
                url.append("true");
            } else {
                url.append("false");
            }
            url.append("&enable=");
            url.append("true");
            int maxFps = replyContent.contains("VIDEO_STANDARD_NTSC") ? 30 : 25;
            url.append("&frameRate=");
            this.fps /= 1000L;
            this.fps = this.fps < 1L ? 1L : this.fps;
            this.fps = this.fps > (long)maxFps ? (long)maxFps : this.fps;
            url.append(this.fps);
            url.append("&resolutionType=");
            url.append(this.resolutionTag);
            url.append("&videoCodec=");
            url.append(this.videoCodec == Codec.H264 ? "VIDEO_CODEC_H264" : "VIDEO_CODEC_MJPEG");
            url.append("&bitRateType=");
            url.append(this.isConstantBitrateUsed ? "VIDEO_BITRATE_T_CBR" : "VIDEO_BITRATE_T_VBR");
            url.append("&qualityType=");
            String qualityType = "";
            this.quality /= 1000;
            if (this.quality <= 20) {
                qualityType = "VIDEO_QUALITY_LOW";
            } else if (this.quality <= 40) {
                qualityType = "VIDEO_QUALITY_MEDIUM";
            } else if (this.quality <= 60) {
                qualityType = "VIDEO_QUALITY_HIGH";
            } else if (this.quality <= 80) {
                qualityType = "VIDEO_QUALITY_SUPER_HIGH";
            } else if (this.quality <= 100) {
                qualityType = "VIDEO_QUALITY_FULL";
            }
            url.append(qualityType);
            url.append("&bitRate=");
            this.bandwidth /= 1024;
            this.bandwidth = this.bandwidth > 10240 ? 10240 : this.bandwidth;
            this.bandwidth = this.bandwidth < 256 ? 256 : this.bandwidth;
            url.append(this.bandwidth);
            url.append("&gopSize=");
            this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps * 1000L, this.iFrameDistMS, 1, 30);
            url.append(this.iFrameDist);
            url.append("&deinterlacing=");
            url.append("true");
            url.append("&width=");
            url.append(this.width);
            url.append("&height=");
            url.append(this.height);
            String reply = this.sendCommand(url.toString());
            if (reply.contains("Error:10")) {
                return -21657;
            }
            if (this.isAudioEnabled) {
                StringBuilder audioUrl = new StringBuilder();
                audioUrl.append("/httpapi?SetAudioConfig");
                audioUrl.append("&channel=");
                audioUrl.append(0);
                audioUrl.append("&enableAudioIn=");
                audioUrl.append(this.isAudioEnabled ? "true" : "false");
                audioUrl.append("&audioInCodec=");
                if (this.audioCodec == Codec.G711U) {
                    this.audioCodec = Codec.G711A;
                    audioUrl.append("AUDIO_CODEC_G711_PCMA");
                } else if (this.audioCodec == Codec.G726) {
                    audioUrl.append("AUDIO_CODEC_G726_32K");
                }
                audioUrl.append("&enableAudioOut=");
                audioUrl.append("false");
                String audioReply = this.sendCommand(url.toString());
                if (audioReply.contains("Error:10")) {
                    return -21657;
                }
            }
            if (this.isAudioEnabled) {
                this.logger.info("Audio enabled for " + this.getVideoSrv());
                if (this.audioCodec == Codec.G711U) {
                    this.audioCodec = Codec.G711A;
                }
            }
            Thread.sleep(5000L);
            this.rtspPort = this.listener.getVideoSourceParameter().getRtspPort();
            this.rtspUrl = "rtsp://" + this.getHost() + ":" + this.rtspPort + "/" + (isMaster ? "Master" : "Slave") + "-" + 0;
            this.logger.info(this.rtspUrl);
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 3, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing RTSP settings for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP Handling for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.logger.info("init done for" + this.getVideoSrv());
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while initialization for " + this);
            this.logger.error((Object)ex, (Throwable)ex);
            return ex.getErrorCode();
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this);
            this.logger.error((Object)t, t);
            return -20000;
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    private String sendCommand(String command) throws Exception {
        String replayAsString = "";
        int counter = 0;
        do {
            byte[] reply = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)command, (int)Integer.MAX_VALUE);
            replayAsString = new String(reply);
            Thread.sleep(200L);
        } while (replayAsString.contains("Error:5") && ++counter < 10);
        return replayAsString;
    }

    @Override
    public final void deliverH264Data(byte[] completeFrameAsByteArray, boolean checkResolution, long timestamp) {
        if (this.lgDevice.getDeviceType() != 203909L) {
            try {
                super.deliverH264Data(completeFrameAsByteArray, false, timestamp);
            }
            catch (SeeTecException seeTecException) {
                this.logger.error("Error while parsing h264 frame for " + this + " | ErrorCode: " + seeTecException.getErrorCode(), (Throwable)seeTecException);
            }
        } else {
            int mediaType = StreamingHelperH264.checkForH264MediaType(this.getVideoSrv().getDevice(), completeFrameAsByteArray);
            if (mediaType == Integer.MIN_VALUE) {
                mediaType = StreamingHelperH264.checkForH264MediaType(this.getVideoSrv().getDevice(), completeFrameAsByteArray, 3);
            }
            if (mediaType == 7) {
                mediaType = 33;
            }
            if (mediaType >= 0) {
                if (mediaType == 7 && this.parameterSetPart == null) {
                    this.parameterSetPart = new byte[completeFrameAsByteArray.length];
                    System.arraycopy(completeFrameAsByteArray, 0, this.parameterSetPart, 0, completeFrameAsByteArray.length);
                } else if (mediaType == 8 && this.pictureSet == null) {
                    this.pictureSet = new byte[completeFrameAsByteArray.length];
                    System.arraycopy(completeFrameAsByteArray, 0, this.pictureSet, 0, completeFrameAsByteArray.length);
                } else {
                    try {
                        ByteArrayOutputStream b;
                        if (mediaType == 33) {
                            if (this.parameterSetPart == null) {
                                this.parameterSetPart = new byte[StreamingHelper.START_SEQUENCE.length + this.describeResponse.getSequenceParameterSet().length];
                                System.arraycopy(StreamingHelper.START_SEQUENCE, 0, this.parameterSetPart, 0, StreamingHelper.START_SEQUENCE.length);
                                System.arraycopy(this.describeResponse.getSequenceParameterSet(), 0, this.parameterSetPart, StreamingHelper.START_SEQUENCE.length, this.describeResponse.getSequenceParameterSet().length);
                            }
                            if (this.pictureSet == null) {
                                this.pictureSet = new byte[StreamingHelper.START_SEQUENCE.length + this.describeResponse.getPictureParameterSet().length];
                                System.arraycopy(StreamingHelper.START_SEQUENCE, 0, this.pictureSet, 0, StreamingHelper.START_SEQUENCE.length);
                                System.arraycopy(this.describeResponse.getPictureParameterSet(), 0, this.pictureSet, StreamingHelper.START_SEQUENCE.length, this.describeResponse.getPictureParameterSet().length);
                            }
                            if (this.configHeader == null) {
                                this.configHeader = new byte[this.parameterSetPart.length + this.pictureSet.length];
                                System.arraycopy(this.parameterSetPart, 0, this.configHeader, 0, this.parameterSetPart.length);
                                System.arraycopy(this.pictureSet, 0, this.configHeader, this.parameterSetPart.length, this.pictureSet.length);
                                int[] resolutionFromStream = StreamingHelperH264.extractH264Resolution(this.configHeader);
                                if (resolutionFromStream != null) {
                                    this.width = resolutionFromStream[0];
                                    this.height = resolutionFromStream[1];
                                }
                            }
                            if (this.useFrameCropping) {
                                if (this.firstIFramePart) {
                                    this.firstIFramePart = false;
                                    this.firstPartIFrame = completeFrameAsByteArray;
                                    return;
                                }
                                this.firstIFramePart = true;
                                b = new ByteArrayOutputStream();
                                try {
                                    b.write(this.firstPartIFrame);
                                    b.write(completeFrameAsByteArray);
                                    completeFrameAsByteArray = b.toByteArray();
                                }
                                catch (IOException ex) {
                                    this.logger.info("Exception: " + ex.getMessage());
                                }
                            }
                        } else if (mediaType == 35) {
                            if (this.useFrameCropping) {
                                if (this.firstPFramePart) {
                                    this.firstPFramePart = false;
                                    this.firstPartPFrame = completeFrameAsByteArray;
                                    return;
                                }
                                this.firstPFramePart = true;
                                b = new ByteArrayOutputStream();
                                try {
                                    if (this.firstPartPFrame.length < completeFrameAsByteArray.length) {
                                        this.firstPFramePart = false;
                                        return;
                                    }
                                    b.write(this.firstPartPFrame);
                                    b.write(completeFrameAsByteArray);
                                    completeFrameAsByteArray = b.toByteArray();
                                }
                                catch (IOException ex) {
                                    this.logger.error("Exception: " + ex.getMessage());
                                }
                            }
                        } else {
                            return;
                        }
                        MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.H264, this.width, this.height, completeFrameAsByteArray, this.configHeader);
                        this.deliverFrame(mediaType, mediaFrame, timestamp);
                    }
                    catch (SeeTecException ex) {
                        this.logger.error("Exception while creating and delivering frame for " + this + " : " + ex.getMessage() + " , error code: " + ex.getErrorCode());
                    }
                }
            }
        }
    }
}

