/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.lg;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class LGIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.lg.LGIOHandler";
    private byte[] result;

    @Override
    public void run() {
        boolean errorCode = false;
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean previousLoopWithError = false;
            DigitalInputSrv[] iServices = super.getDigitalInputSrv();
            for (int i = 0; i < iServices.length; ++i) {
                String url = "/cgi-bin/configManager.cgi?action=setConfig&Alarm[" + i + "].Enable=true";
                this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
            }
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs();
                    if (previousLoopWithError) {
                        previousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this + " ...");
                        for (int i = 0; i < iServices.length; ++i) {
                            if (!iServices[i].getEntity().isEnabled().booleanValue()) continue;
                            iServices[i].publishServiceStatus(iServices[i].getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    previousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        if (ex.getMessage().indexOf("Address already in use") >= 0) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        for (int i = 0; i < iServices.length; ++i) {
                            if (!iServices[i].getEntity().isEnabled().booleanValue()) continue;
                            iServices[i].publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int readDigitalInputs() throws Exception {
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Reading digital inputs of " + this + " ...");
        }
        String url = "/alarm?Check&type=Sensor";
        this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/alarm?Check&type=Sensor", (int)Integer.MAX_VALUE);
        String responseString = new String(this.result);
        int counter = 0;
        String[] parameterList = responseString.split(new String(CRLF_BYTE));
        for (int i = 0; i < parameterList.length; ++i) {
            String[] parameterLine = parameterList[i].toLowerCase().split(":");
            if (parameterLine.length != 2 || !parameterLine[0].startsWith("sensor")) continue;
            if (parameterLine[1].startsWith("h")) {
                iServices[2 * counter].checkInput(1);
                iServices[2 * counter + 1].checkInput(1);
            } else {
                iServices[2 * counter].checkInput(0);
                iServices[2 * counter + 1].checkInput(0);
            }
            ++counter;
        }
        return 0;
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        int errorCode = 0;
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber + "] ");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this);
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        try {
            IOHandler.HoldTimer holdTimer;
            StringBuilder url = new StringBuilder("/httpapi?SetRelay&relayChannel=" + (outputNumber - 1) + "&controlDuration=86400&type=true&name=Relay");
            this.logger.info(new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE)));
            StringBuilder url2 = new StringBuilder("/httpapi?RunRelay&relayChannel=" + (outputNumber - 1) + "&enableRun=" + (value == 0 ? "false" : "true"));
            this.logger.info(new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url2.toString(), (int)Integer.MAX_VALUE)));
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [ " + errorCode + " ] :-( ");
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while writing digital output for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }
}

