/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.jvc.mpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperMpeg4;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClient;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class JVCMPEGVideoSourceClient
extends StreamingVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.jvc.mpeg.JVCMPEGVideoSourceClient";
    private String fpsValue = "30";
    private StringBuffer url = new StringBuffer();
    private HttpServerPushHandler httpServerPushHandler = null;

    @Override
    public int init() {
        boolean newSetting = false;
        this.logger.info("init started for" + this.getVideoSrv());
        try {
            this.videoSourceNr = this.getVideoSrv().getVideoSourceCnf().getServerEntryNo();
            int[] resolution = this.getVideoSrv().getVideoSourceCnf().getImageSize(this.getVideoSrv().getVideoMode());
            if (resolution == null || resolution.length != 2) {
                return -21601;
            }
            this.width = resolution[0];
            this.height = resolution[1];
            this.iFrameDistMS = this.getVideoSrv().getVideoSourceCnf().getIFrameDistance(this.getVideoSrv().getVideoMode());
            this.bandwidth = this.getVideoSrv().getVideoSourceCnf().getBandWidth(this.getVideoSrv().getVideoMode());
            this.fps = this.getVideoSrv().getVideoSourceCnf().getFramerate(this.getVideoSrv().getVideoMode());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed :-(");
            return -21601;
        }
        try {
            this.bandwidth = this.bandwidth < 64000 ? 64000 : this.bandwidth;
            int n = this.bandwidth = this.bandwidth > 8000000 ? 8000000 : this.bandwidth;
            if (this.getVideoSrv().getEntityType() == 210309L || this.getVideoSrv().getEntityType() == 210311L) {
                this.url.append("/api/param?system.mode=");
                if (this.width == 640) {
                    this.url.append("pattern1");
                } else if (this.width == 320) {
                    this.url.append("pattern2");
                } else {
                    this.logger.error("Value '" + this.width + "' not supported for " + this.getVideoSrv());
                }
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)this.url.toString(), (int)Integer.MAX_VALUE);
                newSetting = true;
                this.url = new StringBuffer("/api/param?");
            } else {
                this.url.append("/api/param?encode(2).framesize=");
                if (this.width == 640) {
                    this.url.append("vga");
                } else {
                    this.url.append("qvga");
                }
            }
            this.fps /= 1000L;
            this.fpsValue = this.fps <= 4L ? "1" : (this.fps > 4L && this.fps <= 8L ? "7.5" : (this.fps > 8L && this.fps <= 12L ? "10" : (this.fps > 12L && this.fps <= 20L ? "15" : (this.fps > 20L && this.fps <= 27L ? "25" : "30"))));
            try {
                this.iFrameDist = Math.round(Float.parseFloat(this.fpsValue) * (float)(this.iFrameDistMS / 1000));
                long[] allowedValues = new long[]{30L, 60L, 120L, 150L, 180L, 210L, 240L};
                this.iFrameDist = Tools.convertToCameraValues(allowedValues, this.iFrameDist);
            }
            catch (NumberFormatException allowedValues) {
                // empty catch block
            }
            if (newSetting) {
                this.url.append("encode(2).bitrate=");
            } else {
                this.url.append("&encode(2).bitrate=");
            }
            this.url.append(this.bandwidth);
            this.url.append("&encode(2).iframeinterval=");
            this.url.append(this.iFrameDist);
            this.url.append("&encode(2).framerate=");
            this.url.append(this.fpsValue);
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)this.url.toString(), (int)Integer.MAX_VALUE);
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/api/param?encode(2).status=save", (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException se) {
            this.logger.error("Setting/adjusting parameters from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)se);
            if (se.getErrorCode() == -21657) {
                return -21657;
            }
            return se.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error("Setting/adjusting parameters from " + this.getVideoSrv().getDevice() + " failed :-(", ex);
            return -21601;
        }
        this.url = new StringBuffer("/api/video?encode=mpeg4&boundary=on&ptz_info=off");
        try {
            boolean bAsynchronous = true;
            this.httpServerPushHandler = new HttpServerPushHandler();
            this.networkParameter.setSoTimeout(5000);
            this.errorCode = this.httpServerPushHandler.init(this, this.networkParameter, this.url.toString());
            if (this.errorCode != 0) {
                this.logger.error("Error [" + this.errorCode + "] with " + this.httpServerPushHandler);
            } else {
                this.errorCode = this.httpServerPushHandler.startServerPush(bAsynchronous);
            }
        }
        catch (Exception e) {
            this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
            return -21601;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.fpsValue = null;
        this.url = null;
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        this.logger.info("shutdown done for " + this.getVideoSrv());
        return 0;
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        byte[] contentData = httpServerPushContent.getContentBody();
        int mediaType = StreamingHelperMpeg4.checkForMPEG4Part2MediaType(contentData);
        if (mediaType >= 0) {
            int[] currentResolution;
            if (mediaType == 33 && (currentResolution = StreamingHelperMpeg4.extractMPEG4Part2Resolution(contentData)) != null) {
                this.width = currentResolution[0];
                this.height = currentResolution[1];
            }
            try {
                MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MPEG4, this.width, this.height, contentData);
                this.deliverFrameCreateServerTimestamp(mediaType, mediaFrame);
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while creating and delivering media frame for " + this + " : " + ex.getMessage());
            }
        }
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }
}

