/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.jvc.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class JVCJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.jvc.jpeg.JVCJPEGVideoSourceClient";
    private HttpServerPushHandler httpServerPushHandler = null;
    private String fps;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        int errorCode = 0;
        boolean newSetting = false;
        super.setRunFinished(CLASS_NAME, false);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Grabbing images ...");
        }
        try {
            errorCode = super.init(false);
            if (errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
                return errorCode;
            }
            StringBuilder sb = new StringBuilder();
            this.fps = "30";
            String resolution = null;
            this.quality /= 1000;
            if (this.getVideoSrv().getEntityType() == 210309L || this.getVideoSrv().getEntityType() == 210311L) {
                sb.append("/api/param?system.mode=");
                switch (this.width) {
                    case 1280: {
                        sb.append("pattern1");
                        this.quality *= 2;
                        this.quality = this.quality <= 40 ? 40 : this.quality;
                        break;
                    }
                    case 640: {
                        sb.append("pattern3");
                        this.quality = this.quality <= 10 ? 10 : this.quality;
                        break;
                    }
                    case 320: {
                        sb.append("pattern4");
                        this.quality /= 3;
                        this.quality = this.quality <= 3 ? 3 : this.quality;
                        break;
                    }
                    default: {
                        this.logger.error("Value '" + this.width + "' not supported for " + this.getVideoSrv());
                    }
                }
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE);
                newSetting = true;
            } else if (this.width == 640) {
                resolution = "vga";
                this.quality = this.quality <= 10 ? 10 : this.quality;
            } else {
                resolution = "qvga";
                this.quality /= 3;
                this.quality = this.quality <= 3 ? 3 : this.quality;
            }
            sb = new StringBuilder("/api/param?");
            this.fps = this.highestFramerate <= 22L ? "-60" : (this.highestFramerate > 28L && this.highestFramerate <= 40L ? "-30" : (this.highestFramerate > 40L && this.highestFramerate <= 58L ? "-20" : (this.highestFramerate > 58L && this.highestFramerate <= 83L ? "-15" : (this.highestFramerate > 83L && this.highestFramerate <= 142L ? "-10" : (this.highestFramerate > 142L && this.highestFramerate <= 250L ? "-5" : (this.highestFramerate > 250L && this.highestFramerate <= 333L ? "-3" : (this.highestFramerate > 333L && this.highestFramerate <= 500L ? "-2" : (this.highestFramerate > 500L && this.highestFramerate <= 1500L ? "1" : (this.highestFramerate > 1500L && this.highestFramerate <= 2500L ? "2" : (this.highestFramerate > 2500L && this.highestFramerate <= 3500L ? "3" : (this.highestFramerate > 3500L && this.highestFramerate <= 5500L ? "5" : (this.highestFramerate > 5500L && this.highestFramerate <= 6750L ? "6" : (this.highestFramerate > 6750L && this.highestFramerate <= 8500L ? "7.5" : (this.highestFramerate > 8500L && this.highestFramerate <= 12000L ? "10" : (this.highestFramerate > 12000L && this.highestFramerate <= 17000L ? "15" : (this.highestFramerate > 17000L && this.highestFramerate <= 27000L ? "25" : "30"))))))))))))))));
            if (newSetting) {
                sb.append("encode(1).quality=");
            } else {
                sb.append("encode(1).framesize=");
                sb.append(resolution);
                sb.append("&encode(1).quality=");
            }
            sb.append(this.quality);
            sb.append("k");
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE);
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return errorCode;
        }
        catch (SeeTecException se) {
            this.logger.error("Setting/adjusting parameters from " + this.getVideoSrv().getDevice() + " failed", (Throwable)se);
            if (se.getErrorCode() == -21657) {
                return -21657;
            }
            return se.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return errorCode;
        }
    }

    @Override
    public void run() {
        String url = "/api/video?encode=jpeg&boundary=on&ptz_info=off&framerate=" + this.fps;
        try {
            JVCJPEGVideoSourceClient listener = this;
            NetworkParameter networkParameter = super.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
            networkParameter.setSoTimeout(5000);
            this.httpServerPushHandler = new HttpServerPushHandler();
            int errorCode = this.httpServerPushHandler.init(listener, networkParameter, url);
            if (errorCode != 0) {
                this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
            } else {
                this.httpServerPushHandler.startServerPush(false);
            }
        }
        catch (Exception e) {
            this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed", (Throwable)e);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }
}

