/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.jvc;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.jvc.HttpStreamHandler;
import de.seetec.v5.re.cm.device.video.jvc.HttpStreamListenerIntf;
import de.seetec.v5.re.cm.device.video.jvc.JVCCameraSrv;
import de.seetec.v5.re.cm.device.video.jvc.JVCHardwareMotionDetection;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class JVCVideoSourceClient
extends StreamingVideoSourceClientRTSP
implements HttpStreamListenerIntf,
HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.jvc.JVCVideoSourceClient";
    private int streamNumber = 0;
    private boolean hasMotionDetection;
    private HttpStreamHandler httpStreamHandler = null;
    private float cameraFramerate;
    private boolean settingsChanged = false;
    private ByteArrayOutputStream baos = null;
    private HttpServerPushHandler httpServerPushHandler = null;
    private AudioHandler audioHandler = null;
    private Thread audioHandlerThread = null;
    private byte[] FFFE = new byte[]{-1, -2};
    private byte[] START_USER_DATA = new byte[]{0, 0, 0, 1, 102, 5};
    private boolean messageSent = false;

    @Override
    public int init() {
        block35: {
            this.errorCode = 0;
            super.setRunFinished(CLASS_NAME, false);
            this.networkParameter.setSoTimeout(15000);
            this.hasMotionDetection = false;
            try {
                String url;
                this.errorCode = super.init();
                if (this.errorCode != 0) {
                    this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                    return this.errorCode;
                }
                JVCCameraSrv jvcCameraSrv = (JVCCameraSrv)this.getVideoSrv();
                long[] nTypeList = new long[]{9808L};
                Entity[] entities = jvcCameraSrv.getDevice().getEnabledEntities(new long[]{jvcCameraSrv.getEntityID()}, nTypeList);
                if (entities.length > 0) {
                    this.hasMotionDetection = true;
                }
                long entityType = super.getVideoSrv().getEntityType();
                this.streamNumber = jvcCameraSrv.getStreamNumber(this.listener.getDynamicVideoProfileID());
                if (entityType == 210314L) {
                    if (!jvcCameraSrv.hasMotionDetectionStream() && this.listener.hasHardwareMotionDetection()) {
                        jvcCameraSrv.setHasMotionDetectionStream(true);
                    }
                } else if (entityType == 210315L) {
                    url = "/api/param?encode(" + this.streamNumber + ").framesize=";
                    url = url + jvcCameraSrv.getResolutionString(this.width, this.height);
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
                }
                if ((url = this.getParameterString(entityType).replace("?&", "?")).equals("/api/param?")) {
                    url = "";
                }
                boolean bl = this.settingsChanged = !url.isEmpty();
                if (this.settingsChanged) {
                    try {
                        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
                    }
                    catch (SeeTecException ex) {
                        this.logger.warn("Exception while setting parameters for " + this + " : " + ex.getMessage());
                    }
                }
                if (this.isAudioEnabled) {
                    this.audioHandler = new AudioHandler((RTSPHandlerIntf)this);
                    this.audioHandlerThread = new Thread((Runnable)this.audioHandler, this.audioHandler.toString());
                    this.audioHandlerThread.start();
                } else if (entityType == 210315L) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                if (this.transmissionID == TransmissionType.HTTP) {
                    if (entityType == 210314L && this.width == 1920) {
                        this.useFrameCropping = true;
                    }
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    url = "/api/video?encode=h264(" + this.streamNumber + ")";
                    this.httpStreamHandler = new HttpStreamHandler();
                    this.errorCode = this.httpStreamHandler.init(this, this.networkParameter, url);
                    if (this.errorCode != 0) {
                        this.logger.error("Exception while initializing HTTP stream handler for " + this + " Error: " + this.errorCode);
                        return this.errorCode;
                    }
                    this.errorCode = this.httpStreamHandler.startServerPush(true);
                    if (this.errorCode != 0) {
                        this.logger.error("Exception while starting HTTP reading for " + this + " Error: " + this.errorCode);
                        return this.errorCode;
                    }
                    break block35;
                }
                if (this.transmissionID == TransmissionType.HTTP_SERVERPUSH) {
                    String serverPushUrl = "/api/video?encode=jpeg(" + this.streamNumber + ")&server_push=on";
                    if (entityType == 210314L || entityType == 210315L) {
                        int framerate = (int)(this.fps / 1000L);
                        framerate = framerate < 4 ? 4 : framerate;
                        framerate = framerate > 25 ? 25 : framerate;
                        serverPushUrl = serverPushUrl + "&framerate=" + framerate;
                        serverPushUrl = serverPushUrl + "&boundary=on";
                    }
                    this.httpServerPushHandler = new HttpServerPushHandler();
                    this.errorCode = this.httpServerPushHandler.init(this, this.networkParameter, serverPushUrl);
                    if (this.errorCode != 0) {
                        this.logger.error("Error [" + this.errorCode + "]with " + this.httpServerPushHandler);
                    } else {
                        this.errorCode = this.httpServerPushHandler.startServerPush(true);
                        if (this.errorCode != 0) {
                            this.logger.warn("ServerPush of " + this.httpServerPushHandler + " terminated with error [" + this.errorCode + "]");
                        }
                    }
                    break block35;
                }
                this.rtspUrl = "rtsp://" + this.getHost() + "/PSIA/Streaming/channels/" + (this.streamNumber - 1);
                if (entityType == 210315L) {
                    this.rtspUrl = "rtsp://" + this.getHost() + "/ONVIF/Streaming/channels/" + (this.streamNumber - 1);
                }
                if (this.videoCodec == Codec.MJPEG && (entityType == 210312L || entityType == 210313L || entityType == 210315L)) {
                    this.rtspUrl = this.rtspUrl + "?maxFrameRate=" + this.cameraFramerate;
                }
                this.rtspSettings = new RTSPStreamSettings();
                try {
                    this.errorCode = this.rtspSettings.init(this, null, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), false, 3, this.rtspUrl);
                    if (this.errorCode != 0) {
                        this.logger.error("Error while initializing RTSP Settings for " + this.getVideoSrv());
                        return this.errorCode;
                    }
                }
                catch (ConfigurationException ex) {
                    this.logger.warn("Could not initialize rtspSettings for " + this);
                    this.logger.warn((Object)ex, (Throwable)ex);
                }
                if (entityType == 210314L) {
                    String cameraValues = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/api/param?network.rtsp(" + this.streamNumber + ").port"), (int)Integer.MAX_VALUE, (boolean)true));
                    int rtspPortOnCamera = Integer.parseInt(jvcCameraSrv.readCameraValues(cameraValues, "network.rtsp(" + this.streamNumber + ").port"));
                    this.rtspSettings.setRTSPPort(rtspPortOnCamera);
                    this.rtspSettings.setTcpChannel(0);
                }
                this.rtspSettings.setRange("npt=now-");
                this.rtspHandler = this.rtspSettings.getRTSPHandler();
                this.errorCode = this.rtspHandler.start();
                if (this.errorCode != 0) {
                    this.logger.error("Error while starting RTSP Handling for " + this.getVideoSrv());
                    return this.errorCode;
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while initializing RTSP Handler for " + ex.getMessage());
                return ex.getErrorCode();
            }
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void onNetworkError(int error) {
        try {
            if (this.isShutdown()) {
                return;
            }
            this.listener.sendStatusService(error);
            this.shutdown();
        }
        catch (Throwable e) {
            this.logger.error("Exception in onNetworkError for " + this, e);
        }
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        ((JVCCameraSrv)this.getVideoSrv()).setHasMotionDetectionStream(false);
        if (this.audioHandler != null) {
            this.audioHandler.shutdown();
            this.audioHandler = null;
        }
        return super.shutdown();
    }

    @Override
    public synchronized void deliverRawContent(byte[] rawHTTPContent) {
        try {
            if (rawHTTPContent != null && rawHTTPContent.length != 0) {
                int firstIndex;
                int indexCommentSegment;
                if (this.baos == null) {
                    this.baos = new ByteArrayOutputStream();
                }
                if (this.getVideoSrv().getEntityType() == 210314L && (indexCommentSegment = Basic.indexOfByteArray((byte[])rawHTTPContent, (byte[])this.START_USER_DATA, (int)0)) >= 0) {
                    int pointerResult = indexCommentSegment + 160;
                    int pointerEnabled = indexCommentSegment + 153;
                    if (rawHTTPContent.length >= pointerResult) {
                        if (rawHTTPContent[pointerEnabled] != 49 && !this.messageSent) {
                            this.logger.error("Motion Detection on camera is disabled for " + this.getVideoSrv().getEntityName());
                            this.logger.error("Activate Motion Detection on camera or disable Motion Detection in Seetec for " + this.getVideoSrv().getEntityName());
                            this.messageSent = true;
                        }
                        if (rawHTTPContent[pointerResult] == 49) {
                            this.processMotionDetection();
                        }
                    }
                }
                this.baos.write(rawHTTPContent);
                byte[] data = this.baos.toByteArray();
                this.baos.reset();
                while (true) {
                    firstIndex = Basic.indexOfByteArray((byte[])data, (byte[])StreamingHelper.START_SEQUENCE, (int)0, (boolean)true);
                    int secondIndex = Basic.indexOfByteArray((byte[])data, (byte[])StreamingHelper.START_SEQUENCE, (int)(firstIndex + StreamingHelper.START_SEQUENCE.length), (boolean)true);
                    if (firstIndex == -1 || secondIndex == -1) break;
                    this.deliverH264Data(Arrays.copyOfRange(data, firstIndex, secondIndex), false, Long.MIN_VALUE);
                    byte[] temp = new byte[data.length - (secondIndex - firstIndex)];
                    System.arraycopy(data, 0, temp, 0, firstIndex);
                    System.arraycopy(data, secondIndex, temp, firstIndex, data.length - secondIndex);
                    data = temp;
                }
                if (firstIndex != -1) {
                    this.baos.write(data, firstIndex, data.length - firstIndex);
                    return;
                }
                this.baos.write(data);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            this.logger.error("Content length: " + rawHTTPContent.length + " for " + this.getVideoSrv());
            if (rawHTTPContent.length < 100) {
                this.logger.error("Content: " + Basic.byteArrayToHexString((byte[])rawHTTPContent, (int)0, (int)rawHTTPContent.length));
            }
            this.logger.error("Content: " + Basic.byteArrayToHexString((byte[])rawHTTPContent, (int)0, (int)100));
        }
    }

    private String getParameterString(long entityType) throws SeeTecException {
        float[] allowedFramerates;
        StringBuilder sb = new StringBuilder("/api/param?");
        JVCCameraSrv jvcCameraSrv = (JVCCameraSrv)this.getVideoSrv();
        boolean framerateOnlyChanged = false;
        if (entityType == 210312L || entityType == 210313L) {
            allowedFramerates = new float[]{1.0f, 2.0f, 3.0f, 5.0f, 7.5f, 10.0f, 15.0f, 25.0f, 30.0f};
            this.cameraFramerate = Tools.convertToCameraValues(allowedFramerates, (float)(this.fps / 1000L));
            this.cameraFramerate = this.cameraFramerate > 15.0f && this.hasMotionDetection ? 15.0f : this.cameraFramerate;
            sb.append("encode(").append(this.streamNumber).append(").framesize=");
            sb.append(this.width).append("x").append(this.height);
            if (this.videoCodec == Codec.H264) {
                sb.append("&encode(").append(this.streamNumber).append(").type=h264high");
                sb.append("&encode(").append(this.streamNumber).append(").framerate=");
                sb.append(this.cameraFramerate);
                int[] validBitrateValues = new int[]{65536, 131072, 262144, 393216, 524288, 786432, 0x100000, 0x180000, 0x200000, 0x300000, 0x380000, 0x400000, 8000000};
                this.bandwidth = Tools.convertToCameraValues(validBitrateValues, this.bandwidth);
                sb.append("&encode(").append(this.streamNumber).append(").cbr_mode=cbr");
                sb.append("&encode(").append(this.streamNumber).append(").bitrate=").append(this.bandwidth);
                int[] validIFrameDistances = new int[]{5, 10, 15, 30, 60, 90, 120};
                int gopLength = Tools.convertIFrameDistMStoFrameCount((int)(this.cameraFramerate * 1000.0f), this.iFrameDistMS, 5, 120);
                int gopLengthForCamera = Tools.convertToCameraValues(validIFrameDistances, gopLength);
                sb.append("&encode(").append(this.streamNumber).append(").iframeinterval=").append(gopLengthForCamera);
                StringBuilder url = new StringBuilder("/api/param?encode(" + this.streamNumber + ").framerate&encode(" + this.streamNumber + ").framesize");
                url.append("&encode(").append(this.streamNumber).append(").cbr_mode&encode(").append(this.streamNumber).append(").bitrate&encode(").append(this.streamNumber).append(").iframeinterval");
                String cameraValues = null;
                try {
                    cameraValues = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)true));
                }
                catch (SeeTecException ex) {
                    this.logger.warn("Exception while reading camera configuration for " + this + " : " + ex.getMessage());
                }
                String framerateOnCamera = jvcCameraSrv.readCameraValues(cameraValues, "encode(" + this.streamNumber + ").framerate");
                String frameSizeOnCamera = jvcCameraSrv.readCameraValues(cameraValues, "encode(" + this.streamNumber + ").framesize");
                String cbrmodeOnCamera = jvcCameraSrv.readCameraValues(cameraValues, "encode(" + this.streamNumber + ").cbr_mode");
                String bitrateOnCamera = jvcCameraSrv.readCameraValues(cameraValues, "encode(" + this.streamNumber + ").bitrate");
                String iframeintervalOnCamera = jvcCameraSrv.readCameraValues(cameraValues, "encode(" + this.streamNumber + ").iframeinterval");
                if (!((framerateOnCamera.equals(this.cameraFramerate + "") || (framerateOnCamera + ".0").equals(this.cameraFramerate + "")) && frameSizeOnCamera.equals(this.width + "x" + this.height) && cbrmodeOnCamera.equals("cbr") && bitrateOnCamera.equals(this.bandwidth + "") && iframeintervalOnCamera.equals(gopLengthForCamera + ""))) {
                    this.settingsChanged = true;
                    if (!framerateOnCamera.equals(this.cameraFramerate + "") && !(framerateOnCamera + ".0").equals(this.cameraFramerate + "") && frameSizeOnCamera.equals(this.width + "x" + this.height) && cbrmodeOnCamera.equals("cbr") && bitrateOnCamera.equals(this.bandwidth + "") && iframeintervalOnCamera.equals(gopLengthForCamera + "")) {
                        framerateOnlyChanged = true;
                    }
                }
            } else {
                int[] allowedValues;
                if (this.width == 1920) {
                    allowedValues = new int[]{80, 120, 160, 200, 240, 280, 320};
                    this.quality = Tools.convertToCameraValues(allowedValues, this.quality / 313);
                } else if (this.width == 1280) {
                    allowedValues = new int[]{60, 80, 100, 120, 140, 160, 180};
                    this.quality = Tools.convertToCameraValues(allowedValues, this.quality / 555);
                } else if (this.width == 640) {
                    allowedValues = new int[]{15, 20, 25, 30, 40, 60, 80};
                    this.quality = Tools.convertToCameraValues(allowedValues, this.quality / 1250);
                } else {
                    allowedValues = new int[]{5, 7, 8, 10, 13, 20, 27};
                    this.quality = Tools.convertToCameraValues(allowedValues, this.quality / 3704);
                }
                sb.append("&encode(").append(this.streamNumber).append(").type=jpeg&encode(").append(this.streamNumber).append(").cbr_mode=afs");
                sb.append("&encode(").append(this.streamNumber).append(").quality=").append(this.quality).append("k");
                sb.append("&encode(").append(this.streamNumber).append(").framerate=");
                sb.append(this.cameraFramerate);
                StringBuilder url = new StringBuilder("/api/param?encode(" + this.streamNumber + ").quality&encode(" + this.streamNumber + ").framesize");
                String cameraValues = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)true));
                String frameSizeOnCamera = jvcCameraSrv.readCameraValues(cameraValues, "encode(" + this.streamNumber + ").framesize");
                String qualityOnCamera = jvcCameraSrv.readCameraValues(cameraValues, "encode(" + this.streamNumber + ").quality");
                if (!frameSizeOnCamera.equals(this.width + "x" + this.height) || !qualityOnCamera.equals(this.quality + "k")) {
                    this.settingsChanged = true;
                }
            }
            if (!framerateOnlyChanged) {
                sb.append("&encode(").append(this.streamNumber).append(").status=save");
            }
        }
        if (entityType == 210315L) {
            allowedFramerates = new float[]{1.0f, 2.0f, 3.0f, 5.0f, 7.5f, 10.0f, 15.0f, 25.0f, 30.0f};
            this.cameraFramerate = Tools.convertToCameraValues(allowedFramerates, (float)(this.fps / 1000L));
            String framerateString = "" + this.cameraFramerate;
            framerateString = framerateString.replace(".0", "");
            if (this.videoCodec == Codec.H264) {
                sb.append("&encode(").append(this.streamNumber).append(").type=h264high");
                sb.append("&encode(").append(this.streamNumber).append(").framerate=");
                sb.append(framerateString);
                int[] validBitrateValues = new int[]{65536, 131072, 262144, 393216, 524288, 786432, 0x100000, 0x180000, 0x200000, 0x300000, 0x380000, 0x400000, 8000000};
                this.bandwidth = Tools.convertToCameraValues(validBitrateValues, this.bandwidth);
                sb.append("&encode(").append(this.streamNumber).append(").cbr_mode=cbr");
                sb.append("&encode(").append(this.streamNumber).append(").bitrate=").append(this.bandwidth);
                int[] validIFrameDistances = new int[]{5, 10, 15, 30, 60, 90, 120};
                int gopLength = Tools.convertIFrameDistMStoFrameCount((int)(this.cameraFramerate * 1000.0f), this.iFrameDistMS, 5, 120);
                int gopLengthForCamera = Tools.convertToCameraValues(validIFrameDistances, gopLength);
                sb.append("&encode(").append(this.streamNumber).append(").iframeinterval=").append(gopLengthForCamera);
                StringBuilder url = new StringBuilder("/api/param?encode(" + this.streamNumber + ").framerate&encode(" + this.streamNumber + ").framesize");
                url.append("&encode(").append(this.streamNumber).append(").cbr_mode&encode(").append(this.streamNumber).append(").bitrate&encode(").append(this.streamNumber).append(").iframeinterval");
                String cameraValues = null;
                try {
                    cameraValues = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)true));
                }
                catch (SeeTecException ex) {
                    this.logger.warn("Exception while reading camera configuration for " + this + " : " + ex.getMessage());
                }
                String framerateOnCamera = jvcCameraSrv.readCameraValues(cameraValues, "encode(" + this.streamNumber + ").framerate");
                String frameSizeOnCamera = jvcCameraSrv.readCameraValues(cameraValues, "encode(" + this.streamNumber + ").framesize");
                String cbrmodeOnCamera = jvcCameraSrv.readCameraValues(cameraValues, "encode(" + this.streamNumber + ").cbr_mode");
                String bitrateOnCamera = jvcCameraSrv.readCameraValues(cameraValues, "encode(" + this.streamNumber + ").bitrate");
                String iframeintervalOnCamera = jvcCameraSrv.readCameraValues(cameraValues, "encode(" + this.streamNumber + ").iframeinterval");
                if (!((framerateOnCamera.equals(this.cameraFramerate + "") || (framerateOnCamera + ".0").equals(this.cameraFramerate + "")) && frameSizeOnCamera.equals(jvcCameraSrv.getResolutionString(this.width, this.height)) && cbrmodeOnCamera.equals("cbr") && bitrateOnCamera.equals(this.bandwidth + "") && iframeintervalOnCamera.equals(gopLengthForCamera + ""))) {
                    this.settingsChanged = true;
                    if (!framerateOnCamera.equals(this.cameraFramerate + "") && !(framerateOnCamera + ".0").equals(this.cameraFramerate + "") && frameSizeOnCamera.equals(jvcCameraSrv.getResolutionString(this.width, this.height)) && cbrmodeOnCamera.equals("cbr") && bitrateOnCamera.equals(this.bandwidth + "") && iframeintervalOnCamera.equals(gopLengthForCamera + "")) {
                        framerateOnlyChanged = true;
                    }
                }
            } else {
                int[] allowedValues;
                this.quality = 100000 - this.quality;
                if (this.width == 1920) {
                    allowedValues = new int[]{80, 120, 160, 200, 240, 280, 320};
                    this.quality = Tools.convertToCameraValues(allowedValues, this.quality / 313);
                } else if (this.width == 1280) {
                    allowedValues = new int[]{60, 80, 100, 120, 140, 160, 180};
                    this.quality = Tools.convertToCameraValues(allowedValues, this.quality / 555);
                } else if (this.width == 640) {
                    allowedValues = new int[]{15, 20, 25, 30, 40, 60, 80};
                    this.quality = Tools.convertToCameraValues(allowedValues, this.quality / 1250);
                } else {
                    allowedValues = new int[]{5, 7, 8, 10, 13, 20, 27};
                    this.quality = Tools.convertToCameraValues(allowedValues, this.quality / 3704);
                }
                sb.append("&encode(").append(this.streamNumber).append(").type=jpeg&encode(").append(this.streamNumber).append(").cbr_mode=afs");
                sb.append("&encode(").append(this.streamNumber).append(").quality=").append(this.quality).append("k");
                sb.append("&encode(").append(this.streamNumber).append(").framerate=");
                sb.append(framerateString);
                StringBuilder url = new StringBuilder("/api/param?encode(" + this.streamNumber + ").quality&encode(" + this.streamNumber + ").framesize");
                String cameraValues = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)true));
                String frameSizeOnCamera = jvcCameraSrv.readCameraValues(cameraValues, "encode(" + this.streamNumber + ").framesize");
                String qualityOnCamera = jvcCameraSrv.readCameraValues(cameraValues, "encode(" + this.streamNumber + ").quality");
                if (!frameSizeOnCamera.equals(jvcCameraSrv.getResolutionString(this.width, this.height)) || !qualityOnCamera.equals(this.quality + "k")) {
                    this.settingsChanged = true;
                }
            }
            if (!framerateOnlyChanged) {
                sb.append("&encode(").append(this.streamNumber).append(").status=save");
            }
        } else if (entityType == 210314L) {
            sb.append(((JVCCameraSrv)this.getVideoSrv()).getParametersT16(this.networkParameter));
        }
        return sb.toString();
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        int indexCommentSegment;
        byte[] contentData = httpServerPushContent.getContentBody();
        if (this.getVideoSrv().getEntityType() == 210314L && (indexCommentSegment = Basic.indexOfByteArray((byte[])contentData, (byte[])this.FFFE, (int)0)) >= 0) {
            int pointerResult = indexCommentSegment + 235;
            int pointerEnabled = indexCommentSegment + 228;
            if (contentData.length >= pointerResult) {
                if (contentData[pointerEnabled] != 49 && !this.messageSent) {
                    this.logger.error("Motion Detection on camera is disabled for " + this.getVideoSrv().getEntityName());
                    this.logger.error("Activate Motion Detection on camera or disable Motion Detection in Seetec for " + this.getVideoSrv().getEntityName());
                    this.messageSent = true;
                }
                if (contentData[pointerResult] == 49) {
                    this.processMotionDetection();
                }
            }
        }
        try {
            MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MJPEG, httpServerPushContent.getContentBody(), false);
            this.deliverFrameCreateServerTimestamp(0, mediaFrame);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while creating and delivering media frame for " + this + " : " + ex.getMessage() + " , error code: " + ex.getErrorCode());
        }
    }

    private int processMotionDetection() {
        if (this.getVideoSrv() != null && this.getVideoSrv().getHardwareMotionDetection() != null) {
            ((JVCHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).evaluateWindow(0);
        }
        return 0;
    }

    private class AudioHandler
    extends StreamingVideoSourceClientRTSP.AudioSourceClient
    implements HttpStreamListenerIntf,
    Runnable,
    HttpServerPushListenerIntf {
        private boolean isShutdown;
        private boolean headerRemoved;
        private byte[] data;
        private HttpServerPushHandler httpServerPushHandlerAudio;

        public AudioHandler(RTSPHandlerIntf callback) {
            super(callback);
            this.isShutdown = false;
        }

        @Override
        public void run() {
            if (JVCVideoSourceClient.this.getVideoSrv().getEntityType() == 210314L) {
                String url = "/cgi-bin/getstreamaudio_ie.cgi";
                this.httpServerPushHandlerAudio = new HttpServerPushHandler();
                if ((JVCVideoSourceClient.this.errorCode = this.httpServerPushHandlerAudio.init(this, JVCVideoSourceClient.this.networkParameter, url)) != 0) {
                    JVCVideoSourceClient.this.logger.error("Exception while initializing HTTP stream handler for " + this + " Error: " + JVCVideoSourceClient.this.errorCode);
                }
                if ((JVCVideoSourceClient.this.errorCode = this.httpServerPushHandlerAudio.startServerPush(true)) != 0) {
                    JVCVideoSourceClient.this.logger.error("Exception while starting HTTP reading for " + this + " Error: " + JVCVideoSourceClient.this.errorCode);
                }
            } else {
                String url = "/api/audio?lowdelay=1";
                JVCVideoSourceClient.this.httpStreamHandler = new HttpStreamHandler();
                if ((JVCVideoSourceClient.this.errorCode = JVCVideoSourceClient.this.httpStreamHandler.init(this, JVCVideoSourceClient.this.networkParameter, url)) != 0) {
                    JVCVideoSourceClient.this.logger.error("Exception while initializing HTTP stream handler for " + this + " Error: " + JVCVideoSourceClient.this.errorCode);
                }
                if ((JVCVideoSourceClient.this.errorCode = JVCVideoSourceClient.this.httpStreamHandler.startServerPush(true)) != 0) {
                    JVCVideoSourceClient.this.logger.error("Exception while starting HTTP reading for " + this + " Error: " + JVCVideoSourceClient.this.errorCode);
                }
            }
        }

        @Override
        public boolean isShutdown() {
            return this.isShutdown;
        }

        @Override
        public void deliverRawContent(byte[] inputData) {
            if (inputData == null) {
                JVCVideoSourceClient.this.logger.warn("Audio data is null for " + this);
                return;
            }
            this.data = this.data == null ? inputData : ArrayUtils.addAll((byte[])this.data, (byte[])inputData);
            if (!this.headerRemoved) {
                this.data = this.removeHTTPHeader(this.data);
                this.headerRemoved = true;
            }
            while (this.data.length > 524) {
                try {
                    byte[] temp = ArrayUtils.subarray((byte[])this.data, (int)12, (int)524);
                    this.data = ArrayUtils.subarray((byte[])this.data, (int)524, (int)this.data.length);
                    MediaFrame mediaFrame = StreamingHelper.createSeeTecAudioFrameHeader(JVCVideoSourceClient.this.audioCodec, JVCVideoSourceClient.this.audioBitrate % 8000 == 0 ? (int)(JVCVideoSourceClient.this.audioBitrate / 8000) : 0, temp);
                    JVCVideoSourceClient.this.deliverFrameCreateServerTimestamp(16, mediaFrame);
                }
                catch (Throwable t) {
                    JVCVideoSourceClient.this.logger.error("Ignoring packet due to unexpected error: " + t.getMessage(), t);
                }
            }
        }

        @Override
        public void notifyForNetworkProblems() {
            this.sendStatusService(-21603);
            JVCVideoSourceClient.this.listener.notifyForNetworkProblems();
            this.shutdown();
        }

        private byte[] removeHTTPHeader(byte[] data) {
            int index = Basic.indexOfByteArray((byte[])data, (byte[])SSLConstantsIntf.DOUBLE_CRLF_BYTE, (int)0);
            if (index < 0) {
                JVCVideoSourceClient.this.logger.warn("Could not remove HTTP header from data ");
                return data;
            }
            byte[] dataWithoutHeader = new byte[data.length - index - SSLConstantsIntf.DOUBLE_CRLF_BYTE.length];
            System.arraycopy(data, index + SSLConstantsIntf.DOUBLE_CRLF_BYTE.length, dataWithoutHeader, 0, dataWithoutHeader.length);
            return dataWithoutHeader;
        }

        @Override
        public void deliverContent(HttpServerPushContent httpServerPushContent) {
            try {
                if (httpServerPushContent == null) {
                    JVCVideoSourceClient.this.logger.warn("Audio data is null for " + this);
                    return;
                }
                byte[] httpServerPushBody = httpServerPushContent.getContentBody();
                byte[] data = Arrays.copyOfRange(httpServerPushBody, 36, httpServerPushBody.length);
                MediaFrame mediaFrame = StreamingHelper.createSeeTecAudioFrameHeader(JVCVideoSourceClient.this.audioCodec, JVCVideoSourceClient.this.audioBitrate % 8000 == 0 ? (int)(JVCVideoSourceClient.this.audioBitrate / 8000) : 0, data);
                JVCVideoSourceClient.this.deliverFrameCreateServerTimestamp(16, mediaFrame);
            }
            catch (SeeTecException ex) {
                JVCVideoSourceClient.this.logger.error("Exception while creating and delivering audio frame for " + this + " : " + ex.getMessage() + " , error code: " + ex.getErrorCode());
            }
        }
    }
}

