/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.jvc;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class JVCIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.jvc.JVCIOHandler";
    private Socket socket = null;
    private InputStream is = null;
    private boolean isNetworkProblemSignaled = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        int[] nInputValues = new int[super.getHighestInputNumber()];
        this.port = 32040;
        super.setRunFinished(CLASS_NAME, false);
        try {
            while (true) {
                if (this.isShutdown(CLASS_NAME)) {
                    super.setRunFinished(CLASS_NAME, true);
                    this.shutdown();
                    return;
                }
                try {
                    this.socket = new Socket(this.host, 32040);
                    this.socket.setSoTimeout(5000);
                    this.is = this.socket.getInputStream();
                    this.isNetworkProblemSignaled = false;
                    while (!this.isShutdown(CLASS_NAME) && !this.isNetworkProblemSignaled) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception ex) {
                            this.logger.error("Problem while sleeping: " + ex, (Throwable)ex);
                        }
                        try {
                            byte[] buffer = new byte[4096];
                            int len = -1;
                            try {
                                len = this.is.read(buffer);
                                if (len < 0) {
                                }
                            }
                            catch (SocketTimeoutException ste) {}
                            break;
                            byte[] result = new byte[len];
                            System.arraycopy(buffer, 0, result, 0, result.length);
                            String[] splittedResult = new String(result).split("\r\n");
                            for (int i = 0; i < splittedResult.length; ++i) {
                                int status;
                                int pos = -1;
                                String searchString = "peripheral.input_pin.pin(";
                                pos = splittedResult[i].indexOf(searchString);
                                if (pos == -1) continue;
                                int pin = Integer.parseInt(splittedResult[i].substring(pos + searchString.length(), splittedResult[i].indexOf(")")));
                                nInputValues[--pin] = status = splittedResult[i].substring(splittedResult[i].indexOf("=") + 1).equalsIgnoreCase("break") ? 0 : 1;
                            }
                            DigitalInputSrv[] iServices = super.getDigitalInputSrv();
                            for (int i = 0; i < iServices.length; ++i) {
                                iServices[i].checkInput(nInputValues);
                            }
                        }
                        catch (Throwable t) {
                            if (this.isShutdown(CLASS_NAME)) continue;
                            this.logger.warn("Exception for " + this.device.toString(), t);
                            break;
                        }
                    }
                }
                catch (Throwable ex) {
                    this.logger.error("Error accessing: " + this.host + ":" + this.port + "  for " + this.device.toString() + ". Message: " + ex.getMessage());
                    try {
                        Thread.sleep(7000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    if (this.socket == null) continue;
                    this.socket.close();
                    this.socket = null;
                }
                catch (IOException ioex) {
                    this.logger.error("Error closing port: " + this.host + ":" + this.port + " for " + this.device.toString(), (Throwable)ioex);
                }
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Exception for " + this.device.toString());
            this.logger.fatal((Object)ex, ex);
            this.shutdown();
        }
    }

    @Override
    public int writeDigitalOutput(int nNumber, int value, long holdTime) {
        int errorCode = 0;
        StringBuilder url = new StringBuilder();
        if (this.device.getDeviceType() == 200315L) {
            try {
                IOHandler.HoldTimer holdTimer;
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Writing value [" + value + "] to output [" + nNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
                }
                url = new StringBuilder("/cgi-bin/setup.cgi");
                String body = "loadhtml=alarmenvironment.html&test" + nNumber + "make=" + nNumber + "make";
                if (value == 0) {
                    body = "loadhtml=alarmenvironment.html&test" + nNumber + "break=" + nNumber + "break";
                }
                NetworkHelper.readPostRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (String)body);
                if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(nNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                    holdTimer.shutdown();
                    this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
                }
                return 0;
            }
            catch (SeeTecException sex) {
                this.logger.error((Object)sex, (Throwable)sex);
                return sex.getErrorCode();
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
                return -21600;
            }
        }
        try {
            IOHandler.HoldTimer holdTimer;
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Writing value [" + value + "] to output [" + nNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
            }
            if (value == 0) {
                url.append("/api/param?application.event(1).action=pinout/m");
            } else {
                url.append("/api/param?application.event(1).action=pinout/b");
            }
            url.append(nNumber);
            url.append("/0");
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString());
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(nNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
            }
            return 0;
        }
        catch (SeeTecException sex) {
            this.logger.error((Object)sex, (Throwable)sex);
            return sex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }
}

