/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.jvc;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.AdditionalVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.jvc.JVCCameraControl;
import de.seetec.v5.re.cm.device.video.jvc.JVCVideoSourceClient;
import de.seetec.v5.re.cm.device.video.jvc.jpeg.JVCJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.jvc.jpeg.JVCJPEGVideoSourceClient_C655;
import de.seetec.v5.re.cm.device.video.jvc.mpeg.JVCMPEGVideoSourceClient;
import de.seetec.v5.re.shared.CnfDeviceCaptureMode;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.HashMap;
import java.util.Map;

public class JVCCameraSrv
extends LiveCameraSrv {
    private final Object SEMAPHORE = new Object();
    private int streamNumber = 1;
    private final Map<Integer, Integer> streams = new HashMap<Integer, Integer>();
    private volatile boolean hasMotionDetectionStream = false;

    @Override
    public CameraControl createCameraControl(Long nEntityType) {
        return new JVCCameraControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        VideoSourceClient videoSourceClient = null;
        try {
            this.logger.info("StreamingMode for " + this + " is [" + this.getVideoSourceCnf().getMediaCodec() + "]");
            long entityType = super.getEntityType();
            if (entityType == 210308L) {
                videoSourceClient = new JVCJPEGVideoSourceClient_C655();
            } else if (entityType == 210312L || entityType == 210313L) {
                videoSourceClient = new JVCVideoSourceClient();
                Object object = this.SEMAPHORE;
                synchronized (object) {
                    if (this.streams.get(listener.getDynamicVideoProfileID()) == null) {
                        this.streams.put(listener.getDynamicVideoProfileID(), this.streamNumber);
                        ++this.streamNumber;
                    }
                }
            } else if (entityType == 210314L) {
                videoSourceClient = new JVCVideoSourceClient();
                Object object = this.SEMAPHORE;
                synchronized (object) {
                    if (this.streams.get(listener.getDynamicVideoProfileID()) == null) {
                        if (this.getAdditionalVideoProfileHandler() == null || this.getAdditionalVideoProfileHandler().length == 0) {
                            this.streams.put(listener.getDynamicVideoProfileID(), 1);
                        } else {
                            VideoProfileHandler videoProfileHandler1 = this.getBasicVideoProfileHandler();
                            VideoProfileHandler videoProfileHandler2 = this.getAdditionalVideoProfileHandler()[0];
                            if (videoProfileHandler1.getVideoSourceParameter().getImageSize()[0] == 1280) {
                                this.streams.put(videoProfileHandler1.getDynamicVideoProfileID(), 1);
                                this.streams.put(videoProfileHandler2.getDynamicVideoProfileID(), 2);
                            } else if (videoProfileHandler2.getVideoSourceParameter().getImageSize()[0] == 1280) {
                                this.streams.put(videoProfileHandler2.getDynamicVideoProfileID(), 1);
                                this.streams.put(videoProfileHandler1.getDynamicVideoProfileID(), 2);
                            } else {
                                this.streams.put(videoProfileHandler1.getDynamicVideoProfileID(), 1);
                                this.streams.put(videoProfileHandler2.getDynamicVideoProfileID(), 2);
                            }
                        }
                    }
                }
            } else if (entityType == 210315L) {
                videoSourceClient = new JVCVideoSourceClient();
                Object object = this.SEMAPHORE;
                synchronized (object) {
                    if (this.streams.get(listener.getDynamicVideoProfileID()) == null) {
                        if (this.getAdditionalVideoProfileHandler() == null || this.getAdditionalVideoProfileHandler().length == 0) {
                            this.streams.put(listener.getDynamicVideoProfileID(), 1);
                        } else {
                            VideoProfileHandler videoProfileHandler1 = this.getBasicVideoProfileHandler();
                            VideoProfileHandler videoProfileHandler2 = this.getAdditionalVideoProfileHandler()[0];
                            if (videoProfileHandler1.getVideoSourceParameter().getImageSize()[0] >= videoProfileHandler2.getVideoSourceParameter().getImageSize()[0]) {
                                this.streams.put(videoProfileHandler1.getDynamicVideoProfileID(), 1);
                                this.streams.put(videoProfileHandler2.getDynamicVideoProfileID(), 2);
                            } else {
                                this.streams.put(videoProfileHandler1.getDynamicVideoProfileID(), 2);
                                this.streams.put(videoProfileHandler2.getDynamicVideoProfileID(), 1);
                            }
                        }
                    }
                    this.setResolutions();
                }
            } else {
                videoSourceClient = this.getVideoSourceCnf().getMediaCodec() == Codec.MPEG4 ? new JVCMPEGVideoSourceClient() : new JVCJPEGVideoSourceClient();
            }
            errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            if (seetecEx.getErrorCode() == -21657) {
                throw new SeeTecException(-21657, "Unauthorized access for " + this);
            }
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    public String readCameraValues(String cameraValues, String parameterName) {
        if (cameraValues == null) {
            return "";
        }
        String[] parameterLines = cameraValues.split("\r\n");
        if (parameterLines.length > 1) {
            for (int i = 0; i < parameterLines.length; ++i) {
                String parameterLine = parameterLines[i];
                String[] parameter = parameterLine.split("=");
                if (parameter.length <= 1 || !parameter[0].equals(parameterName)) continue;
                String value = parameter[1].substring(0, parameter[1].indexOf("&"));
                return value;
            }
        }
        return "";
    }

    public int getStreamNumber(int dynamicVideoProfileID) {
        return this.streams.get(dynamicVideoProfileID);
    }

    public String getResolutionString(int width, int height) {
        long entityType = super.getEntityType();
        if (entityType == 210315L) {
            if (width == 1280 && height == 960) {
                return "quadvga";
            }
            if (width == 640 && height == 480) {
                return "vga";
            }
            if (width == 320 && height == 240) {
                return "qvga";
            }
            return width + "x" + height;
        }
        if (width == 720) {
            return "d1";
        }
        if (width == 704) {
            return "4cif";
        }
        if (width == 640) {
            return "vga";
        }
        if (width == 352) {
            return "cif";
        }
        if (width == 320) {
            return "qvga";
        }
        return width + "x" + height;
    }

    String getParametersT16(NetworkParameter networkParameter) {
        String urlString;
        VideoProfileHandler videoProfileHandler;
        Integer firstStream = this.streams.get(this.getBasicVideoProfileHandler().getDynamicVideoProfileID());
        StringBuilder url = new StringBuilder();
        if (firstStream != null) {
            videoProfileHandler = this.getBasicVideoProfileHandler();
            url.append(this.getStreamParameters(firstStream, videoProfileHandler, networkParameter));
        }
        if (this.getAdditionalVideoProfileHandler() != null && this.getAdditionalVideoProfileHandler().length > 0) {
            Integer secondStream = this.streams.get(this.getAdditionalVideoProfileHandler()[0].getDynamicVideoProfileID());
            if (secondStream != null) {
                videoProfileHandler = this.getAdditionalVideoProfileHandler()[0];
                url.append(this.getStreamParameters(secondStream, videoProfileHandler, networkParameter));
            }
        } else {
            String urlCheckStreamOff = "/api/param?encode(2).type";
            try {
                String cameraValues = new String(NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)urlCheckStreamOff, (int)Integer.MAX_VALUE, (boolean)true));
                String streamType = this.readCameraValues(cameraValues, "encode(2).type");
                if (!streamType.equals("off")) {
                    url.append("&encode(2).type=off");
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while getting stream information for " + this + " : " + ex.getMessage());
            }
        }
        if (!url.toString().isEmpty()) {
            url.append("&encode.status=save");
        }
        if ((urlString = url.toString()).contains("1280x720") && urlString.contains("vga")) {
            urlString = urlString.replace("vga", "640x360");
        }
        return urlString;
    }

    private String getStreamParameters(int streamNumber, VideoProfileHandler videoProfileHandler, NetworkParameter networkParameter) {
        StringBuilder sb = new StringBuilder();
        boolean settingsChanged = false;
        try {
            long fps = videoProfileHandler.getFramerate();
            CnfDeviceCaptureMode cnfDeviceCaptureMode = this.getDevice().getDeviceCnf().getCaptureMode();
            int width = videoProfileHandler.getVideoSourceParameter().getImageSize()[0];
            int height = videoProfileHandler.getVideoSourceParameter().getImageSize()[1];
            if (cnfDeviceCaptureMode.getDisplayResolution().equals("720p") && this.getAdditionalVideoProfileHandler().length > 0) {
                VideoProfileHandler basic = this.getBasicVideoProfileHandler();
                VideoProfileHandler additional = this.getAdditionalVideoProfileHandler()[0];
                if (basic.getVideoSourceParameter().getImageSize()[0] != 1280 && additional.getVideoSourceParameter().getImageSize()[0] == 640) {
                    if (videoProfileHandler instanceof AdditionalVideoProfileHandler) {
                        this.logger.warn("Cannot set VGA Resolution for " + videoProfileHandler.getVideoProfileName() + " . Setting 4CIF instead");
                        width = 720;
                        height = 576;
                    }
                } else if (additional.getVideoSourceParameter().getImageSize()[0] != 1280 && basic.getVideoSourceParameter().getImageSize()[0] == 640 && videoProfileHandler instanceof BasicVideoProfileHandler) {
                    this.logger.warn("Cannot set VGA Resolution for " + videoProfileHandler.getVideoProfileName() + " . Setting 4CIF instead");
                    width = 720;
                    height = 576;
                }
            }
            int bandwidth = videoProfileHandler.getVideoSourceParameter().getBandWidth();
            int iFrameDistMS = videoProfileHandler.getVideoSourceParameter().getIFrameDistance();
            int quality = videoProfileHandler.getVideoSourceParameter().getQuality();
            Codec videoCodec = videoProfileHandler.getVideoSourceParameter().getMediaCodec();
            int framerate = (int)(fps / 1000L);
            framerate = framerate < 4 ? 4 : framerate;
            framerate = framerate > 25 ? 25 : framerate;
            String resolutionString = this.getResolutionString(width, height);
            sb.append("&encode(").append(streamNumber).append(").framesize=");
            sb.append(resolutionString);
            sb.append("&encode(").append(streamNumber).append(").framerate=");
            sb.append(framerate);
            if (videoCodec == Codec.H264) {
                int[] validBitrateValues = new int[]{256000, 512000, 1000000, 2000000, 3000000, 4000000, 6000000, 8000000};
                bandwidth = this.convertToCameraValues(validBitrateValues, bandwidth);
                sb.append("&encode(").append(streamNumber).append(").type=h264high");
                sb.append("&encode(").append(streamNumber).append(").cbr_mode=cbr");
                sb.append("&encode(").append(streamNumber).append(").bitrate=").append(bandwidth);
                int gopLength = this.convertIFrameDistMStoFrameCount((long)framerate * 1000L, iFrameDistMS, 1, 30);
                gopLength = gopLength > 2 * framerate ? 2 * framerate : gopLength;
                gopLength = gopLength > 30 ? 30 : gopLength;
                sb.append("&encode(").append(streamNumber).append(").iframeinterval=").append(gopLength);
                StringBuilder url = new StringBuilder("/api/param?encode(" + streamNumber + ").framerate&encode(" + streamNumber + ").type&encode(" + streamNumber + ").framesize");
                url.append("&encode(").append(streamNumber).append(").cbr_mode&encode(").append(streamNumber).append(").bitrate&encode(").append(streamNumber).append(").iframeinterval");
                String cameraValues = new String(NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)true));
                String framerateOnCamera = this.readCameraValues(cameraValues, "encode(" + streamNumber + ").framerate");
                String frameSizeOnCamera = this.readCameraValues(cameraValues, "encode(" + streamNumber + ").framesize");
                String cbrmodeOnCamera = this.readCameraValues(cameraValues, "encode(" + streamNumber + ").cbr_mode");
                String bitrateOnCamera = this.readCameraValues(cameraValues, "encode(" + streamNumber + ").bitrate");
                String codecOnCamera = this.readCameraValues(cameraValues, "encode(" + streamNumber + ").type");
                String iframeintervalOnCamera = this.readCameraValues(cameraValues, "encode(" + streamNumber + ").iframeinterval");
                if (!((framerateOnCamera.equals(framerate + "") || (framerateOnCamera + ".0").equals(framerate + "")) && frameSizeOnCamera.equals(resolutionString) && codecOnCamera.contains("h264") && cbrmodeOnCamera.equals("cbr") && bitrateOnCamera.equals(bandwidth + "") && iframeintervalOnCamera.equals(gopLength + ""))) {
                    settingsChanged = true;
                }
            } else {
                quality = 100000 - quality;
                int lower = 0;
                int upper = 300;
                if (width == 1280) {
                    lower = 36;
                    upper = 300;
                } else if (width == 720) {
                    lower = 13;
                    upper = 112;
                } else if (width == 704) {
                    lower = 13;
                    upper = 110;
                } else if (width == 640) {
                    lower = 12;
                    upper = 100;
                } else if (width == 352) {
                    lower = 3;
                    upper = 27;
                } else if (width == 320) {
                    lower = 3;
                    upper = 25;
                }
                int divisor = 100000 / (upper - lower);
                quality = lower + quality / divisor;
                quality = quality < lower ? lower : quality;
                quality = quality > upper ? upper : quality;
                sb.append("&encode(").append(streamNumber).append(").type=jpeg");
                sb.append("&encode(").append(streamNumber).append(").quality=").append(quality).append("k");
                StringBuilder url = new StringBuilder("/api/param?encode(" + streamNumber + ").quality&encode(" + streamNumber + ").type&encode(" + streamNumber + ").quality&encode(" + streamNumber + ").framerate&encode(" + streamNumber + ").framesize");
                String cameraValues = new String(NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)true));
                String frameSizeOnCamera = this.readCameraValues(cameraValues, "encode(" + streamNumber + ").framesize");
                String frameRateOnCamera = this.readCameraValues(cameraValues, "encode(" + streamNumber + ").framerate");
                String qualityOnCamera = this.readCameraValues(cameraValues, "encode(" + streamNumber + ").quality").replace("k", "").replace("q", "");
                String codecOnCamera = this.readCameraValues(cameraValues, "encode(" + streamNumber + ").type");
                if (!(frameSizeOnCamera.equals(resolutionString) && this.isSimilar(Integer.parseInt(qualityOnCamera), quality) && codecOnCamera.contains("jpeg") && frameRateOnCamera.equals(framerate + ""))) {
                    settingsChanged = true;
                }
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Configuration exception while getting stream parameters for " + this);
        }
        catch (ConfigurationException ex) {
            this.logger.error("Configuration exception while getting stream parameters for " + this);
        }
        if (settingsChanged) {
            return sb.toString();
        }
        return "";
    }

    protected final int convertToCameraValues(int[] allowedValues, int valueToConvert) {
        int result = Integer.MIN_VALUE;
        for (int i = 0; i < allowedValues.length; ++i) {
            if (allowedValues[i] > valueToConvert) {
                if (i == 0) {
                    result = allowedValues[0];
                    break;
                }
                int middle = (allowedValues[i] + allowedValues[i - 1]) / 2;
                result = valueToConvert > middle ? allowedValues[i] : allowedValues[i - 1];
                break;
            }
            result = i == allowedValues.length - 1 ? allowedValues[allowedValues.length - 1] : valueToConvert;
        }
        return result;
    }

    protected final int convertIFrameDistMStoFrameCount(long fps, long iFrameDistMS, int min, int max) {
        int iFrameDistFrameCount = (int)(fps * iFrameDistMS) / 1000000;
        iFrameDistFrameCount = iFrameDistFrameCount < min ? min : iFrameDistFrameCount;
        iFrameDistFrameCount = iFrameDistFrameCount > max ? max : iFrameDistFrameCount;
        return iFrameDistFrameCount;
    }

    private boolean isSimilar(int a, int b) {
        return Math.abs(a - b) < 10;
    }

    public boolean hasMotionDetectionStream() {
        return this.hasMotionDetectionStream;
    }

    public void setHasMotionDetectionStream(boolean isMotionDetectionStream) {
        this.hasMotionDetectionStream = isMotionDetectionStream;
    }

    private void setResolutions() throws ConfigurationException, SeeTecException {
        String url = "/api/param?encode(2).type=off&encode(3).type=off&camera.status=save";
        if (this.streams.size() > 1) {
            int basicImageWidth = this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize()[0];
            int basicImageHeight = this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize()[1];
            int additionalImageWidth = this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getImageSize()[0];
            int additionalImageHeight = this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getImageSize()[1];
            url = basicImageWidth >= additionalImageWidth ? "/api/param?encode(1).framesize=" + this.getResolutionString(basicImageWidth, basicImageHeight) + "&encode(2).framesize=" + this.getResolutionString(additionalImageWidth, additionalImageHeight) + "&encode(1).status=save&encode(2).status=save" : "/api/param?encode(1).framesize=" + this.getResolutionString(additionalImageWidth, additionalImageHeight) + "&encode(2).framesize=" + this.getResolutionString(basicImageWidth, basicImageHeight) + "&encode(1).status=save&encode(2).status=save";
            url = url + "&encode(3).type=off&camera.status=save";
        }
        NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)url, (int)Integer.MAX_VALUE, (boolean)true);
    }
}

