/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.jvc;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.net.URLEncoder;
import java.util.Vector;

public class JVCCameraControl
extends CameraControl {
    private String previousCommand;

    private byte[] sendCameraCommand(String url) {
        try {
            boolean readContentLength = false;
            if (this.videoSrv.getEntityType() == 210315L) {
                readContentLength = true;
            }
            this.videoSrv.notifyForCameraControl();
            if (this.videoSrv.getEntityType() == 210308L) {
                if (url.equals(this.previousCommand)) {
                    return null;
                }
                this.previousCommand = url;
                return NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)readContentLength, (String)"No Content");
            }
            return NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)readContentLength);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return null;
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int TILT_TOLERANCE = 5000;
        int PAN_TOLERANCE = 5000;
        StringBuilder sb = new StringBuilder(256);
        int pan = 0;
        int tilt = 0;
        int zoom = 0;
        boolean somethingSet = false;
        if (this.videoSrv.getEntityType() == 210308L) {
            int speed;
            if (panSpeed != null) {
                this.previousPanSpeed = pan = panSpeed.intValue();
            } else {
                pan = this.previousPanSpeed;
            }
            if (tiltSpeed != null) {
                this.previousTiltSpeed = tilt = tiltSpeed.intValue();
            } else {
                tilt = this.previousTiltSpeed;
            }
            if (zoomSpeed != null) {
                this.previousZoomSpeed = zoom = zoomSpeed.intValue();
            } else {
                zoom = this.previousZoomSpeed;
            }
            sb.append("/SetPanTiltInfo.cgi?Speed=");
            if (panSpeed != null && tiltSpeed != null) {
                speed = 0;
                speed = Math.abs(pan) < 5000 && Math.abs(tilt) > 5000 ? Math.abs(tilt) / 14285 + 1 : (Math.abs(pan) > 5000 && Math.abs(tilt) < 5000 ? Math.abs(pan) / 14285 + 1 : (Math.abs(pan) + Math.abs(tilt)) / 28570 + 1);
                speed = speed < 1 ? 1 : speed;
                speed = speed > 7 ? 7 : speed;
                sb.append(speed);
            } else if (panSpeed != null) {
                speed = Math.abs(pan) / 14285 + 1;
                speed = speed < 1 ? 1 : speed;
                speed = speed > 7 ? 7 : speed;
                sb.append(speed);
            } else if (tiltSpeed != null) {
                speed = Math.abs(tilt) / 14285 + 1;
                speed = speed < 1 ? 1 : speed;
                speed = speed > 7 ? 7 : speed;
                sb.append(speed);
            }
            if (!(tiltSpeed == null && panSpeed == null || pan == 0 && tilt == 0)) {
                this.sendCameraCommand(sb.toString());
            }
            sb = new StringBuilder("/MotorControl.cgi?");
            if (Math.abs(pan) < 5000 && Math.abs(tilt) < 5000) {
                if (panSpeed != null) {
                    sb.append("&Pan=");
                    if (pan > 0) {
                        sb.append(2);
                    } else if (pan < 0) {
                        sb.append(1);
                    } else {
                        sb.append(0);
                    }
                }
                if (tiltSpeed != null) {
                    sb.append("&Tilt=");
                    if (tilt > 0) {
                        sb.append(2);
                    } else if (tilt < 0) {
                        sb.append(1);
                    } else {
                        sb.append(0);
                    }
                }
            } else {
                if (panSpeed != null) {
                    sb.append("&Pan=");
                    if (Math.abs(pan) > 5000) {
                        if (pan > 0) {
                            sb.append(2);
                        } else if (pan < 0) {
                            sb.append(1);
                        } else {
                            sb.append(0);
                        }
                    } else {
                        sb.append(0);
                    }
                }
                if (tiltSpeed != null) {
                    sb.append("&Tilt=");
                    if (Math.abs(tilt) > 5000) {
                        if (tilt > 0) {
                            sb.append(2);
                        } else if (tilt < 0) {
                            sb.append(1);
                        } else {
                            sb.append(0);
                        }
                    } else {
                        sb.append(0);
                    }
                }
            }
            if (zoomSpeed != null) {
                sb.append("&Zoom=");
                if (zoom > 0) {
                    sb.append(2);
                } else if (zoom < 0) {
                    sb.append(1);
                } else {
                    sb.append(0);
                }
            }
            if (panSpeed != null || tiltSpeed != null || zoomSpeed != null) {
                String url = sb.toString().replace("?&", "?");
                this.sendCameraCommand(url);
            }
            return 0;
        }
        sb.append("/api/param?");
        try {
            if (panSpeed != null) {
                somethingSet = true;
                pan = panSpeed / 200;
                if (pan != 0) {
                    if (pan <= 0) {
                        sb.append("camera.motion.pan.mode=left");
                    } else {
                        sb.append("camera.motion.pan.mode=right");
                    }
                    pan = Math.abs(pan);
                    pan = pan > 100 ? 100 : pan;
                    sb.append("&camera.motion.pan.speed=");
                    sb.append(pan);
                    sb.append("&camera.motion.pan.status=start");
                }
            }
            if (tiltSpeed != null && (tilt = tiltSpeed / 200) != 0) {
                if (somethingSet) {
                    sb.append("&");
                    somethingSet = true;
                }
                if (tilt <= 0) {
                    sb.append("camera.motion.tilt.mode=down");
                } else {
                    sb.append("camera.motion.tilt.mode=up");
                }
                tilt = Math.abs(tilt);
                tilt = tilt > 100 ? 100 : tilt;
                sb.append("&camera.motion.tilt.speed=");
                sb.append(tilt);
                sb.append("&camera.motion.tilt.status=start");
            }
            if (zoomSpeed != null && (zoom = zoomSpeed / 200) != 0) {
                if (somethingSet) {
                    sb.append("&");
                }
                if (zoom < 0) {
                    sb.append("camera.motion.zoom.mode=out");
                } else {
                    sb.append("camera.motion.zoom.mode=in");
                }
                zoom = Math.abs(zoom);
                zoom = zoom > 100 ? 100 : zoom;
                sb.append("&camera.motion.zoom.speed=");
                sb.append(zoom);
                sb.append("&camera.motion.zoom.status=start");
            }
            if (pan != 0 || tilt != 0 || zoom != 0) {
                this.sendCameraCommand(sb.toString());
            }
            String stopCommand = null;
            if (panSpeed != null && pan <= 0) {
                stopCommand = "/api/param?camera.motion.pan.status=stop";
            }
            if (tiltSpeed != null && tilt <= 0) {
                stopCommand = stopCommand != null ? stopCommand + "&camera.motion.tilt.status=stop" : "/api/param?camera.motion.tilt.status=stop";
            }
            if (zoomSpeed != null && zoom <= 0) {
                stopCommand = stopCommand != null ? stopCommand + "&camera.motion.zoom.status=stop" : "/api/param?camera.motion.zoom.status=stop";
            }
            if (stopCommand != null) {
                this.sendCameraCommand(stopCommand);
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            this.sendCameraCommand("/api/param?camera.motion.clickoncenter=" + xPosition + "-" + yPosition);
            return 0;
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
            return 0;
        }
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousIris(Integer value) {
        if (this.videoSrv.getEntityType() == 210308L) {
            value = value > 0 ? 1 : value;
            value = value < 0 ? 2 : value;
            this.sendCameraCommand("MotorControl.cgi?Iris=" + value);
        } else {
            String scene = "";
            if (this.videoSrv.getEntityType() == 210315L) {
                scene = ".scene(0)";
            }
            int currentValue = 0;
            int newValue = 50;
            byte[] response = null;
            if (value != null) {
                this.sendCameraCommand("/api/param?camera" + scene + ".iris=manual");
                response = this.sendCameraCommand("/api/param?camera" + scene + ".iris");
                if (response != null) {
                    String[] lines = new String(response).split("\r\n");
                    for (int i = 0; i < lines.length; ++i) {
                        if (!lines[i].startsWith("camera" + scene + ".iris=")) continue;
                        String[] parts = lines[i].split("=");
                        currentValue = Integer.parseInt(parts[1].split("&")[0]);
                        break;
                    }
                }
                if (value != 0) {
                    newValue = value > 0 ? currentValue + 10 : currentValue - 10;
                    newValue = newValue > 99 ? 99 : newValue;
                    newValue = newValue < 1 ? 1 : newValue;
                    this.sendCameraCommand("/api/param?camera" + scene + ".iris=" + newValue);
                }
            }
        }
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        if (this.videoSrv.getEntityType() == 210308L) {
            this.sendCameraCommand("/SetLensInfo.cgi?IrisMode=" + (active != false ? 0 : 1));
        } else if (this.videoSrv.getEntityType() == 210315L) {
            this.sendCameraCommand("/api/param?camera.scene(0).iris=" + (active != false ? "autoM" : "manual"));
            this.sendCameraCommand("/api/param?camera.scene.status=save");
        } else {
            this.sendCameraCommand("/api/param?camera.iris=" + (active != false ? "autoM" : "manual"));
        }
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        if (value != null) {
            if (this.videoSrv.getEntityType() == 210308L) {
                value = value > 0 ? 2 : value;
                value = value < 0 ? 1 : value;
                this.sendCameraCommand("/MotorControl.cgi?Focus=" + value);
            } else if (value != 0) {
                if (value > 0) {
                    this.sendCameraCommand("/api/param?camera.focus=manual&camera.focus.mode=far&camera.focus.speed=5");
                } else {
                    this.sendCameraCommand("/api/param?camera.focus=manual&camera.focus.mode=near&camera.focus.speed=5");
                }
                this.sendCameraCommand("/api/param?camera.focus.status=start");
            } else {
                this.sendCameraCommand("/api/param?camera.focus.status=stop");
            }
        }
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (this.videoSrv.getEntityType() == 210308L) {
            if (active.booleanValue()) {
                this.sendCameraCommand("/SetLensInfo.cgi?FocusMode=2");
            } else {
                this.sendCameraCommand("/SetLensInfo.cgi?FocusMode=1");
            }
        } else if (active.booleanValue()) {
            this.sendCameraCommand("/api/param?camera.focus=op_auto");
            this.sendCameraCommand("/api/param?camera.image.true_daynight.af=on");
        } else {
            this.sendCameraCommand("/api/param?camera.focus=manual");
            this.sendCameraCommand("/api/param?camera.image.true_daynight.af=off");
        }
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        if (this.videoSrv.getEntityType() == 210308L) {
            this.sendCameraCommand("/SetBWInfo.cgi?BwMode=" + (active != false ? 1 : 0) + "IrLight=" + (active != false ? 0 : 1));
        } else if (this.videoSrv.getEntityType() == 210315L) {
            this.sendCameraCommand("/api/param?camera.scene(0).image.true_daynight=" + (active != false ? "bw" : "color"));
        } else {
            this.sendCameraCommand("/api/param?camera.image.true_daynight=" + (active != false ? "bw" : "color"));
        }
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        return 0;
    }

    @Override
    public int setHomePosition() {
        if (this.sendCameraCommand("/api/param?camera.position(0).status=goto") == null) {
            return -21600;
        }
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> vResult, Long presetID, String presetName) {
        int presetPosition = -1;
        String encodedPresetName = null;
        try {
            int i;
            byte[] vector = new byte[100];
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                vector[Integer.parseInt((String)presetCnf.getPresetPosition())] = 1;
            }
            for (i = 1; i <= 99; ++i) {
                if (vector[i] != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this + " :-(");
                return -21600;
            }
            encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
            this.presetList.addElement(presetCnf);
            vResult.addElement(presetCnf.getPresetCnf());
            if (this.videoSrv.getEntityType() == 210308L) {
                this.sendCameraCommand("/SetTblPos.cgi?TableNum=" + presetPosition + "&Title=" + encodedPresetName);
            } else {
                this.sendCameraCommand("/api/param?camera.position(" + presetPosition + ").comment=" + encodedPresetName);
                this.sendCameraCommand("/api/param?camera.position(" + presetPosition + ").status=save");
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Adding preset [" + presetName + "] failed :-(");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                if (this.videoSrv.getEntityType() == 210308L) {
                    this.sendCameraCommand("/MovMotorSetPos.cgi?TableNum=" + presetCnf.getPresetPosition());
                } else {
                    this.sendCameraCommand("/api/param?camera.position(" + presetCnf.getPresetPosition() + ").status=goto");
                }
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [" + presetName + "] failed :-(");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available :-(");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                this.presetList.removeElementAt(i);
                if (this.videoSrv.getEntityType() == 210308L) {
                    this.sendCameraCommand("/ClearTblPos.cgi?TableNum=" + presetCnf.getPresetPosition());
                } else {
                    this.sendCameraCommand("/api/param?camera.position(" + presetCnf.getPresetPosition() + ").status=initialize");
                }
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed :-(");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available :-(");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }
}

