/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.iqle;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.DoNothingCameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.iqle.IqleDevice;
import de.seetec.v5.re.cm.device.video.iqle.IqleVideoSourceClient;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class IqleCameraSrv
extends LiveCameraSrv {
    private static final int VIDEOSTANDARD = 1;
    private static final int CAPS = 2;
    private static final int VIDEOWIDGET = 3;
    private static final int TITLE = 4;
    private boolean isPal;
    private int streamNumber;
    private final Map<Integer, Integer> streams = new HashMap<Integer, Integer>();

    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new DoNothingCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        IqleVideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [VideoSourceClient] with VideoProfileHandler=" + listener + " ...");
        try {
            videoSourceClient = new IqleVideoSourceClient();
            int errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                if (errorCode == HTTPStatusCode.HTTP_NOT_FOUND.getStatusCode()) {
                    throw new SeeTecException(-21656, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                }
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    public int handleChannelParameters(int channelID, String title, boolean useTitle, boolean useDateTime, String resolution, NetworkParameter networkParameter, int videoProfileID) throws SeeTecException {
        String[] videoSystem = ((IqleDevice)this.device).getCaps(networkParameter, 1, "table.VideoStandard");
        if (videoSystem.length == 1 && videoSystem[0].toLowerCase().equals("pal")) {
            this.isPal = true;
        } else if (videoSystem.length == 1 && !videoSystem[0].toLowerCase().equals("pal")) {
            this.isPal = false;
        } else {
            this.logger.error("Error while getting video system configuration for " + this);
            throw new SeeTecException(-20100, "Could not retrieve video system configuration ");
        }
        String[] resolutionsSubstream = ((IqleDevice)this.device).getCaps(networkParameter, 2, "caps.caps[" + channelID + "].ExtraFormat[0].Video.ResolutionTypes");
        String[] resolutionsMainstream = ((IqleDevice)this.device).getCaps(networkParameter, 2, "caps.caps[" + channelID + "].MainFormat[0].Video.ResolutionTypes", false);
        for (String resolutionMainstream : resolutionsMainstream = this.subtract(resolutionsMainstream, resolutionsSubstream)) {
            if (!resolutionMainstream.toLowerCase().equals(resolution) && !resolutionMainstream.toLowerCase().contains("1080")) continue;
            this.streamNumber = 0;
        }
        for (String resolutionSubstream : resolutionsSubstream) {
            if (!resolutionSubstream.toLowerCase().equals(resolution)) continue;
            this.streamNumber = 1;
        }
        this.streams.put(videoProfileID, this.streamNumber);
        String[] channelEnable = ((IqleDevice)this.device).getCaps(networkParameter, 3, "table.VideoWidget[" + channelID + "].ChannelTitle.EncodeBlend");
        if (!useTitle) {
            if (channelEnable.length != 1 || !channelEnable[0].equals("false")) {
                NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)("/cgi-bin/configManager.cgi?action=setConfig&VideoWidget[" + channelID + "].ChannelTitle.EncodeBlend=false"), (int)Integer.MAX_VALUE);
            }
        } else {
            String[] channelTitle = ((IqleDevice)this.device).getCaps(networkParameter, 4, "table.ChannelTitle[" + channelID + "].Name");
            if (channelTitle.length != 1 || !channelTitle[0].equals(title)) {
                NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)("/cgi-bin/configManager.cgi?action=setConfig&ChannelTitle[" + channelID + "].Name=" + title), (int)Integer.MAX_VALUE);
            }
            if (channelEnable.length != 1 || !channelEnable[0].equals("true")) {
                NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)("/cgi-bin/configManager.cgi?action=setConfig&VideoWidget[" + channelID + "].ChannelTitle.EncodeBlend=true"), (int)Integer.MAX_VALUE);
            }
        }
        String[] dateTimeEnable = ((IqleDevice)this.device).getCaps(networkParameter, 3, "table.VideoWidget[" + channelID + "].TimeTitle.EncodeBlend", false);
        if (useDateTime) {
            if (dateTimeEnable.length != 1 || !dateTimeEnable[0].equals("true")) {
                NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)("/cgi-bin/configManager.cgi?action=setConfig&VideoWidget[" + channelID + "].TimeTitle.EncodeBlend=true"), (int)Integer.MAX_VALUE);
            }
        } else if (dateTimeEnable.length != 1 || !dateTimeEnable[0].equals("false")) {
            NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)("/cgi-bin/configManager.cgi?action=setConfig&VideoWidget[" + channelID + "].TimeTitle.EncodeBlend=false"), (int)Integer.MAX_VALUE);
        }
        return 0;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    public boolean isIsPal() {
        return this.isPal;
    }

    private String[] subtract(String[] supersets, String[] sets) {
        Vector<String> v = new Vector<String>();
        boolean foundDouble = false;
        for (String superset : supersets) {
            for (String set : sets) {
                if (!superset.equals(set)) continue;
                foundDouble = true;
            }
            if (!foundDouble) {
                v.add(superset);
            }
            foundDouble = false;
        }
        return v.toArray(new String[v.size()]);
    }

    public int getStreamNumber(int videoProfileID) {
        int streamNr = -1;
        if (this.streams.get(videoProfileID) != null) {
            streamNr = this.streams.get(videoProfileID);
        }
        return streamNr;
    }
}

