/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.iqinvision.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionDevice;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionMotionDetectionHandler;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class IQinVisionJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.iqinvision.jpeg.IQinVisionJPEGVideoSourceClient";
    private HttpServerPushHandler httpServerPushHandler = null;
    private boolean isServerPush = false;
    private StringBuilder sb = null;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        try {
            int errorCode = 0;
            this.logger.info("init started for" + this.getVideoSrv());
            errorCode = super.init(false);
            if (errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
                return errorCode;
            }
            this.sb = new StringBuilder("/now.jpg?snap=spush&pragma=motion");
            this.compression = (100000 - (this.compression + 999)) / 1000;
            this.compression = this.compression > 90 ? 90 : this.compression;
            this.compression = this.compression < 13 ? 13 : this.compression;
            try {
                this.highestFramerate /= 1000L;
                this.highestFramerate = this.highestFramerate < 1L ? 1L : this.highestFramerate;
                String fps = "";
                String sFrameEverySecond = "" + this.highestFramerate;
                fps = sFrameEverySecond.length() > 5 ? sFrameEverySecond.substring(0, 5) : sFrameEverySecond;
                String setCompression = "/set.oid?OidTR1.2.7=" + this.compression;
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)setCompression, (int)Integer.MIN_VALUE);
                String setFramerate = "/set.oid?OidTR1.2.31=%22" + fps + "%22";
                if (this.getVideoSrv().getDevice().getDeviceType() == 201325L || this.getVideoSrv().getDevice().getDeviceType() == 201324L || this.getVideoSrv().getDevice().getDeviceType() == 201323L) {
                    float[] cameraFramerates = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 7.5f, 10.0f, 15.0f, 30.0f};
                    fps = "" + Tools.convertToCameraValues(cameraFramerates, (float)this.highestFramerate);
                    fps = fps.replace(".0", "");
                    setFramerate = "/set.oid?OidTR1.17.2.4=%22" + fps + "%22";
                }
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)setFramerate, (int)Integer.MIN_VALUE);
                if (((IQinVisionDevice)this.getVideoSrv().getDevice()).rotateImageOnCamera(this.networkParameter)) {
                    String setRotation = "/set.oid?OidTR1.2.4=" + (this.getRotationAngle() == 0 ? "none" : "180");
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)setRotation, (int)Integer.MAX_VALUE);
                }
            }
            catch (SeeTecException e) {
                this.logger.error("Error while setting values " + this.getVideoSrv());
                return e.getErrorCode();
            }
            catch (Exception e) {
                this.logger.error("Error while setting values " + this.getVideoSrv());
                return -21601;
            }
            try {
                byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/get.oid?1.17.6", (int)Integer.MAX_VALUE);
                if (new String(result).contains("enabled")) {
                    this.logger.info("Device H.264 capable. So use modes for JPEG and not downsampling.");
                    StringBuilder mode = new StringBuilder("/set.oid?OidSB1.17.2.6=");
                    if (this.height == 1080) {
                        mode.append("mode5");
                    } else if (this.height == 720) {
                        mode.append("mode2");
                    } else if (this.height == 480) {
                        mode.append("mode9");
                    } else if (this.height == 240) {
                        mode.append("mode11");
                    }
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)mode.toString(), (int)Integer.MIN_VALUE);
                } else if (this.resolutionTag != null && !this.resolutionTag.trim().toLowerCase().equals("default")) {
                    this.sb.append("&");
                    this.sb.append(this.resolutionTag);
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Error while requesting H.264 capability for " + this.getVideoSrv() + ": " + ex.getMessage());
                return ex.getErrorCode();
            }
            catch (Exception e) {
                this.logger.error("Error while requesting H.264 capability for " + this.getVideoSrv());
                return -21601;
            }
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return errorCode;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        int errorCode = 0;
        try {
            boolean bAsynchronous = false;
            this.isServerPush = this.hasMotionDataStream(this.networkParameter);
            this.httpServerPushHandler = new HttpServerPushHandler();
            this.networkParameter.setSoTimeout(5000);
            errorCode = this.httpServerPushHandler.init(this, this.networkParameter, this.sb.toString());
            if (errorCode != 0) {
                this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
            } else {
                this.httpServerPushHandler.startServerPush(bAsynchronous);
            }
            if (this.httpServerPushHandler != null) {
                this.httpServerPushHandler.shutdown();
            }
        }
        catch (Throwable e) {
            this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed :-(", e);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        String header;
        byte[] contentData = httpServerPushContent.getContentBody();
        if (contentData.length > 0) {
            super.deliverContent(httpServerPushContent);
        }
        if (!this.isServerPush && (header = httpServerPushContent.getContentHeader()) != null && this.getVideoSrv().getHardwareMotionDetection() != null) {
            ((IQinVisionMotionDetectionHandler)((IQinVisionHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler()).deliverContent(httpServerPushContent);
        }
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        super.getListener().sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.shutdown();
    }

    public boolean hasMotionDataStream(NetworkParameter networkParameter) {
        try {
            NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/now.motiondata", (int)200);
        }
        catch (SeeTecException ex) {
            if (ex.getNetworkStatus() == HTTPStatusCode.HTTP_NOT_FOUND) {
                return false;
            }
            this.logger.error("Exception while testing motion detection capability for " + ex.getMessage());
        }
        return true;
    }
}

