/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.iqinvision;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import org.apache.logging.log4j.LogManager;

public class IQinVisionMotionDetectionHandler
extends MotionDetectionHandler
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionMotionDetectionHandler";
    private NetworkParameter networkParameter = null;
    private HttpServerPushHandler httpServerPushHandler = null;
    private boolean isServerPush = true;
    private boolean hasEmbeddedMotionData = false;
    private long lastMDProblemEventSent = Long.MIN_VALUE;

    public IQinVisionMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        int errorCode;
        block15: {
            byte[] result = null;
            errorCode = 0;
            String url = null;
            this.listener = hardwareMotionDetection;
            if (this.listener == null) {
                return -20003;
            }
            try {
                this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
                result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/set.oid?OidTR1.3.19=ENABLED", (int)Integer.MAX_VALUE);
                if (result == null) {
                    this.logger.warn("Could not enable motion detection. Enable it on the camera or disable motion detection windows in SeeTec 5 system.");
                    return -21664;
                }
                if (new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/get.oid?1.11.1.7.1", (int)Integer.MAX_VALUE)).toLowerCase().indexOf("enabled") == -1 && new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/get.oid?1.11.1.7.2", (int)Integer.MAX_VALUE)).toLowerCase().indexOf("enabled") == -1 && new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/get.oid?1.11.1.7.3", (int)Integer.MAX_VALUE)).toLowerCase().indexOf("enabled") == -1 && new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/get.oid?1.11.1.7.4", (int)Integer.MAX_VALUE)).toLowerCase().indexOf("enabled") == -1 && new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/get.oid?1.11.1.7.5", (int)Integer.MAX_VALUE)).toLowerCase().indexOf("enabled") == -1 && new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/get.oid?1.11.1.7.6", (int)Integer.MAX_VALUE)).toLowerCase().indexOf("enabled") == -1 && new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/get.oid?1.11.1.7.7", (int)Integer.MAX_VALUE)).toLowerCase().indexOf("enabled") == -1 && new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/get.oid?1.11.1.7.8", (int)Integer.MAX_VALUE)).toLowerCase().indexOf("enabled") == -1) {
                    this.logger.warn("Motion Detection on camera DISABLED for " + this.listener.getVideoSrv());
                    this.logger.warn("Try to enable one motion detection window");
                    result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/set.oid?OidTR1.11.1.7.1=ENABLED", (int)Integer.MAX_VALUE);
                    if (result == null) {
                        this.logger.warn("Could not enable motion detection window. Enable it on the camera or disable motion detection windows in SeeTec 5 system.");
                        return -21664;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Error while testing connectivity to motion detection for " + this.listener.getVideoSrv(), (Throwable)e);
                return -20053;
            }
            this.isServerPush = this.checkForMotionDataStream(this.networkParameter);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                if (this.isServerPush) {
                    url = "/now.motiondata";
                    try {
                        this.httpServerPushHandler = new HttpServerPushHandler();
                        errorCode = this.httpServerPushHandler.init(this, this.networkParameter, url);
                        if (errorCode != 0) {
                            this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
                            break block15;
                        }
                        errorCode = this.httpServerPushHandler.startServerPush(true);
                    }
                    catch (Exception e) {
                        this.logger.error("Reading configuration from " + this.listener.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                        errorCode = -21601;
                    }
                    break block15;
                }
                this.hasEmbeddedMotionData = this.checkForEmbeddedMotionData(this.networkParameter);
                if (!this.hasEmbeddedMotionData) {
                    this.logger.warn("Camera has insufficient firmware version for " + this.listener.getVideoSrv());
                    this.logger.warn("Update the camera to latest firmware.");
                }
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
                errorCode = -21651;
            }
        }
        return errorCode;
    }

    public boolean checkForMotionDataStream(NetworkParameter networkParameter) {
        boolean ret = true;
        String url = "/now.motiondata";
        try {
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url, (int)256);
            if (result == null) {
                this.logger.error("Error while checking for motion data settings for " + this.listener.getVideoSrv());
            }
        }
        catch (SeeTecException ex) {
            if (ex.getNetworkStatus() == HTTPStatusCode.HTTP_NOT_FOUND) {
                ret = false;
            }
            this.logger.error("Exception while checking for motion data settings for " + this.listener.getVideoSrv() + (Object)((Object)ex));
        }
        return ret;
    }

    public boolean checkForEmbeddedMotionData(NetworkParameter networkParameter) {
        boolean ret = false;
        String url = "/get.oid?2.8";
        try {
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url, (int)256);
            if (result == null) {
                this.logger.error("Error while checking camera model for " + this.listener.getVideoSrv());
            } else {
                String cameraName = new String(result);
                if (cameraName.indexOf("IQ04") != -1 || cameraName.indexOf("IQD4") != -1 || cameraName.indexOf("IQ54") != -1 || cameraName.indexOf("IQD3") != -1 || cameraName.indexOf("IQM3") != -1 || cameraName.indexOf("IQ73") != -1 || cameraName.indexOf("IQ83") != -1 || cameraName.indexOf("IQA3") != -1 || cameraName.indexOf("IQM5") != -1) {
                    ret = true;
                } else if (System.currentTimeMillis() > this.lastMDProblemEventSent + 60000L) {
                    this.lastMDProblemEventSent = System.currentTimeMillis();
                    this.logger.error(Basic.generateIndentedMultiLineLog((String[])new String[]{"Problems with motion detection of camera [" + this.listener.getVideoSrv().getContentName() + "]", "Please make sure that your firmware is up to date."}));
                }
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while checking camera model for " + this.listener.getVideoSrv() + (Object)((Object)ex));
        }
        return ret;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        if (this.isShutdown(CLASS_NAME)) {
            return;
        }
        if (nStatusCode != 0) {
            this.listener.notifyForNetworkProblems();
        }
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21650);
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        String header;
        boolean hasDetected = false;
        if (this.isServerPush) {
            byte[] content = httpServerPushContent.getContentBody();
            if (content.length != 0) {
                String[] windows = new String(content).split("\r\n");
                for (int i = 0; i < windows.length; ++i) {
                    block10: {
                        windows[i] = windows[i].substring(windows[i].indexOf("=") + 1);
                        String[] partsOfDetection = windows[i].split(";");
                        if (partsOfDetection.length != 3) {
                            this.logger.error("Wrong content line format. Discarding for " + this.listener.getVideoSrv());
                            continue;
                        }
                        try {
                            int level = Integer.parseInt(partsOfDetection[1].substring(partsOfDetection[1].indexOf("=") + 1));
                            int threshold = Integer.parseInt(partsOfDetection[2].substring(partsOfDetection[2].indexOf("=") + 1));
                            if (level < threshold) break block10;
                            hasDetected = true;
                        }
                        catch (NumberFormatException nfe) {
                            this.logger.error("Error while converting number for " + this.listener.getVideoSrv());
                            continue;
                        }
                    }
                    if (!hasDetected) continue;
                    if (this.listener != null) {
                        this.listener.evaluateWindow(i);
                    }
                    hasDetected = false;
                }
            }
        } else if (this.hasEmbeddedMotionData && (header = httpServerPushContent.getContentHeader()) != null && header.indexOf("trigger=motion") >= 0) {
            hasDetected = true;
            if (this.listener != null) {
                this.listener.evaluateWindow(0);
            }
        }
    }
}

