/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.iqinvision;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionIOHandler;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import de.seetec.v5.shared.util.SeeTecException;

public class IQinVisionDevice
extends VideoServer {
    private boolean isRTSPPortSet = false;

    public int setRTSPPort(NetworkParameter networkParameter, int rtspPort) {
        int error = 0;
        StringBuffer url = null;
        byte[] result = null;
        if (!this.isRTSPPortSet) {
            this.isRTSPPortSet = true;
            if (networkParameter != null && rtspPort > 0) {
                if (rtspPort != 554 && rtspPort < 1024) {
                    this.logger.error("Invalid customized RTSP port: " + rtspPort + ". Valid values 554,1024..65535");
                    return -21601;
                }
                url = new StringBuffer("/set.oid?OidTR1.17.3.1=");
                url.append(rtspPort);
                try {
                    result = NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                    if (result == null) {
                        this.logger.error("Error while setting initial parameters for " + this);
                        return -20000;
                    }
                }
                catch (SeeTecException e) {
                    this.logger.error("Exception while setting initial parameters for " + this);
                    return e.getErrorCode();
                }
                String resultString = new String(result);
                if (resultString.toLowerCase().indexOf("error") >= 0) {
                    error = -21600;
                    this.logger.error("Could not set port on camera");
                    this.isRTSPPortSet = false;
                }
            } else {
                this.logger.error("Invalid RTSP port: " + rtspPort + ". Null or below zero.");
                return -21601;
            }
        }
        return error;
    }

    @Override
    protected IOHandler createIOHandler() {
        return new IQinVisionIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    public int setGlobalParameters(NetworkParameter networkParameter, int rotationAngle) {
        String setRotation = "/set.oid?OidTR1.2.4=" + (rotationAngle == 0 ? "none" : "180");
        try {
            NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)setRotation, (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting global parameters for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    public int[][] sortArray(int[][] resolutions) {
        if (resolutions == null) {
            return null;
        }
        int[][] ret = resolutions;
        boolean orderCorrect = false;
        while (!orderCorrect) {
            orderCorrect = true;
            for (int i = 0; i < ret.length - 1; ++i) {
                if (ret[i][0] * ret[i][1] >= ret[i + 1][0] * ret[i + 1][1]) continue;
                orderCorrect = false;
                int[] tmpArray = ret[i + 1];
                ret[i + 1] = ret[i];
                ret[i] = tmpArray;
            }
        }
        return ret;
    }

    public String getResolutionString(int width, int height) {
        if (width == 2592) {
            return "5mp";
        }
        if (width == 2560) {
            return "3mpwide";
        }
        if (width == 2048) {
            return "3mp";
        }
        if (width == 1920) {
            return "1080p";
        }
        if (width == 1600) {
            return "2mp";
        }
        if (width == 1280 && height == 960) {
            return "1.2mp";
        }
        if (width == 1280 && height == 720) {
            return "720p";
        }
        if (width == 720) {
            return "480p";
        }
        if (width == 640) {
            return "vga";
        }
        if (width == 352) {
            return "sif";
        }
        return "qvga";
    }

    public static int[] getResolutionValues(String resolutionTag) {
        String resolution = resolutionTag.toLowerCase();
        if (resolution.contains("5mp")) {
            return new int[]{2592, 1944};
        }
        if (resolution.contains("3mpwide")) {
            return new int[]{2560, 1440};
        }
        if (resolution.contains("3mp")) {
            return new int[]{2048, 1536};
        }
        if (resolution.contains("1080p")) {
            return new int[]{1920, 1080};
        }
        if (resolution.contains("2mp")) {
            return new int[]{1600, 1200};
        }
        if (resolution.contains("1.2mp")) {
            return new int[]{1280, 960};
        }
        if (resolution.contains("720p")) {
            return new int[]{1280, 720};
        }
        if (resolution.contains("480p")) {
            return new int[]{720, 480};
        }
        if (resolution.contains("qvga")) {
            return new int[]{320, 240};
        }
        if (resolution.contains("vga")) {
            return new int[]{640, 480};
        }
        if (resolution.contains("sif")) {
            return new int[]{352, 240};
        }
        return new int[]{320, 240};
    }

    public final boolean rotateImageOnCamera(NetworkParameter networkParameter) throws SeeTecException {
        String cameraName;
        return this.getDeviceType() != 201313L && this.getDeviceType() != 201314L && this.getDeviceType() != 201315L || (cameraName = new String(NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/get.oid?2.8", (int)Integer.MAX_VALUE, (boolean)false))).indexOf("IQ030S") == -1 && cameraName.indexOf("IQ031S") == -1 && cameraName.indexOf("IQ032S") == -1;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }

    public static final int checkDeviceInfos(long type, String host, int port, boolean useAuthorization, String user, String pass, int timeout) {
        String cameraName;
        String url;
        String cameraResponse;
        NetworkParameter networkParameter;
        block11: {
            String cameraNameToTest;
            block10: {
                String[] stringArray;
                if (useAuthorization) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = user;
                    stringArray = stringArray2;
                    stringArray2[1] = pass;
                } else {
                    stringArray = null;
                }
                networkParameter = NetworkParameterFactory.createNetworkParameter((String)host, (int)port, (boolean)false, (int)-1, (int)timeout, stringArray);
                cameraResponse = null;
                cameraNameToTest = "checkDevInfo";
                try {
                    url = "/get.oid?2.4";
                    cameraResponse = new String(NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)false));
                }
                catch (SeeTecException se) {
                    if (se.getNetworkStatus() == HTTPStatusCode.HTTP_OK) break block10;
                    return -21697;
                }
            }
            if (cameraResponse == null) {
                return -21697;
            }
            cameraName = cameraResponse.substring(cameraResponse.indexOf("<xmp>") + 5, cameraResponse.indexOf("</xmp>"));
            try {
                url = "/set.oid?OidTB2.4=" + cameraNameToTest;
                cameraResponse = new String(NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true));
            }
            catch (SeeTecException se) {
                if (se.getNetworkStatus() != HTTPStatusCode.HTTP_UNAUTHORIZED) break block11;
                return -21701;
            }
        }
        if (cameraResponse.contains("Error: Unauthorized")) {
            return -21701;
        }
        try {
            url = "/set.oid?OidTB2.4=" + cameraName;
            NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
        }
        catch (SeeTecException se) {
            return -21701;
        }
        return 0;
    }
}

