/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.ids;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.DoNothingCameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.ids.IdsConfiguration;
import de.seetec.v5.re.cm.device.video.ids.IdsVideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class IdsCameraSrv
extends LiveCameraSrv {
    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new DoNothingCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        IdsVideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [VideoSourceClient] with VideoProfileHandler=" + listener + " ...");
        IdsConfiguration idsConfiguration = this.getCurrentConfiguration();
        int codec1 = idsConfiguration.getCodec1();
        int codec2 = idsConfiguration.getCodec2();
        String profile = "";
        if (codec1 > 0 && (codec2 > 0 || codec1 == Codec.MJPEG.getType() && codec2 == Codec.H264.getType() || codec2 == Codec.MJPEG.getType() && codec1 == Codec.H264.getType())) {
            int width1 = idsConfiguration.getWidth1();
            int height1 = idsConfiguration.getHeight1();
            int width2 = idsConfiguration.getWidth2();
            int height2 = idsConfiguration.getHeight2();
            if (codec1 == Codec.H264.getType()) {
                if (width1 == 2048 && height1 == 1536) {
                    profile = "SINGLE_H264_3MP";
                } else if (width1 == 2560 && height1 == 1920) {
                    profile = "SINGLE_H264_5MP";
                } else if (width1 == 360 && height1 == 288) {
                    profile = "DUAL_CIF";
                } else if (width1 == 640 && height1 == 352 && (codec2 <= 0 || width2 == 640 && height2 == 352)) {
                    profile = "DUAL_VGA";
                } else if (width1 == 720 && height1 == 576) {
                    profile = "DUAL_D1";
                } else if (width1 == 1280 && height1 == 720 && (codec2 <= 0 || width2 == 640 && height2 == 352)) {
                    profile = "DUAL_HD_VGA";
                } else if (width1 == 1280 && height1 == 720 && (codec2 <= 0 || width2 == 1280 && height2 == 720)) {
                    profile = "DUAL_HD";
                } else if (width1 == 1920 && height1 == 1080) {
                    profile = "DUAL_FULLHD_VGA";
                }
            } else if (codec1 == Codec.MJPEG.getType()) {
                if (width1 == 640 && height1 == 480) {
                    profile = "SINGLE_MJPEG_640x480";
                } else if (width1 == 1280 && height1 == 960) {
                    profile = "SINGLE_MJPEG_1280x960";
                } else if (width1 == 1920 && height1 == 1080) {
                    profile = "SINGLE_MJPEG_FULLHD";
                } else if (width1 == 2048 && height1 == 1536) {
                    profile = "SINGLE_MJPEG_3MP";
                } else if (width1 == 2560 && height1 == 1920) {
                    profile = "SINGLE_MJPEG_5MP";
                } else if (width1 == 360 && height1 == 288) {
                    profile = "DUAL_CIF";
                } else if (width1 == 640 && height1 == 352 && (codec2 <= 0 || width2 == 640 && height2 == 352)) {
                    profile = "DUAL_VGA";
                } else if (width1 == 720 && height1 == 576) {
                    profile = "DUAL_D1";
                } else if (width1 == 640 && height1 == 352 && (codec2 <= 0 || width2 == 1280 && height2 == 720)) {
                    profile = "DUAL_HD_VGA";
                } else if (width1 == 1280 && height1 == 720 && (codec2 <= 0 || width2 == 1280 && height2 == 720)) {
                    profile = "DUAL_HD";
                } else if (width1 == 640 && height1 == 352 && (codec2 <= 0 || width2 == 1920 && height2 == 1080)) {
                    profile = "DUAL_FULLHD_VGA";
                }
            }
        }
        this.logger.info("Set profile: " + profile + " for " + this);
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)("/dciset.cgi?profile=" + profile), (int)Integer.MAX_VALUE, (boolean)false);
        }
        catch (ConfigurationException exception) {
            this.logger.warn((Object)exception);
            this.logger.warn("Could not set profile for " + this);
        }
        try {
            videoSourceClient = new IdsVideoSourceClient();
            errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                if (errorCode == HTTPStatusCode.HTTP_NOT_FOUND.getStatusCode()) {
                    throw new SeeTecException(-21656, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                }
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    public IdsConfiguration getCurrentConfiguration() {
        try {
            IdsConfiguration idsConfiguration = new IdsConfiguration();
            VideoProfileHandler basicVideoProfileHandler = this.getBasicVideoProfileHandler();
            idsConfiguration.setCodec1(basicVideoProfileHandler.getVideoSourceParameter().getMediaCodec().getType());
            idsConfiguration.setWidth1(basicVideoProfileHandler.getVideoSourceParameter().getImageSize()[0]);
            idsConfiguration.setHeight1(basicVideoProfileHandler.getVideoSourceParameter().getImageSize()[1]);
            if (this.getAdditionalVideoProfileHandler().length > 0) {
                VideoProfileHandler additionalVideoProfileHandler = this.getAdditionalVideoProfileHandler()[0];
                idsConfiguration.setCodec2(additionalVideoProfileHandler.getVideoSourceParameter().getMediaCodec().getType());
                idsConfiguration.setWidth2(additionalVideoProfileHandler.getVideoSourceParameter().getImageSize()[0]);
                idsConfiguration.setHeight2(additionalVideoProfileHandler.getVideoSourceParameter().getImageSize()[1]);
            }
            return idsConfiguration;
        }
        catch (Exception exception) {
            this.logger.error("Could not read whole configuration");
            this.logger.error("Exception while reading configuration: " + exception.getMessage());
            return null;
        }
    }
}

