/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.hikvision;

import de.seetec.v5.re.cm.configuration.device.video.hikvision.AdminAccessProtocol;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.AdminAccessProtocolList;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.IntegerCap;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.StreamingChannel;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionCameraSrv;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.xml.sax.SAXException;

public class HikvisionVideoSourceClientISAPI
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.hikvision.HikvisionVideoSourceClientISAPI";
    private int rtspPort = 554;
    private String parameterString = null;
    private String defaultFps = "2500";
    private String defaultQuality = "40";
    private boolean restartLater;
    private Thread audioHandlerThread = null;
    private AudioHandler audioHandler = null;
    private boolean audioOverRtsp = false;
    private int maxBitrate;
    private int minBitrate;
    private int bitrate;
    private int streamNumber;
    private HikvisionDevice hikvisionDevice;

    public HikvisionDevice getHikvisionDevice() {
        if (this.hikvisionDevice == null) {
            this.hikvisionDevice = (HikvisionDevice)this.getVideoSrv().getDevice();
        }
        return this.hikvisionDevice;
    }

    @Override
    public int init() {
        try {
            try {
                this.transmissionID = this.listener.getVideoSourceParameter().getTransmissionID();
            }
            catch (ConfigurationException ex) {
                this.logger.error("Exception while getting streaming configuration for " + this + ": " + ex.getMessage());
            }
            this.completeFrame = new ByteArrayOutputStream();
            int tempTimeout = this.networkParameter.getSoTimeout();
            this.networkParameter.setSoTimeout(5000);
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            HikvisionCameraSrv hikvisionCameraSrv = (HikvisionCameraSrv)this.getVideoSrv();
            if (!HikvisionDevice.isSmartDriver(this.getHikvisionEntityType(hikvisionCameraSrv))) {
                hikvisionCameraSrv.setModelInformation(this.width, this.height);
            }
            this.title = URLDecoder.decode(this.title.trim(), "UTF-8");
            this.errorCode = hikvisionCameraSrv.setGlobalParameters(this.useTitle, this.title, this.useDateTime, this.rotationAngle);
            if (this.errorCode != 0) {
                this.logger.warn("Error " + this.errorCode + " while setting channel parameters for " + this);
                this.logger.warn("Will continue anyway...");
            }
            int iFrameLimit = 400;
            this.streamNumber = this.getVideoStreamNumber();
            this.rtspUrl = this.streamNumber == 1 ? "rtsp://" + this.getHost() + "/ISAPI/Streaming/channels/" + this.getVideoSourceNumber() + "01" : (this.streamNumber == 2 ? "rtsp://" + this.getHost() + "/ISAPI/Streaming/channels/" + this.getVideoSourceNumber() + "02" : "rtsp://" + this.getHost() + "/ISAPI/Streaming/channels/" + this.getVideoSourceNumber() + "03");
            if (this.videoCodec != Codec.RTSP) {
                String parameter;
                String[] elementPath;
                StreamingChannel stream = this.getHikvisionObject(StreamingChannel.class, "/ISAPI/Streaming/channels/" + this.getVideoSourceNumber() + "0" + this.streamNumber + "/capabilities");
                String url = "/ISAPI/Streaming/channels/" + this.getVideoSourceAndStream() + "/capabilities";
                String[] maxIframeDist = hikvisionCameraSrv.getCaps(url, elementPath = new String[]{"Video", "GovLength"}, parameter = "max");
                if (maxIframeDist != null && maxIframeDist.length > 0) {
                    this.logger.info("Maximum I-Frame-Dist on camera is " + maxIframeDist[0]);
                    try {
                        iFrameLimit = Integer.parseInt(maxIframeDist[0]);
                    }
                    catch (NumberFormatException ex) {
                        this.logger.warn("Could not parse " + maxIframeDist[0] + " to number for " + this + ". Continue with fallback value 400 ");
                    }
                } else {
                    this.logger.warn("Could not read I-Frame-Distance capabilities. Using default value 400");
                }
                this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, 1, iFrameLimit);
                this.quality = 100000 - this.quality;
                this.quality /= 1000;
                this.bitrate = this.bandwidth / 1024;
                int[] bitrateLimits = this.getBitrateLimits();
                this.minBitrate = bitrateLimits[0];
                this.maxBitrate = bitrateLimits[1];
                this.audioOverRtsp = hikvisionCameraSrv.getAudioOverRtsp();
                this.bitrate = this.bitrate < this.minBitrate ? this.minBitrate : this.bitrate;
                this.bitrate = this.bitrate > this.maxBitrate ? this.maxBitrate : this.bitrate;
                int maxFrameRateStream = Integer.MAX_VALUE;
                if (stream != null) {
                    String[] fpsString = stream.getVideo().getMaxFrameRate().getOpt().split(",");
                    maxFrameRateStream = this.getMaxFps(fpsString);
                }
                this.defaultFps = HikvisionCameraSrv.getFramerate(this.fps, maxFrameRateStream);
                if (this.streamNumber == 2 && this.fps == 50000L) {
                    this.defaultFps = "2500";
                } else if (this.streamNumber == 2 && this.fps == 60000L) {
                    this.defaultFps = "3000";
                }
                if ("5000".equals(this.defaultFps) || "6000".equals(this.defaultFps)) {
                    this.closeWDR();
                }
                this.defaultQuality = this.quality < 17 ? "100" : (this.quality < 33 ? "80" : (this.quality < 50 ? "60" : (this.quality < 67 ? "40" : (this.quality < 83 ? "20" : "1"))));
                this.rtspPort = this.listener.getVideoSourceParameter().getRtspPort();
                try {
                    Element audioEnabledElement;
                    Element audioElement;
                    Element videoCodecTypeElement;
                    String xmlString = this.getHikvisionDevice().getHttpHandler().readGetRequest("/ISAPI/Streaming/channels/" + this.getVideoSourceAndStream());
                    xmlString = xmlString.substring(xmlString.indexOf(">") + 1, xmlString.lastIndexOf(">") + 1);
                    ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
                    Document cameraConf = new SAXBuilder().build((InputStream)bais);
                    Element root = cameraConf.getRootElement();
                    Namespace ns = root.getNamespace();
                    Element videoElement = root.getChild("Video", ns);
                    if (videoElement != null && (videoCodecTypeElement = videoElement.getChild("videoCodecType", ns)) != null) {
                        String codec = videoCodecTypeElement.getText();
                        if (this.videoCodec == Codec.MJPEG && codec.toLowerCase().equals("h.264") || this.videoCodec == Codec.H264 && codec.toLowerCase().equals("mjpeg")) {
                            this.logger.info("Codec has been changed. Restarting camera...");
                            this.restartLater = true;
                        }
                    }
                    if ((audioElement = root.getChild("Audio", ns)) != null && (audioEnabledElement = audioElement.getChild("enabled", ns)) != null) {
                        String audioEnabledString = audioEnabledElement.getText();
                        if (this.isAudioEnabled && audioEnabledString.equals("false")) {
                            this.restartLater = true;
                        }
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.error("Error while retrieving streaming data for " + this + ": " + ex.getMessage());
                }
                catch (JDOMException ex) {
                    this.logger.error("Exception while reading xml: " + ex.getMessage() + " for " + this);
                }
                this.parameterString = "<StreamingChannel version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\"><id>" + this.getVideoSourceAndStream() + "</id><channelName></channelName><enabled>true</enabled><Transport><ControlProtocolList><ControlProtocol><streamingTransport>RTSP</streamingTransport></ControlProtocol></ControlProtocolList>";
                this.parameterString = this.parameterString + "<Unicast><enabled>true</enabled></Unicast><Multicast><enabled>false</enabled><destIPAddress>0.0.0.0</destIPAddress><destPortNo>0</destPortNo></Multicast>";
                this.parameterString = this.parameterString + "</Transport><Video><enabled>true</enabled>";
                this.parameterString = this.parameterString + "<videoInputChannelID>" + this.videoSourceNr + "</videoInputChannelID><videoCodecType>";
                switch (this.videoCodec) {
                    case H264: {
                        this.parameterString = this.parameterString + "H.264";
                        break;
                    }
                    case H265: {
                        this.parameterString = this.parameterString + "H.265";
                        break;
                    }
                    default: {
                        this.parameterString = this.parameterString + "MJPEG";
                    }
                }
                this.parameterString = this.parameterString + "</videoCodecType><videoScanType>progressive</videoScanType><videoResolutionWidth>" + this.width + "</videoResolutionWidth><videoResolutionHeight>" + this.height + "</videoResolutionHeight>";
                this.parameterString = !this.isConstantBitrateUsed ? this.parameterString + "<videoQualityControlType>VBR</videoQualityControlType><vbrUpperCap>" + this.bitrate + "</vbrUpperCap>" : this.parameterString + "<videoQualityControlType>CBR</videoQualityControlType><constantBitRate>" + this.bitrate + "</constantBitRate>";
                this.parameterString = this.parameterString + "<fixedQuality>" + this.defaultQuality + "</fixedQuality><maxFrameRate>" + this.defaultFps + "</maxFrameRate>";
                if (this.videoCodec != Codec.MJPEG) {
                    this.parameterString = this.parameterString + "<GovLength>" + this.iFrameDist + "</GovLength>";
                }
                this.parameterString = this.parameterString + "<snapShotImageType>JPEG</snapShotImageType></Video>";
                try {
                    List<AdminAccessProtocol> adminAccessProtocols;
                    AdminAccessProtocolList adminAccessProtocolList = this.getHikvisionObject(AdminAccessProtocolList.class, "/ISAPI/Security/adminAccesses");
                    if (adminAccessProtocolList != null && !(adminAccessProtocols = adminAccessProtocolList.getAdminAccessProtocol()).isEmpty()) {
                        for (AdminAccessProtocol adminAccessProtocol : adminAccessProtocols) {
                            int port;
                            String protocol = adminAccessProtocol.getProtocol().getValue();
                            if (protocol == null || !protocol.toLowerCase().equals("rtsp") || (port = adminAccessProtocol.getPortNo().getValue().intValue()) == this.rtspPort) continue;
                            String id = adminAccessProtocol.getId().getValue();
                            String data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><AdminAccessProtocolList version=\"1.0\" xmlns=\"http://www.isapi.org/ver20/XMLSchema\"><AdminAccessProtocol version=\"1.0\" xmlns=\"http://www.isapi.org/ver20/XMLSchema\"><id>" + id + "</id><protocol>RTSP</protocol><portNo>" + this.rtspPort + "</portNo></AdminAccessProtocol></AdminAccessProtocolList>";
                            this.getHikvisionDevice().getHttpHandler().readPutRequest("/ISAPI/Security/adminAccesses", data);
                        }
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.warn("Exception while reading/writing RTSP Port for " + this + ": " + ex.getMessage());
                }
                String codeAudio = "G.711ulaw";
                if (this.isAudioEnabled && null != this.audioCodec) {
                    switch (this.audioCodec) {
                        case G711U: {
                            codeAudio = "G.711ulaw";
                            break;
                        }
                        case G711A: {
                            codeAudio = "G.711alaw";
                            break;
                        }
                        case PCM: {
                            codeAudio = "PCM";
                            break;
                        }
                        case G726: {
                            codeAudio = "G.726";
                            break;
                        }
                    }
                }
                this.parameterString = this.parameterString + "<Audio><enabled>" + (this.isAudioEnabled ? "true" : "false") + "</enabled><audioInputChannelID>1</audioInputChannelID><audioCompressionType>" + codeAudio + "</audioCompressionType></Audio>";
                this.parameterString = this.parameterString + "</StreamingChannel>";
                try {
                    String deviceUrl = "/ISAPI/Streaming/channels/" + this.getVideoSourceAndStream();
                    this.getHikvisionDevice().getHttpHandler().readPutRequest(deviceUrl, this.parameterString);
                    if (this.restartLater && !HikvisionDevice.isSmartDriver(this.getHikvisionEntityType(hikvisionCameraSrv))) {
                        this.rebootDevice();
                        this.shutdown();
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.warn("Exception while sending camera configuration for " + this + ": " + ex.getMessage());
                    this.logger.warn("Trying to get image stream anyway...");
                }
                catch (Exception ex) {
                    this.logger.error("Exception while sending camera configuration for " + this + ": " + ex.getMessage());
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.rtspSettings = new RTSPStreamSettings();
            this.networkParameter.setSoTimeout(tempTimeout);
            if (!this.audioOverRtsp) {
                this.errorCode = this.rtspSettings.init(this, null, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), false, 4, this.rtspUrl);
                if (this.errorCode != 0) {
                    this.logger.error("Error while setting RTSP parameters for " + this);
                    return this.errorCode;
                }
                if (this.videoCodec != Codec.RTSP) {
                    this.audioHandler = new AudioHandler((RTSPHandlerIntf)this);
                    this.audioHandlerThread = new Thread((Runnable)this.audioHandler, this.audioHandler.toString());
                    this.audioHandlerThread.start();
                }
            } else {
                this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl, true, false);
                if (this.errorCode != 0) {
                    this.logger.error("Error while setting RTSP parameters for " + this);
                    return this.errorCode;
                }
            }
            this.rtspSettings.setUdpBuffer(65535);
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP Handler for " + this);
                return this.errorCode;
            }
            this.logger.info("init done for" + this.getVideoSrv());
            return 0;
        }
        catch (SeeTecException exception) {
            return exception.getErrorCode();
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.getVideoSrv() != null) {
            ((HikvisionCameraSrv)this.getVideoSrv()).resetModelInformation();
        }
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.audioHandler != null) {
            this.audioHandler.shutdown();
            this.audioHandler = null;
        }
        return super.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int getMaxFps(String[] fpsStrings) {
        int fps = 1;
        for (String fpsString : fpsStrings) {
            fps = Integer.parseInt(fpsString) > fps ? Integer.parseInt(fpsString) : fps;
        }
        return fps;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    public void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down" + this.getVideoSrv());
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    public int setCameraParameters(long fps) throws SAXException, JAXBException, SeeTecException, ConfigurationException {
        StreamingChannel stream = this.getHikvisionObject(StreamingChannel.class, "/ISAPI/Streaming/channels/" + this.getVideoSourceAndStream() + "/capabilities");
        int maxFrameRate = Integer.MAX_VALUE;
        if (stream != null) {
            String[] fpsString = stream.getVideo().getMaxFrameRate().getOpt().split(",");
            maxFrameRate = this.getMaxFps(fpsString);
        }
        String framerate = HikvisionCameraSrv.getFramerate(fps, maxFrameRate);
        String url = "/ISAPI/Streaming/channels/" + this.getVideoSourceAndStream();
        StringBuilder xmlContent = new StringBuilder();
        xmlContent.append("<StreamingChannel version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\">");
        xmlContent.append("<id>");
        xmlContent.append(this.getVideoSourceAndStream());
        xmlContent.append("</id>");
        xmlContent.append("<channelName></channelName>");
        xmlContent.append("<enabled>true</enabled>");
        xmlContent.append("<Transport>");
        xmlContent.append("<rtspPortNo>");
        xmlContent.append(this.rtspPort);
        xmlContent.append("</rtspPortNo>");
        xmlContent.append("<maxPacketSize>1000</maxPacketSize>");
        xmlContent.append("<sourcePortNo>0</sourcePortNo>");
        xmlContent.append("<ControlProtocolList>");
        xmlContent.append("<ControlProtocol>");
        xmlContent.append("<streamingTransport>RTSP</streamingTransport>");
        xmlContent.append("</ControlProtocol>");
        xmlContent.append("</ControlProtocolList>");
        xmlContent.append("<Unicast>");
        xmlContent.append("<enabled>true</enabled>");
        xmlContent.append("</Unicast>");
        xmlContent.append("<Multicast>");
        xmlContent.append("<enabled>false</enabled>");
        xmlContent.append("<destIPAddress>0.0.0.0</destIPAddress>");
        xmlContent.append("<destPortNo>0</destPortNo>");
        xmlContent.append("</Multicast>");
        xmlContent.append("</Transport>");
        xmlContent.append("<Video>");
        xmlContent.append("<enabled>true</enabled>");
        xmlContent.append("<videoInputChannelID>");
        xmlContent.append(this.videoSourceNr);
        xmlContent.append("</videoInputChannelID>");
        xmlContent.append("<videoCodecType>");
        switch (this.videoCodec) {
            case H264: {
                xmlContent.append("H.264");
                break;
            }
            case H265: {
                xmlContent.append("H.265");
                break;
            }
            default: {
                xmlContent.append("MJPEG");
            }
        }
        xmlContent.append("</videoCodecType>");
        xmlContent.append("<videoScanType>progressive</videoScanType>");
        xmlContent.append("<videoResolutionWidth>");
        xmlContent.append(this.width);
        xmlContent.append("</videoResolutionWidth>");
        xmlContent.append("<videoResolutionHeight>");
        xmlContent.append(this.height);
        xmlContent.append("</videoResolutionHeight>");
        if (!this.isConstantBitrateUsed) {
            xmlContent.append("<videoQualityControlType>VBR</videoQualityControlType>");
            xmlContent.append("<constantBitRate>4096</constantBitRate>");
        } else {
            xmlContent.append("<videoQualityControlType>CBR</videoQualityControlType>");
            xmlContent.append("<constantBitRate>");
            xmlContent.append(this.bitrate);
            xmlContent.append("</constantBitRate>");
        }
        xmlContent.append("<fixedQuality>");
        xmlContent.append(this.defaultQuality);
        xmlContent.append("</fixedQuality>");
        xmlContent.append("<maxFrameRate>");
        xmlContent.append(framerate);
        xmlContent.append("</maxFrameRate>");
        if (this.videoCodec != Codec.MJPEG) {
            xmlContent.append("<keyFrameInterval>");
            xmlContent.append(this.iFrameDist);
            xmlContent.append("</keyFrameInterval>");
            xmlContent.append("<BPFrameInterval>2</BPFrameInterval>");
        }
        xmlContent.append("<snapShotImageType>JPEG</snapShotImageType>");
        xmlContent.append("</Video>");
        String codeAudio = "G.711ulaw";
        if (null != this.audioCodec) {
            switch (this.audioCodec) {
                case G711U: {
                    codeAudio = "G.711ulaw";
                    break;
                }
                case G711A: {
                    codeAudio = "G.711alaw";
                    break;
                }
                case PCM: {
                    codeAudio = "PCM";
                    break;
                }
                case G726: {
                    codeAudio = "G.726";
                    break;
                }
            }
        }
        xmlContent.append("<Audio>");
        xmlContent.append("<enabled>false</enabled>");
        xmlContent.append("<audioInputChannelID>1</audioInputChannelID>");
        xmlContent.append("<audioCompressionType>").append(codeAudio).append("</audioCompressionType>");
        xmlContent.append("</Audio>");
        xmlContent.append("</StreamingChannel>");
        try {
            this.getHikvisionDevice().getHttpHandler().readPutRequest(url, xmlContent.toString());
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting framerate for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    public long getMilliCompression() {
        return this.quality;
    }

    private int determineChannelId() {
        int channelId = 1;
        try {
            String streamName = this.listener.getVideoSourceParameter().getStreamName();
            channelId = streamName.endsWith("1") ? 1 : (streamName.endsWith("2") ? 2 : 3);
        }
        catch (ConfigurationException configurationException) {
            this.logger.warn("Could not read stream name from configuration for " + this);
        }
        return channelId;
    }

    private long getHikvisionEntityType(HikvisionCameraSrv hikvisionCameraSrv) {
        return hikvisionCameraSrv.getDevice().getDeviceEntity().getEntityType();
    }

    private void rebootDevice() {
        try {
            this.getHikvisionDevice().getHttpHandler().readPutRequest("/System/reboot", "");
            boolean reachable = true;
            while (reachable) {
                try {
                    Socket socket = new Socket();
                    socket.connect(new InetSocketAddress(this.networkParameter.getHost(), this.networkParameter.useHTTPS() ? this.networkParameter.getSSLport() : this.networkParameter.getHTTPport()), 5000);
                    socket.close();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    reachable = false;
                }
            }
        }
        catch (SeeTecException seeTecException) {
            this.logger.info("Could not reboot for " + this.getVideoSrv().getDevice());
        }
    }

    private void closeWDR() {
        String url = "/Image/channels/1/WDRExt";
        try {
            String getWdr = this.getHikvisionDevice().getHttpHandler().readGetRequest(url);
            getWdr = getWdr.substring(getWdr.indexOf("<?xml version"), getWdr.length());
            getWdr = getWdr.replace("open", "close");
            this.getHikvisionDevice().getHttpHandler().readPutRequest(url, getWdr);
        }
        catch (SeeTecException ex) {
            this.logger.warn("Error while closing wdr for " + this, (Throwable)ex);
        }
    }

    private <T> T getHikvisionObject(Class<T> clazz, String url) throws SAXException, JAXBException, SeeTecException {
        try {
            return this.getHikvisionDevice().unmarshalHikvisionObject(clazz, this.getHikvisionDevice().getHttpHandler().readGetRequest(url).getBytes());
        }
        catch (SeeTecException ex) {
            if (ex.getMessage().contains("Statuscode: 403, Name: HTTP_FORBIDDEN")) {
                this.errorCode = -21657;
                this.logger.error("Error while trying to get Device Info  for " + this + " failed with error [" + this.errorCode + "] :-(");
            } else {
                this.logger.error("Exception while reading camera configuration. Check Firmware for compatibility", (Throwable)ex);
            }
            return null;
        }
    }

    private int[] getBitrateLimits() {
        int[] result = new int[2];
        try {
            IntegerCap constantBitrate;
            StreamingChannel.Video video;
            String url = "/ISAPI/Streaming/channels/" + this.getVideoSourceAndStream() + "/capabilities";
            StreamingChannel streamingChannel = this.getHikvisionObject(StreamingChannel.class, url);
            if (streamingChannel != null && (video = streamingChannel.getVideo()) != null && (constantBitrate = video.getConstantBitRate()) != null) {
                result[0] = constantBitrate.getMin().intValue();
                result[1] = constantBitrate.getMax().intValue();
            }
        }
        catch (ConfigurationException | SeeTecException | JAXBException | SAXException ex) {
            this.logger.error("Exception while reading Stream configuration for " + this + ": " + ex.getMessage());
        }
        return result;
    }

    private int getVideoSourceNumber() throws ConfigurationException {
        return this.listener.getVideoSourceParameter().getServerEntryNo();
    }

    private int getVideoStreamNumber() {
        int streamNumber;
        if (this.videoCodec == Codec.RTSP) {
            streamNumber = 1;
        } else if (HikvisionDevice.isSmartDriver(this.getHikvisionEntityType((HikvisionCameraSrv)this.getVideoSrv()))) {
            streamNumber = this.determineChannelId();
        } else {
            ((HikvisionCameraSrv)this.getVideoSrv()).setModelInformation(this.width, this.height);
            streamNumber = ((HikvisionCameraSrv)this.getVideoSrv()).getStreamNumber(this.listener);
        }
        return streamNumber;
    }

    private String getVideoSourceAndStream() throws ConfigurationException {
        return String.valueOf(this.getVideoSourceNumber() * 100 + this.getVideoStreamNumber());
    }

    private class AudioHandler
    extends StreamingVideoSourceClientRTSP.AudioSourceClient
    implements Runnable {
        private Socket socket;
        private boolean isShutdown;

        public AudioHandler(RTSPHandlerIntf callback) {
            super(callback);
            this.isShutdown = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String url = "/TwowayAudio/open";
            String xmlData = "";
            try {
                HikvisionVideoSourceClientISAPI.this.getHikvisionDevice().getHttpHandler().readPutRequest(url, xmlData);
            }
            catch (SeeTecException ex) {
                HikvisionVideoSourceClientISAPI.this.logger.error("Exception while enabling audio for " + this + ": " + ex.getMessage());
            }
            String authorization = "";
            try {
                authorization = NetworkHelper.createBasicAuthorization((NetworkParameter)HikvisionVideoSourceClientISAPI.this.networkParameter);
            }
            catch (Exception ex) {
                HikvisionVideoSourceClientISAPI.this.logger.error("Exception while creating Basic Authorization for " + this + ": " + ex.getMessage());
            }
            authorization = authorization == null ? "" : authorization;
            String host = HikvisionVideoSourceClientISAPI.this.networkParameter.getHost();
            String request = "GET /TwowayAudio/receiveData HTTP/1.1\r\n" + authorization + "User-Agent: Java/1.4.2\r\nHost: " + host + "\r\nAccept: audio/basicConnection: keep-alive\r\n\r\n";
            try {
                this.socket = HikvisionVideoSourceClientISAPI.this.networkParameter.useHTTPS() ? NetworkHelper.createNetworkConnection((String)host, (int)HikvisionVideoSourceClientISAPI.this.networkParameter.getSSLport(), (boolean)true) : NetworkHelper.createNetworkConnection((String)host, (int)HikvisionVideoSourceClientISAPI.this.networkParameter.getHTTPport(), (boolean)false);
                this.socket.setSoTimeout(HikvisionVideoSourceClientISAPI.this.networkParameter.getSoTimeout());
                OutputStream os = this.socket.getOutputStream();
                os.write(request.getBytes());
                os.flush();
                InputStream is = this.socket.getInputStream();
                byte[] buffer = new byte[256];
                while (!this.isShutdown()) {
                    int len = is.read(buffer);
                    if (len <= 0) {
                        break;
                    }
                    this.onTcpData(Arrays.copyOf(buffer, len));
                }
            }
            catch (Exception ex) {
                HikvisionVideoSourceClientISAPI.this.logger.error("Exception while reading Audio data from " + this + ": " + ex.getMessage());
                HikvisionVideoSourceClientISAPI.this.onNetworkError(-20100);
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException ex) {
                    HikvisionVideoSourceClientISAPI.this.logger.error("Exception closing audio socket for " + this + ": " + ex.getMessage());
                }
                this.socket = null;
            }
        }

        @Override
        public void shutdown() {
            this.isShutdown = true;
            super.shutdown();
        }

        private boolean isShutdown() {
            return this.isShutdown;
        }

        public void onTcpData(byte[] data) {
            try {
                if (data[1] != -56) {
                    MediaFrame mediaFrame = StreamingHelper.createSeeTecAudioFrameHeader(HikvisionVideoSourceClientISAPI.this.audioCodec, HikvisionVideoSourceClientISAPI.this.audioBitrate, Arrays.copyOfRange(data, 12, data.length));
                    HikvisionVideoSourceClientISAPI.this.deliverFrameCreateServerTimestamp(16, mediaFrame);
                }
            }
            catch (Throwable t) {
                HikvisionVideoSourceClientISAPI.this.logger.error("Ignoring packet due to unexpected error: " + t.getMessage(), t);
            }
        }
    }
}

