/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.hikvision;

import de.seetec.v5.re.cm.configuration.device.video.hikvision.EventNotificationAlert;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.MotionDetection;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.TamperDetection;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.MotionRecording;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionDevice;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

class HikvisionTriggerHandler
extends GenericEventTriggerHandler {
    private NetworkParameter networkParameter = null;
    private int videoServerNumber;
    private HttpHandlerImpl httpHandler;
    private HikvisionDevice hikvisionDevice;

    @Override
    public int init(Device device, List<GenericEventTriggerCnf> genericEventTriggerCnfs) {
        block17: {
            if (device instanceof HikvisionDevice) {
                this.hikvisionDevice = (HikvisionDevice)device;
                try {
                    this.networkParameter = device.getDeviceCnf().getNetworkParameter();
                    List<GenericEventTriggerCnf> triggerEvents = genericEventTriggerCnfs;
                    if (this.hikvisionDevice.isCGIDevice()) {
                        this.getHttpHandler().readGetRequest("/");
                        for (GenericEventTriggerCnf event : triggerEvents) {
                            String eventName;
                            String eventShortName;
                            block16: {
                                String url;
                                if (event == null || !event.isEnabled()) continue;
                                eventShortName = "";
                                eventName = event.getGenericEventTriggerType();
                                if (eventName.toLowerCase().equals("vmd")) {
                                    url = "/PSIA/Custom/SelfExt/motionDetection/channels/" + this.videoServerNumber + "/motionDetection";
                                    String motionDetection = this.getHttpHandler().readGetRequest(url);
                                    if (motionDetection.contains("<enabled>false</enabled>")) {
                                        this.logger.error("Motion Detection is disabled on " + device.toString() + "Channel " + this.videoServerNumber);
                                    }
                                } else if (eventName.toLowerCase().equals("tamperdetection")) {
                                    eventShortName = "tamper";
                                    url = "/PSIA/Custom/SelfExt/TamperDetection/channels/" + this.videoServerNumber;
                                    String tamperDetection = this.getHttpHandler().readGetRequest(url);
                                    if (tamperDetection.contains("<enabled>false</enabled>")) {
                                        this.logger.error("Tampering Detection is disabled on " + device.toString() + "Channel " + this.videoServerNumber);
                                    }
                                } else if (eventName.toLowerCase().equals("videoloss")) {
                                    url = "/PSIA/Custom/SelfExt/Event/triggers/videoloss-" + this.videoServerNumber;
                                    try {
                                        this.getHttpHandler().readGetRequest(url);
                                    }
                                    catch (SeeTecException ex) {
                                        if (ex.getNetworkStatus() != HTTPStatusCode.HTTP_BAD_REQUEST) break block16;
                                        this.logger.error("Video Loss Detection is disabled on " + device.toString() + "Channel " + this.videoServerNumber);
                                    }
                                }
                            }
                            this.setLinkage(event.getSourceNumber(), eventName, eventShortName);
                        }
                        break block17;
                    }
                    for (GenericEventTriggerCnf event : triggerEvents) {
                        TamperDetection tamperDetection;
                        String url;
                        if (event == null || !event.isEnabled()) continue;
                        String eventName = event.getGenericEventTriggerType();
                        if (eventName.toLowerCase().equals("vmd")) {
                            url = "/ISAPI/System/Video/inputs/channels/" + this.videoServerNumber + "/MotionDetection";
                            MotionDetection motionDetection = this.readObjectFromDevice(MotionDetection.class, url);
                            if (motionDetection.getEnabled().isValue()) continue;
                            this.logger.error("Motion Detection is disabled on " + device.toString() + "Channel " + (this.videoServerNumber + 1));
                            continue;
                        }
                        if (!eventName.toLowerCase().equals("tamperdetection") || (tamperDetection = this.readObjectFromDevice(TamperDetection.class, url = "/ISAPI/System/Video/inputs/channels/" + this.videoServerNumber + "/tamperdetection")).getEnabled().isValue()) continue;
                        this.logger.error("Tampering Detection is disabled on " + device.toString() + "Channel " + (this.videoServerNumber + 1));
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Exception while checking for enabled triggers: " + ex.getMessage());
                }
            }
        }
        this.hikvisionDevice.startEventReader();
        return super.init(device, genericEventTriggerCnfs);
    }

    public HikvisionTriggerHandler(MotionRecording motionRecording) {
        super(motionRecording);
    }

    @Override
    public void run() {
        while (!this.isShutdown()) {
            EventNotificationAlert eventNotificationAlert;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                this.logger.warn("Exception while thread sleep for " + this);
            }
            if ((eventNotificationAlert = this.hikvisionDevice.retrieveEventMessage(this.videoServerNumber)) == null) continue;
            try {
                List triggerEvents = this.genericEventTriggerCnfs;
                for (GenericEventTriggerCnf event : triggerEvents) {
                    if (event == null || !event.isEnabled()) continue;
                    String eventName = event.getGenericEventTriggerType();
                    boolean alarmTypeMatches = this.isValidTemperatureAlarm(eventNotificationAlert, eventName);
                    alarmTypeMatches |= this.isValidBodyTemperatureAlarm(eventNotificationAlert, eventName);
                    alarmTypeMatches |= this.isValidVcaRuleAlarm(eventNotificationAlert, eventName);
                    alarmTypeMatches |= eventNotificationAlert.getEventType().value().equals("shelteralarm") && eventName.equals("tamperdetection");
                    alarmTypeMatches |= eventNotificationAlert.getEventType().value().equals("tamperdetection") && eventName.equals("shelteralarm");
                    if (!(alarmTypeMatches |= eventNotificationAlert.getEventType().value().equals(eventName))) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Event raised: " + (Object)((Object)eventNotificationAlert.getEventType()) + " from device: " + this.device.toString());
                    }
                    this.forwardTrigger(event);
                }
            }
            catch (ConfigurationException ex) {
                this.logger.error("Reading configuration from " + this.device + " failed");
                this.logger.error((Object)ex, (Throwable)ex);
            }
            catch (Exception ex) {
                this.logger.error("Exception while evaluating event trigger: " + ex.getMessage());
            }
        }
    }

    public <T> T createHikvisionObject(Class<T> clazz, String content) throws SAXException, JAXBException, SeeTecException {
        return ((HikvisionDevice)this.device).unmarshalHikvisionObject(clazz, content.getBytes());
    }

    public HttpHandlerImpl getHttpHandler() {
        if (this.httpHandler == null) {
            try {
                this.httpHandler = new HttpHandlerImpl(this.networkParameter);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return this.httpHandler;
    }

    protected <T> T readObjectFromDevice(Class<T> clazz, String url) throws SAXException, JAXBException, SeeTecException {
        if (clazz != null) {
            this.createHikvisionObject(clazz, this.getHttpHandler().readGetRequest(url.trim()));
        }
        return null;
    }

    protected void setVideoSourceNumber(int serverEntryNo) throws SeeTecException {
        if (serverEntryNo <= 0) {
            throw new SeeTecException(-21601, "Video Source number " + serverEntryNo + " invalid.");
        }
        this.videoServerNumber = serverEntryNo;
    }

    private void setLinkage(int channelID, String eventName, String eventShortName) throws SeeTecException {
        eventShortName = eventShortName.equals("") ? eventName : eventShortName;
        String url = "/PSIA/Custom/SelfExt/Event/triggers/" + eventShortName + "-" + channelID;
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version='1.0' encoding='utf-8'?>");
        sb.append("<EventTrigger>");
        sb.append("<id>");
        sb.append(eventShortName).append("-").append(channelID);
        sb.append("</id>");
        sb.append("<eventType>").append(eventName).append("</eventType>");
        sb.append("<eventDescription>").append(eventName).append(" Event is detected.</eventDescription>");
        sb.append("<videoInputChannelID>").append(channelID).append("</videoInputChannelID>");
        sb.append("<EventTriggerNotificationList>");
        sb.append("<EventTriggerNotification>");
        sb.append("<id>");
        sb.append("email");
        sb.append("</id>");
        sb.append("<notificationMethod>email</notificationMethod>");
        sb.append("<notificationRecurrence>beginning</notificationRecurrence>");
        sb.append("</EventTriggerNotification>");
        sb.append("</EventTriggerNotificationList>");
        sb.append("</EventTrigger>");
        this.getHttpHandler().readPutRequest(url, sb.toString());
    }

    @Override
    public int shutdown() {
        this.hikvisionDevice.shutdownEventStream();
        return super.shutdown();
    }

    protected boolean isValidTemperatureAlarm(EventNotificationAlert eventNotificationAlert, String eventName) {
        EventNotificationAlert.DetectionRegionList detectionRegionList;
        boolean returnValue = false;
        String[] eventNameParts = eventName.split("\\s\\|\\s");
        if (eventNameParts.length == 3 && (eventNameParts[0].equals("Temperature Alarm") && eventNotificationAlert.getEventType().value().equals("TMA") || eventNameParts[0].equals("Temperature Pre-Alarm") && eventNotificationAlert.getEventType().value().equals("TMPA")) && (detectionRegionList = eventNotificationAlert.getDetectionRegionList()) != null) {
            List<EventNotificationAlert.DetectionRegionList.DetectionRegionEntry> detectionRegionEntries = detectionRegionList.getDetectionRegionEntry();
            for (EventNotificationAlert.DetectionRegionList.DetectionRegionEntry detectionRegionEntry : detectionRegionEntries) {
                if (!detectionRegionEntry.getRegionID().getValue().equals(eventNameParts[2])) continue;
                return true;
            }
        }
        return returnValue;
    }

    protected boolean isValidBodyTemperatureAlarm(EventNotificationAlert eventNotificationAlert, String eventName) {
        EventNotificationAlert.DetectionRegionList detectionRegionList;
        boolean returnValue = false;
        String[] eventNameParts = eventName.split("\\s\\|\\s");
        if (eventNameParts.length == 3 && (eventNameParts[0].equals("Body Temperature Alarm") && eventNotificationAlert.getEventType().value().equals("TMA") || eventNameParts[0].equals("Body Temperature Pre-Alarm") && eventNotificationAlert.getEventType().value().equals("TMPA")) && (detectionRegionList = eventNotificationAlert.getDetectionRegionList()) != null) {
            List<EventNotificationAlert.DetectionRegionList.DetectionRegionEntry> detectionRegionEntries = detectionRegionList.getDetectionRegionEntry();
            for (EventNotificationAlert.DetectionRegionList.DetectionRegionEntry detectionRegionEntry : detectionRegionEntries) {
                if (!detectionRegionEntry.getRegionID().getValue().equals(eventNameParts[2])) continue;
                return true;
            }
        }
        return returnValue;
    }

    protected boolean isValidVcaRuleAlarm(EventNotificationAlert eventNotificationAlert, String eventName) {
        boolean returnValue = false;
        if (eventName.contains("VCA rule")) {
            String ruleNumber = eventName.replace("VCA rule", "").trim();
            EventNotificationAlert.DetectionRegionList detectionRegionList = eventNotificationAlert.getDetectionRegionList();
            if (detectionRegionList != null) {
                List<EventNotificationAlert.DetectionRegionList.DetectionRegionEntry> detectionRegionEntries = detectionRegionList.getDetectionRegionEntry();
                for (EventNotificationAlert.DetectionRegionList.DetectionRegionEntry detectionRegionEntry : detectionRegionEntries) {
                    if (!detectionRegionEntry.getRegionID().getValue().equals(ruleNumber)) continue;
                    returnValue = true;
                }
            }
        }
        return returnValue;
    }
}

