/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.hikvision;

import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionDevice;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.util.ConfigurationException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import org.apache.logging.log4j.Logger;

public class HikvisionPlaybackVideoSourceClient
extends PlaybackVideoSourceClient {
    private HikvisionDevice device = null;

    @Override
    public int init() {
        try {
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.getLogger().error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.device = (HikvisionDevice)this.getVideoSrv().getDevice();
            try {
                this.setTimeDifference(this.getTimeDifferenceFromDevice());
            }
            catch (Exception ex) {
                this.getLogger().error("Error getting time from device " + this + ": " + ex.getMessage());
            }
            this.printDebug = false;
            this.setRtspPlaybackSpeed(Double.valueOf(this.getEdgeStorageParameter().getPlaybackSpeed()));
            this.setStartAllTrackIds(false);
            this.transmissionID = TransmissionType.RTP_OVER_RTSP_OVER_TCP;
            this.setLocalStorageReady(true);
        }
        catch (Throwable ex) {
            this.getLogger().error("Error while initalizing " + this, ex);
        }
        return 0;
    }

    @Override
    protected double getMaxPlaybackSpeed() {
        return this.edgeStorageParameter.getPlaybackSpeed();
    }

    @Override
    protected String getRtspUrl(long startTimestamp, long endTimestamp, String trackID) throws ConfigurationException {
        LocalDateTime start = LocalDateTime.ofEpochSecond(startTimestamp / 1000L, 0, ZoneOffset.UTC);
        LocalDateTime end = LocalDateTime.ofEpochSecond(endTimestamp / 1000L, 0, ZoneOffset.UTC);
        try {
            start = start.minus(this.getTimeDifferenceFromDevice(), ChronoUnit.MILLIS);
            end = end.minus(this.getTimeDifferenceFromDevice(), ChronoUnit.MILLIS);
        }
        catch (Exception exception) {
            this.getLogger().warn("Could not get time difference for " + this + " : " + exception.getMessage());
        }
        String startTimeFormatted = start.format(DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'"));
        String endTimeFormatted = end.format(DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'"));
        String url = String.format("rtsp://" + this.getHost() + "/ISAPI/Streaming/tracks/" + trackID + "?starttime=" + startTimeFormatted + "&endtime=" + endTimeFormatted, new Object[0]);
        this.getLogger().info("Playback RTSP URL: " + url + " for " + this);
        return url;
    }

    @Override
    protected String getTimeRange(long startTimestamp, long endTimestamp, String nameOfTimerange) {
        LocalDateTime start = LocalDateTime.ofEpochSecond(startTimestamp / 1000L, 0, ZoneOffset.UTC);
        LocalDateTime end = LocalDateTime.ofEpochSecond(endTimestamp / 1000L, 0, ZoneOffset.UTC);
        try {
            start = start.minus(this.getTimeDifferenceFromDevice(), ChronoUnit.MILLIS);
            end = end.minus(this.getTimeDifferenceFromDevice(), ChronoUnit.MILLIS);
        }
        catch (Exception exception) {
            this.getLogger().warn("Could not get time difference for " + this + " : " + exception.getMessage());
        }
        String formattedStartDate = start.format(DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'"));
        String formattedEndDate = end.format(DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'"));
        String rateControl = this.getRtspPlaybackSpeed() > 1.0 ? "no" : "yes";
        return "clock=" + formattedStartDate + "-" + formattedEndDate + " Rate-Control:" + rateControl;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected HikvisionDevice getDevice() {
        return this.device;
    }

    @Override
    protected Long getTimeDifferenceFromDevice() throws Exception {
        return this.device.getTimeDifferenceFromDevice();
    }

    @Override
    protected String getRequireField() {
        return "";
    }
}

