/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.hikvision;

import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionDevice;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class HikvisionMotionDetectionHandler
extends MotionDetectionHandler
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.hikvision.HikvisionMotionDetectionHandler";
    private HttpServerPushHandler httpServerPushHandler = null;
    private NetworkParameter networkParameter = null;
    private HikvisionDevice hikvisionDevice;
    private long lastTamperingEventSent;
    private boolean tamperingStatus = false;

    public HikvisionDevice getHikvisionDevice() {
        if (this.hikvisionDevice == null) {
            this.hikvisionDevice = (HikvisionDevice)this.listener.getVideoSrv().getDevice();
        }
        return this.hikvisionDevice;
    }

    public HikvisionMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        int errorCode;
        block16: {
            String url;
            StringBuilder sb = new StringBuilder();
            boolean motionWorks = false;
            this.listener = hardwareMotionDetection;
            if (this.listener == null) {
                return -20003;
            }
            try {
                this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
                url = "/Event/triggers/";
                int id = 1;
                if (this.getHikvisionDevice().getDeviceType() == 200425L || this.getHikvisionDevice().getDeviceType() == 200402L) {
                    id = 2;
                }
                sb.append("<EventTrigger>");
                sb.append("<id>");
                sb.append(id);
                sb.append("</id>");
                sb.append("<eventType>VMD</eventType>");
                sb.append("<eventDescription>VMD Event is detected.</eventDescription>");
                sb.append("<EventTriggerNotificationList>");
                sb.append("<EventTriggerNotification>");
                sb.append("<id>");
                sb.append(id);
                sb.append("</id>");
                sb.append("<notificationMethod>email</notificationMethod>");
                sb.append("<notificationRecurrence>beginning</notificationRecurrence>");
                sb.append("</EventTriggerNotification>");
                sb.append("</EventTriggerNotificationList>");
                sb.append("</EventTrigger>");
                this.getHikvisionDevice().getHttpHandler().readPutRequest(url, sb.toString());
                motionWorks = true;
            }
            catch (Exception id) {
                // empty catch block
            }
            try {
                url = "/MotionDetection/1";
                String xmlString = this.getHikvisionDevice().getHttpHandler().readGetRequest(url);
                xmlString = xmlString.substring(xmlString.indexOf(">") + 1, xmlString.lastIndexOf(">") + 1);
                ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
                Document alarmData = new SAXBuilder().build((InputStream)bais);
                Element root = alarmData.getRootElement();
                Namespace ns = root.getNamespace();
                Element enabled = root.getChild("enabled", ns);
                if (enabled != null && enabled.getText().equals("false")) {
                    this.logger.error("Exception while starting Motion detection for " + this + ". Please make sure motion detection is enabled.");
                }
                motionWorks = true;
            }
            catch (Exception xmlString) {
                // empty catch block
            }
            if (!motionWorks) {
                this.logger.error("Error while testing connectivity to motion detection for " + this.listener.getVideoSrv());
                return -21664;
            }
            try {
                String shelterAlarmString = this.getHikvisionDevice().getHttpHandler().readGetRequest("/Video/inputs/channels/" + this.listener.getVideoSrv().getVideoSourceCnf().getServerEntryNo() + "/shelterAlarm");
                if (!shelterAlarmString.contains("<enabled>true</enabled>")) {
                    this.logger.warn("Tampering not enabled on " + (Object)((Object)this.listener) + ". Please enable Tampering on Device.");
                }
            }
            catch (ConfigurationException | SeeTecException ex) {
                this.logger.error("Exception while checking for Tampering Detection on " + (Object)((Object)this.listener), ex);
            }
            url = "/Event/notification/alertStream";
            try {
                try {
                    this.networkParameter.setSoTimeout(10000);
                    this.httpServerPushHandler = new HttpServerPushHandler();
                    errorCode = this.httpServerPushHandler.init(this, this.networkParameter, url);
                    if (errorCode != 0) {
                        this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
                        break block16;
                    }
                    errorCode = this.httpServerPushHandler.startServerPush(true);
                }
                catch (Exception e) {
                    this.logger.error("Reading configuration from " + this.listener.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                    errorCode = -21601;
                }
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
                errorCode = -21651;
            }
        }
        return errorCode;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (this.isShutdown(CLASS_NAME)) {
            return;
        }
        if (statusCode != 0) {
            this.listener.notifyForNetworkProblems();
        }
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21650);
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        byte[] content = httpServerPushContent.getContentBody();
        if (content != null) {
            try {
                Element tamperingDescription;
                Element eventState;
                ByteArrayInputStream bais = new ByteArrayInputStream(content);
                Document alarmData = new SAXBuilder().build((InputStream)bais);
                Element root = alarmData.getRootElement();
                Namespace ns = root.getNamespace();
                Element eventDescription = root.getChild("eventDescription", ns);
                if (eventDescription != null && eventDescription.getText().equals("Motion alarm") && (eventState = root.getChild("eventState", ns)) != null && eventState.getText().equals("active") && this.listener != null) {
                    this.listener.evaluateWindow(0);
                }
                if ((tamperingDescription = root.getChild("eventDescription", ns)) != null && tamperingDescription.getText().toLowerCase().equals("shelteralarm alarm")) {
                    Element tamperingState = root.getChild("eventState", ns);
                    if (tamperingState != null && tamperingState.getText().toLowerCase().equals("active") && this.listener != null && this.listener.getVideoSrv().getVideoSourceCnf().isEnableTampering() && System.currentTimeMillis() > this.lastTamperingEventSent + 10000L) {
                        this.lastTamperingEventSent = System.currentTimeMillis();
                        ((LiveCameraSrv)this.listener.getVideoSrv()).evaluateTampering();
                        this.listener.getVideoSrv().getCore().sendTamperingEvent(this.listener.getVideoSrv());
                        this.tamperingStatus = true;
                    }
                } else if (this.tamperingStatus && System.currentTimeMillis() > this.lastTamperingEventSent + 5000L) {
                    this.tamperingStatus = false;
                }
            }
            catch (ConfigurationException ex) {
                this.logger.error("Exception while reading motion detection or tampering data: " + ex.getMessage());
            }
            catch (JDOMException ex) {
                this.logger.error("Exception while reading motion detection data: " + ex.getMessage());
            }
        }
    }
}

