/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.hikvision;

import de.seetec.v5.re.cm.configuration.definition.device.GenericEventDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.ImageChannel;
import de.seetec.v5.re.cm.device.video.hikvision.Track;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public final class HikvisionHelper {
    public static String encodeAndLimitPresetName(int numberOfDigits, String presetName) throws UnsupportedEncodingException {
        String encodedPresetName = URLEncoder.encode(presetName, "UTF-8");
        while (encodedPresetName.length() > numberOfDigits) {
            encodedPresetName = URLDecoder.decode(encodedPresetName, "UTF-8");
            encodedPresetName = encodedPresetName.substring(0, encodedPresetName.length() - 1);
            encodedPresetName = URLEncoder.encode(encodedPresetName, "UTF-8");
        }
        return encodedPresetName;
    }

    protected static boolean isEventsAvailableForFirstChannelOnly(SupportedGenericEventsType supportedGenericEventsType) {
        if (supportedGenericEventsType == null || supportedGenericEventsType.getGenericEventDefinition().isEmpty()) {
            return false;
        }
        List<GenericEventDefinitionType> genericEvents = supportedGenericEventsType.getGenericEventDefinition();
        for (GenericEventDefinitionType genericEventDefinitionType : genericEvents) {
            if (genericEventDefinitionType.getSourceNumber() <= 1) continue;
            return false;
        }
        return true;
    }

    protected static SupportedGenericEventsType copyEventsForOtherChannels(int numberOfVideoSources, SupportedGenericEventsType supportedGenericEventsType) {
        SupportedGenericEventsType supportedGenericEvents = new SupportedGenericEventsType();
        List<GenericEventDefinitionType> genericEvents = supportedGenericEventsType.getGenericEventDefinition();
        for (GenericEventDefinitionType genericEventDefinitionType : genericEvents) {
            ArrayList<String> globalEvents = new ArrayList<String>();
            globalEvents.add("tamperdetection");
            globalEvents.add("diskfull");
            globalEvents.add("diskerror");
            globalEvents.add("illaccess");
            globalEvents.add("audioexception");
            globalEvents.add("shelteralarm");
            globalEvents.add("recordingfailure");
            if (globalEvents.contains(genericEventDefinitionType.getEventType().toLowerCase())) {
                genericEventDefinitionType.setSourceNumber(0);
                supportedGenericEvents.getGenericEventDefinition().add(genericEventDefinitionType);
                continue;
            }
            if (genericEventDefinitionType.getSourceNumber() == 0) {
                supportedGenericEvents.getGenericEventDefinition().add(genericEventDefinitionType);
                continue;
            }
            if (genericEventDefinitionType.getSourceNumber() != 1) continue;
            for (int i = 1; i <= numberOfVideoSources; ++i) {
                GenericEventDefinitionType newGenericEventDefinitionType = new GenericEventDefinitionType();
                newGenericEventDefinitionType.setEventType(genericEventDefinitionType.getEventType());
                newGenericEventDefinitionType.setSourceNumber(i);
                supportedGenericEvents.getGenericEventDefinition().add(newGenericEventDefinitionType);
            }
        }
        return supportedGenericEvents;
    }

    protected static boolean isCorridorModeSupported(ImageChannel imageChannel) {
        return imageChannel != null && imageChannel.getCorridor() != null && imageChannel.getCorridor().getEnabled() != null && imageChannel.getCorridor().getEnabled().getOpt() != null && imageChannel.getCorridor().getEnabled().getOpt().contains("true") && imageChannel.getCorridor().getEnabled().getOpt().contains("false");
    }

    protected static List<Track> getTracklist(String xmlData, int source) throws JDOMException {
        ArrayList<Track> responseList = new ArrayList<Track>();
        if (xmlData != null && !xmlData.isEmpty()) {
            SAXBuilder saxBuilder = new SAXBuilder();
            ByteArrayInputStream input = new ByteArrayInputStream(xmlData.getBytes());
            Document document = saxBuilder.build((InputStream)input);
            Element root = document.getRootElement();
            Namespace nameSpaceRoot = root.getNamespace();
            List tracks = root.getChildren("Track", nameSpaceRoot);
            for (Element element : tracks) {
                Namespace nameSpaceTracks = element.getNamespace();
                Element id = element.getChild("id", nameSpaceTracks);
                Element channel = element.getChild("Channel", nameSpaceTracks);
                if (!channel.getText().startsWith("" + source)) continue;
                Track track = new Track();
                track.setId(id.getText());
                responseList.add(track);
            }
        }
        return responseList;
    }
}

