/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.hikvision;

import de.seetec.v5.re.cm.DMConstantsIntf;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.EventNotificationAlert;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionDevice;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.HttpHandlerIntf;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HikvisionEventReader
implements HttpHandlerIntf,
Runnable {
    private NetworkParameter networkParameter;
    private Thread myThread;
    private HttpHandlerImpl httpHandler;
    protected Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private HikvisionDevice hikvisionDevice;

    protected void init(HikvisionDevice hikvisionDevice) throws ConfigurationException {
        this.hikvisionDevice = hikvisionDevice;
        this.networkParameter = hikvisionDevice.getDeviceCnf().getNetworkParameter();
        this.myThread = new Thread((Runnable)this, "EventReader for " + hikvisionDevice.toString());
        this.myThread.start();
    }

    public void deliverContent(byte[] httpServerPushContent) {
        byte[] firstTwoBytes = new byte[2];
        System.arraycopy(httpServerPushContent, 0, firstTwoBytes, 0, 2);
        if (Arrays.equals(firstTwoBytes, DMConstantsIntf.FFD8_BYTE)) {
            return;
        }
        EventNotificationAlert eventNotificationAlert = null;
        try {
            eventNotificationAlert = this.hikvisionDevice.unmarshalHikvisionObject(EventNotificationAlert.class, httpServerPushContent);
        }
        catch (Exception ex) {
            this.logger.warn("Exception while parsing event notification for " + this + ": " + ex.getMessage());
        }
        if (eventNotificationAlert != null && eventNotificationAlert.getEventState() != null && eventNotificationAlert.getEventState().getValue().equals("active")) {
            this.hikvisionDevice.deliverEventMessage(eventNotificationAlert);
        }
    }

    public void sendStatusService(int statusCode) {
        if (statusCode != 0) {
            this.logger.warn("Network problems for Hikvision Event Reader from " + this);
            if (this.hikvisionDevice.getNumberOfActiveEventClients() > 0) {
                this.reinizialize();
            } else {
                this.shutdown();
            }
        }
    }

    @Override
    public void run() {
        this.networkParameter.setSoTimeout(15000);
        try {
            String url = "/ISAPI/Event/notification/alertStream";
            if (this.hikvisionDevice.isCGIDevice()) {
                url = url.replace("/ISAPI", "");
            }
            this.httpHandler = new HttpHandlerImpl(this.networkParameter);
            this.httpHandler.readServerPushRequest(url, (HttpHandlerIntf)this);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
    }

    protected void shutdown() {
        if (this.httpHandler != null) {
            this.httpHandler.shutdown();
            this.httpHandler = null;
        }
    }

    private void reinizialize() {
        try {
            Thread.sleep(500L);
            this.init(this.hikvisionDevice);
        }
        catch (Exception ex) {
            this.logger.warn("Exception while re-initializing: " + ex.getMessage() + " for " + this);
        }
    }
}

