/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.hikvision;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.device.video.hikvision.ImageChannel;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionAudioOutServer;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionCameraControl;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionDevice;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionHardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionHelper;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionTriggerHandler;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionVideoSourceClientCGI;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionVideoSourceClientISAPI;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.EdgeStorageParameter;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class HikvisionCameraSrv
extends LiveCameraSrv {
    private boolean globalParametersSet = false;
    private NetworkParameter networkParameter;
    private boolean tamperingEnabled = false;
    private volatile boolean modelInformationAlreadySet = false;
    private boolean audioOverRtsp = true;
    private final Map<Integer, Integer> streams = new HashMap<Integer, Integer>();
    private VideoProfileHandler listener;
    private final Semaphore semaphore = new Semaphore(1);
    private HikvisionDevice hikvisionDevice;

    @Override
    public int initLive() throws UnknownHostException, ConfigurationException {
        int errorCode = super.initLive();
        EdgeStorageParameter edgeStorageParameter = this.getVideoSourceCnf().getEdgeStorageParameter();
        if (edgeStorageParameter != null && edgeStorageParameter.isEnabled()) {
            this.logger.info(this.getHikvisionDevice().checkEdgeStorageReady(this.getVideoSourceCnf().getServerEntryNo()));
        }
        return errorCode;
    }

    private HikvisionDevice getHikvisionDevice() {
        if (this.hikvisionDevice == null && this.device instanceof HikvisionDevice) {
            this.hikvisionDevice = (HikvisionDevice)this.device;
        }
        return this.hikvisionDevice;
    }

    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new HikvisionCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        this.listener = listener;
        StreamingVideoSourceClientRTSP videoSourceClient = null;
        try {
            this.networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception reading network parameters for " + this + ": " + ex.getMessage());
        }
        this.logger.info("Creating new [VideoSourceClient] with VideoProfileHandler=" + listener + " ...");
        HikvisionDevice hikvisionDevice = (HikvisionDevice)this.device;
        if (hikvisionDevice.isCGIDevice()) {
            this.logger.info("API Supported: CGI for " + this);
            videoSourceClient = new HikvisionVideoSourceClientCGI();
        } else {
            this.logger.info("API Supported: ISAPI for " + this);
            videoSourceClient = new HikvisionVideoSourceClientISAPI();
        }
        int errorCode = videoSourceClient.init(core, this, listener);
        if (errorCode != 0) {
            videoSourceClient.shutdown();
            videoSourceClient = null;
            this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
            throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
        }
        try {
            if (this.getVideoSourceCnf().isEnableTampering()) {
                long[] typeList = new long[]{9808L};
                Entity[] entities = this.device.getEnabledEntities(new long[]{this.getEntityID()}, typeList);
                if (!this.tamperingEnabled && entities.length == 0) {
                    this.logger.info("No hardware motion detection entities enabled. Start tampering for " + this);
                    HikvisionHardwareMotionDetectionCnf hikvisionHardwareMotionDetectionCnf = new HikvisionHardwareMotionDetectionCnf();
                    HardwareMotionDetectionCnf[] hardwareMotionDetectionCnf = new HardwareMotionDetectionCnf[]{hikvisionHardwareMotionDetectionCnf};
                    this.hardwareMotionDetection = new HikvisionHardwareMotionDetection();
                    this.hardwareMotionDetection.init(this, hardwareMotionDetectionCnf);
                    this.tamperingEnabled = true;
                }
            }
        }
        catch (Throwable ex) {
            videoSourceClient.shutdown();
            videoSourceClient = null;
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] resolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setGlobalParameters(boolean useTitle, String title, boolean displayDateTime, int rotationAngle) throws ConfigurationException, UnsupportedEncodingException, SeeTecException, InterruptedException {
        this.semaphore.acquire();
        try {
            String value;
            int i;
            String[] defaultParameters;
            String[] parameters;
            String osdParametersOnCamera;
            String url;
            if (this.globalParametersSet) {
                int n = 0;
                return n;
            }
            HikvisionDevice hikvisionDevice = (HikvisionDevice)this.device;
            int videoChannel = this.getVideoSourceCnf().getServerEntryNo();
            StringBuilder xmlData = new StringBuilder();
            if (hikvisionDevice.isCGIDevice()) {
                url = "/Video/inputs/channels/" + videoChannel + "/osdDatetime";
                xmlData.append("<OsdDatetime version=\"1.0\"><enabled>");
                xmlData.append(displayDateTime ? "true" : "false").append("</enabled>");
                try {
                    osdParametersOnCamera = hikvisionDevice.getHttpHandler().readGetRequest(url, true);
                    parameters = new String[]{"posX", "posY", "type", "displayWeek", "attribute", "timeFormat"};
                    defaultParameters = new String[]{"0", "32", "4", "false", "4", "24hours"};
                    for (i = 0; i < parameters.length; ++i) {
                        value = HikvisionCameraSrv.getOsdDateTimeParameters(osdParametersOnCamera, parameters[i]);
                        xmlData.append("<").append(parameters[i]).append(">").append(value.isEmpty() ? defaultParameters[i] : value).append("</").append(parameters[i]).append(">");
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while reading camera parameters for " + this + ": " + ex.getMessage());
                }
                xmlData.append("</OsdDatetime>");
                try {
                    hikvisionDevice.getHttpHandler().readPutRequest(url, xmlData.toString(), true);
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while setting Date/Time display: " + ex.getMessage() + " for " + this);
                    this.logger.error("Will continue anyway...");
                }
            } else {
                url = "/ISAPI/System/Video/inputs/channels/" + videoChannel + "/overlays/dateTimeOverlay";
                xmlData.append("<DateTimeOverlay version=\"1.0\"><enabled>");
                xmlData.append(displayDateTime ? "true" : "false").append("</enabled>");
                try {
                    osdParametersOnCamera = hikvisionDevice.getHttpHandler().readGetRequest(url, true);
                    parameters = new String[]{"positionX", "positionY", "dateStyle", "timeStyle", "displayWeek"};
                    defaultParameters = new String[]{"0", "32", "DD-MM-YYYY", "24hour", "true"};
                    for (i = 0; i < parameters.length; ++i) {
                        value = HikvisionCameraSrv.getOsdDateTimeParameters(osdParametersOnCamera, parameters[i]);
                        xmlData.append("<").append(parameters[i]).append(">").append(value.isEmpty() ? defaultParameters[i] : value).append("</").append(parameters[i]).append(">");
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while reading camera parameters for " + this + ": " + ex.getMessage());
                }
                xmlData.append("</DateTimeOverlay>");
                try {
                    hikvisionDevice.getHttpHandler().readPutRequest(url, xmlData.toString(), true);
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while setting Date/Time display: " + ex.getMessage() + " for " + this);
                    this.logger.error("Will continue anyway...");
                }
            }
            if (hikvisionDevice.isCGIDevice()) {
                xmlData = new StringBuilder("<TextOverlayList><TextOverlay><id>1</id><enabled>");
                url = "/Video/inputs/channels/" + videoChannel + "/overlays/text";
                if (useTitle && title != null) {
                    xmlData.append("true");
                } else {
                    xmlData.append("false");
                }
                xmlData.append("</enabled>");
                try {
                    osdParametersOnCamera = hikvisionDevice.getHttpHandler().readGetRequest(url, true);
                    parameters = new String[]{"posX", "posY"};
                    defaultParameters = new String[]{"20", "544"};
                    for (i = 0; i < parameters.length; ++i) {
                        value = HikvisionCameraSrv.getOsdDateTimeParameters(osdParametersOnCamera, parameters[i]);
                        xmlData.append("<").append(parameters[i]).append(">").append(value.isEmpty() ? defaultParameters[i] : value).append("</").append(parameters[i]).append(">");
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while reading camera parameters for " + this + ": " + ex.getMessage());
                }
                xmlData.append("<message>");
                xmlData.append(title == null ? "seetec" : title.replace(" ", ""));
                xmlData.append("</message></TextOverlay></TextOverlayList>");
            } else {
                url = "/ISAPI/System/Video/inputs/channels/" + videoChannel + "/overlays/text";
                xmlData = new StringBuilder("<TextOverlayList><TextOverlay><id>1</id><enabled>");
                if (useTitle && title != null) {
                    xmlData.append("true");
                } else {
                    xmlData.append("false");
                }
                xmlData.append("</enabled>");
                osdParametersOnCamera = "";
                try {
                    osdParametersOnCamera = hikvisionDevice.getHttpHandler().readGetRequest(url, true);
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while reading camera parameters for " + this + ": " + ex.getMessage());
                }
                parameters = new String[]{"positionX", "positionY"};
                defaultParameters = new String[]{"20", "544"};
                for (i = 0; i < parameters.length; ++i) {
                    value = HikvisionCameraSrv.getOsdDateTimeParameters(osdParametersOnCamera, parameters[i]);
                    xmlData.append("<").append(parameters[i]).append(">").append(value.isEmpty() ? defaultParameters[i] : value).append("</").append(parameters[i]).append(">");
                }
                xmlData.append("<displayText>");
                if (title != null) {
                    xmlData.append(title.replace(" ", ""));
                }
                xmlData.append("</displayText></TextOverlay></TextOverlayList>");
                url = "/ISAPI/System/Video/inputs/channels/" + videoChannel + "/overlays/text";
            }
            try {
                hikvisionDevice.getHttpHandler().readPutRequest(url, xmlData.toString(), true);
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while setting Title display: " + ex.getMessage() + " for " + this);
                this.logger.error("Will continue anyway...");
            }
            catch (Exception ex) {
                this.logger.error("Exception while setting Title display: " + ex.getMessage());
            }
            if (!hikvisionDevice.isCGIDevice()) {
                url = "/ISAPI/System/Video/inputs/channels/" + videoChannel;
                xmlData = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><VideoInputChannel version=\"2.0\" xmlns=\"http://www.hikvision.com/ver20/XMLSchema\"><id>" + videoChannel + "</id><name/></VideoInputChannel>");
            }
            try {
                hikvisionDevice.getHttpHandler().readPutRequest(url, xmlData.toString(), true);
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while removing camera name: " + ex.getMessage() + " for " + this);
                this.logger.error("Will continue anyway...");
            }
            catch (Exception ex) {
                this.logger.error("Exception while removing camera name: " + ex.getMessage());
            }
            if (!hikvisionDevice.isCGIDevice()) {
                this.setRotationIsapi(rotationAngle, videoChannel);
            } else {
                this.setRotationCgi(hikvisionDevice, rotationAngle, videoChannel);
            }
            this.globalParametersSet = true;
        }
        finally {
            this.semaphore.release();
        }
        return 0;
    }

    public void setModelInformation(int width, int height) {
        if (this.modelInformationAlreadySet) {
            return;
        }
        if (this.networkParameter == null) {
            try {
                this.networkParameter = this.device.getDeviceCnf().getNetworkParameter();
            }
            catch (ConfigurationException ex) {
                this.logger.error("Exception reading network parameters for " + this + ": " + ex.getMessage());
            }
        }
        long entityID = this.device.getDeviceType();
        if (width != -1 && height != -1) {
            String[] resolutionsSubstream = this.getCaps("/ISAPI/Streaming/channels/2/capabilities", new String[]{"Video", "videoResolutionWidth"}, "opt");
            String[] resolutionsMainstream = this.getCaps("/ISAPI/Streaming/channels/1/capabilities", new String[]{"Video", "videoResolutionWidth"}, "opt");
            if (resolutionsSubstream == null) {
                resolutionsSubstream = this.getCaps("/ISAPI/Streaming/channels/102/capabilities", new String[]{"Video", "videoResolutionWidth"}, "opt");
            }
            if (resolutionsMainstream == null) {
                resolutionsMainstream = this.getCaps("/ISAPI/Streaming/channels/101/capabilities", new String[]{"Video", "videoResolutionWidth"}, "opt");
            }
            resolutionsMainstream = this.subtract(resolutionsMainstream, resolutionsSubstream);
            this.logger.info("Resolutions for Main stream on " + this + " : ");
            for (String s : resolutionsMainstream) {
                this.logger.info(s);
            }
            this.logger.info("Resolutions for Sub stream on " + this + " : ");
            for (String s : resolutionsSubstream) {
                this.logger.info(s);
            }
            if (this.listener != null) {
                try {
                    boolean isMultistreaming = this.getAdditionalVideoProfileHandler().length > 0;
                    int otherProfileID = -1;
                    int widthOtherStream = -1;
                    int heightOtherStream = -1;
                    if (isMultistreaming) {
                        if (this.listener instanceof BasicVideoProfileHandler) {
                            otherProfileID = this.getAdditionalVideoProfileHandler()[0].getDynamicVideoProfileID();
                            widthOtherStream = this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getImageSize()[0];
                            heightOtherStream = this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getImageSize()[1];
                        } else {
                            otherProfileID = this.getBasicVideoProfileHandler().getDynamicVideoProfileID();
                            widthOtherStream = this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize()[0];
                            heightOtherStream = this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize()[1];
                        }
                    }
                    for (String resolutionMainstream : resolutionsMainstream) {
                        if (resolutionMainstream.contains("*")) {
                            if (!resolutionMainstream.toLowerCase().equals(width + "*" + height)) continue;
                            this.streams.put(this.listener.getDynamicVideoProfileID(), 1);
                            continue;
                        }
                        if (!resolutionMainstream.toLowerCase().equals(Integer.toString(width))) continue;
                        this.streams.put(this.listener.getDynamicVideoProfileID(), 1);
                    }
                    for (String resolutionSubstream : resolutionsSubstream) {
                        if (resolutionSubstream.contains("*")) {
                            if (!resolutionSubstream.toLowerCase().equals(width + "*" + height)) continue;
                            this.streams.put(this.listener.getDynamicVideoProfileID(), 2);
                            continue;
                        }
                        if (!resolutionSubstream.toLowerCase().equals(Integer.toString(width))) continue;
                        this.streams.put(this.listener.getDynamicVideoProfileID(), 2);
                    }
                    this.logger.info("Resolution " + width + " * " + height + " is mapped to stream " + this.streams.get(this.listener.getDynamicVideoProfileID()));
                    if (isMultistreaming) {
                        for (String resolutionMainstream : resolutionsMainstream) {
                            if (!resolutionMainstream.toLowerCase().equals(widthOtherStream + "*" + heightOtherStream)) continue;
                            this.streams.put(otherProfileID, 1);
                        }
                        for (String resolutionSubstream : resolutionsSubstream) {
                            if (!resolutionSubstream.toLowerCase().equals(widthOtherStream + "*" + heightOtherStream)) continue;
                            this.streams.put(otherProfileID, 2);
                        }
                        this.logger.info("Resolution " + widthOtherStream + " * " + heightOtherStream + " is mapped to stream " + this.streams.get(otherProfileID));
                    }
                }
                catch (ConfigurationException ex) {
                    this.logger.error("Exception while matching stream number to video profile for " + this);
                }
            }
        }
        if (entityID == 200403L) {
            this.audioOverRtsp = false;
        }
        if (width != -1 && height != -1) {
            this.modelInformationAlreadySet = true;
        }
    }

    public int getStreamNumber(VideoProfileHandler videoProfileHandler) {
        return this.streams.get(videoProfileHandler.getDynamicVideoProfileID());
    }

    public boolean getAudioOverRtsp() {
        return this.audioOverRtsp;
    }

    public String[] getCaps(String url, String[] elementPath, String parameterName) {
        String[] ret = null;
        try {
            HikvisionDevice hikvisionDevice = (HikvisionDevice)this.device;
            String parameterString = "";
            try {
                parameterString = hikvisionDevice.getHttpHandler().readGetRequest(url, true);
            }
            catch (SeeTecException ex) {
                parameterString = hikvisionDevice.getHttpHandler().readGetRequest(url.replace("/ISAPI", ""), true);
            }
            parameterString = parameterString.substring(parameterString.indexOf(62) + 1, parameterString.lastIndexOf(62) + 1);
            ByteArrayInputStream bais = new ByteArrayInputStream(parameterString.getBytes());
            Document cameraConf = new SAXBuilder().build((InputStream)bais);
            Element element = cameraConf.getRootElement();
            Namespace ns = element.getNamespace();
            for (String elementFromPath : elementPath) {
                element = element.getChild(elementFromPath, ns);
            }
            if (element != null) {
                String parameterValues = element.getAttributeValue(parameterName);
                ret = parameterValues.split(",");
            }
        }
        catch (Throwable ex) {
            this.logger.error("Exception while reading camera parameters for " + this + ": " + ex.getMessage());
        }
        return ret;
    }

    public static String getFramerate(long fps, int maxFrameRate) {
        if (fps < 1500L) {
            return "100";
        }
        if (fps < 3000L || maxFrameRate < 300) {
            return "200";
        }
        if (fps < 5000L || maxFrameRate < 500) {
            return "400";
        }
        if (fps < 7000L || maxFrameRate < 700) {
            return "600";
        }
        if (fps < 9000L || maxFrameRate < 900) {
            return "800";
        }
        if (fps < 11000L || maxFrameRate < 1100) {
            return "1000";
        }
        if (fps < 12500L || maxFrameRate < 1250) {
            return "1200";
        }
        if (fps < 13500L || maxFrameRate < 1350) {
            if (maxFrameRate == 2500 || maxFrameRate == 1250 || maxFrameRate == 1200) {
                return maxFrameRate == 1200 || maxFrameRate == 2500 ? "1200" : "1250";
            }
            return "1200";
        }
        if (fps < 15500L || maxFrameRate < 1550) {
            if (maxFrameRate == 2500 || maxFrameRate == 1250 || maxFrameRate == 1200) {
                return maxFrameRate == 1200 || maxFrameRate == 2500 ? "1200" : "1250";
            }
            return "1500";
        }
        if (fps < 17000L || maxFrameRate < 1700) {
            return "1600";
        }
        if (fps < 19000L || maxFrameRate < 1900) {
            return "1800";
        }
        if (fps < 21000L || maxFrameRate < 2100) {
            return "2000";
        }
        if (fps < 23500L || maxFrameRate < 2350) {
            return "2200";
        }
        if (fps < 30000L || maxFrameRate < 3000) {
            return "2500";
        }
        if (fps == 30000L) {
            if (maxFrameRate == 2500 || maxFrameRate == 5000) {
                return "2500";
            }
            return "3000";
        }
        if (maxFrameRate == 2500) {
            return "2500";
        }
        if (maxFrameRate == 3000) {
            return "3000";
        }
        if (maxFrameRate == 6000) {
            if (fps < 60000L) {
                return "3000";
            }
            return "6000";
        }
        if (fps < 50000L) {
            return "2500";
        }
        return "5000";
    }

    public void resetModelInformation() {
        this.modelInformationAlreadySet = false;
    }

    @Override
    protected GenericEventTriggerHandler createNewGenericEventTriggerHandler() {
        HikvisionTriggerHandler hikvisionTriggerHandler = new HikvisionTriggerHandler(this);
        try {
            hikvisionTriggerHandler.setVideoSourceNumber(this.getVideoSourceCnf().getServerEntryNo());
        }
        catch (ConfigurationException | SeeTecException ex) {
            this.logger.error("Exception while creating Hikvision Trigger Handler for " + this + ": " + ex.getMessage());
        }
        return hikvisionTriggerHandler;
    }

    private String[] subtract(String[] supersets, String[] sets) {
        ArrayList<String> v = new ArrayList<String>();
        boolean foundDouble = false;
        for (String superset : supersets) {
            for (String set : sets) {
                if (!superset.equals(set)) continue;
                foundDouble = true;
            }
            if (!foundDouble) {
                v.add(superset);
            }
            foundDouble = false;
        }
        return v.toArray(new String[v.size()]);
    }

    public static String getOsdDateTimeParameters(String parameterString, String parameter) {
        String ret = "";
        try {
            parameterString = parameterString.substring(parameterString.indexOf(62) + 1, parameterString.lastIndexOf(62) + 1);
            ByteArrayInputStream bais = new ByteArrayInputStream(parameterString.getBytes());
            Document osdConf = new SAXBuilder().build((InputStream)bais);
            Element element = osdConf.getRootElement();
            Namespace ns = element.getNamespace();
            Element wantedParameter = element.getChild(parameter, ns);
            if (wantedParameter != null) {
                ret = wantedParameter.getText();
            } else {
                List children = element.getChildren();
                for (Object object : children) {
                    Element child;
                    if (!(object instanceof Element) || (wantedParameter = (child = (Element)object).getChild(parameter, ns)) == null) continue;
                    return wantedParameter.getText();
                }
            }
        }
        catch (JDOMException ex) {
            return "";
        }
        return ret;
    }

    @Override
    protected HikvisionAudioOutServer createAudioOutServer() {
        NetworkParameter networkParameter = null;
        HttpHandlerImpl httpHandler = null;
        try {
            networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
            httpHandler = ((HikvisionDevice)this.getDevice()).getHttpHandler();
        }
        catch (ConfigurationException configurationException) {
            this.logger.error("Could not read Network parameter [" + configurationException.getMessage() + "] for " + this);
        }
        HikvisionAudioOutServer hikvisionAudioOutServer = null;
        try {
            hikvisionAudioOutServer = new HikvisionAudioOutServer(networkParameter, (HttpHandler)httpHandler, ((HikvisionDevice)this.getDevice()).isCGIDevice());
            hikvisionAudioOutServer.init();
        }
        catch (SeeTecException ex) {
            this.logger.warn("Hikvision Audio Out Server could not be initialized : " + ex.getMessage());
        }
        return hikvisionAudioOutServer;
    }

    private void setRotationCgi(HikvisionDevice device, int rotation, int videoSource) throws ConfigurationException {
        try {
            String url = "/Image/channels/" + videoSource + "/imageFlip";
            String result = device.getHttpHandler().readGetRequest(url, true);
            if (rotation == 0 && result.contains("false") || rotation == 180 && result.contains("CENTER") || rotation == 90 && result.contains("LEFTRIGHT")) {
                return;
            }
            result = result.substring(result.indexOf("<?xml version"), result.length());
            if (rotation == 0) {
                result = result.replace("true", "false");
            } else if (rotation == 180) {
                if (result.contains("false")) {
                    result = result.replace("<enabled>false</enabled>", "<enabled>true</enabled><ImageFlipStyle>CENTER</ImageFlipStyle>");
                } else {
                    result = result.replace("LEFTRIGHT", "CENTER");
                    result = result.replace("UPDOWN", "CENTER");
                }
            } else if (result.contains("false")) {
                result = result.replace("<enabled>false</enabled>", "<enabled>true</enabled><ImageFlipStyle>LEFTRIGHT</ImageFlipStyle>");
            } else {
                result = result.replace("UPDOWN", "LEFTRIGHT");
                result = result.replace("CENTER", "LEFTRIGHT");
            }
            device.getHttpHandler().readPutRequest(url, result, true);
        }
        catch (SeeTecException ex) {
            this.logger.warn("Could not set image Rotation for " + this + ": " + ex.getMessage());
        }
    }

    protected void setRotationIsapi(int rotation, int channelNumber) throws ConfigurationException, SeeTecException {
        try {
            HikvisionDevice hikvisionDevice = (HikvisionDevice)this.device;
            ImageChannel imageChannel = hikvisionDevice.getHikvisionObject(ImageChannel.class, "/ISAPI/Image/channels/1/capabilities");
            boolean isCorridorModeSupported = HikvisionHelper.isCorridorModeSupported(imageChannel);
            if (isCorridorModeSupported) {
                switch (rotation) {
                    case 0: {
                        this.enableImageFlip(false, channelNumber);
                        this.enableCorridor(false, channelNumber);
                        break;
                    }
                    case 90: {
                        this.enableImageFlip(false, channelNumber);
                        this.enableCorridor(true, channelNumber);
                        break;
                    }
                    case 180: {
                        this.enableImageFlip(true, channelNumber);
                        this.enableCorridor(false, channelNumber);
                        break;
                    }
                    default: {
                        this.enableImageFlip(true, channelNumber);
                        this.enableCorridor(true, channelNumber);
                        break;
                    }
                }
            } else {
                switch (rotation) {
                    case 0: {
                        this.enableImageFlip(false, channelNumber);
                        break;
                    }
                    default: {
                        this.enableImageFlip(true, channelNumber);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Exception while trying to rotate image: " + ex.getMessage() + " for " + this);
        }
    }

    private void enableImageFlip(boolean enabled, int channelNumber) throws SeeTecException, ConfigurationException {
        String url = "/ISAPI/Image/channels/" + channelNumber + "/imageFlip";
        StringBuilder body = new StringBuilder("<ImageFlip xmlns=\"http://www.hikvision.com/ver20/XMLSchema\" version=\"2.0\">");
        if (enabled) {
            body.append("<enabled>true</enabled><ImageFlipStyle>CENTER</ImageFlipStyle>");
        } else {
            body.append("<enabled>false</enabled>");
        }
        body.append("</ImageFlip>");
        HikvisionDevice hikvisionDevice = (HikvisionDevice)this.device;
        hikvisionDevice.getHttpHandler().readPutRequest(url, body.toString());
    }

    private void enableCorridor(boolean enabled, int channelNumber) throws SeeTecException, ConfigurationException {
        String url = "/ISAPI/Image/channels/" + channelNumber + "/corridor";
        StringBuilder body = new StringBuilder("<corridor xmlns=\"http://www.hikvision.com/ver20/XMLSchema\" version=\"2.0\">");
        if (enabled) {
            body.append("<enabled>true</enabled>");
        } else {
            body.append("<enabled>false</enabled>");
        }
        body.append("</corridor>");
        HikvisionDevice hikvisionDevice = (HikvisionDevice)this.device;
        hikvisionDevice.getHttpHandler().readPutRequest(url, body.toString());
    }
}

