/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.grundig;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.videoprofile.AdditionalVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.grundig.GrundigDevice;
import de.seetec.v5.re.cm.device.video.grundig.GrundigHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.grundig.GrundigIOHandler;
import de.seetec.v5.re.cm.device.video.grundig.GrundigMotionDetectionHandler;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.Reader;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.onvif.ver10.media.wsdl.Media;
import org.onvif.ver10.schema.AudioEncoderConfiguration;
import org.onvif.ver10.schema.AudioEncoding;
import org.onvif.ver10.schema.Profile;

public class GrundigVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.grundig.GrundigVideoSourceClient";
    private MetadataSourceClient metadataSourceClient;

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }

    @Override
    public int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        try {
            GrundigDevice grundigDevice = (GrundigDevice)this.getVideoSrv().getDevice();
            OnvifCore onvifCore = grundigDevice.getOnvifCore();
            String profileToken = "";
            if (this.listener instanceof BasicVideoProfileHandler) {
                profileToken = "Profile1";
                this.logger.info("BasicVideoProfileHandler");
            } else if (this.listener instanceof AdditionalVideoProfileHandler) {
                profileToken = "Profile2";
                this.logger.info("AdditionalVideoProfileHandler");
            }
            this.logger.info(profileToken + " will be used!");
            Media mediaService = onvifCore.getMediaService().getOnvifMediaService();
            Profile profile = mediaService.getProfile(profileToken);
            String streamUri = "";
            if (this.listener instanceof BasicVideoProfileHandler) {
                streamUri = this.videoCodec == Codec.H264 ? "rtsp://" + this.getHost() + "/h264" : "rtsp://" + this.getHost() + "/jpeg";
            }
            this.logger.info("streamUri: " + streamUri);
            this.rtspUrl = streamUri;
            try {
                if (this.isAudioEnabled) {
                    AudioEncoding audioEncoding = null;
                    if (this.audioCodec == Codec.G711U) {
                        this.audioCodec = Codec.G711A;
                        audioEncoding = AudioEncoding.G_711;
                    } else if (this.audioCodec == Codec.G726) {
                        audioEncoding = AudioEncoding.G_726;
                    }
                    if (profile.getAudioSourceConfiguration() == null) {
                        mediaService.addAudioSourceConfiguration(profileToken, "AudioSource1");
                    }
                    if (profile.getAudioEncoderConfiguration() == null) {
                        mediaService.addAudioEncoderConfiguration(profileToken, "AudioEncoder1");
                    }
                    AudioEncoderConfiguration audioEncoderConfiguration = profile.getAudioEncoderConfiguration();
                    audioEncoderConfiguration.setEncoding(audioEncoding);
                    if (audioEncoding == AudioEncoding.G_711) {
                        audioEncoderConfiguration.setBitrate(64000);
                        audioEncoderConfiguration.setSampleRate(8000);
                    } else if (audioEncoding == AudioEncoding.G_726) {
                        audioEncoderConfiguration.setBitrate(32000);
                        audioEncoderConfiguration.setSampleRate(8000);
                    }
                    mediaService.setAudioEncoderConfiguration(audioEncoderConfiguration, true);
                } else {
                    if (profile.getAudioSourceConfiguration() != null) {
                        mediaService.removeAudioSourceConfiguration(profileToken);
                    }
                    if (profile.getAudioEncoderConfiguration() != null) {
                        mediaService.removeAudioEncoderConfiguration(profileToken);
                    }
                }
            }
            catch (Exception exception) {
                this.logger.warn("Audio is not available via ONVIF");
                if (exception.getCause().getMessage().contains("401: Unauthorized")) {
                    this.logger.warn("=> Authorization failed");
                }
                this.isAudioEnabled = false;
            }
        }
        catch (Exception exception) {
            this.logger.info(exception.getMessage() + this);
        }
        try {
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, "*");
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            long[] typeList = new long[]{9808L};
            if (this.getVideoSrv().getDevice().getEnabledEntities(new long[]{this.getVideoSrv().getEntityID()}, typeList).length > 0) {
                this.metadataSourceClient = new MetadataSourceClient(this);
                this.rtspSettings.enableMetadata(this.metadataSourceClient);
                this.rtspSettings.setMetadataTimeout(this.networkParameter.getSoTimeout());
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSP Stream failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while starting RTSP Handling for " + this.getVideoSrv() + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (Exception ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.metadataSourceClient != null) {
            this.metadataSourceClient.shutdown();
            this.metadataSourceClient = null;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    protected class MetadataSourceClient
    implements RTSPHandlerIntf {
        private RTSPHandlerIntf listener = null;
        private byte[] receiverReportMetadata = new byte[32];

        public MetadataSourceClient(RTSPHandlerIntf listener) {
            this.listener = listener;
            this.receiverReportMetadata[0] = -127;
            this.receiverReportMetadata[1] = -55;
            this.receiverReportMetadata[2] = 0;
            this.receiverReportMetadata[3] = 7;
        }

        @Override
        public void onNetworkError(int error) {
            if (this.listener != null) {
                this.listener.onNetworkError(error);
            }
        }

        @Override
        public void processData(byte[] data) {
            boolean offset = false;
            if (data[1] != -56) {
                String content = new String(data, 12, data.length - 12);
                boolean booleanValue = false;
                try {
                    GrundigHardwareMotionDetection grundigHardwareMotionDetection;
                    boolean value;
                    SAXBuilder parser = new SAXBuilder();
                    Document document = parser.build((Reader)new StringReader(content.trim()));
                    Element rootElement = document.getRootElement();
                    Namespace namespaceTT = Namespace.getNamespace((String)"tt", (String)"http://www.onvif.org/ver10/schema");
                    Namespace namespaceWSNT = Namespace.getNamespace((String)"wsnt", (String)"http://docs.oasis-open.org/wsn/b-2");
                    Element messageElement = rootElement.getChild("Event", namespaceTT).getChild("NotificationMessage", namespaceWSNT).getChild("Message", namespaceWSNT).getChild("Message", namespaceTT);
                    if (messageElement.getChild("Source", namespaceTT).getChild("SimpleItem", namespaceTT).getAttribute("Name").getValue().equals("VideoSourceToken") && (value = messageElement.getChild("Data", namespaceTT).getChild("SimpleItem", namespaceTT).getAttribute("Value").getBooleanValue()) && (grundigHardwareMotionDetection = (GrundigHardwareMotionDetection)GrundigVideoSourceClient.this.getVideoSrv().getHardwareMotionDetection()) != null && grundigHardwareMotionDetection.getMotionDetectionHandler() != null) {
                        ((GrundigMotionDetectionHandler)((Object)grundigHardwareMotionDetection.getMotionDetectionHandler())).processMotionDetection(0);
                    }
                    if (messageElement.getChild("Source", namespaceTT).getChild("SimpleItem", namespaceTT).getAttribute("Name").getValue().equals("RelayToken")) {
                        booleanValue = messageElement.getChild("Data", namespaceTT).getChild("SimpleItem", namespaceTT).getAttribute("Value").getBooleanValue();
                        GrundigDevice grundigDevice = (GrundigDevice)GrundigVideoSourceClient.this.getVideoSrv().getDevice();
                        GrundigIOHandler grundigIOHandler = (GrundigIOHandler)grundigDevice.getIOHandler();
                        grundigIOHandler.setAlarm(booleanValue);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void shutdown() {
            this.listener = null;
            this.receiverReportMetadata = null;
        }

        @Override
        public void sendStatusService(int errorCode) {
        }

        @Override
        public void sendDescribeResponse(RTSPResponse response) {
        }

        @Override
        public void setSSRCfromRTSP(String ssrc) {
        }
    }
}

