/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.grundig;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.grundig.GrundigDevice;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.List;
import org.onvif.ver10.deviceio.wsdl.DeviceIOPort;
import org.onvif.ver10.schema.RelayLogicalState;
import org.onvif.ver10.schema.RelayOutput;

public class GrundigIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.grundig.GrundigIOHandler";
    private int errorCode;
    private DeviceIOPort deviceIOservice = null;
    private boolean alarm = false;

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean previousLoopWithError = false;
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs();
                    if (previousLoopWithError) {
                        previousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this + " ...");
                        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
                        for (int i = 0; i < iServices.length; ++i) {
                            if (!iServices[i].getEntity().isEnabled().booleanValue()) continue;
                            iServices[i].publishServiceStatus(iServices[i].getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    previousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        if (ex.getMessage().indexOf("Address already in use") >= 0) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
                        for (int i = 0; i < iServices.length; ++i) {
                            if (!iServices[i].getEntity().isEnabled().booleanValue()) continue;
                            iServices[i].publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public void setAlarm(boolean alarm) {
        this.alarm = alarm;
    }

    private int readDigitalInputs() throws Exception {
        GrundigDevice grundigDevice;
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Reading digital inputs of " + this + " ...");
        }
        if ((grundigDevice = (GrundigDevice)this.device).isOnvifDevice()) {
            if (this.alarm) {
                iServices[0].checkInput(1);
                iServices[1].checkInput(1);
            } else {
                iServices[0].checkInput(0);
                iServices[1].checkInput(0);
            }
        }
        return 0;
    }

    @Override
    public DigitalInputSrv[] getDigitalInputSrv() {
        return super.getDigitalInputSrv();
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        GrundigDevice grundigDevice;
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber + "] :-(");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this + " :-(");
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        if ((grundigDevice = (GrundigDevice)this.device).isOnvifDevice()) {
            try {
                IOHandler.HoldTimer holdTimer;
                this.logger.info("holdTime: " + holdTime);
                this.logger.info("value: " + value);
                this.deviceIOservice = grundigDevice.getOnvifCore().getDeviceIoService().getOnvifDeviceIoService();
                List relayOutputs = this.deviceIOservice.getRelayOutputs();
                RelayOutput relayOutput = (RelayOutput)relayOutputs.get(outputNumber - 1);
                RelayLogicalState relayLogicalState = value > 0 ? RelayLogicalState.ACTIVE : RelayLogicalState.INACTIVE;
                this.deviceIOservice.setRelayOutputState(relayOutput.getToken(), relayLogicalState);
                if (holdTime > 0L && (this.errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                    holdTimer.shutdown();
                    this.logger.warn("Creating " + holdTimer + " failed with error [" + this.errorCode + "] :-(");
                }
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)throwable, throwable);
                this.logger.warn("Problems setting output [" + outputNumber + "] of " + this + " :-(");
            }
        }
        return 0;
    }
}

