/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.grundig;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifException;
import de.seetec.v5.re.cm.device.video.grundig.GrundigIOHandler;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class GrundigDevice
extends VideoServer {
    private int errorCode;
    private NetworkParameter networkParameter;
    private OnvifCore onvifCore = null;

    @Override
    public int initializeDevice(long nSrvType) {
        block10: {
            super.initializeDevice(nSrvType);
            if (this.isOnvifDevice()) {
                try {
                    if (this.networkParameter == null) {
                        this.networkParameter = this.getDeviceCnf().getNetworkParameter();
                    }
                    if (this.networkParameter == null) break block10;
                    if (this.onvifCore == null) {
                        this.onvifCore = new OnvifCore();
                    }
                    String user = null;
                    if (this.networkParameter.getUserPWD() != null && this.networkParameter.getUserPWD()[0] != null) {
                        user = this.networkParameter.getUserPWD()[0];
                    }
                    String pw = null;
                    if (this.networkParameter.getUserPWD() != null && this.networkParameter.getUserPWD()[1] != null) {
                        pw = this.networkParameter.getUserPWD()[1];
                    }
                    boolean useAuthorization = false;
                    if (user != null && pw != null) {
                        useAuthorization = true;
                    }
                    OnvifDevice onvifDevice = new OnvifDevice(this.getDeviceEntity().getEntityName(), this.networkParameter, user, pw, "PasswordDigest", useAuthorization);
                    try {
                        this.onvifCore.init(onvifDevice, this.logger.isDebugEnabled());
                    }
                    catch (OnvifException onvifException) {
                        this.onvifCore.shutdown();
                        this.errorCode = onvifException.getErrorCode();
                        this.logger.error(onvifException.getCause().getMessage());
                        return this.errorCode;
                    }
                }
                catch (ConfigurationException exception) {
                    this.logger.info((Object)exception);
                }
            }
        }
        return 0;
    }

    @Override
    protected IOHandler createIOHandler() {
        return new GrundigIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    @Override
    public String getFirmwareVersion() {
        return "<unknown>";
    }

    public final OnvifCore getOnvifCore() {
        if (this.onvifCore != null) {
            return this.onvifCore;
        }
        return null;
    }

    public final boolean isOnvifDevice() {
        long deviceType = this.getDeviceType();
        return deviceType == 204104L || deviceType == 204106L || deviceType == 204103L || deviceType == 204102L || deviceType == 204100L || deviceType == 204101L || deviceType == 204105L;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }
}

