/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.grundig;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.grundig.GrundigCameraControl;
import de.seetec.v5.re.cm.device.video.grundig.GrundigDevice;
import de.seetec.v5.re.cm.device.video.grundig.GrundigVideoSourceClient;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;

public class GrundigCameraSrv
extends LiveCameraSrv {
    private int preparationError = 0;
    public static final String PROFILE_1 = "Profile1";
    public static final String PROFILE_2 = "Profile2";

    public final int init(Core core, Device device, Entity entity, int preparationError) {
        this.preparationError = preparationError;
        return this.init(core, device, entity);
    }

    @Override
    public CameraControl createCameraControl(Long nEntityType) {
        return new GrundigCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        GrundigVideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [ VideoSourceClient ] with VideoProfileHandler=" + listener + " ...");
        try {
            if (this.preparationError != 0) {
                this.sendStatusService(this.preparationError);
                errorCode = this.preparationError;
            } else {
                GrundigDevice grundigDevice = (GrundigDevice)this.getDevice();
                if (grundigDevice.isOnvifDevice()) {
                    videoSourceClient = new GrundigVideoSourceClient();
                }
                errorCode = videoSourceClient.init(core, this, listener);
            }
            if (errorCode != 0) {
                if (videoSourceClient != null) {
                    videoSourceClient.shutdown();
                    videoSourceClient = null;
                }
                this.logger.error("Initializing [ VideoSourceClient ] for " + this + " failed with error [ " + errorCode + " ] :-( ");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] resolution) throws SeeTecException {
        throw new SeeTecException(-20001, "Unknown exception while requesting snapshot");
    }
}

