/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.grandeye.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.grandeye.GrandEyeCameraSrv;
import de.seetec.v5.re.cm.device.video.grandeye.GrandEyeDevice;
import de.seetec.v5.shared.EntityType;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class GrandEyeH264VideoSourceClient
extends StreamingVideoSourceClientRTSP
implements EntityType {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.grandeye.mpeg.GrandEyeH264VideoSourceClient";
    private StringBuffer url = null;
    private int memoryTotal;
    private int memoryH264;

    @Override
    public int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        GrandEyeDevice grandEyeDevice = (GrandEyeDevice)this.getVideoSrv().getDevice();
        int[] memory = grandEyeDevice.calculateMemoryUsed(this.width, this.height);
        this.memoryTotal = memory[0];
        this.memoryH264 = memory[1];
        if (this.memoryTotal + grandEyeDevice.getMemoryUsed() > 100 || this.memoryH264 + grandEyeDevice.getMemoryUsedH264() > 100) {
            this.logger.error("Not enough ressources available on camera " + this);
            return -21601;
        }
        grandEyeDevice.setMemoryUsed(this.memoryTotal);
        grandEyeDevice.setMemoryUsedH264(this.memoryH264);
        int nCamera = ((GrandEyeCameraSrv)super.getVideoSrv()).getVirtualCameraID(this.getListener());
        this.iFrameDist = this.fps * (long)this.iFrameDistMS / 1000000L;
        this.iFrameDist = this.iFrameDist < 1L ? 1L : this.iFrameDist;
        this.iFrameDist = this.iFrameDist > 120L ? 120L : this.iFrameDist;
        this.quality /= 1000;
        this.fps /= 1000L;
        this.fps = this.fps < 1L ? 1L : this.fps;
        this.bandwidth = this.bandwidth < 50000 ? 50000 : this.bandwidth;
        this.bandwidth = this.bandwidth > 4000000 ? 4000000 : this.bandwidth;
        this.url = new StringBuffer("/seth264settings.cgi?");
        this.url.append("camera=");
        this.url.append(nCamera);
        if (this.isConstantBitrateUsed) {
            this.url.append("&ratecontrol=cbr");
            this.url.append("&cbrbitrate=");
            this.url.append(this.bandwidth);
        } else {
            this.url.append("&ratecontrol=vbr");
            this.url.append("&vbrquality=");
            this.url.append(this.quality);
        }
        this.url.append("&goplength=");
        this.url.append(this.iFrameDist);
        this.url.append("&maxfps=");
        this.url.append(this.fps);
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)this.url.toString(), (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException e) {
            this.logger.error("Error while setting camera parameters for " + this.getVideoSrv() + ": " + e.getMessage());
            return e.getErrorCode();
        }
        catch (Exception e) {
            this.logger.error("Error while setting iFrame distance " + this.getVideoSrv());
            return -21601;
        }
        this.url = new StringBuffer("rtsp://");
        this.url.append(this.getHost());
        this.url.append("/h264/video.sdp?");
        this.url.append("camera=");
        this.url.append(nCamera);
        try {
            this.transmissionID = this.getListener().getVideoSourceParameter().getTransmissionID();
        }
        catch (ConfigurationException exception) {
            this.logger.error("Exception while getting streaming configuration for " + this + ": " + exception.getMessage());
        }
        try {
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.url.toString(), this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 1);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSP Handling failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while starting RTSP Handling for " + this.getVideoSrv() + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (Exception ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        GrandEyeDevice grandEyeDevice = (GrandEyeDevice)this.getVideoSrv().getDevice();
        grandEyeDevice.setMemoryUsed(-this.memoryTotal);
        grandEyeDevice.setMemoryUsedH264(-this.memoryH264);
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.getListener().sendStatusService(error);
        this.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

