/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.grandeye.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.grandeye.GrandEyeCameraSrv;
import de.seetec.v5.re.cm.device.video.grandeye.GrandEyeDevice;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class GrandEyeJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.grandeye.jpeg.GrandEyeJPEGVideoSourceClient";
    private HttpServerPushHandler httpServerPushHandler = null;
    private int memoryTotal;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        try {
            int errorCode = 0;
            this.logger.info("init started for" + this.getVideoSrv());
            errorCode = super.init(false);
            if (errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
                return errorCode;
            }
            GrandEyeDevice grandEyeDevice = (GrandEyeDevice)this.getVideoSrv().getDevice();
            int[] memory = grandEyeDevice.calculateMemoryUsed(this.width, this.height);
            this.memoryTotal = memory[0];
            if (this.memoryTotal + grandEyeDevice.getMemoryUsed() > 100) {
                this.logger.error("Not enough ressources available on camera " + this);
                return -21601;
            }
            grandEyeDevice.setMemoryUsed(this.memoryTotal);
            try {
                int jpegQuality = (this.quality + 999) / 1000;
                if (jpegQuality < 5) {
                    jpegQuality = 5;
                }
                if (jpegQuality > 95) {
                    jpegQuality = 95;
                }
                if (this.videoSourceNr == 8) {
                    this.setVideoParameter("/admin/setparam.cgi?jpegbayerquality=" + jpegQuality);
                } else {
                    this.setVideoParameter("/admin/setparam.cgi?jpegquality=" + jpegQuality);
                }
            }
            catch (SeeTecException sex) {
                this.logger.error("Exception while initializing " + this);
                return sex.getErrorCode();
            }
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return errorCode;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        int errorCode = 0;
        try {
            long nFPS = (this.highestFramerate + 999L) / 1000L;
            String sSeeTecID = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
            int nCamera = ((GrandEyeCameraSrv)super.getVideoSrv()).getVirtualCameraID(this.getListener());
            StringBuffer sb = new StringBuffer("/mjpg/video.cgi?sid=");
            sb.append(sSeeTecID);
            sb.append("&camera=");
            sb.append(nCamera);
            sb.append("&maxfps=");
            sb.append(nFPS);
            sb.append("&title=");
            sb.append(this.useTitle ? "1" : "0");
            sb.append("&date=");
            sb.append(this.useDateTime ? "1" : "0");
            sb.append("&clock=");
            sb.append(this.useDateTime ? "1" : "0");
            if (this.title != null && this.title.length() > 0) {
                sb.append("&textstring=");
                sb.append(this.title);
                sb.append("&textcolor=white");
                sb.append("&textbackgroundcolor=black");
            }
            if (this.resolutionTag != null && this.resolutionTag.trim().length() > 0) {
                sb.append("&resolution=");
                sb.append(this.resolutionTag.trim());
            } else {
                sb.append("&resolution=");
                sb.append(this.width);
                sb.append("x");
                sb.append(this.height);
            }
            this.logger.info("Using [" + sb + "] for " + this);
            try {
                boolean bAsynchronous = false;
                this.httpServerPushHandler = new HttpServerPushHandler();
                this.networkParameter.setSoTimeout(5000);
                errorCode = this.httpServerPushHandler.init(this, this.networkParameter, sb.toString());
                if (errorCode != 0) {
                    this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
                } else {
                    errorCode = this.httpServerPushHandler.startServerPush(bAsynchronous);
                }
                if (this.httpServerPushHandler != null) {
                    this.httpServerPushHandler.shutdown();
                }
            }
            catch (Exception e) {
                this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                errorCode = -21601;
                this.listener.sendStatusService(errorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            errorCode = -21651;
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public void setVideoParameter(String sURL) throws SeeTecException {
        this.logger.info("Setting parameter [" + sURL + "] for " + this);
        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sURL);
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.shutdown();
    }

    @Override
    public int shutdown() {
        GrandEyeDevice grandEyeDevice = (GrandEyeDevice)this.getVideoSrv().getDevice();
        grandEyeDevice.setMemoryUsed(-this.memoryTotal);
        return super.shutdown();
    }
}

