/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.grandeye.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.grandeye.GrandEyeCameraSrv;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class GrandEyeEvolutionJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.grandeye.jpeg.GrandEyeEvolutionJPEGVideoSourceClient";
    private HttpServerPushHandler httpServerPushHandler = null;
    private int camera;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        try {
            int errorCode = 0;
            this.logger.info("init started for" + this.getVideoSrv());
            errorCode = super.init(false);
            if (errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
                return errorCode;
            }
            try {
                GrandEyeCameraSrv grandEyeCameraSrv = (GrandEyeCameraSrv)this.getVideoSrv();
                grandEyeCameraSrv.setCodecAndResolution(this.listener);
                this.camera = grandEyeCameraSrv.getCameraNumber(this.width);
                int jpegQuality = this.quality = (this.quality + 999) / 1000;
                jpegQuality = jpegQuality < 5 ? 5 : jpegQuality;
                jpegQuality = jpegQuality > 95 ? 95 : jpegQuality;
                long fps = (this.highestFramerate + 999L) / 1000L;
                StringBuilder sb = new StringBuilder("/admin/setparam.cgi?camera=" + this.camera);
                sb.append("&fps=");
                sb.append(fps);
                sb.append("&jpegquality=");
                sb.append(jpegQuality);
                this.logger.info("Using [" + sb.toString() + "] for " + this);
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MIN_VALUE);
                this.myThread = new Thread((Runnable)this, this.toString());
                this.myThread.start();
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while initializing " + this + ": " + ex.getMessage());
                return ex.getErrorCode();
            }
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
        return 0;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        int errorCode = 0;
        try {
            try {
                boolean asynchronous = false;
                this.httpServerPushHandler = new HttpServerPushHandler();
                this.networkParameter.setSoTimeout(5000);
                errorCode = this.httpServerPushHandler.init(this, this.networkParameter, "/video.cgi?camera=" + this.camera);
                if (errorCode != 0) {
                    this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
                } else {
                    errorCode = this.httpServerPushHandler.startServerPush(asynchronous);
                }
                if (this.httpServerPushHandler != null) {
                    this.httpServerPushHandler.shutdown();
                }
            }
            catch (Exception e) {
                this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                errorCode = -21601;
                this.listener.sendStatusService(errorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            errorCode = -21651;
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.shutdown();
    }
}

