/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.grandeye;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import org.apache.logging.log4j.LogManager;

public class GrandEyeMotionDetectionHandler
extends MotionDetectionHandler
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.grandeye.GrandEyeMotionDetectionHandler";
    private NetworkParameter networkParameter = null;
    private HttpServerPushHandler httpServerPushHandler = null;

    public GrandEyeMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        int errorCode;
        block13: {
            errorCode = 0;
            this.listener = hardwareMotionDetection;
            if (this.listener == null) {
                return -20003;
            }
            try {
                if (this.listener.getVideoSrv() == null || this.listener.getVideoSrv().getDevice() == null || this.listener.getVideoSrv().getDevice().getDeviceCnf() == null) {
                    return -20036;
                }
                this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
            }
            catch (Exception e) {
                return -20036;
            }
            try {
                this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
                long deviceID = this.listener.getVideoSrv().getDevice().getDeviceType();
                String mdUrl = "/admin/setparam.cgi?vmdmode=1";
                if (deviceID == 201204L) {
                    mdUrl = "/setalarmconfig.cgi?alarmenable=1&alarmduration=10&alarmtrigger=Motion%20Detection&name=Motion%20Detection";
                }
                if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)mdUrl, (int)Integer.MAX_VALUE) == null) {
                    this.logger.error("Error while doing test request for " + this.listener.getVideoSrv());
                    return -20053;
                }
            }
            catch (Exception e) {
                this.logger.error("Error while testing connectivity to motion detection for " + this.listener.getVideoSrv(), (Throwable)e);
                return -20053;
            }
            try {
                try {
                    this.networkParameter.setSoTimeout(20000);
                    this.httpServerPushHandler = new HttpServerPushHandler();
                    errorCode = this.httpServerPushHandler.init(this, this.networkParameter, "/io/motiondata.cgi");
                    if (errorCode != 0) {
                        this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
                        break block13;
                    }
                    errorCode = this.httpServerPushHandler.startServerPush(true);
                }
                catch (Exception e) {
                    this.logger.error("Reading configuration from " + this.listener.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                    errorCode = -21601;
                }
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
                errorCode = -21651;
            }
        }
        return errorCode;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int nStatusCode) {
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21650);
        if (this.isShutdown(CLASS_NAME)) {
            return;
        }
        this.listener.notifyForNetworkProblems();
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        if (this.isMotionDetected(httpServerPushContent.getContentBody())) {
            this.listener.evaluateWindow(0);
        }
    }

    protected boolean isMotionDetected(byte[] content) {
        return content != null && new String(content).contains("alarm=1");
    }
}

