/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.grandeye;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.video.grandeye.GrandEyeDevice;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public final class GrandEyeIOHandler
extends IOHandler
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.grandeye.GrandEyeIoHandler";
    private GrandEyeDevice grandEyeDevice;
    private boolean[] outputsActivated = new boolean[4];
    private HttpServerPushHandler httpServerPushHandler = null;

    @Override
    public final void run() {
        int errorCode = 0;
        super.setRunFinished(CLASS_NAME, false);
        if (this.grandEyeDevice == null) {
            this.grandEyeDevice = (GrandEyeDevice)this.device;
        }
        for (int i = 0; i < this.outputsActivated.length; ++i) {
            this.outputsActivated[i] = false;
        }
        try {
            boolean previousLoopWithError = false;
            DigitalInputSrv[] iServices = super.getDigitalInputSrv();
            errorCode = 0;
            super.setRunFinished(CLASS_NAME, false);
            String url = "/input.cgi";
            boolean bAsynchronous = true;
            this.httpServerPushHandler = new HttpServerPushHandler();
            errorCode = this.httpServerPushHandler.init(this, this.networkParameter, url);
            if (errorCode != 0) {
                this.logger.error("Error [" + errorCode + "]with " + this.httpServerPushHandler);
            } else {
                errorCode = this.httpServerPushHandler.startServerPush(bAsynchronous);
                if (errorCode != 0) {
                    this.logger.warn("ServerPush of " + this.httpServerPushHandler + " terminated with error [" + errorCode + "]");
                }
            }
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    if (!previousLoopWithError) continue;
                    previousLoopWithError = false;
                    this.logger.info("Publishing input stati after error for " + this + " ...");
                    for (int i = 0; i < iServices.length; ++i) {
                        if (!iServices[i].getEntity().isEnabled().booleanValue()) continue;
                        iServices[i].publishServiceStatus(iServices[i].getInputStatus());
                    }
                }
                catch (Throwable throwable) {
                    previousLoopWithError = true;
                    if (throwable instanceof IOException || throwable instanceof UnknownHostException || throwable instanceof NoRouteToHostException || throwable instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)throwable, throwable);
                        if (throwable.getMessage().indexOf("Address already in use") >= 0) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        for (int i = 0; i < iServices.length; ++i) {
                            if (!iServices[i].getEntity().isEnabled().booleanValue()) continue;
                            iServices[i].publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable throwable2) {
                        this.logger.warn((Object)throwable2, throwable2);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this.logger.error((Object)throwable, throwable);
        }
        this.logger.info("Thread of this " + this + " finished");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public final int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        return 0;
    }

    @Override
    protected final int discard() {
        return 0;
    }

    @Override
    public final void deliverContent(HttpServerPushContent httpServerPushContent) {
        try {
            byte[] content = httpServerPushContent.getContentBody();
            String body = new String(content);
            DigitalInputSrv[] iServices = super.getDigitalInputSrv();
            for (int i = 0; i < iServices.length / 2; ++i) {
                if (body.contains("state" + i + ":L")) {
                    iServices[2 * i].checkInput(1);
                    iServices[2 * i + 1].checkInput(1);
                    continue;
                }
                if (!body.contains("state" + i + ":H")) continue;
                iServices[2 * i].checkInput(0);
                iServices[2 * i + 1].checkInput(0);
            }
        }
        catch (Exception exception) {
            this.logger.warn("Error while handling input alarms on " + this);
            this.shutdown();
        }
    }

    @Override
    public final void sendStatusService(int nStatusCode) {
    }

    @Override
    public final void notifyForNetworkProblems() {
        this.logger.warn("Error while handling input alarms on " + this);
        this.shutdown();
    }

    @Override
    public final int shutdown() {
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
        }
        return super.shutdown();
    }
}

