/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.generic.video;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.generic.video.GenericCameraSrv;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.URI;

public final class GenericRTSPVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.generic.GenericRTSPVideoSourceClient";
    private int rtspPort = Integer.MIN_VALUE;

    @Override
    public int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        try {
            this.rtspUrl = ((GenericCameraSrv)this.getVideoSrv()).getRtspUrl(this.listener.getDynamicVideoProfileID());
            this.logger.info(this.rtspUrl);
        }
        catch (Exception exception) {
            this.logger.error("There is no generic RTSP Url in the configuration or it can not be read =(");
            this.logger.error((Object)exception);
            return -21662;
        }
        try {
            URI uri;
            if (!this.rtspUrl.toLowerCase().startsWith("rtsp://")) {
                this.rtspUrl = "rtsp://" + this.rtspUrl;
            }
            if ((uri = new URI(this.rtspUrl)).getPort() != -1) {
                this.rtspPort = uri.getPort();
                this.logger.info("Set RTSP PORT to " + this.rtspPort);
            }
        }
        catch (Exception exception) {
            this.logger.warn((Object)exception);
            this.listener.getVideoSourceParameter().setRtspPort(554);
        }
        try {
            this.networkParameter.setSoTimeout(5000);
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 3, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Error while setting RTSP parameters for " + this.getVideoSrv());
                return this.errorCode;
            }
            if (this.rtspPort != Integer.MIN_VALUE) {
                this.rtspSettings.setRTSPPort(this.rtspPort);
            }
            this.rtspSettings.setUdpBuffer(65535);
            this.rtspSettings.setUserAgent("Java / Seetec");
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            try {
                String apiVersion = this.getVideoSrv().getDevice().getDeviceCnf().getAPI();
                if (apiVersion.equalsIgnoreCase("2.0")) {
                    this.logger.info("API Version " + this.getVideoSrv().getDevice().getDeviceCnf().getAPI() + " for " + this);
                    this.respectEveryParameterSet = true;
                }
            }
            catch (Exception exception) {
                this.logger.warn("Unable to read API version for " + this);
            }
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP stream for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (SeeTecException ex) {
            this.logger.info((Object)ex);
            this.logger.error("Error while first RTSP request. errorCode: " + ex.getErrorCode() + " for " + this.getVideoSrv());
            return ex.getErrorCode();
        }
        catch (Exception ex) {
            this.logger.info((Object)ex);
            this.logger.error("Error while first RTSP request. errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

