/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.generic.video;

import de.seetec.v5.re.cm.device.shared.net.MulticastCallback;
import de.seetec.v5.re.cm.device.shared.net.MulticastReader;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpRTPReaderUnicast;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.shared.TransmissionType;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;

public class GenericMulticastVideoSourceClient
extends StreamingVideoSourceClientRTSP
implements MulticastCallback {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.generic.GenericMulticastVideoSourceClient";
    private MulticastReader multicastReader;
    private InetAddress inetAddress;
    private UdpRTPReaderUnicast udpReader;
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final int SOCKET_BUFFERSIZE = 524288;
    private static final int BUFFERSIZE = 65535;

    @Override
    public int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        if (this.transmissionID == TransmissionType.RTP_OVER_UDP_MULTICAST) {
            try {
                String ip = this.networkParameter.getHost();
                int port = this.networkParameter.getHTTPport();
                try (Socket socket = new Socket();){
                    socket.connect(new InetSocketAddress(ip, port), 5000);
                    this.inetAddress = socket.getLocalAddress();
                }
            }
            catch (Throwable ex) {
                this.logger.warn("Timeout connecting to socket after [5000 ms] for " + this);
                if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                    this.getVideoSrv().notifyForNetworkFailure();
                }
                if (System.currentTimeMillis() > this.lastCannotCreateDeviceEventSent + 5000L) {
                    this.lastCannotCreateDeviceEventSent = System.currentTimeMillis();
                    this.listener.sendStatusService(-21656);
                }
                this.logger.error("Exception [" + ex.getMessage() + " for " + this);
            }
            this.multicastReader = new MulticastReader(this, this.inetAddress);
            this.networkParameter.setSoTimeout(5000);
            this.errorCode = this.multicastReader.init(this.multicastConfigurationDevice, this.networkParameter.getSoTimeout());
            if (this.errorCode != 0) {
                return this.errorCode;
            }
        } else {
            int httpPort = this.networkParameter.getHTTPport();
            this.udpReader = new UdpRTPReaderUnicast(this, httpPort);
            this.udpReader.init(524288, 10000, true, 65535);
            this.logger.info("UDP port '" + this.udpReader.getPort() + "' opened for " + this);
            return 0;
        }
        return 0;
    }

    protected void setAddressOfNetworkInterface(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.udpReader != null) {
            this.udpReader.shutdown();
            this.udpReader = null;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }
}

