/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.generic.video;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.DoNothingCameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.generic.video.GenericJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.generic.video.GenericMulticastVideoSourceClient;
import de.seetec.v5.re.cm.device.video.generic.video.GenericRTSPVideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public final class GenericCameraSrv
extends LiveCameraSrv {
    private final Map<Integer, String> streams = new HashMap<Integer, String>();
    InetAddress inetAddress;

    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new DoNothingCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        VideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [VideoSourceClient] with VideoProfileHandler=" + listener + " ...");
        try {
            Document configuration = new SAXBuilder().build((InputStream)new ByteArrayInputStream(this.getEntity().getConfiguration()));
            Element root = configuration.getRootElement();
            if (this.streams.isEmpty()) {
                this.streams.put(this.getBasicVideoProfileHandler().getDynamicVideoProfileID(), this.getVideoSourceCnf().getGenericRTSPUrl());
                for (int i = 0; i < this.getAdditionalVideoProfileHandler().length; ++i) {
                    if (this.getAdditionalVideoProfileHandler() == null || this.getAdditionalVideoProfileHandler().length <= i) continue;
                    String rtspUrl = ((Element)root.getChild("VideoProfiles").getChildren("VideoProfile").get(i)).getChildText("GenericRTSPUrl");
                    this.streams.put(this.getAdditionalVideoProfileHandler()[i].getDynamicVideoProfileID(), rtspUrl);
                }
            }
            Codec streamingMode = listener.getVideoSourceParameter().getMediaCodec();
            if (this.getEntityType() == 219701L) {
                videoSourceClient = new GenericMulticastVideoSourceClient();
                videoSourceClient.setAddressOfNetworkInterface(this.inetAddress);
            } else if (streamingMode == Codec.RTSP) {
                videoSourceClient = new GenericRTSPVideoSourceClient();
            } else if (streamingMode == Codec.MJPEG) {
                videoSourceClient = new GenericJPEGVideoSourceClient();
            }
            errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    public final String getRtspUrl(int streamNumber) {
        return this.streams.get(streamNumber);
    }

    @Override
    public int checkReachability(VideoProfileHandler listener) {
        if (this.getEntityType() == 219701L) {
            return 0;
        }
        return super.checkReachability(listener);
    }
}

