/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.flir;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.flir.FlirCameraSrv;
import de.seetec.v5.re.cm.device.video.flir.FlirDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class FlirVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.flir.FlirVideoSourceClient";
    private FlirDevice flirDevice;
    private int sourceNumber;
    private int encoderNumber;
    private int frameRateDivider;
    private int streamNumber = 1;
    private int videoSystem;
    private float maximalFramerate;
    private double framerate;
    private static final int PAL = 1;
    private static final int NTSC = 2;

    @Override
    public int init() {
        try {
            try {
                if (this.flirDevice == null) {
                    this.flirDevice = (FlirDevice)((FlirCameraSrv)this.getVideoSrv()).getDevice();
                }
                try {
                    this.flirDevice.testCredentials(this.networkParameter);
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while testing connectivity for " + this + ": " + ex.getMessage());
                    this.shutdown();
                    return -21657;
                }
                FlirCameraSrv flirCameraSrv = (FlirCameraSrv)this.getVideoSrv();
                this.sourceNumber = this.listener.getVideoSourceParameter().getServerEntryNo();
                StringBuffer url = null;
                byte[] result = null;
                this.errorCode = super.init();
                if (this.errorCode != 0) {
                    this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this.getVideoSrv());
                    return this.errorCode;
                }
                this.networkParameter.setSoTimeout(5000);
                if (!this.flirDevice.isGlobalParametersSet()) {
                    this.flirDevice.setGlobalParameters(this.sourceNumber, this.useDateTime, this.useTitle, this.title);
                }
                this.encoderNumber = this.streamNumber = this.listener instanceof BasicVideoProfileHandler ? 1 : 2;
                String videoSystemOnSeetec = this.getVideoSrv().getDevice().getDeviceCnf().getCaptureMode().getDisplayResolution();
                this.errorCode = this.flirDevice.setVideoSystem(videoSystemOnSeetec);
                this.errorCode = flirCameraSrv.setImageFlip(this.rotationAngle);
                this.videoSystem = videoSystemOnSeetec.equals("PAL") ? 1 : 2;
                this.resolutionTag = this.flirDevice.getResolutionTag(this.width, this.height, this.videoSystem);
                if (this.resolutionTag == null) {
                    this.logger.error("Resolution " + this.width + " x " + this.height + " not supported for " + this.getVideoSrv());
                    return -21655;
                }
                this.quality /= 1000;
                this.quality = this.quality < 1 ? 1 : this.quality;
                this.maximalFramerate = this.flirDevice.getMaximalFramerate(this.videoSystem, Codec.H264, this.encoderNumber, this.sourceNumber);
                if ((double)this.fps < 1000.0) {
                    this.fps = 1000L;
                }
                this.framerate = (double)this.fps / 1000.0;
                this.frameRateDivider = (int)((double)this.maximalFramerate / this.framerate + 0.5);
                this.bandwidth /= 1024;
                this.bandwidth = this.bandwidth < 10 ? 10 : this.bandwidth;
                url = new StringBuffer("/params/set.cgi?");
                url.append("Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".MediaSubType=");
                String codecOnSeetec = this.videoCodec == Codec.H264 ? "H.264" : "MJPEG";
                url.append(codecOnSeetec);
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                String codec = "";
                int numberOfTries = 0;
                while (!codec.equals(codecOnSeetec) && numberOfTries < 10) {
                    ++numberOfTries;
                    result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/params/get.cgi?Video-" + this.sourceNumber + ".Encoder-" + this.encoderNumber + ".MediaSubType"), (int)Integer.MAX_VALUE);
                    HTTPResponse httpResponse = new HTTPResponse(result);
                    String httpBodyString = httpResponse.getHttpBody().getData();
                    String[] codecLines = httpBodyString.split("=");
                    if (codecLines.length == 2) {
                        codec = codecLines[1].trim().replace("\r", "").replace("\n", "").trim();
                    }
                    Thread.sleep(1000L);
                }
                if (numberOfTries == 10) {
                    this.logger.error("Could not set codec to " + codecOnSeetec);
                    this.shutdown();
                }
                url = new StringBuffer("/params/set.cgi?");
                url.append("Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Enable=True");
                url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".FrameRateDivider=").append(this.frameRateDivider);
                url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Resolution=").append(this.resolutionTag);
                if (this.videoCodec == Codec.H264) {
                    this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, 1, 255);
                    url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".GopLength=").append(this.iFrameDist);
                    if (this.isConstantBitrateUsed) {
                        url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".BitRateMode=Constant%20bitrate");
                        url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".BitRate=").append(this.bandwidth);
                    } else {
                        url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".BitRateMode=Constant%20quality");
                        url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".CqmQuality=").append(this.quality);
                    }
                } else {
                    url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".CqmQuality=").append(this.quality);
                }
                url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Tx-1.RtpControlMode=Floodguard");
                url.append("&Video-").append(this.sourceNumber).append(".Encoder-").append(this.encoderNumber).append(".Enable=True");
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                if (this.isAudioEnabled) {
                    this.logger.info("Audio Parameter: " + this.audioCodec + " with " + this.audioBitrate + "bit for " + this.getVideoSrv().getDevice());
                    url = new StringBuffer("/params/set.cgi?");
                    url.append("Audio-1.Input-").append(this.sourceNumber).append(".Enable=True");
                    url.append("&Audio-1.Encoder-1.AudioFormat=");
                    if (this.audioCodec == Codec.G711U) {
                        url.append("u-law%208bit");
                    } else if (this.audioCodec == Codec.G711A) {
                        url.append("A-law%208bit");
                    } else if (this.audioCodec == Codec.PCM) {
                        url.append("PCM%2016bit");
                    } else {
                        this.logger.error("Unknown audio encoding type: " + this.audioCodec + " for " + this.getVideoSrv().getDevice());
                        return -21601;
                    }
                    try {
                        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                    }
                    catch (SeeTecException e) {
                        this.logger.error("Exception while setting Audio association for " + this.getVideoSrv(), (Throwable)e);
                        return e.getErrorCode();
                    }
                }
                this.rtspUrl = "rtsp://" + this.getHost() + "/VideoInput/" + this.videoSourceNr + "/h264/" + this.streamNumber;
                if (this.getVideoSrv().getEntityType() == 215500L) {
                    this.rtspUrl = "rtsp://" + this.getHost() + "/video-1.Encoder-" + this.streamNumber;
                }
                this.rtspSettings = new RTSPStreamSettings();
                this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 2, this.rtspUrl);
                if (this.errorCode != 0) {
                    this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                    return this.errorCode;
                }
                int[] res = new int[]{this.width, this.height};
                this.rtspSettings.setCheckResolution(true, res);
                this.rtspHandler = this.rtspSettings.getRTSPHandler();
                this.errorCode = this.rtspHandler.start();
                if (this.errorCode != 0) {
                    this.logger.error("Start of RTSPHandler failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                    return this.errorCode;
                }
                this.logger.info("init done for" + this.getVideoSrv());
                return 0;
            }
            catch (ConfigurationException ex) {
                this.logger.error("Exception occured while setting camera parameters for " + this + ": " + ex.getMessage());
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception occured while setting camera parameters for " + this + ": " + ex.getMessage());
                return ex.getErrorCode();
            }
            return 0;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down.");
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }
}

