/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.flir;

import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.shared.OPCLowerNodeIDType;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class FlirMotionDetectionHandler
extends MotionDetectionHandler
implements Runnable,
HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.flir.FlirMotionDetectionHandler";
    private Thread myThread = null;
    private NetworkParameter networkParameter = null;
    private byte[] result = null;
    private long lastTamperingEventSent;
    private long lastVideoLossEventSent;
    private int videoSourceNumber;
    private boolean tamperingStatus = false;
    private boolean videolossStatus = false;

    public FlirMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        int errorCode = 0;
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        try {
            this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
            this.videoSourceNumber = this.listener.getVideoSrv().getVideoSourceCnf().getServerEntryNo();
            for (int i = 0; i < this.listener.getHardwareMotionDetectionCnf().length; ++i) {
                String request = "/params/set.cgi?Video-" + this.videoSourceNumber + ".Vmd-" + (i + 1) + ".Enable=True";
                if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)request, (int)Integer.MAX_VALUE) != null) continue;
                this.logger.error("Error enabling Motion Detection for " + this);
            }
        }
        catch (Exception e) {
            this.logger.error("Error while doing MD test request for " + this.listener.getVideoSrv());
            this.logger.warn((Object)e, (Throwable)e);
            return -20001;
        }
        if (this.listener.getVideoSrv().getDevice().getFirmwareVersion().startsWith("4")) {
            try {
                try {
                    this.networkParameter.setSoTimeout(10000);
                    String url = "/api/events.cgi?InputPin:1,2=on&VideoSignal:all=on&MotionEvent:all=on&TamperingAlarm:all=on&Heartbeat=3";
                    HttpServerPushHandler httpServerPushHandler = new HttpServerPushHandler();
                    errorCode = httpServerPushHandler.init(this, this.networkParameter, url);
                    if (errorCode != 0) {
                        this.logger.error("Error [" + errorCode + "] with " + httpServerPushHandler);
                    } else {
                        httpServerPushHandler.startServerPush(true);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Reading configuration from " + this.listener.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                    errorCode = -21601;
                }
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
                errorCode = -21651;
            }
        } else {
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
        }
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public void run() {
        long TIME_FOR_ITERATION = 500L;
        int videoSourceNumber = 1;
        try {
            videoSourceNumber = this.listener.getVideoSrv().getVideoSourceCnf().getServerEntryNo();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while retrieving video source number for " + this + ": " + ex.getMessage());
        }
        long time = 0L;
        long sleep = 0L;
        String motionDetectionURL = "/params/get.cgi?Video-" + videoSourceNumber + ".Vmd-*.MotionDetectAlarm";
        String tamperingDetectionURL = "/params/get.cgi?Video-" + videoSourceNumber + ".Vca-*.ImageContentMonitor.*";
        String videoLossDetectionURL = "/params/get.cgi?Video-" + videoSourceNumber + ".Input-*.NoVideoAlarm";
        this.networkParameter.setSoTimeout(5000);
        while (!this.isShutdown(CLASS_NAME)) {
            try {
                int j;
                String[] linesOfDetectionData;
                time = System.currentTimeMillis();
                this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)motionDetectionURL, (int)Integer.MAX_VALUE);
                if (this.result != null) {
                    linesOfDetectionData = new String(this.result).split("\r\n");
                    for (int i = 0; i < this.listener.getHardwareMotionDetectionCnf().length; ++i) {
                        for (j = 0; j < linesOfDetectionData.length; ++j) {
                            String resultOfMotionDetection;
                            if (!linesOfDetectionData[j].toLowerCase().contains("vmd-" + (i + 1)) || !(resultOfMotionDetection = linesOfDetectionData[j].substring(linesOfDetectionData[j].indexOf("=") + 1)).equalsIgnoreCase("on")) continue;
                            this.listener.evaluateWindow(i);
                        }
                    }
                }
                if ((this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)tamperingDetectionURL, (int)Integer.MAX_VALUE)) != null) {
                    String[] i = linesOfDetectionData = new String(this.result).split("\r\n");
                    j = i.length;
                    for (int resultOfMotionDetection = 0; resultOfMotionDetection < j; ++resultOfMotionDetection) {
                        String linesOfDetectionData1 = i[resultOfMotionDetection];
                        if (!linesOfDetectionData1.toLowerCase().contains("imagecontentalarm=") && !linesOfDetectionData1.toLowerCase().contains("nomatchalarm=")) continue;
                        String resultOfTamperingDetection = linesOfDetectionData1.substring(linesOfDetectionData1.indexOf("=") + 1);
                        if (resultOfTamperingDetection.equalsIgnoreCase("on")) {
                            try {
                                if (!this.listener.getVideoSrv().getVideoSourceCnf().isEnableTampering() || System.currentTimeMillis() <= this.lastTamperingEventSent + 10000L) continue;
                                this.lastTamperingEventSent = System.currentTimeMillis();
                                try {
                                    this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/empty.html?%25(" + videoSourceNumber + "092,11,2)%25=1"), (int)Integer.MAX_VALUE, (boolean)true);
                                }
                                catch (SeeTecException ex) {
                                    this.logger.error("Exception occured while resetting tampering flag for " + this + ": " + ex.getMessage());
                                }
                                ((LiveCameraSrv)this.listener.getVideoSrv()).evaluateTampering();
                                this.listener.getVideoSrv().getCore().sendTamperingEvent(this.listener.getVideoSrv());
                                this.tamperingStatus = true;
                            }
                            catch (ConfigurationException ce) {
                                this.logger.error("Error evaluating tampering flag for " + this);
                            }
                            continue;
                        }
                        if (!this.tamperingStatus) continue;
                        this.tamperingStatus = false;
                    }
                }
                if ((this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)videoLossDetectionURL, (int)Integer.MAX_VALUE)) != null) {
                    linesOfDetectionData = new String(this.result).split("\r\n");
                    for (int j2 = 0; j2 < linesOfDetectionData.length; ++j2) {
                        if (!linesOfDetectionData[j2].toLowerCase().contains("novideoalarm=")) continue;
                        String resultOfVideoLossDetection = linesOfDetectionData[j2].substring(linesOfDetectionData[j2].indexOf("=") + 1);
                        if (resultOfVideoLossDetection.equalsIgnoreCase("on")) {
                            try {
                                if (!this.listener.getVideoSrv().getVideoSourceCnf().isEnableVideoloss() || System.currentTimeMillis() <= this.lastVideoLossEventSent + 5000L) continue;
                                this.lastVideoLossEventSent = System.currentTimeMillis();
                                ((LiveCameraSrv)this.listener.getVideoSrv()).evaluateVideoLoss();
                                this.listener.getVideoSrv().getCore().sendVideoLossEvent(this.listener.getVideoSrv());
                                this.videolossStatus = true;
                            }
                            catch (ConfigurationException ce) {
                                this.logger.error("Error evaluating videoLoss flag for " + this);
                            }
                            continue;
                        }
                        if (!this.videolossStatus) continue;
                        this.listener.getVideoSrv().getCore().sendOPCEvent("false", OPCLowerNodeIDType.CAMERA_VIDEOLOSS_STATUS, this.listener.getVideoSrv().getEntityID());
                        this.videolossStatus = false;
                    }
                }
                if ((sleep = 500L - (System.currentTimeMillis() - time)) > 0L) {
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException linesOfDetectionData2) {}
                    continue;
                }
                if (sleep >= -1000L) continue;
                this.logger.warn("Request took quite long: " + Math.abs(sleep) + "ms for " + this.listener.getVideoSrv());
            }
            catch (SeeTecException ex) {
                this.logger.error((Object)ex, (Throwable)ex);
            }
        }
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.video.flir.FlirMotionDetectionHandler@" + Integer.toHexString(this.hashCode());
        return "[ " + sThis.substring(sThis.lastIndexOf(46) + 1) + ", [ " + this.listener.getVideoSrv() + " ] ]";
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21650);
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        if (this.isShutdown(CLASS_NAME)) {
            return;
        }
        if (nStatusCode != 0) {
            this.listener.notifyForNetworkProblems();
        }
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        try {
            byte[] content = httpServerPushContent.getContentBody();
            String xmlString = new String(content);
            if (!xmlString.isEmpty()) {
                String value;
                Attribute state;
                ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
                Document cameraConf = new SAXBuilder().build((InputStream)bais);
                Element root = cameraConf.getRootElement();
                Namespace ns = root.getNamespace();
                List videoSignalList = root.getChildren("MotionEvent", ns);
                for (Element videoElement : videoSignalList) {
                    if (videoElement.getAttributeValue("EntityNbr", ns) == null || !videoElement.getAttributeValue("EntityNbr", ns).equals("" + this.videoSourceNumber) || (state = videoElement.getAttribute("State", ns)) == null || (value = state.getValue()) == null || !value.equalsIgnoreCase("on")) continue;
                    this.listener.evaluateWindow(0);
                }
                videoSignalList = root.getChildren("CustomEvent", ns);
                for (Element videoElement : videoSignalList) {
                    if (videoElement.getAttributeValue("EntityNbr", ns) == null || !videoElement.getAttributeValue("EntityNbr", ns).equals("" + this.videoSourceNumber) || videoElement.getAttributeValue("Type", ns) == null || !videoElement.getAttributeValue("Type", ns).equals("TamperingAlarm") || (state = videoElement.getAttribute("Value", ns)) == null) continue;
                    value = state.getValue();
                    if (value != null && value.equalsIgnoreCase("on")) {
                        try {
                            if (!this.listener.getVideoSrv().getVideoSourceCnf().isEnableTampering() || System.currentTimeMillis() <= this.lastTamperingEventSent + 10000L) continue;
                            this.lastTamperingEventSent = System.currentTimeMillis();
                            ((LiveCameraSrv)this.listener.getVideoSrv()).evaluateTampering();
                            this.listener.getVideoSrv().getCore().sendTamperingEvent(this.listener.getVideoSrv());
                            this.tamperingStatus = true;
                        }
                        catch (ConfigurationException ce) {
                            this.logger.error("Error evaluating tampering flag for " + this);
                        }
                        continue;
                    }
                    if (!this.tamperingStatus) continue;
                    this.tamperingStatus = false;
                }
            }
        }
        catch (JDOMException ex) {
            this.logger.error("Exception while reading alarm information for " + this + (Object)((Object)ex));
        }
    }
}

